/*
 * Decompiled with CFR 0.152.
 */
package org.jatha.display;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.EOFException;
import org.jatha.Jatha;
import org.jatha.display.Listener;
import org.jatha.dynatype.LispValue;
import org.jatha.read.LispParser;

class LispInput
extends TextField
implements Runnable,
ActionListener,
KeyListener {
    protected int matchingPosition = -1;
    protected boolean flashing = false;
    protected Thread myThread = null;
    protected Graphics myGraphics = null;
    protected String input;
    protected FontMetrics fontInfo = null;
    protected int fontWidth = 0;
    protected int fontHeight = 0;
    protected Color fgColor = null;
    protected Color bgColor = null;
    protected int hFudge = 8;
    protected int vFudge = 7;
    protected Listener myParent;
    protected String SaveBuffer = "";
    protected String LastCommand = "";
    protected boolean FirstCharOfCommand = true;
    protected int CommandMultiplier = 1;
    private Jatha f_lisp = null;

    public LispInput(Jatha lisp, Listener parent, int cols) {
        super(cols);
        this.f_lisp = lisp;
        this.myParent = parent;
        this.myThread = new Thread((Runnable)this, "Parenthesis Matching");
        this.myThread.start();
        this.setBackground(new Color(255, 255, 153));
        this.setFont(new Font("Geneva", 0, 10));
        this.addActionListener(this);
        this.addKeyListener(this);
    }

    public void setFontInfo() {
        this.myGraphics = this.getGraphics();
        this.fontInfo = this.getFontMetrics(this.getFont());
        this.fontWidth = this.fontInfo.charWidth('A');
        this.fontHeight = this.fontInfo.getHeight();
        this.fgColor = this.getForeground();
        this.bgColor = this.getBackground().brighter();
    }

    void eval(LispValue input) {
        this.myParent.Out(input, true);
        this.myParent.Out(this.f_lisp.eval(input));
    }

    public void actionPerformed(ActionEvent e) {
        boolean valid = true;
        LispValue value = this.f_lisp.NIL;
        LispParser parser = new LispParser(this.f_lisp, this.getText() + " ");
        try {
            value = parser.parse();
        }
        catch (EOFException ex) {
            this.myParent.Out("\n*** Incomplete LISP Input - fix it and try again.\n");
            valid = false;
        }
        if (valid) {
            this.eval(value);
            this.selectAll();
            this.LastCommand = this.getText();
            this.FirstCharOfCommand = true;
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyTyped(KeyEvent e) {
        char key = e.getKeyChar();
        int quoteCount = 0;
        int parenCount = 0;
        if (this.handleEmacsCommand(e)) {
            return;
        }
        this.CommandMultiplier = 1;
        Thread thread = this.myThread;
        synchronized (thread) {
            if (this.flashing) {
                this.myThread.interrupt();
            }
        }
        if (key == ')') {
            int i;
            this.input = this.getText();
            for (i = 0; i < this.input.length(); ++i) {
                if (this.input.charAt(i) != '\"') continue;
                ++quoteCount;
            }
            if (quoteCount % 2 == 0) {
                for (i = this.input.length() - 1; i >= 0; --i) {
                    if (this.input.charAt(i) == '\"') {
                        while (this.input.charAt(--i) != '\"') {
                        }
                        continue;
                    }
                    if (this.input.charAt(i) == ')') {
                        ++parenCount;
                        continue;
                    }
                    if (this.input.charAt(i) != '(' || --parenCount != 0) continue;
                    this.matchingPosition = i;
                    if (this.getCaretPosition() - this.matchingPosition >= this.getColumns()) continue;
                    Thread thread2 = this.myThread;
                    synchronized (thread2) {
                        this.myThread.notify();
                        continue;
                    }
                }
            }
        }
    }

    boolean handleEmacsCommand(KeyEvent e) {
        char key = e.getKeyChar();
        int type = e.getID();
        if (key >= '\u001b') {
            this.FirstCharOfCommand = false;
            return false;
        }
        if (this.FirstCharOfCommand) {
            this.setText(this.LastCommand);
            this.FirstCharOfCommand = false;
        }
        if (key == '\u0001') {
            if (type == 400) {
                this.setCaretPosition(0);
            }
            this.CommandMultiplier = 1;
            return true;
        }
        if (key == '\u0002') {
            int p = this.getCaretPosition();
            for (int i = 0; i < this.CommandMultiplier; ++i) {
                if (p <= 0) continue;
                this.setCaretPosition(this.getCaretPosition() - 1);
            }
            this.CommandMultiplier = 1;
            return true;
        }
        if (key == '\u0004') {
            for (int i = 0; i < this.CommandMultiplier; ++i) {
                this.setCaretPosition(this.getCaretPosition() + 1);
                this.eraseLastCharTyped();
            }
            this.CommandMultiplier = 1;
            return true;
        }
        if (key == '\u0005') {
            if (type == 400) {
                this.setCaretPosition(this.getText().length() + 1);
            }
            this.CommandMultiplier = 1;
            return true;
        }
        if (key == '\u0006') {
            for (int i = 0; i < this.CommandMultiplier; ++i) {
                this.setCaretPosition(this.getCaretPosition() + 1);
            }
            this.CommandMultiplier = 1;
            return true;
        }
        if (key == '\u000b') {
            this.saveText(this.killToEndOfLine());
            this.CommandMultiplier = 1;
            return true;
        }
        if (key == '\u0015') {
            this.CommandMultiplier *= 4;
            return true;
        }
        if (key == '\u0019') {
            for (int i = 0; i < this.CommandMultiplier; ++i) {
                this.restoreText();
            }
            this.CommandMultiplier = 1;
            return true;
        }
        return false;
    }

    void eraseLastCharTyped() {
        String s = this.getText();
        int p = this.getCaretPosition();
        if (p > 0) {
            this.setText(s.substring(0, p - 1) + s.substring(p));
            this.setCaretPosition(p - 1);
        }
    }

    String killToEndOfLine() {
        String s = this.getText();
        int p = this.getCaretPosition();
        String killed = s.substring(p);
        this.setText(s.substring(0, p));
        return killed;
    }

    void saveText(String s) {
        this.SaveBuffer = s;
    }

    void restoreText() {
        String s = this.getText();
        int p = this.getCaretPosition();
        this.setText(s.substring(0, p) + this.SaveBuffer + s.substring(p));
        this.setCaretPosition(p + this.SaveBuffer.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Thread thread = this.myThread;
        synchronized (thread) {
            while (true) {
                Object var6_7;
                try {
                    this.myThread.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (this.fontInfo == null) {
                    this.setFontInfo();
                }
                this.flashing = true;
                int h = this.hFudge + this.fontInfo.stringWidth(this.input.substring(0, this.matchingPosition));
                int v = this.vFudge;
                this.myGraphics.setXORMode(Color.white);
                this.myGraphics.fillRect(h, v, this.fontWidth, this.fontHeight);
                try {
                    try {
                        this.myThread.wait(500L);
                    }
                    catch (InterruptedException e) {
                        var6_7 = null;
                        this.flashing = false;
                        this.myGraphics.fillRect(h, v, this.fontWidth, this.fontHeight);
                        this.myGraphics.setPaintMode();
                        continue;
                    }
                    var6_7 = null;
                    this.flashing = false;
                    this.myGraphics.fillRect(h, v, this.fontWidth, this.fontHeight);
                    this.myGraphics.setPaintMode();
                }
                catch (Throwable throwable) {
                    var6_7 = null;
                    this.flashing = false;
                    this.myGraphics.fillRect(h, v, this.fontWidth, this.fontHeight);
                    this.myGraphics.setPaintMode();
                    throw throwable;
                }
            }
        }
    }
}

