/*
 * Decompiled with CFR 0.152.
 */
package org.jatha.compile;

import org.jatha.Jatha;
import org.jatha.compile.CompilerException;
import org.jatha.compile.LispCompiler;
import org.jatha.compile.LispPrimitive;
import org.jatha.dynatype.LispPackage;
import org.jatha.dynatype.LispString;
import org.jatha.dynatype.LispValue;
import org.jatha.machine.SECDMachine;

public class InternPrimitive
extends LispPrimitive {
    public InternPrimitive(Jatha lisp) {
        super(lisp, "INTERN", 1L, 2L);
    }

    public void Execute(SECDMachine machine) {
        LispValue args = machine.S.pop();
        LispValue str = args.car();
        LispValue pkgArg = args.second();
        if (str instanceof LispString) {
            LispValue pkg = pkgArg == this.f_lisp.NIL ? machine.get_special_value(machine.getLisp().PACKAGE_SYMBOL) : machine.getLisp().findPackage(pkgArg);
            if (pkg == this.f_lisp.NIL) {
                System.err.println("\n;; * Warning: package '" + pkgArg + "' does not exist.  Using default package.");
                pkg = machine.get_special_value(machine.getLisp().PACKAGE_SYMBOL);
            }
            LispValue newSymbol = machine.getLisp().EVAL.intern((LispString)str, (LispPackage)pkg);
            machine.S.push(newSymbol);
            machine.C.pop();
        } else {
            System.err.println("\n;; *** The first argument to INTERN is not a string");
        }
    }

    public LispValue CompileArgs(LispCompiler compiler, SECDMachine machine, LispValue args, LispValue valueList, LispValue code) throws CompilerException {
        return compiler.compileArgsLeftToRight(args, valueList, this.f_lisp.makeCons(machine.LIS, this.f_lisp.makeCons(args.length(), code)));
    }
}

