/*
 * Decompiled with CFR 0.152.
 */
package org.jatha.compile;

import org.jatha.Jatha;
import org.jatha.compile.CompilerException;
import org.jatha.compile.LispCompiler;
import org.jatha.compile.LispPrimitive;
import org.jatha.dynatype.LispString;
import org.jatha.dynatype.LispValue;
import org.jatha.machine.SECDMachine;

public class AproposPrimitive
extends LispPrimitive {
    public AproposPrimitive(Jatha lisp) {
        super(lisp, "APROPOS", 1L, 2L);
    }

    public void Execute(SECDMachine machine) {
        LispValue args = machine.S.pop();
        LispValue str = args.car();
        LispValue pkgArg = args.second();
        if (str instanceof LispString) {
            LispValue pkg;
            if (pkgArg != this.f_lisp.NIL) {
                pkg = this.f_lisp.findPackage(pkgArg);
                if (pkg == this.f_lisp.NIL) {
                    System.err.println("\n;; * Warning: package '" + pkgArg + "' does not exist.  Searching all packages.");
                }
            } else {
                pkg = this.f_lisp.NIL;
            }
            machine.S.push(this.f_lisp.apropos(str, pkg));
            machine.C.pop();
        } else {
            System.err.println("\n;; *** The first argument to APROPOS is not a string");
        }
    }

    public LispValue CompileArgs(LispCompiler compiler, SECDMachine machine, LispValue args, LispValue valueList, LispValue code) throws CompilerException {
        return compiler.compileArgsLeftToRight(args, valueList, this.f_lisp.makeCons(machine.LIS, this.f_lisp.makeCons(args.length(), code)));
    }
}

