/*
 * Decompiled with CFR 0.152.
 */
package TauIL.error;

import TauIL.error.ErrorMessage;
import TauIL.error.WarningMessage;
import java.io.File;
import java.io.PrintStream;

public class MessageManager {
    private File warn_log = new File("warning.log");
    private File err_log = new File("error.log");
    private PrintStream warn_out = System.out;
    private PrintStream err_out = System.err;
    private boolean report_err = true;
    private boolean report_warn = true;
    private boolean log_err = false;
    private boolean log_warn = false;
    private String app = "";

    public MessageManager(String string) {
        this.app = string;
    }

    public void report(WarningMessage warningMessage) {
        if (this.report_warn) {
            this.warn_out.println(this.app + ": " + warningMessage);
        }
        if (this.log_warn) {
            // empty if block
        }
    }

    public void report(ErrorMessage errorMessage) {
        if (this.report_err) {
            this.err_out.println(this.app + ": " + errorMessage);
        }
        if (this.log_err) {
            // empty if block
        }
    }

    public void enableErrorLog() {
        this.log_err = true;
    }

    public void disableErrorLog() {
        this.log_err = false;
    }

    public void enableWarningLog() {
        this.log_warn = true;
    }

    public void disableWarningLog() {
        this.log_warn = false;
    }

    public void enableAllLogging() {
        this.enableErrorLog();
        this.enableWarningLog();
    }

    public void disableAllLogging() {
        this.disableErrorLog();
        this.disableWarningLog();
    }

    public void setErrorLog(File file) {
        this.err_log = file;
    }

    public void setWarningLog(File file) {
        this.warn_log = file;
    }

    public void enableErrorOutput() {
        this.report_err = true;
    }

    public void disableErrorOutput() {
        this.report_err = false;
    }

    public void enableWarningOutput() {
        this.report_warn = true;
    }

    public void disableWarningOutput() {
        this.report_warn = false;
    }

    public void enableAllOutput() {
        this.enableErrorOutput();
        this.enableWarningOutput();
    }

    public void disableAllOutput() {
        this.disableErrorOutput();
        this.disableWarningOutput();
    }

    public void setErrorOutput(PrintStream printStream) {
        this.err_out = printStream;
    }

    public void setWarningOutput(PrintStream printStream) {
        this.warn_out = printStream;
    }

    public void enableErrorReporting() {
        this.enableErrorLog();
        this.enableErrorOutput();
    }

    public void enableWarningReporting() {
        this.enableWarningLog();
        this.enableErrorOutput();
    }

    public void enableAllReporting() {
        this.enableWarningReporting();
        this.enableErrorReporting();
    }

    public void disableErrorReporting() {
        this.disableErrorLog();
        this.disableErrorOutput();
    }

    public void disableWarningReporting() {
        this.disableWarningLog();
        this.disableWarningOutput();
    }

    public void disableAllReporting() {
        this.disableErrorReporting();
        this.disableWarningReporting();
    }
}

