/*
**  NSData+Extensions.h
**
**  Copyright (c) 2001, 2002, 2003
**
**  Author: Alexander Malmberg <alexander@malmberg.org>
**          Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**  
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**  Lesser General Public License for more details.
**  
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#ifndef _Pantomime_H_NSData_Extensions
#define _Pantomime_H_NSData_Extensions

#import <Foundation/NSArray.h>
#import <Foundation/NSData.h>
#import <Foundation/NSString.h>

@interface NSData (PantomimeExtensions)

+ (id) dataWithCString: (const char *) theCString;


-(NSRange) rangeOfData: (NSData *) theData;

-(NSRange) rangeOfCString: (const char *) theCString;

-(NSRange) rangeOfCString: (const char *) theCString
                  options: (unsigned int) options;

-(NSRange) rangeOfCString: (const char *) theCString
 	          options: (unsigned int)options
	            range: (NSRange) theRange;

- (NSData *) subdataFromIndex: (int) theIndex;
- (NSData *) subdataToIndex: (int) theIndex;

- (NSData *) dataByTrimmingWhiteSpaces;
- (NSData *) dataFromQuotedData;
- (NSData *) dataByRemovingLineFeedCharacters;

- (int) indexOfCharacter: (char) theCharacter;

- (BOOL) hasCPrefix: (const char *) theCString;
- (BOOL) hasCSuffix: (const char *) theCString;

- (BOOL) hasCaseInsensitiveCPrefix: (const char *) theCString;
- (BOOL) hasCaseInsensitiveCSuffix: (const char *) theCString;

- (NSComparisonResult) caseInsensitiveCCompare: (const char *) theCString;

- (NSArray *) componentsSeparatedByCString: (const char *) theCString;


// Turns _ASCII_ data into a string
-(NSString *) asciiString;
-(const char *) cString;

@end


@interface NSMutableData (PantomimeExtensions)

// the resulting string __MUST__ contain only ascii characters
-(void) appendCFormat: (NSString *) format, ...;

-(void) appendCString: (const char *) theCString;

- (void) insertCString: (const char *) theCString
               atIndex: (int) theIndex;

- (void) replaceCRLFWithLF;
- (NSMutableData *) replaceLFWithCRLF;

@end

#endif // _Pantomime_H_NSData_Extensions
