import os, sys
from distutils.core import setup, Extension

if sys.platform == "win32":
    import py2exe

#############################################################################

class InnoScript:
    def __init__(self,
                 name,
                 lib_dir,
                 dist_dir,
                 windows_exe_files = [],
                 lib_files = [],
                 version = "1.0"):
        self.lib_dir = lib_dir
        self.dist_dir = dist_dir
        if not self.dist_dir[-1] in "\\/":
            self.dist_dir += "\\"
        self.name = name
        self.version = version
        self.windows_exe_files = [self.chop(p) for p in windows_exe_files]
        self.lib_files = [self.chop(p) for p in lib_files]

    def chop(self, pathname):
        assert pathname.startswith(self.dist_dir)
        return pathname[len(self.dist_dir):]
    
    def create(self, pathname="dist\\memaid.iss"):
        self.pathname = pathname
        ofi = self.file = open(pathname, "w")
        print >> ofi, "; WARNING: This script has been created by py2exe. Changes to this script"
        print >> ofi, "; will be overwritten the next time py2exe is run!"
        print >> ofi, r"[Setup]"
        print >> ofi, r"AppName=%s" % self.name
        print >> ofi, r"AppVerName=%s %s" % (self.name, self.version)
        print >> ofi, r"DefaultDirName={pf}\%s" % self.name
        print >> ofi, r"DefaultGroupName=%s" % self.name
        print >> ofi

        print >> ofi, r"[Files]"
        for path in self.windows_exe_files + self.lib_files:
            print >> ofi, r'Source: "%s"; DestDir: "{app}\%s"; Flags: ignoreversion' % (path, os.path.dirname(path))
        print >> ofi

        print >> ofi, r"[Icons]"
        for path in self.windows_exe_files:
            print >> ofi, r'Name: "{group}\%s"; Filename: "{app}\%s"' % (self.name, path),
        print >> ofi, ' ; WorkingDir: {app}'
        print >> ofi, 'Name: "{group}\Uninstall %s"; Filename: "{uninstallexe}"' % self.name

    def compile(self):
        try:
            import ctypes
        except ImportError:
            try:
                import win32api
            except ImportError:
                import os
                os.startfile(self.pathname)
            else:
                print "Ok, using win32api."
                win32api.ShellExecute(0, "compile",
                                                self.pathname,
                                                None,
                                                None,
                                                0)
        else:
            print "Cool, you have ctypes installed."
            res = ctypes.windll.shell32.ShellExecuteA(0, "compile",
                                                      self.pathname,
                                                      None,
                                                      None,
                                                      0)
            if res < 32:
                raise RuntimeError, "ShellExecute failed, error %d" % res


#############################################################################


if sys.platform == "win32":
    from py2exe.build_exe import py2exe
else:
    class py2exe:
        pass
    
class build_installer(py2exe):
    # This class first builds the exe file(s), then creates a Windows installer.
    # You need InnoSetup for it.
    def run(self):
        # First, let py2exe do it's work.
        py2exe.run(self)

        lib_dir = self.lib_dir
        dist_dir = self.dist_dir
        
        # create the Installer, using the files py2exe has created.
        script = InnoScript("MemAid",
                            lib_dir,
                            dist_dir,
                            self.windows_exe_files,
                            self.lib_files,
                            version="0.2.3")
        script.create()
        script.compile()
        # Note: the final setup.exe will be in an Output subdirectory.
        
#############################################################################

module = Extension('pyqt_memaid.ann._memaid_core',
                    sources = ['pyqt_memaid/ann/memaid.c',
                               'pyqt_memaid/ann/ann.c',
                               'pyqt_memaid/ann/memaid_core_wrap.c'])

if sys.platform == "win32": # For py2exe.
    base_path = ""
else:
    base_path = os.path.join(sys.exec_prefix, "lib", "python" + sys.version[:3],
                             "site-packages","pyqt_memaid")
  
pixmap_path = os.path.join(base_path, "pixmaps")
util_path   = os.path.join(base_path, "util")
doc_path    = os.path.join(base_path, "docs")

setup (name = "pyqt_memaid",
       author = "Peter Bienstman",
       author_email = "Peter.Bienstman@UGent.be",
       ext_modules = [module],
       packages = ["pyqt_memaid", "pyqt_memaid.ann"],
       data_files = [(pixmap_path,
                      ["pyqt_memaid/pixmaps/edit.png",
                       "pyqt_memaid/pixmaps/editclear.png",
                       "pyqt_memaid/pixmaps/fileopen.png",
                       "pyqt_memaid/pixmaps/exit.png",
                       "pyqt_memaid/pixmaps/filesave.png",
                       "pyqt_memaid/pixmaps/contents.png",
                       "pyqt_memaid/pixmaps/fileexport.png",
                       "pyqt_memaid/pixmaps/filesaveas.png",
                       "pyqt_memaid/pixmaps/edit.png",
                       "pyqt_memaid/pixmaps/fileimport.png",
                       "pyqt_memaid/pixmaps/edit_add.png",
                       "pyqt_memaid/pixmaps/filenew.png",
                       "pyqt_memaid/pixmaps/configure.png",
                       "pyqt_memaid/pixmaps/memaid.png"]),
                     (util_path, ["util/convert.py"]),
                     (doc_path, ["pyqt_memaid/docs/pyqt_memaid.html"])],
       scripts = ['pyqt_memaid/pyqt_memaid'],
       windows = [{'script':'pyqt_memaid/pyqt_memaid',
                   "icon_resources":[(1,"pyqt_memaid/pixmaps/pyqt_memaid.ico")]}],
       cmdclass = {"py2exe": build_installer}
       )
