/***************************************************************************
 *   Copyright (C) 2003 by Stephen Allewell                                *
 *   stephen@mirramar.fsnet.co.uk                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef __CALIBRATEDIALOG_H
#define __CALIBRATEDIALOG_H

#include <qmap.h>
#include <qstring.h>
#include "patternlibrarydlg.h"

class QListViewItem;
class QIconViewItem;
class KXStitchMimeSource;
class KAction;
class QLabel;

/** Wrapper class to manage the pattern libraries
    @author Stephen P Allewell
  */
class PatternLibraryDialog : public PatternLibraryDlg
{
  Q_OBJECT
public:
  PatternLibraryDialog(QWidget* parent, KXStitchMimeSource* data = 0);
  virtual ~PatternLibraryDialog();

  KXStitchMimeSource* pattern();

protected slots:
  void showContextMenu(KListView*,QListViewItem*,const QPoint&);
  virtual void accept();
  void contextHelp();
  void libraryChanged(QListViewItem*);
  void patternChanged(QIconViewItem*);
  void patternDoubleClicked(QIconViewItem*);
  void newCatagory();
  void showToolTip(QIconViewItem*);
  void removeToolTip();

private:
  void fillLibraryList();
  void recurseLibrary(QListViewItem*,QString);
  void fillPatternList(QListViewItem* item = 0);

  KXStitchMimeSource* m_patternData;
  QListViewItem*      m_listViewItem;
  QLabel*             m_tooltip;
};

#endif
