/* regex-utils.h - Convenience functions for POSIX regular expressions
 *
 * Copyright (C) 2001  Oskar Liljeblad
 *
 * This file is part of the file renaming utilities (renameutils)
 * and regex-markup.
 *
 * This software is copyrighted work licensed under the terms of the
 * GNU General Public License. Please consult the file `COPYING' for
 * details.
 */

#ifndef __REGEX_H__
#define __REGEX_H__

#include <sys/types.h>
#include <regex.h>
#include "common.h"

char *xregerror (int errcode, regex_t *compiled);
bool xregexec(const regex_t *pref, const char *string,
		size_t nmatch, regmatch_t *pmatch, int eflags);
bool xregexec_substring(const regex_t *pref, char *string,
		int start, int end, size_t nmatch, regmatch_t *pmatch,
		int eflags);

#endif
