/**
 * IceMC - a menu editor for IceWM
 * Copyright (c) 2000 Georg Mittendorfer
 */

#include "IceClipboard.h"

/////////////////////////////////////////////////////
// constructor & destructor
/////////////////////////////////////////////////////

IceClipboard::IceClipboard() 
{
  IceListView* list = new IceListView();
  item = new IceListViewItem(list,0,0,0,0);
  list->takeItem(item);
  delete list;
}

IceClipboard::~IceClipboard()
{
}

/////////////////////////////////////////////////////
// public methods
/////////////////////////////////////////////////////

void IceClipboard::insertItem(IceListViewItem* newItem) // virtual
{
  ;//qDebug("DEBUG: IceClipboard::insertItem(...)");

  if (newItem) {
    IceListView* list = new IceListView();
    delete item;
    item = new IceListViewItem(list,0,0,0,0);
    
    newItem->deepCopy(item);

    list->takeItem(item);
    delete list;
  }
  else
    qWarning("WARNING: IceClipboard::insertItem(...) null pointer");
}

//  void IceClipboard::insertDragItem(IceListViewItem* newItem)
//  {}

//  void IceClipboard::getDragItem(IceListViewItem* newItem);
//  {}

void IceClipboard::getItem(IceListViewItem* newItem) // virtual
{
  ;//qDebug("DEBUG: IceClipboard::getItem(...)");

  if ((newItem) && (item)) {
    IceListView* list = new IceListView();
    list->insertItem(item);
    item->deepCopy(newItem);
    list->takeItem(item);
    delete list;
  }
  else
    qWarning("WARNING: IceClipboard::getItem(...) null pointer");
}




