/*  GTKtalog.
 *  Copyright (C) 1999  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>
#if defined(OS_FREEBSD) || defined(OS_NETBSD) || defined(OS_OPENBSD)
#    include <sys/param.h>
#    include <sys/mount.h>
#endif
#include <gnome.h>
#include <string.h>

#define __DEF_CONFIG__
#include "addisk.h"
#include "buttonbar.h"
#include "config_common.h"
#include "exit.h"
#include "folder.h"
#include "interface.h"
#include "io.h"
#include "loadcat.h"
#include "setup.h"
#include "splash.h"
#include "thread_utils.h"
#include "progressbar.h"

#define P_FILE		100
#define P_GEOMETRY	101
#define P_WINTITLE	102
#define P_VERSION	103

CONFIG *my_config;

static char *popt_filename = NULL;
static char *popt_geometry = NULL;
static char *popt_wintitle = NULL;
struct poptOption command_line[] = {
  {"catalog", 'c', POPT_ARG_STRING
   || POPT_ARGFLAG_ONEDASH, &popt_filename, P_FILE,
   N_("Catalog file to load."), "filename"},
  {"geometry", 'g', POPT_ARG_STRING
   || POPT_ARGFLAG_ONEDASH, &popt_geometry, P_GEOMETRY,
   N_("Geometry. See `man X' for more info.")},
  {"title", 't', POPT_ARG_STRING
   || POPT_ARGFLAG_ONEDASH, &popt_wintitle, P_WINTITLE,
   N_("Title of the window"), "text"},
  {"version", 'v', POPT_ARGFLAG_ONEDASH, NULL, P_VERSION,
   N_("Prints the version of " PACKAGE)},
  POPT_AUTOHELP {NULL, 0, 0, NULL, 0}
};



GtkWidget *main_window;

static gint
save_session (GnomeClient * client, gint phase, GnomeSaveStyle save_style,
	      gint is_shutdown, GnomeInteractStyle interact_style,
	      gint is_fast, gpointer client_data)
{
  gchar **argv;
  guint argc;

  /* allocate 0-filled, so it will be NULL-terminated */
  argv = g_malloc0 (sizeof (gchar *) * 4);
  argc = 1;

  argv[0] = client_data;

  if (my_config->racine)
    {
      if (my_config->racine->catalog_filename_is_valid)
	{
	  argv[1] = "-c";
	  argv[2] = g_strdup (my_config->racine->catalog_filename->str);
	  argc = 3;
	}
    }
  gnome_client_set_clone_command (client, argc, argv);
  gnome_client_set_restart_command (client, argc, argv);

  return TRUE;
}

static void
session_die (GnomeClient * client, gpointer client_data)
{
  quit_prog (my_config->racine);
}

int
main (int argc, const char *argv[])
{
  poptContext optCon;
#ifndef GNOME1
  GnomeProgram *gnomeprog;
#endif
  GString *_title = NULL;
  GString *_filename = NULL;
  GString *_geometry = NULL;
  gint wx, wy, ww, wh;
  int c;
  GnomeClient *client;
  gchar *cwd, *fullname_prog;
  int l;

#if defined(__DEBUG__)
  GML_init (5, PACKAGE);
  GML_init_server (11142);
  GML_init_log_file (FALSE);
  GML_log_point (0, "main() debut");
#endif
  cwd = g_get_current_dir ();
  bindtextdomain (PACKAGE, GNOMELOCALEDIR);
#ifndef GNOME1
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#endif
  textdomain (PACKAGE);
#ifdef GNOME1
  gnome_init_with_popt_table (PACKAGE, VERSION, argc, (char **) argv,
			      command_line, 0, &optCon);
  optCon = poptGetContext (NULL, argc, (char **) argv, command_line, 0);
#else
  gnomeprog =
    gnome_program_init (PACKAGE, VERSION, LIBGNOMEUI_MODULE, argc,
			(gchar **) argv, GNOME_PARAM_POPT_TABLE, NULL, NULL);
  optCon = poptGetContext (NULL, argc, argv, command_line, 0);
#endif

  /* Processing of arguments */

  while ((c = poptGetNextOpt (optCon)) != -1)
    {
      switch (c)
	{
	case P_VERSION:
	  printf (_("GTKtalog\nVersion: %s\nLicence: GPL\n"
		    "More infos on " GTKTALOGWEB "\n"), VERSION);
	  exit (0);
	  break;
	case P_FILE:
	  _filename = g_string_new (popt_filename);
	  break;
	case P_GEOMETRY:
	  _geometry = g_string_new (popt_geometry);
	  break;
	case P_WINTITLE:
	  _title = g_string_new (popt_wintitle);
	  break;
	}
    }

  if (c < -1)
    {
      /* an error occurred during option processing */
      fprintf (stderr, "%s: %s\n",
	       poptBadOption (optCon, POPT_BADOPTION_NOALIAS),
	       poptStrerror (c));
      return (-1);
    }

  /*initialisation des differentes variables */

  client = gnome_master_client ();
  main_window = gnome_app_new (PACKAGE, "gtktalog");

  if (_title)
    {
      gtk_window_set_title (GTK_WINDOW (main_window), _title->str);
      g_string_free (_title, TRUE);
    }
  else
    {
      gtk_window_set_title (GTK_WINDOW (main_window), "GTKtalog V " VERSION);
    }
  gtk_window_set_wmclass (GTK_WINDOW (main_window),
			  "GTKtalog V " VERSION, "GTKtalog");
  gtk_widget_realize (main_window);

  my_config = init_config (GTK_WIDGET (main_window));
  my_config->update_edit_window = FALSE;
  my_config->calendar_widgets = NULL;
  my_config->fast_name = NULL;
  my_config->racine = NULL;

  splash_screen (GTK_WIDGET (main_window));

  if (_geometry)
    {
#ifdef GNOME1
      if (gnome_parse_geometry (_geometry->str, &wx, &wy, &ww, &wh) != TRUE)
	{
	  wx = 0;
	  wy = 0;
	  ww = 660;
	  wh = 350;
	}
      g_string_free (_geometry, TRUE);
      _geometry = NULL;
#else
      wx = 0;
      wy = 0;
      ww = 660;
      wh = 350;
#endif
    }
  else
    {
      wx = my_config->mainwindow_x;
      wy = my_config->mainwindow_y;
      ww = my_config->mainwindow_w;
      wh = my_config->mainwindow_h;
    }
  if (wx < 0)
    wx = 0;
  if (wy < 0)
    wy = 0;
  if (ww < 0)
    ww = 660;
  if (wh < 0)
    wh = 350;

  reinit_thread_status ();

  build_gui ();

  progress_setGnomeAppBar (NULL, GNOMEAPPBAR_SCAN, FALSE);
  fullname_prog = (char *) argv[0];
  if (!g_path_is_absolute (fullname_prog))
    {
      fullname_prog = g_concat_dir_and_file (cwd, fullname_prog);
    }
  g_free (cwd);

  gtk_signal_connect (GTK_OBJECT (client), "save_yourself",
		      GTK_SIGNAL_FUNC (save_session), fullname_prog);
  gtk_signal_connect (GTK_OBJECT (client), "die",
		      GTK_SIGNAL_FUNC (session_die), NULL);

  gtk_signal_connect (GTK_OBJECT (main_window), "delete_event",
		      G_CALLBACK (cb_quit_prog), my_config);

  gtk_widget_show (main_window);
#ifdef GNOME1
  if ((my_config->mainwindow_save_xywh) || (_geometry))
#else
  if (_geometry)
    gtk_window_parse_geometry (GTK_WINDOW (main_window), _geometry->str);
  else if (my_config->mainwindow_save_xywh)
#endif
    gdk_window_move_resize (main_window->window, wx, wy, ww, wh);

  my_config->current_pid = getpid ();

  if ((!_filename) && (my_config->load_file_at_boot))
    {
      _filename = g_string_new (my_config->file_to_load);
    }

  if (_filename)
    {
      set_thread_status_to_running ();
      gtk_entry_set_text (GTK_ENTRY (path_entry), "");
      my_config->racine = init_folder ();
      create_tree (my_config->racine);
      l = load_cat_from_file (_filename->str, my_config->racine);
      g_node_traverse (my_config->racine->tree,
		       G_PRE_ORDER, G_TRAVERSE_ALL, -1, add_gnode_to_ctree,
		       my_config->racine);
      ctree_window_add (my_config->racine->ctree);
      update_tree (my_config->racine);

      gtk_window_set_title (GTK_WINDOW (main_window),
			    my_config->racine->catalog_filename->str);
      g_string_free (_filename, TRUE);
      menus_set_sensitive (TRUE);
      reinit_thread_status ();
      if (l == -2)
	{
	  WARNING_DIALOG (_
			  ("At least one disk name was empty. A random name was used instead"),
			  main_window);
	}

    }

#if defined(__DEBUG__)
  GML_log_point (5, "main() DUMP END: before gtk_main()");
#endif
  set_search_running (FALSE);


  gtk_timeout_add (60000 * my_config->minutes_before_autosave, autosave,
		   NULL);

  gtk_main ();

#if defined(__DEBUG__)
  GML_log_point (5, "main(): quitting");
  GML_end ();
#endif
  return (0);
}
