/*  GTKtalog.
 *  Copyright (C) 1999-2000  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>
#include <gnome.h>
#include <time.h>
#include <stdio.h>
#include "date.h"
#include "config_common.h"

static void
quit_cal (GtkWidget * w, gpointer data)
{
  CALENDAR_WIDGETS *cw = data;
  gnome_dialog_close (GNOME_DIALOG (cw->dialog));
  return;
}



void
calendar_day_selected_double_click (GtkWidget * widget, gpointer data)
{
  CALENDAR_WIDGETS *cw = data;
  struct tm tm;

  memset (&cw->tm, 0, sizeof (tm));
  gtk_calendar_get_date (GTK_CALENDAR (widget), &cw->tm.tm_year,
			 &cw->tm.tm_mon, &cw->tm.tm_mday);

  cw->isValid = TRUE;
  quit_cal (cw->dialog, cw);
}


struct tm *
open_calendar (GtkWindow * parent)
{
  CALENDAR_WIDGETS *cw;
  gint button;
  GDate *d;
  struct tm *tm=NULL;

  cw = (CALENDAR_WIDGETS *) g_malloc (sizeof (CALENDAR_WIDGETS));
  cw->isValid = FALSE;

  cw->dialog = gnome_dialog_new (_("Date"), GNOME_STOCK_BUTTON_CANCEL, NULL);


  cw->calendar = gtk_calendar_new ();
  gtk_calendar_display_options (GTK_CALENDAR (cw->calendar),
				GTK_CALENDAR_SHOW_HEADING |
				GTK_CALENDAR_SHOW_DAY_NAMES |
				GTK_CALENDAR_WEEK_START_MONDAY);
  gtk_signal_connect (GTK_OBJECT (cw->calendar), "day_selected_double_click",
		      GTK_SIGNAL_FUNC (calendar_day_selected_double_click),
		      cw);


  gtk_box_pack_start (GTK_BOX (GNOME_DIALOG (cw->dialog)->vbox), cw->calendar,
		      TRUE, TRUE, 0);
  gnome_dialog_set_parent (GNOME_DIALOG (cw->dialog), parent);

  gtk_widget_show (cw->calendar);
  gtk_widget_show (cw->dialog);
  button = gnome_dialog_run_and_close (GNOME_DIALOG (cw->dialog));
  d = NULL;
  if (button == -1)
    {
      if (cw->isValid == TRUE)
	{
	  d = g_date_new_dmy((GDateDay)cw->tm.tm_mday, (GDateMonth)cw->tm.tm_mon+1, (GDateYear)cw->tm.tm_year);
	  tm = (struct tm*)g_malloc(sizeof(struct tm));
	  g_date_to_struct_tm(d,tm);
	  /* Don't know if gdate functions are bugged, if mktime is bugged or why I have to
	   * increment tm_hour
	   */
	  tm->tm_hour += 1;
	  
	}
    }
  g_free (cw);
  return (tm);
}
