/***************************************************************************
                          pg_connection.h  -  description
                             -------------------
    begin                : Sat May 20 2000
    copyright            : (C) 2000 by Thierry Florac
    email                : tflorac@free.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PG_CONNECTION_H
#define PG_CONNECTION_H

#include "libpq-fe.h"

typedef struct _pgConnection pgConnection;

pgConnection* pg_connection_new (void);

pgConnection* pg_connection_new_with_dialog (void);
pgConnection* pg_connection_new_with_params (gchar *hostname,
                                            gchar *port,
                                            gchar *database,
                                            gchar *username,
                                            gchar *password);

PGconn* pg_connection_get_handle (pgConnection *connection);
gchar*  pg_connection_get_hostname (pgConnection *connection);
gchar*  pg_connection_get_port (pgConnection *connection);
gchar*  pg_connection_get_database (pgConnection *connection);
gchar*  pg_connection_get_username (pgConnection *connection);
gchar*  pg_connection_get_password (pgConnection *connection);

void pg_connection_set_hostname (pgConnection *connection, gchar *hostname);
void pg_connection_set_port (pgConnection *connection, gchar *port);
void pg_connection_set_database (pgConnection *connection, gchar *database);
void pg_connection_set_username (pgConnection *connection, gchar *username);
void pg_connection_set_password (pgConnection *connection, gchar *password);

gboolean pg_connection_open (pgConnection *connection);
gboolean pg_connection_close (pgConnection *connection);
gboolean pg_connection_is_active (pgConnection *connection);

gboolean pg_connection_start (pgConnection *connection);
gboolean pg_connection_in_trans (pgConnection *connection);
gboolean pg_connection_execute (pgConnection *connection, gchar *sql);
void*    pg_connection_query (pgConnection *connection, gchar *sql);
gboolean pg_connection_commit (pgConnection *connection);
gboolean pg_connection_rollback (pgConnection *connection);

void pg_connection_show_error (pgConnection *connection, gchar *start, gchar *end);
void pg_connection_free (pgConnection *connection);


//
// pg_connection_dialog callbacks declaration
//
void
pg_connection_dialog_set_connection (pgConnection *connection);


void
on_pg_connection_dialog_show           (GtkWidget       *widget,
                                        gpointer         user_data);

void
on_pg_connection_dialog_ok_button_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data);

void
on_pg_connection_dialog_cancel_button_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data);

#endif
