/***************************************************************************
                          gpc_query.c  -  description
                             -------------------
    begin                : Wed May 17 2000
    copyright            : (C) 2000 by Thierry Florac
    email                : tflorac@free.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "gpc_app.h"

#include "gpc_query.h"
#include "gpc_query_intf.h"

#include "support.h"


gint   gpc_query_film_selection;
gint   gpc_query_image_selection;

gchar *gpc_query_film_params;
gchar *gpc_query_image_params;

gchar *gpc_query_film_with;
gchar *gpc_query_filmkey_with;
gchar *gpc_query_image_with;
gchar *gpc_query_imagekey_with;
gchar *gpc_query_combine_with;


/* Check to see if films keywords are queried */
gboolean   
gpc_query_get_film_keywords ( )
{
  gchar    *clause;
  gint      index;
  gboolean  test_keyword = FALSE;
  
  for (index = 0; ; index++) {
    if (!gtk_clist_get_text (GTK_CLIST (lookup_widget (gpc_query_dialog, "film_query_clist")), index, 0, &clause)) 
      break;
    test_keyword = test_keyword || (g_strncasecmp ("FILM_KEY", clause, 8) == 0);
  }
  return test_keyword;
}


/* Check to see if images keywords are queried */
gboolean   
gpc_query_get_image_keywords ( )
{
  gchar    *clause;
  gint      index;
  gboolean  test_keyword = FALSE;
  
  for (index = 0; ; index++) {
    if (!gtk_clist_get_text (GTK_CLIST (lookup_widget (gpc_query_dialog, "image_query_clist")), index, 0, &clause)) 
      break;
    test_keyword = test_keyword || (g_strncasecmp ("IMAGE_KEY", clause, 9) == 0);
  }
  return test_keyword;
}


void 
gpc_query_add_film_field_params (gpointer data, gpointer user_data)
{
  gchar    *list_clause;
  gboolean  is_keyword = FALSE;
  gchar    *temp;
  
  list_clause = (gchar *) data;
  if (user_data)
    is_keyword = (GPOINTER_TO_INT (user_data) == GPC_FILM_KEYWORD);
  if (is_keyword) {
    if (!g_strcasecmp (gpc_query_filmkey_with, "or")) {
      if (gpc_query_film_params) {
        temp = g_strdup_printf ("(%s) or (%s)", gpc_query_film_params, list_clause);
        g_free (gpc_query_film_params);
        gpc_query_film_params = temp;
      }
      else
        gpc_query_film_params = g_strdup (list_clause);
    }
    else { // gpc_query_filmkey_with == "and"
      if (gpc_query_film_params) {
        temp = g_strdup_printf ("%s and FILM.ID in (select FILM_ID from GPC_KEYWORD FILM_KEY where %s)", gpc_query_film_params, list_clause);
        g_free (gpc_query_film_params);
        gpc_query_film_params = temp;
      }
      else
        gpc_query_film_params = g_strdup_printf ("FILM.ID in (select FILM_ID from GPC_KEYWORD FILM_KEY where %s)", list_clause);
    }
  }
  else { // !is_keyword
    if (gpc_query_film_params) {
      temp = g_strdup_printf ("(%s) or (%s)", gpc_query_film_params, list_clause);
      g_free (gpc_query_film_params);
      gpc_query_film_params = temp;
    }
    else
      gpc_query_film_params = g_strdup (list_clause);
  }
}


void 
gpc_query_add_image_field_params (gpointer data, gpointer user_data)
{
  gchar    *list_clause;
  gboolean  is_keyword = FALSE;
  gchar    *temp;
  
  list_clause = (gchar *) data;
  if (user_data)
    is_keyword = (GPOINTER_TO_INT (user_data) == GPC_IMAGE_KEYWORD);
  if (is_keyword) {
    if (!g_strcasecmp (gpc_query_imagekey_with, "or")) {
      if (gpc_query_image_params) {
        temp = g_strdup_printf ("(%s) or (%s)", gpc_query_image_params, list_clause);
        g_free (gpc_query_image_params);
        gpc_query_image_params = temp;
      }
      else
        gpc_query_image_params = g_strdup (list_clause);
    }
    else { // gpc_query_imagekey_with == "and"
      if (gpc_query_image_params) {
        temp = g_strdup_printf ("%s and IMAGE.ID in (select IMAGE_ID from GPC_KEYWORD IMAGE_KEY where %s)", gpc_query_image_params, list_clause);
        g_free (gpc_query_image_params);
        gpc_query_image_params = temp;
      }
      else
        gpc_query_image_params = g_strdup_printf ("IMAGE.ID in (select IMAGE_ID from GPC_KEYWORD IMAGE_KEY where %s)", list_clause);
    }
  }
  else { // !is_keyword
    if (gpc_query_image_params) {
      temp = g_strdup_printf ("(%s) or (%s)", gpc_query_image_params, list_clause);
      g_free (gpc_query_image_params);
      gpc_query_image_params = temp;
    }
    else
      gpc_query_image_params = g_strdup (list_clause);
  }
}


/* Build films query selection "where" clause */
gchar*   
gpc_query_get_film_clause ( )
{
  gchar    *result = NULL;
  gchar    *clause;
  gchar    *temp;
  gchar    *field;
  gint      index_list;
  gint      index_params;
  gint      space_pos;
  gboolean  query_keyword = FALSE;
  GList    *params[GPC_FILM_LAST - GPC_FILM_FIRST + 1];
  
  for (index_params = GPC_FILM_FIRST; index_params < GPC_FILM_LAST + 1; index_params++)
    params[index_params] = NULL;
  for (index_list = 0; ; index_list++) {
    if (!gtk_clist_get_text (GTK_CLIST (lookup_widget (gpc_query_dialog, "film_query_clist")), index_list, 0, &clause)) 
      break;
    query_keyword = query_keyword || (g_strncasecmp ("FILM_KEY", clause, 8) == 0);
    for (space_pos = 0; (space_pos < strlen (clause)) && (clause[space_pos] != ' '); space_pos++);
    if (clause[space_pos] == ' ') {
      field = g_strndup (clause, space_pos);
      index_params = GPC_FILM_FIRST;
      while (g_strcasecmp (GpcQueryParamField[index_params], field) != 0)
        index_params++;
      params[index_params] = g_list_append (params[index_params], g_strdup (clause));
      g_free (field);
    }
  }
  for (index_params = GPC_FILM_FIRST; index_params < GPC_FILM_LAST + 1; index_params++) {
    if (params[index_params]) {
      if (gpc_query_film_params) {
        g_free (gpc_query_film_params);
	      gpc_query_film_params = NULL;
      }
      //g_list_foreach (params[index_params], gpc_query_add_film_field_params, NULL); 
      g_list_foreach (params[index_params], gpc_query_add_film_field_params, GINT_TO_POINTER (index_params)); 
      if (result) {
        //temp = g_strdup_printf ("%s and (%s)", result, gpc_query_film_params);
        temp = g_strdup_printf ("%s %s (%s)", result, gpc_query_film_with, gpc_query_film_params);
        g_free (gpc_query_film_params);
        gpc_query_film_params = NULL;
        g_free (result);
        result = temp;
      }
      else
        result = g_strdup_printf ("(%s)", gpc_query_film_params);
    }
  }  
  for (index_params = GPC_FILM_FIRST; index_params < GPC_FILM_LAST + 1; index_params++) {
    if (params[index_params]) {
      gpc_list_free (params[index_params]);
      params[index_params] = NULL;
    }
  }
  if (query_keyword) {
    temp = g_strdup_printf ("(%s) and (FILM.ID = FILM_KEY.FILM_ID)", result);
    g_free (result);
    result = temp;
  }
  return result;
}


/* Build images query selection "where" clause... */
gchar*   
gpc_query_get_image_clause ( )
{
  gchar   *result = NULL;
  gchar   *clause;
  gchar   *temp;
  gchar   *field;
  gint     index_list;
  gint     index_params;
  gint     space_pos;
  gboolean query_keyword = FALSE;
  GList   *params[GPC_IMAGE_LAST - GPC_IMAGE_FIRST + 1];

  /* params is an array of lists build for each image's query field            */
  /* each list is composed of the different queries relative to the same field */
  for (index_params = GPC_IMAGE_FIRST; index_params < GPC_IMAGE_LAST + 1; index_params++)
    params[index_params - GPC_IMAGE_FIRST] = NULL;
  /* The loop is executed for each entered images query param */
  for (index_list = 0;  ; index_list++) {
    /* "clause" is extracted from the previously pre-entered query element found in the list */
    if (!gtk_clist_get_text (GTK_CLIST (lookup_widget (gpc_query_dialog, "image_query_clist")), index_list, 0, &clause)) 
      break;
    /* "query_keyword" is true if there is a query parameter about an image keyword */
    query_keyword = query_keyword || (g_strncasecmp ("IMAGE_KEY", clause, 9) == 0);
    /* we are looking for the first "space" in the pre-entered query element */
    for (space_pos = 0; (space_pos < strlen (clause)) && (clause[space_pos] != ' '); space_pos++);
    /* if the space is found, we try to find the corresponding field name */
    if (clause[space_pos] == ' ') {
      field = g_strndup (clause, space_pos);
      index_params = GPC_IMAGE_FIRST;
      while (g_strcasecmp (GpcQueryParamField[index_params], field) != 0)
        index_params++;
      /* then, the entered query element is added to the corresponding field queries... */
      params[index_params - GPC_IMAGE_FIRST] = g_list_append (params[index_params - GPC_IMAGE_FIRST], g_strdup (clause));
      g_free (field);
    }
  }
  /* When all query elements have been affected to the fields, these elements are combined together */
  for (index_params = GPC_IMAGE_FIRST; index_params < GPC_IMAGE_LAST + 1; index_params++) {
    if (params[index_params - GPC_IMAGE_FIRST]) {
      if (gpc_query_image_params) {
        g_free (gpc_query_image_params);
      	gpc_query_image_params = NULL;
      }
      /* for each field, query elements are combined together with 'or' */
      //g_list_foreach (params[index_params - GPC_IMAGE_FIRST], gpc_query_add_image_field_params, NULL);
      g_list_foreach (params[index_params - GPC_IMAGE_FIRST], gpc_query_add_image_field_params, GINT_TO_POINTER (index_params));
      if (result) {
        //temp = g_strdup_printf ("%s and (%s)", result, gpc_query_image_params);
        temp = g_strdup_printf ("%s %s (%s)", result, gpc_query_image_with, gpc_query_image_params);
        g_free (gpc_query_image_params);
        gpc_query_image_params = NULL;
        g_free (result);
        result = temp;
      }
      else
        result = g_strdup_printf ("(%s)", gpc_query_image_params);
    }
  }  
  /* Query elements are then freed for each field */
  for (index_params = GPC_IMAGE_FIRST; index_params < GPC_IMAGE_LAST + 1; index_params++) {
    if (params[index_params - GPC_IMAGE_FIRST]) {
      gpc_list_free (params[index_params - GPC_IMAGE_FIRST]);
      params[index_params - GPC_IMAGE_FIRST] = NULL;
    }
  }
  /* If keywords are queried, an internal join is added */
  if (query_keyword && !g_strcasecmp (gpc_query_imagekey_with, "or")) {
    temp = g_strdup_printf ("(%s) and (IMAGE.ID = IMAGE_KEY.IMAGE_ID)", result);
    g_free (result);
    result = temp;
  }
  return result;
}


pgQuery* 
gpc_query_get_films (pgConnection *connection)
{
  pgQuery  *query = NULL;
  gchar    *where_film;
  gchar    *where_image;
  gchar    *from_film;
  gchar    *from_image;
  gchar    *sql;

  if (gpc_query_film_with)
    g_free (gpc_query_film_with);
  gpc_query_film_with = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (lookup_widget (gpc_query_dialog, "film_fields_combine_and_button"))) ?
                        g_strdup ("and") : g_strdup ("or");
  gpc_query_filmkey_with = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (lookup_widget (gpc_query_dialog, "film_keywords_combine_and_button"))) ?
                           g_strdup ("and") : g_strdup ("or");
  gpc_query_image_with = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (lookup_widget (gpc_query_dialog, "image_fields_combine_and_button"))) ?
                         g_strdup ("and") : g_strdup ("or");
  gpc_query_imagekey_with = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (lookup_widget (gpc_query_dialog, "image_keywords_combine_and_button"))) ?
                            g_strdup ("and") : g_strdup ("or");
  gpc_query_combine_with = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (lookup_widget (gpc_query_dialog, "gpc_query_combine_and_button"))) ?
                           g_strdup ("and") : g_strdup ("or");

  where_film = gpc_query_get_film_clause ();
  where_image = gpc_query_get_image_clause ();
  if (gpc_query_get_image_keywords () && !g_strcasecmp (gpc_query_imagekey_with, "or"))
    from_image = "GPC_IMAGE IMAGE, GPC_KEYWORD IMAGE_KEY";
  else
    from_image = "GPC_IMAGE IMAGE";
  if (where_film) {
    if (gpc_query_get_film_keywords ())
      from_film = "GPC_FILM FILM, GPC_KEYWORD FILM_KEY";
    else
      from_film = "GPC_FILM FILM";
    if (where_image)
      sql = g_strdup_printf ("select distinct FILM.ID, FILM.NUMBER, FILM.DESCRIPTION "
                             "from %s "
                             "where (%s) %s (FILM.ID in (select distinct IMAGE.FILM_ID from %s where %s)) "
                             "order  by FILM.NUMBER", from_film, where_film, gpc_query_combine_with, from_image, where_image);
    else
      sql = g_strdup_printf ("select distinct FILM.ID, FILM.NUMBER, FILM.DESCRIPTION "
                             "from %s "
                             "where %s "
                             "order by FILM.NUMBER", from_film, where_film);
  }
  else {
    if (where_image)
      sql = g_strdup_printf ("select distinct FILM.ID, FILM.NUMBER, FILM.DESCRIPTION "
                             "from GPC_FILM FILM "
                             "where (FILM.ID in (select distinct IMAGE.FILM_ID from %s where %s)) "
                             "order by FILM.NUMBER", from_image, where_image);
    else
      sql = g_strdup ("select distinct FILM.ID, FILM.NUMBER, FILM.DESCRIPTION "
                      "from GPC_FILM FILM "
                      "order by FILM.NUMBER");
  }
  //g_print ("Films: %s\n", sql); fflush (stdout);
  query = pg_query_new_with_sql (connection, sql);
  g_free (sql);
  g_free (where_film);
  g_free (where_image);  
  if (pg_query_open (query) < 0) {
    pg_query_free (query);
    return NULL;
  }
  return query;
}


/* build SQL images query from entered params... */
pgQuery* 
gpc_query_get_images (pgConnection *connection, gint film_ID)
{
  pgQuery  *query = NULL;
  gchar    *where;
  gchar    *from;
  gchar    *sql;

  where = gpc_query_get_image_clause ();
  if (gpc_query_get_image_keywords () && !g_strcasecmp (gpc_query_imagekey_with, "or")) 
    from = "GPC_IMAGE IMAGE, GPC_KEYWORD IMAGE_KEY";
  else
    from = "GPC_IMAGE IMAGE";
  if (where) 
    sql = g_strdup_printf ("select distinct IMAGE.ID, IMAGE.NUMBER, IMAGE.DESCRIPTION "
                           "from %s "
                           "where (IMAGE.FILM_ID = %d) and (%s) "
                           "order by IMAGE.NUMBER", from, film_ID, where);
  else
    sql = g_strdup_printf ("select distinct IMAGE.ID, IMAGE.NUMBER, IMAGE.DESCRIPTION "
                           "from %s "
                           "where (IMAGE.FILM_ID = %d) "
                           "order by IMAGE.NUMBER", from, film_ID);
  //g_print ("Images: %s\n", sql); fflush (stdout);
  query = pg_query_new_with_sql (connection, sql);
  g_free (sql);
  if (where)
    g_free (where);
  if (pg_query_open (query) < 0) {
    pg_query_free (query);
    return NULL;
  }
  return query;
}


void
on_gpc_query_dialog_realize            (GtkWidget       *widget,
                                        gpointer         user_data)
{
  gtk_clist_select_row (GTK_CLIST (lookup_widget (gpc_query_dialog, "film_query_clist")), -1, 0);
  gtk_clist_select_row (GTK_CLIST (lookup_widget (gpc_query_dialog, "image_query_clist")), -1, 0);
  gpc_query_film_selection = -1;
  gpc_query_image_selection = -1;
}


/* Apply query params to build SQL query */
void
on_gpc_query_dialog_apply              (GnomePropertyBox *gnomepropertybox,
                                        gint              arg1,
                                        gpointer          user_data)
{
  gchar *test1;
  gchar *test2;
  
  if (arg1 != -1)
    return;
  /* if modified, store and free current image properties before changing selection */
  if (gpc_image_infos && gpc_image_modified) {
    gpc_image_infos_store (gpc_connection, gpc_image_infos);
    gpc_image_infos_free (gpc_image_infos);
    gpc_image_infos = NULL;
  }
  /* if modified, store and free current film properties before changing selection */
  if (gpc_film_infos && gpc_film_modified) {
    gpc_film_infos_store (gpc_connection, gpc_film_infos);
    gpc_film_infos_free (gpc_film_infos);
    gpc_film_infos = NULL;
  }
  /* clear films and images lists, and free corresponding queries */
  gtk_clist_clear (films_clist);
  gtk_clist_clear (images_clist);
  if (gpc_images) {
    pg_query_free (gpc_images);
    gpc_images = NULL;
  }
  if (gpc_films) {
    pg_query_free (gpc_films);
    gpc_films = NULL;
  }
  /* refresh films list from a new query or from the full list */
  gpc_query_mode = gtk_clist_get_text (GTK_CLIST (lookup_widget (gpc_query_dialog, "film_query_clist")), 0, 0, &test1) ||
                   gtk_clist_get_text (GTK_CLIST (lookup_widget (gpc_query_dialog, "image_query_clist")), 0, 0, &test2);
  if (gpc_query_mode)
    gpc_films = gpc_query_get_films (gpc_connection);
  else
    gpc_films = gpc_film_get_list (gpc_connection);
  gpc_app_update_films_list (gpc_films);
}


/* Values lists are updated according to the selected field name... */
void
on_query_field_combo_entry_changed     (GtkEditable     *editable,
                                        gpointer         user_data)
{
  gint    index;
  gchar  *value;
  
  value = gtk_editable_get_chars (editable, 0, -1);
  for (index = 0; index < GPC_QUERY_END; index++) {
    if (g_strcasecmp (value, _(GpcQueryParamLib[index])) == 0)
      break;
  }
  if (index == GPC_QUERY_END)
    return;
  switch (index) {
    case GPC_FILM_KIND     : if (!gpc_film_kinds)
                               gpc_film_kinds = gpc_app_get_keywords (gpc_connection, "GPC_FILM_KIND");
                             gtk_combo_set_popdown_strings (GTK_COMBO (lookup_widget (gpc_query_dialog, "query_value_combo")), gpc_film_kinds);
                             break;
    case GPC_FILM_MAKER    : if (!gpc_film_makers)
                               gpc_film_makers = gpc_app_get_keywords (gpc_connection, "GPC_FILM_MAKER");
                             gtk_combo_set_popdown_strings (GTK_COMBO (lookup_widget (gpc_query_dialog, "query_value_combo")), gpc_film_makers);
                             break;
    case GPC_FILM_MODEL    : if (!gpc_film_models)
                               gpc_film_models = gpc_app_get_keywords (gpc_connection, "GPC_FILM_MODEL");
                             gtk_combo_set_popdown_strings (GTK_COMBO (lookup_widget (gpc_query_dialog, "query_value_combo")), gpc_film_models);
                             break;
    case GPC_CAMERA_MAKER  : if (!gpc_camera_makers)
                               gpc_camera_makers = gpc_app_get_keywords (gpc_connection, "GPC_CAMERA_MAKER");
                             gtk_combo_set_popdown_strings (GTK_COMBO (lookup_widget (gpc_query_dialog, "query_value_combo")), gpc_camera_makers);
                             break;
    case GPC_CAMERA_MODEL  : if (!gpc_camera_models)
                               gpc_camera_models = gpc_app_get_keywords (gpc_connection, "GPC_CAMERA_MODEL");
                             gtk_combo_set_popdown_strings (GTK_COMBO (lookup_widget (gpc_query_dialog, "query_value_combo")), gpc_camera_models);
                             break;
    case GPC_LENS_MAKER    : if (!gpc_lens_makers)
                               gpc_lens_makers = gpc_app_get_keywords (gpc_connection, "GPC_LENS_MAKER");
                             gtk_combo_set_popdown_strings (GTK_COMBO (lookup_widget (gpc_query_dialog, "query_value_combo")), gpc_lens_makers);
                             break;
    case GPC_LENS_MODEL    : if (!gpc_lens_models)
                               gpc_lens_models = gpc_app_get_keywords (gpc_connection, "GPC_LENS_MODEL");
                             gtk_combo_set_popdown_strings (GTK_COMBO (lookup_widget (gpc_query_dialog, "query_value_combo")), gpc_lens_models);
                             break;
    case GPC_FILM_KEYWORD  : 
    case GPC_IMAGE_KEYWORD : if (!gpc_keywords)
                               gpc_keywords = gpc_app_get_keywords (gpc_connection, "GPC_KEY");
                             gtk_combo_set_popdown_strings (GTK_COMBO (lookup_widget (gpc_query_dialog, "query_value_combo")), gpc_keywords);
                             break;
    default                : gtk_combo_set_popdown_strings (GTK_COMBO (lookup_widget (gpc_query_dialog, "query_value_combo")), NULL);
  }
}


/* This function is called each time the "add" button is clicked */
void
on_query_params_add_button_clicked     (GtkButton       *button,
                                        gpointer         user_data)
{
  gchar  *fields[2];
  gint    index_param;
  gint    index_operator;
  gchar  *field;
  gchar  *operator;
  gchar  *value;
  gchar  *sql_value;
  gfloat  float_value;

  gchar  *old_locale;
  gchar  *saved_locale;

  /* 1 - Get field, operator and value fields as they were entered... */  
  field = gtk_editable_get_chars (GTK_EDITABLE (lookup_widget (gpc_query_dialog, "query_field_combo_entry")), 0, -1);
  operator = gtk_editable_get_chars (GTK_EDITABLE (lookup_widget (gpc_query_dialog, "query_operator_combo_entry")), 0, -1);
  value = gtk_editable_get_chars (GTK_EDITABLE (lookup_widget (gpc_query_dialog, "query_value_combo_entry")), 0, -1);
  if (((field == NULL) || (strlen (field) == 0)) ||
      ((operator == NULL) || (strlen (operator) == 0)) ||
      ((value == NULL) || (strlen (value) == 0)))
    return;
  /* 2 - Check to see if the entered field is present is the fields list */
  for (index_param = 0; index_param < GPC_QUERY_END; index_param++)
    if (g_strcasecmp (field, _(GpcQueryParamLib[index_param])) == 0)
      break;
  /* 3 - If the selected film is correct... */
  if (index_param < GPC_QUERY_END) {
    /* 3.1 - Check to see if the entered operator is a predefined one */
    for (index_operator = 0; index_operator < GPC_QUERY_OPERATORS; index_operator++)
      if (g_strcasecmp (operator, GpcQueryOperator[index_operator]) == 0)
        break;
    /* 3.2 - If the operator is known to us, operate accordingly to the database field type : */
    /*     - string values are 'sql-ized' with single quotes                                  */
    /*     - float values are converted with the correct locale                               */
    if (index_operator < GPC_QUERY_OPERATORS) {
      switch (index_param) {
        case GPC_FILM_PATHNAME     :
        case GPC_FILM_KIND         :
        case GPC_FILM_NUMBER       :
        case GPC_FILM_MAKER        :
        case GPC_FILM_MODEL        :
        case GPC_FILM_PERIOD       :
        case GPC_FILM_DESCRIPTION  :
        case GPC_FILM_KEYWORD      :
        case GPC_CAMERA_MAKER      :
        case GPC_CAMERA_MODEL      :
        case GPC_IMAGE_FILENAME    :
        case GPC_IMAGE_MIME_TYPE   :
        case GPC_IMAGE_NUMBER      :
        case GPC_IMAGE_SPEED       :
        case GPC_IMAGE_DESCRIPTION :
        case GPC_IMAGE_KEYWORD     :
        case GPC_LENS_MAKER        :
        case GPC_LENS_MODEL        : sql_value = get_sql_string (value);
                                     fields[0] = g_strdup_printf ("%s %s %s", GpcQueryParamField[index_param], operator, sql_value);
                                     g_free (sql_value);
                                     break;
        case GPC_LENS_APERTURE     :
        case GPC_IMAGE_LATITUDE    :
        case GPC_IMAGE_LONGITUDE   :
        case GPC_IMAGE_ELEVATION   :
        case GPC_IMAGE_DIRECTION   :
        case GPC_IMAGE_PITCH       :
        case GPC_IMAGE_ROLL        : float_value = atof (value);
                                     old_locale = setlocale (LC_NUMERIC, NULL);
                                     saved_locale = g_strdup (old_locale);
                                     setlocale (LC_NUMERIC, "C");
                                     fields[0] = g_strdup_printf ("%s %s %.3f", GpcQueryParamField[index_param], operator, float_value);
                                     setlocale (LC_NUMERIC, saved_locale);
                                     g_free (saved_locale);
                                     break;
        default                    : fields[0] = g_strdup_printf ("%s %s %s", GpcQueryParamField[index_param], operator, value);
                                     break;
      }
    }
    else
      fields[0] = g_strdup_printf ("%s %s %s", GpcQueryParamField[index_param], operator, value);
    fields[1] = NULL;
    if (index_param < GPC_IMAGE_ID)
      gtk_clist_append (GTK_CLIST (lookup_widget (gpc_query_dialog, "film_query_clist")), fields);
    else
      gtk_clist_append (GTK_CLIST (lookup_widget (gpc_query_dialog, "image_query_clist")), fields);
    gnome_property_box_changed (GNOME_PROPERTY_BOX (gpc_query_dialog));
  }
  g_free (value);
  g_free (operator);
  g_free (field);
}


void
on_film_query_clist_select_row         (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  gpc_query_film_selection = row;
}


void
on_film_query_delete_button_clicked    (GtkButton       *button,
                                        gpointer         user_data)
{
  if (gpc_query_film_selection == -1)
    return;
  
  gtk_clist_remove (GTK_CLIST (lookup_widget (gpc_query_dialog, "film_query_clist")), gpc_query_film_selection);
  gnome_property_box_changed (GNOME_PROPERTY_BOX (gpc_query_dialog));
}


void
on_film_query_clear_button_clicked     (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_clist_clear (GTK_CLIST (lookup_widget (gpc_query_dialog, "film_query_clist")));
  gpc_query_film_selection = -1;
  gnome_property_box_changed (GNOME_PROPERTY_BOX (gpc_query_dialog));
}


void
on_image_query_clist_select_row        (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  gpc_query_image_selection = row;
}


void
on_image_query_delete_button_clicked   (GtkButton       *button,
                                        gpointer         user_data)
{
  if (gpc_query_image_selection == -1)
    return;
  gtk_clist_remove (GTK_CLIST (lookup_widget (gpc_query_dialog, "image_query_clist")), gpc_query_image_selection);
  gnome_property_box_changed (GNOME_PROPERTY_BOX (gpc_query_dialog));
}


void
on_image_query_clear_button_clicked    (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_clist_clear (GTK_CLIST (lookup_widget (gpc_query_dialog, "image_query_clist")));
  gpc_query_image_selection = -1;
  gnome_property_box_changed (GNOME_PROPERTY_BOX (gpc_query_dialog));
}

void
on_query_operator_toggled              (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  gnome_property_box_changed (GNOME_PROPERTY_BOX (gpc_query_dialog));
}

