import tiling

import gtk


GCONF_BACKGROUND = "/desktop/gnome/background"


#
# Restricts the given coordinates to visible values.
#
def _crop_coords(x, y, width, height):

    scrwidth = gtk.gdk.screen_width()
    scrheight = gtk.gdk.screen_height()

    x = min(x, scrwidth - 1)
    y = min(y, scrheight - 1)

    width = min(scrwidth - x, width)
    height = min(scrheight - y, height)

    return (x, y, width, height)



#
# Captures the wallpaper image by making a screen shot.
#
def get_wallpaper_fallback(x, y, width, height):

    x, y, width, height = _crop_coords(x, y, width, height)

    rootwin = gtk.gdk.get_default_root_window()
    pbuf = gtk.gdk.Pixbuf(0, 1, 8, width, height)
    pbuf.get_from_drawable(rootwin, rootwin.get_colormap(),
                           x, y, 0, 0, width, height)

    return pbuf



#
# Captures the wallpaper image by accessing the background pixmap.
#
def get_wallpaper(widget, x, y, width, height):

    x, y, width, height = _crop_coords(x, y, width, height)
    # get wallpaper
    try:
        pmap_id = get_wallpaper_id()
        tiling.tile_transparency(widget, pmap_id, x, y, width, height)
    except:
        raise NotImplementedError



#
# Captures solid color wallpapers. Requires GNOME.
#
def get_wallcolor(width, height):

    import gconf
    client = gconf.client_get_default()
    value = client.get(GCONF_BACKGROUND + "/primary_color")
    color = value.get_string()

    pbuf = gtk.gdk.Pixbuf(0, 1, 8, width, height)
    c = gtk.gdk.color_parse(color)
    fillr = (c.red / 256) << 24
    fillg = (c.green / 256) << 16
    fillb = (c.blue / 256) << 8
    fillcolor = fillr | fillg | fillb | 255
    pbuf.fill(fillcolor)

    return pbuf



#
# Returns the ID of the background pixmap.
#
def get_wallpaper_id():

    try:
        root = gtk.gdk.get_default_root_window()
        ident = root.property_get("_XROOTPMAP_ID", "PIXMAP")[2][0]
        return long(ident)

    except:
        raise NotImplementedError

