from ConfigDialog import ConfigDialog
from GConfBackend import backend

#
# Class for settings. Settings can be bound to objects and can be visualized in
# a configuration dialog.
#
class ConfigSettings:

    def __init__(self):

        self.__ident = ""

        self.__getter = None
        self.__setter = None
        self.__caller = None
        self.__callback = None

        self.__items = []


    def set_getter_and_setter_and_caller(self, getter, setter, caller):

        self.__getter = getter
        self.__setter = setter
        self.__caller = caller


    def set_callback(self, callback):

        self.__callback = callback
        

    def __setter_wrapper(self, key, value):

        self.__setter(key, value)

        # save config
        backend.set(self.__ident, key, value)

        # run callback
        if (self.__callback):
            if (str(value).startswith("\"")): value = value[1:-1]
            self.__caller(self.__callback, key, value)
        

    def __getter_wrapper(self, key):

        value = self.__getter(key)



    def initialize(self, ident):

        self.__ident = ident

        # get values from GConf
        # set them with __setter (not the wrapper)
        for key in backend.list(self.__ident):
            value = backend.get(self.__ident, key)
            try:
                self.__setter(key, value)
            except:
                import sys; print >>sys.stderr, \
                   "Couldn't pass arguments (%s, %s) to setter." % (key, value)
                import traceback; traceback.print_exc()

            # run callback
            if (self.__callback):
                if (str(value).startswith("\"")): value = value[1:-1]
                self.__caller(self.__callback, key, value)
        #end for
        

    def add_item(self, itype, attrs):

        self.__items.append((itype, attrs))
        

    def show(self):

        dialog = ConfigDialog()
        dialog.set_items(self.__items, self.__getter, self.__setter_wrapper)
        dialog.show()
