# First draft 05/01/96    Jianjun

#constrct a FitsTable object
# FitsTable FitsTableObjName FitsFileObjName chdu 

class FitsTable {
    inherit Table

    constructor {args} {}
    destructor         {}

    public method setFileName { fName }
    public method dispTable   { {cols {}} }

    #-------------------------------

    protected method tableHighLight {}
    protected method drawTable {}
    protected method buildNewMenus {}
    protected method postMenus {}
    protected method formatTable {}
    protected method updateHL {}
    protected method updateNumCols {}

    protected method writeTabData {col row val}
    protected method readTabData {fCol fRow nCols nRows}
    protected method getFormattedData {col row}
    protected method getRawData {col row}
    protected method putRawData {col row val}
    protected method getRawDataBlock { fCol fRow lCol lRow }
    protected method putRawDataBlock { fCol fRow data }

    private method selAllCol {}
    private method unselAllCol {}
    private method makeColSelList {}
    private method colInfoSelCmd {}
    private method chgTDisp {}  
    private method chkTDisp {tdisp}  

    private variable col_info
    private variable colSelState
    private variable isTableDisplayed 0
}


body FitsTable::constructor {args} {

    set fFObj [lindex $args 0]
    set fFObj FitsExtension::$fFObj
    set father [lindex $args 1]

    set chdu           [$fFObj cget -chdu]
    set isFailedToCopy [$fFObj cget -isFailedToCopy]
    set fitsfileCmd    [$fFObj cget -fitsfile]
    set fileName       [$fFObj getOrigName]

# Table info        
    set tabType [eval $fFObj getTabInfo hdutype]
    
    if { ($tabType != "Binary Table") \
	     && ($tabType != "ASCII Table") } {
	puts "It is not a table \n"
	return 
    }
    
    set numCols  [$fFObj getTabInfo ncols]       
    set numRows  [$fFObj getTabInfo nrows]
    set colNames [$fFObj getTabInfo column]
    set colSelList $colNames

    $father addChild $this table
}

body FitsTable::destructor {} {

    set isBeingDestroyed 1
    if { [winfo exists $droot] } {
       destroy $droot
    }

    $father freeChild $this
}


body FitsTable::setFileName { fName } {

   Table::setFileName $fName
   .fvwinkeeper signoff  $droot
   .fvwinkeeper register $droot "Table" [urlTail $fName] $chdu \
         $this
   if { [llength $myChildren] } {
      foreach child $myChildren {
         # Not all children contain setFileName
         catch {$child setFileName $fName}
      }
   }
}


body FitsTable::drawTable {} {

   Table::drawTable

   bind $droot <<DeleteRows>>  [code $this selRowsFrExpr 1]
   bind $droot <<DeleteCols>>  [code $this tryDelCols]
   bind $droot <<InsertRows>>  [code $this addRows]
   bind $droot <<InsertCols>>  [code $this addCols]
   bind $droot <<DispFormat>>  [code $this formatTable]

   bind $droot <<Plot>>        [code $this plotCmd]
   bind $droot <<Sort>>        [code $this sortCmd]
   bind $droot <<Calc>>        [code $this calculateCmd]
   bind $droot <<Histogram>>   [code $this histoCmd]
   bind $droot <<Statistics>>  [code $this statCmd]
}


body FitsTable::buildNewMenus {} {

   Table::buildNewMenus

   # Add some items to the Edit menu

   #    Insert

   $mBar.edit insert "Prefer*" cascade -label "Insert" -menu $mBar.edit.insert
   menu $mBar.edit.insert -tearoff false
   $mBar.edit.insert add command -label "Row" \
         -command "doMenuEvent <<InsertRows>>"
   $mBar.edit.insert add command -label "Column" \
         -command "doMenuEvent <<InsertCols>>"

   #    Delete

   $mBar.edit insert "Prefer*" cascade -label "Delete" -menu $mBar.edit.delete
   menu $mBar.edit.delete -tearoff false
   $mBar.edit.delete add command -label "Rows" \
         -command "doMenuEvent <<DeleteRows>>"
   $mBar.edit.delete add command -label "Selected column" \
         -command "doMenuEvent <<DeleteCols>>"

   #    Display Format

   $mBar.edit insert "Prefer*" command -label "Display Format" \
         -command "doMenuEvent <<DispFormat>>"

   $mBar.edit insert "Prefer*" separator


   # Fill in the TOOLS menu

   $mBar.tools add command -label "Plot..." \
         -command "doMenuEvent <<Plot>>"
   $mBar.tools add command -label "Sort Rows..." \
         -command "doMenuEvent <<Sort>>"
   $mBar.tools add command -label "Calculator..." \
         -command "doMenuEvent <<Calc>>"
   $mBar.tools add command -label "Histogram..." \
         -command "doMenuEvent <<Histogram>>"
   $mBar.tools add command -label "Statistics..." \
         -command "doMenuEvent <<Statistics>>"
}


body FitsTable::postMenus {} {

   Table::postMenus

   set anyColSelected [sarray colState 0 [expr $dispCols-1] 1]
   if { $anyColSelected } {
      $mBar.edit.delete entryconfigure "*column*" -state normal
   } else {
      $mBar.edit.delete entryconfigure "*column*" -state disabled
   }

   if { $isFailedToCopy } {
       $mBar.tools entryconfigure "Sort Rows..." -state disabled
       $mBar.tools entryconfigure "Calculator..." -state disabled
   } else {
       $mBar.tools entryconfigure "Sort Rows..." -state normal
       $mBar.tools entryconfigure "Calculator..." -state normal
   }
   update idle
}


body FitsTable::formatTable { } {

    set fmtWin .fmtInfo
    catch {destroy $fmtWin}
    powToplevel $fmtWin .dummy
    wm title $fmtWin "fv: Edit Display Format"

    iwidgets::combobox   $fmtWin.name  -labeltext "Column Name"  \
          -labelpos w \
          -selectioncommand [code $this colInfoSelCmd] \
          -textvariable [scope col_info(name)]  -editable 0 
    eval $fmtWin.name insert list end $colSelList
    set col_info(name) [lindex $colSelList 0]

    iwidgets::entryfield $fmtWin.w -labeltext "TDISP Keyword" \
          -labelpos w \
          -width 10 \
          -textvariable [scope col_info(disp)] \
          -command [code $this chgTDisp]
    colInfoSelCmd 

    grid $fmtWin.name -row 1 -col 1 -sticky ew
    grid $fmtWin.w    -row 2 -col 1 -sticky ew

    iwidgets::buttonbox $fmtWin.bbox
    $fmtWin.bbox add apply -text Apply -command [code $this chgTDisp]
    $fmtWin.bbox add help   -text Help -command "hhelp displayFormat"
    $fmtWin.bbox add cancel -text Exit -command "destroy $fmtWin"

    grid $fmtWin.bbox  -row 3 -col 1

    iwidgets::Labeledwidget::alignlabels $fmtWin.name $fmtWin.w
}


body FitsTable::updateNumCols {} {
   set numCols  [$fFObj getTabInfo ncols]
   set colNames [$fFObj getTabInfo column]
}


body FitsTable::colInfoSelCmd {} {
    set name $col_info(name)
    set col_info(disp) [string trim [lindex $colInfo($name) 3] ']
    set curColType [string trim [lindex $colInfo($name) 1] ']
    chkTDisp $col_info(disp) 
}

body FitsTable::chgTDisp {} {
    regsub -all " " $col_info(disp) "" [scope col_info(disp)]
    set tmpTdisp [chkTDisp $col_info(disp) ]
    if { $tmpTdisp  == "NO" } {
	error "Illegal TDISP value, see HELP"
	return
    } else {
	set col_info(disp) $tmpTdisp
    }
    set tmpPos [lsearch -exact $colNames $col_info(name)]

    if { $tmpPos == -1} {
	error "No such column."
	return
    } else {
	set n [expr $tmpPos+1]
	if { $tmpTdisp == "" } {
	    $fFObj delNthKey  "TDISP$n"
	} else {
	    $fFObj putKwd "TDISP$n '$col_info(disp)'" 1 
	}
	set colInfo($col_info(name)) \
	    [lreplace $colInfo($col_info(name)) 3 3 '$col_info(disp)']

     }
    $fFObj changeFile
# refresh 
    refresh
    updateRestDisps 
}

body FitsTable::chkTDisp {tdisp} {

# illegal TDISP: w - width, m - minimum number of digits, d - number of didgets,
# e - number of digits in the exp.   
# Aw
# Lw
# Iw.m
# Bw.m (binary integers only)
# Ow.m (Octal integers only)
# Zw.m (Hexadecimal integer)
# Fw.d
# Ew.dEe    
# ENw.d
# ESw.d
# Gw.dEe
# Dw.dEe
# also allow lower case starting char

    if {($tdisp == "") || ($tdisp == " ")} return ""

    set typeIdx  [string range $tdisp 0 0]
    set type $typeIdx
    set tmp1 [string range $tdisp 0 1]
    switch $typeIdx {
	a -
	A { 
	    if { [regexp {[Aa]} $curColType] == 0 } {
		error "Cannot format column to character type"
		return
	    }
	    scan $tdisp "$typeIdx%d" w 
	}
	l -
	L {
	    if { [regexp {[Ll]} $curColType] == 0 } {
		error "Cannot format column to logical type"
		return
	    }
	    scan $tdisp "$typeIdx%d" w 
	}
	i -
	I {
	    if { [regexp {[IJBijb]} $curColType] == 0 } {
		error "Cannot format column to integer type"
		return
	    }
	    scan $tdisp "$typeIdx%d.%d" w m 
	}
	b -
	B {
	    if { [regexp {[IJBijb]} $curColType] == 0 } {
		error "Cannot format column to byte type"
		return
	    } 
	    scan $tdisp "$typeIdx%d.%d" w m 
	}
	o -
	O {
	    if { [regexp {[IJBijb]} $curColType] == 0 } {
		error "Cannot format column to octal integer type"
		return
	    } 
	    scan $tdisp "$typeIdx%d.%d" w m 
	}
	z -
	Z {
	    if { [regexp {[IJBijb]} $curColType] == 0 } {
		error "Cannot format column to hexadecimal integer"
		return
	    } 
	    scan $tdisp "$typeIdx%d.%d" w m 
	}
	f -
	F {
	    if { [regexp {[FEDGfedg]} $curColType] == 0 } {
		error "Cannot format column to float type"
		return
	    }  
	    scan $tdisp "$typeIdx%d.%d" w m }
	e -
	E {
	    if { [regexp {[FEDGfedg]} $curColType] == 0 } {
		error "Cannot format column to E type"
		return
	    }  	    
	    switch $tmp1 {
		EN {scan $tdisp "EN%d.%dE%d" w d e; set type EN }
		ES {scan $tdisp "ES%d.%dE%d" w d e; set type ES }
		default {scan $tdisp "$typeIdx%d.%d$typeIdx%d" w d e}
	    }
	}
	g -
	G {
	    if { [regexp {[FEDGfedg]} $curColType] == 0 } {
		error "Cannot format column to G type"
		return
	    }  	 

	    scan $tdisp "$typeIdx%d.%dE%d" w d e 
	}
	d -
	D {
	    if { [regexp {[FEDGfedg]} $curColType] == 0 } {
		error "Cannot format column to double type"
		return
	    }  	 
	    scan $tdisp "$typeIdx%d.%dE%d" w d e 
	}
	default {error "Unknown TDISP type"; return NO}
    }

    if { [info exist w] == 0 } {
	return NO
    } 

    set type [string toupper $type]
    if { [info exist m] == 1 } {
	return "${type}${w}.${m}"
    } else {
	if { [info exist d] == 1} {
	    if { [info exist e] == 1 } {
		return ${type}${w}.${d}E${e}
	    } else {
		return ${type}${w}.${d}
	    }
	} else {
	    return ${type}${w}
	}
    }
}

body FitsTable::updateHL {} {
   $father updateHL DIMENSION [list $numCols $numRows]
}


##############################################
#
#   Select the Table columns to be displayed
#

body FitsTable::dispTable { {cols {}} } {
   if { [llength $cols]==0 } {
      tableHighLight
      tkwait window .thl
      if { !$isTableDisplayed } {
         delete object $this
         return
      }
   } elseif { [lindex $cols 0]=="-" } {
      set colSelList {}
      for {set i 0} {$i < $numCols } {incr i} {
         lappend colSelList [lindex $colNames $i]
      }
      set isTableDisplayed 1
   } else {
      set colSelList $cols
      set isTableDisplayed 1
   }

   makeTable
}


body FitsTable::tableHighLight { } {

    if { [winfo exists .thl] } {
       destroy .thl
    }
    # table highlight
    powToplevel .thl .dummy

    set fName $fileName
    set rName [urlTail $fName]
    # set dName [getFullDirPath $fName]
    wm title .thl "fv: Table Info of $rName\[[expr $chdu-1]\]"

    wm geometry .thl 300x300
#
    frame .thl.finfo     -relief sunken  -borderwidth 2
    pack  .thl.finfo      -side top -fill both -expand 0

    #Table Infomation
    label .thl.finfo.col -text "Total Columns: $numCols"
    label .thl.finfo.row -text "Total Rows   : $numRows"
    pack  .thl.finfo.col -side top -fill both -expand 1
    pack  .thl.finfo.row -side top -fill both -expand 1

    #buttons
    iwidgets::buttonbox .thl.buttonbox -orient vertical
    pack  .thl.buttonbox  -side right -padx 0 -pady 0 -fill x -expand 0

    .thl.buttonbox add makeTable -text "Display Table" \
	-command  " [code $this makeColSelList]
                    destroy .thl " -padx 0 -pady 0
    .thl.buttonbox add selectAll -text "Select All"  -padx 0 -pady 0 \
	    -command [code $this selAllCol]
    .thl.buttonbox add clearAll -text "Clear All"    -padx 0 -pady 0 \
	    -command [code $this unselAllCol]
    .thl.buttonbox add cancel   -text "Cancel"       -padx 0 -pady 0 \
            -command "destroy .thl"
    .thl.buttonbox add help     -text "Help"         -padx 0 -pady 0 \
          -command {hhelp columnSelection}

    selAllCol
    # column names         
    iwidgets::scrolledframe .thl.fcolList  \
	    -labeltext "Selected columns for display" -hscrollmode dynamic \
	    -vscrollmode dynamic 
    pack  .thl.fcolList   -side left -fill both -expand 1

    set tmpSF [.thl.fcolList childsite]
    set j 0
    foreach i $colSelList {
	pack [checkbutton $tmpSF.$j -text $i \
		  -variable [scope colSelState($j)] \
		  -selectcolor $fvPref::checkBBgColor  \
		  -activeforeground black \
                  -activebackground $fvPref::globalBgColor ]\
	    -anchor w -pady 0
	incr j
    }
}

body FitsTable::makeColSelList {} {
    set colSelList {}
    for {set i 0} {$i < $numCols } {incr i} {
	if { $colSelState($i) == 1} {
	    lappend colSelList [lindex $colNames $i]
	}
    }
    set isTableDisplayed 1
}

body FitsTable::selAllCol {} {
    for {set i 0} {$i < $numCols } {incr i} {
	set colSelState($i) 1
    }
}

body FitsTable::unselAllCol {} {
    for {set i 0} {$i < $numCols } {incr i} {
	set colSelState($i) 0
    }
}

#
#  End column selection handlers
#
##############################################


##############################################
#
# Handle Reading/Writing/Formatting of Data
#

body FitsTable::writeTabData {col row val} {

   set tmpNull [string trim "$columnNull($col)" ']
   set tmpForm $columnForm($col)
   set tmpType $columnType($col)
   set tmpName $columnName($col)
    
   if { [regexp L $tmpType] == 1} {
      if { ([regexp -nocase {[ftu]} $val] == 0) || \
            ([string length $val] !=1)} {
         error "Logical column can only have value T, F or U"
         return
      } else {
         set val [string toupper $val]
      }
   }	
   set tmpStr [string toupper [string trim $val " "]]

   if { $tmpStr == "NULL" } {

      if { $tabType == "ASCII Table" && [regexp A $tmpType] } {
         set val "NULL"
      } else {

         # float and double do not need a TNULL key for binary table
         if { $tabType == "ASCII Table" } {
            if { $tmpNull == "NULL" } {
               error "\nNo NULL value is defined. Please write a\
                     TNULLn keyword in the header first."
            }
         } else {
            if { $tmpNull == "NULL" && \
                  ![regexp A|D|E|F|C|M|d|e|f $tmpType] } {
               error "\nNo NULL value is defined. Please write a\
                     TNULLn keyword in the header first."
            }		
         }
         set val "NULL"
         
      }

   }

   putRawData $col $row $val
}

body FitsTable::readTabData {fCol fRow nCols nRows} {
   # col/row is 0-indexed

   set tmpColList [lrange $colSelList $fCol [expr $fCol+$nCols-1]]
   incr fRow
   incr fCol
   $fitsfileCmd load tblock -noformat tabData $tmpColList $fRow $nRows $fCol 1
}

body FitsTable::getFormattedData {col row} {
   set val [getRawData $col $row]
   if { $val=="NULL" || $val==" " } {
      return $val
   }
   if { [regexp C|M $columnType($col)] } {
      foreach [list v1 v2] $val {}
      return [format "$columnForm($col), $columnForm($col)" $v1 $v2]
   } else {
      return [format $columnForm($col) $val]
   }
}


body FitsTable::getRawData {col row} {
   set v $tabData($col,$row)
   if { $v!="NULL" && $v!=" " } {
      if { [regexp E $columnType($col)] } {
         return [format "%.7G" $v]
      } elseif { [regexp D $columnType($col)] } {
         return [format "%.15G" $v]
      } elseif { [regexp C $columnType($col)] } {
         return [format "%.7G %.7G" [lindex $v 0] [lindex $v 1]]
      } elseif { [regexp M $columnType($col)] } {
         return [format "%.15G %.15G" [lindex $v 0] [lindex $v 1]]
      }
   }
   return $v
}

body FitsTable::putRawData {col row val} {
   $fFObj putTable $columnName($col) 1 [expr $row+1] [list $val]
   readTabData $col $row 1 1
}

body FitsTable::getRawDataBlock { fCol fRow lCol lRow } {
   # col/row zero-indexed

   set clipCols [lrange $colSelList $fCol $lCol]
   incr fRow
   incr lRow
   return [$fFObj getcolblock $clipCols ${fRow}-${lRow}]
}

body FitsTable::putRawDataBlock { fCol fRow data } {
   # col/row zero-indexed

   set nCols  [llength $data]
   set nRows  [llength [lindex $data 0]]

   set range "[expr $fRow+1]-[expr $fRow+$nRows]"
   foreach cData $data {
      $fFObj putTable $columnName($fCol) 1 $range $cData
      incr fCol
   }
}


#
#  End Data handlers
#
##############################################
