/*
 * global.h : global definition for fbgetty
 * Part of fbgetty 
 * Copyright (C) 1999 2000 2001 Yann Droneaud <ydroneaud@meuh.eu.org>. 
 *
 * fbgetty is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * fbgetty is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
 *
 */

#ifndef _FBGETTY_GLOBAL_H_
#define _FBGETTY_GLOBAL_H_

/*
 * This file must be included first (before all others) in all the fbgetty source file
 */

/* get the value guessed by configure script */
#ifndef HAVE_CONFIG_H
#error "You must run configure before trying to compile fbgetty"
#else
#include <config.h>
#endif

#ifndef HAVE_LOGIN_TTY
# ifdef HAVE_LIBUTIL
#  define HAVE_LOGIN_TTY
# endif /* HAVE_LIBUTIL */
#endif /* HAVE_LOGIN_TTY */

#ifdef USE_FRAME_BUFFER
# if defined(__linux__) && ! defined(HAVE_LINUX_FB_H)
#  undef USE_FRAME_BUFFER
# endif
#endif

/* some informations about the package */
#define PACKAGE_AUTHOR_NAME "Yann Droneaud"
#define PACKAGE_AUTHOR_MAIL "ydroneaud@meuh.eu.org"
#define PACKAGE_AUTHOR      PACKAGE_AUTHOR_NAME " <" PACKAGE_AUTHOR_MAIL ">"

#define PACKAGE_MAIL        "fbgetty-bug@meuh.eu.org"
#define PACKAGE_HOMEPAGE    "http://fbgetty.meuh.eu.org/"

#define PACKAGE_NAME        PACKAGE
#define PACKAGE_VERSION     VERSION

#define PACKAGE_NICKNAME    "closing the branch"

/* get all GNU's extensions */
#define _GNU_SOURCE 1

#ifndef FALSE
# define FALSE (1 != 1)
#endif

#ifndef TRUE
# define TRUE (!FALSE)
#endif

#endif /* _FBGETTY_GLOBAL_H_ */
