<?php
/*
   Minimal raw RPC query support over HTTP. All variables are simply
   serialized() and then transmitted, no access permission checks are
   done.
*/

define("PHPRPC_VERSION", 1);
define("PHPRPC_TYPE", "application/vnd.php.serialized");

#-- do call
function phprpc($url, $func, $args) {

   #-- prepare
   $args = array(
      "RPC" => PHPRPC_VERSION,
      "engine" => "ewiki",
      "method" => $func,
      "args" => $args,
   );
   $args = serialize($args);
   $args = gzencode($args);
   $len_args = strlen($args);

   #-- prepare HTTP request
   $c = parse_url($url);
   extract($c);
   $port || ($port=80);
   $query && ($path .= "?$query");
   $n = "\015\012";
   $req = "POST $path HTTP/1.0$n"
        . "Host: $host$n"
        . ($user ? "Authorization: Basic ".base64_encode("$user:$pass").$n : "")
        . "User-Agent: ewiki/".EWIKI_VERSION."$n"
        . "Accept-Encoding: gzip$n"
        . "Connection: close$n"
        . "Accept: ".PHPRPC_TYPE."$n"
        . "Content-Type: ".PHPRPC_TYPE."; version=".PHP_VERSION."$n"
        ;

   #-- open connection
   if ($f = fsockopen($host, $port, $io_err, $io_err_s, 20)) {
      socket_set_blocking($f, true);
      socket_set_timeout($f, 17, 555);

      #-- send
      fwrite($f, $req);
      fwrite($f, "Content-Length: $len_args$n");
      fwrite($f, "$n");
      fwrite($f, $args);  $args = "";  //freemem()
      fwrite($f, "$n");

      #-- read
      $result = "";
      while (!feof($f)) {
         $result .= fread($f, 1<<21);  // max 2MB (incl. headers)
      }

      #-- strip headers
      while ($p = strpos($result, "\n")) {
         $line = trim(substr($result, 0, $p));
         $result = substr($result, $p + 1);
         if (!strlen($line)) {
            break;
         }
         $h[strtolower(strtok($line, ":"))] = trim(strtok("\000"));
      }
      fclose($f);

      #-- decode
      if (trim(strtok($h["content-type"], ";")) == PHPRPC_TYPE) {
         if ($h["content-encoding"] == "gzip") {
            $result = gzinflate(substr($result, 10, strlen($result)-18));
         }
         if ($h["content-encoding"] == "deflate") {
            $result = gzinflate($result);
         }
         $result = unserialize($result);

         #-- ok
         if ($result) {
            return($result);
         }
      }//decode

   }//socket
}



#-- handle calls
function phprpc_server($allowed="*") {

   global $phprpc_methods;
   if ($phprpc_methods) {
      $allowed = $phprpc_methods;
   }

   if (($_SERVER["REQUEST_METHOD"] == "POST")
   and (trim(strtok($_SERVER["HTTP_CONTENT_TYPE"], ";")) == PHPRPC_TYPE))
   {
       #-- get raw data
       if ($f = gzopen("php://input", "rb")) {
          $call = unserialize(gzread($f, 1<<21));  // 2MB max (packed)
          gzclose($f);
       }
       else {
          $call = unserialize($GLOBALS["HTTP_RAW_POST_DATA"]);
       }

       #-- make function call
       if (is_array($call) && ($call["RPC"]==PHPRPC_VERSION)) {

          ($method = $call["method"]) || ($method = $call["func"]) || ($method = $call["function"]);
          ($args = $call["args"]) || ($args = $call["params"]);

          #-- plain function or static method call
          if (strpos($method, ":")) {
             $class = strtok($method, ":");
             $method = trim(strtok(" "), ":");
          }
          if ($class) {
             $method = array($class, $method);
          }
          
          #-- exec
          if (($allowed=="*") || in_array($method, $allowed) || in_array($class, $allowed)) {
             $r = call_user_func_array($method, $args);
          }
       }

       #-- return result
       if ($r) {
          header("Content-Type: ".PHPRPC_TYPE."; version=".PHP_VERSION);
          header("Content-Encoding: gzip");
          header("Cache-Control: no-cache, private");
          $r = serialize($r);
          $r = gzencode($r);
          header("Content-Encoding: gzip");
          header("Content-Length: ".strlen($r));
          print($r);
          exit;
       }

       #-- error
       header("Status: 500 Didn't work");
       header("Content-Type: application/x-null");
       exit;

   }
}

?>