(in-package :odcl)

(defun excercise-simple-cache-basic (cache)
  (let ((x (gensym))
        (rval (random-string))
        (rval2 (list (random-string) (gensym))))
    (cache-put cache x rval)
    (unless (equal rval (cache-get cache x))
      (error "Cache corrupted value."))
    (cache-put cache x rval2)
    (unless (equal rval2 (cache-get cache x))
      (error "Cache corrupted second value."))
    (cache-delete cache x)
    (when (cache-get cache x)
      (error "Cache did not delete value."))
    (cache-put cache x rval)
    (cache-flush cache)))

(defun excercise-simple-cache-markable (cache)
  (let ((x (gensym))
        (rval (list (random-string) (gensym))))
    (cache-put cache x rval :bar)
    (multiple-value-bind (val mark)
        (cache-get cache x)
      (unless (equal rval val)
        (error "Cache corrupted value."))
      (unless (equal mark :bar)
        (error "Cache corrupted mark.")))
    (cache-mark cache x :baz)
    (multiple-value-bind (val mark)
        (cache-get cache x)
      (unless (equal rval val)
        (error "Cache corrupted value."))
      (unless (equal mark :baz)
        (error "Cache corrupted mark.")))))

(defun excercise-simple-cache-unmarkable (cache)
  (let ((x (gensym))
        (rval (list (random-string) (gensym))))
    (handler-case
        (progn (cache-put cache x rval :bar)
               (error "Cache did not thru mark-unsupported error."))
      (simple-cache-mark-unsupported ()
        t))
    (handler-case
        (progn (cache-mark cache x :bar)
               (error "Cache did not thru mark-unsupported error."))
      (simple-cache-mark-unsupported ()
        t))
    (cache-put cache x rval)
    (handler-case
        (progn (cache-mark cache x :bar)
               (error "Cache did not thru mark-unsupported error."))
      (simple-cache-mark-unsupported ()
        t))))

(defregression (:simple-cache 1)
  "Hashtable cache, non-markable."
  (let ((cache (make-instance 'hash-table-cache)))
    (excercise-simple-cache-basic cache)
    (excercise-simple-cache-unmarkable cache)))

(defregression (:simple-cache 2)
  "Hashtable cache, markable."
  (let ((cache (make-instance 'hash-table-cache :markable t)))
    (excercise-simple-cache-basic cache)
    (excercise-simple-cache-markable cache)))

(defregression (:simple-cache 3)
  "Hashtable cache, markable, keyfun."
  (let ((cache (make-instance 'hash-table-cache :markable t :keyfun 'identity)))
    (excercise-simple-cache-basic cache)
    (excercise-simple-cache-markable cache)))

(defregression (:simple-cache 4)
  "Lru cache."
  (let ((cache (make-instance 'lru-cache)))
    (excercise-simple-cache-basic cache)
    (excercise-simple-cache-markable cache)))
