# locale.mk: compile *.po
#
################################################################
# Copyright (C) 2004 Tez Kamihira
# 
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.
# 
# This file is derived from Tom Lord's "programs.mk".
#



ifndef locale-mk
locale-mk	:= 1

machine_objs	:= $(addsuffix .mo,$(basename $(portable_objs)))

# Build *.mo
#
# Set on entry:	(see also "library.mk")
#
# After "make all", the build directory will contain "Locales" which
# contains the names of the *.mo that were built.
#

include $(makefiles)/library.mk

all: $(machine_objs) Locales

ifndef no-Locales-rule
Locales: $(machine_objs)
	echo $(machine_objs) | sed -f $(makefiles)/column.sed > Locales
endif

clean: clean-prog

clean-prog:
	for f in $(machine_objs) Locales ; do \
	  test ! -e $$f || rm $$f ; \
	done

endif

# arch-tag: Tez Kamihira Mon Jun 14 14:31:18 JST 2004 (locales.mk)
#
