#import <Foundation/Foundation.h>
#import "MockTarArchive.h"

@implementation MockTarArchive : TarArchive

- (id)initFromFile:(NSString *)path;
{
	NSParameterAssert(path != nil);
	
	// this isn't correct since path represents the output here but that shouldn't matter
	[super initWithPath:path];
	ASSIGN(_output, [NSData dataWithContentsOfFile:path]);
	return self;
}

- (void)dealloc
{
	[_output release];
	[super dealloc];
}

- (NSData *)dataByRunningTar
{
	return _output;
}

@end
