#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <xmms/plugin.h>
#include <xmms/xmmsctrl.h>
#include <xmms/configfile.h>

#include "config.h"
#include "globals.h"
#include "coverview.h"
#include "interface-xmms.h"
#include "graphics.h"
#include "plugconf.h"

#include "xmms-headers/dock.h"
#include "xmms-headers/widget.h"
#include "xmms-headers/vis.h"
#include "xmms-headers/main.h"
#include "xmms-headers/util.h"

static void coview_init(void);
static void coview_cleanup(void);
static void coview_about(void);
static void coview_configure(void);

gboolean dial=FALSE;

static guint timeout_tag;


void coview_killall()
	{
	if (!coview_test_visible())
		coview_window_visible(TRUE);
	xmms_remote_quit(coview_session);}

void coview_play_prev()
	{xmms_remote_playlist_prev(coview_session); }

void coview_play_next()
	{xmms_remote_playlist_next(coview_session); }

void coview_play()
	{xmms_remote_play(coview_session);}

void coview_pause()
	{xmms_remote_pause(coview_session);}

void coview_stop()
	{xmms_remote_stop(coview_session);}

void coview_shuffle()
	{xmms_remote_toggle_shuffle(coview_session);}

void coview_open()
{
	static GtkWidget *filebrowser;
	if (filebrowser != NULL)
	{	gdk_window_raise(filebrowser->window);
		return;	}
	filebrowser = util_create_filebrowser(TRUE);
	gtk_signal_connect(GTK_OBJECT(filebrowser), "destroy",
	GTK_SIGNAL_FUNC(gtk_widget_destroyed), &filebrowser);
}
	
gboolean coview_test_shuffle()
	{gboolean test=xmms_remote_is_shuffle(coview_session);
	return test;}

void coview_repeat()
	{xmms_remote_toggle_repeat(coview_session);}

gboolean coview_test_repeat()
	{gboolean test=xmms_remote_is_repeat(coview_session);
	return test;}
	
gchar *coview_skin()
	{gchar *temp=xmms_remote_get_skin(coview_session);
	gchar *temp2;
	if (temp) 
		temp2=strdup(temp);
	else
		temp2=NULL;
	return temp2;
	}
	
gint coview_playlist_length()
	{gint N=xmms_remote_get_playlist_length(coview_session);
	return N;
	}

gint coview_playlist_pos()
	{gint N=xmms_remote_get_playlist_pos(coview_session);
	return N;
	}

gchar *coview_playlist_filename(gint pos)
	{gchar *temp=xmms_remote_get_playlist_file (coview_session, pos);
	gchar *temp2;
	if (temp) 
		temp2=strdup(temp);
	else
		temp2=NULL;
	return temp2;
	}
	
gchar *coview_title(gint pos)
	{gchar *temp=xmms_remote_get_playlist_title (coview_session, pos);
	gchar *temp2;
	if (temp) 
		temp2=strdup(temp);
	else
		temp2=NULL;
	return temp2;
	}

gboolean coview_test_visible()
	{gboolean test= xmms_remote_is_main_win(coview_session);
	return test;}
	
gboolean list_state,eq_state;

void coview_window_visible(gboolean show)
{
	if (show)
	{
		xmms_remote_main_win_toggle(coview_session, show);
		xmms_remote_pl_win_toggle(coview_session, list_state);
		xmms_remote_eq_win_toggle(coview_session, eq_state);
	}
	else
	{
		xmms_remote_main_win_toggle(coview_session, show);
		list_state=xmms_remote_is_pl_win(coview_session);
		eq_state=xmms_remote_is_eq_win(coview_session);
		xmms_remote_pl_win_toggle(coview_session, FALSE);
		xmms_remote_eq_win_toggle(coview_session, FALSE);
	}
}

void coview_show_yourself(gboolean show)
{
	if (show)
		gtk_widget_show(window);
	else
		gtk_widget_hide(window);
}

	
/*******************************************************************************
	CONFIGURATION FILES : read, write, write-partial	
*******************************************************************************/

	
void read_xmms_config() 
	{
	ConfigFile *config; gchar *cmd;

	config = xmms_cfg_open_default_file ();
	if (config) 
		{
		if (!xmms_cfg_read_string(config, "CDDA", "device" , &cdaudio_player))
			cdaudio_player=strdup("/dev/cdrom");
		if (!xmms_cfg_read_int(config, PLUGIN_NAME, "WindowSizeX" , &xwin))
			xwin=300;
		if (!xmms_cfg_read_int(config, PLUGIN_NAME, "WindowSizeY" , &ywin))
			ywin=300;
		if (!xmms_cfg_read_int(config, PLUGIN_NAME, "PosX" , &posx))
			posx=0;
		if (!xmms_cfg_read_int(config, PLUGIN_NAME, "PosY" , &posy))
			posy=0;
		if (!xmms_cfg_read_string(config,PLUGIN_NAME,"Font",&fontname))
			fontname=strdup("-*-*-*-*-*-*-14-*-*-*-*-*-*");
		if (!xmms_cfg_read_string(config,PLUGIN_NAME,"NoPicture",&empty_picture))
			empty_picture=g_strdup_printf("%s/coverviewer/pingoo.jpg",DATADIR);
		if (!xmms_cfg_read_string(config,PLUGIN_NAME,"ImagesDirectory",&image_dir))
			image_dir=g_strdup_printf("%s/.covers/",g_get_home_dir());
		if (!xmms_cfg_read_string(config,PLUGIN_NAME,"ImagesKeywords",&image_keywords))
			image_keywords=strdup("");
		if (!xmms_cfg_read_string(config,PLUGIN_NAME,"TitleFormat",&title_format))
			title_format=strdup("%t (%s : %a)");
		script_net=g_strdup_printf("%s/coverviewer/script.py",DATADIR);
		/*if (!xmms_cfg_read_string(config,PLUGIN_NAME,"ScriptNet",&script_net))
			{script_net=g_strdup_printf("%s/coverviewer/script.py",DATADIR);}*/
		if (!xmms_cfg_read_string(config,PLUGIN_NAME,"SearchOrder",&search_order))	
			search_order=strdup("5312");
		if (!xmms_cfg_read_string(config,PLUGIN_NAME,"GetAllImages",&get_all))	
			get_all=strdup("0");
		if (!xmms_cfg_read_string(config,PLUGIN_NAME,"ScriptAlbum",&script_album))
			script_album=g_strdup_printf("%s/coverviewer/get_album.py",DATADIR);
		if (!xmms_cfg_read_boolean(config,PLUGIN_NAME,"ImageRatioPreserve",&ratio))
			ratio=TRUE;
		if (!xmms_cfg_read_boolean(config,PLUGIN_NAME,"SlideShow",&slide))
			slide=TRUE;
		if (!xmms_cfg_read_boolean(config,PLUGIN_NAME,"SmartSearch",&smart_search))
			smart_search=TRUE;
		if (!xmms_cfg_read_boolean(config,PLUGIN_NAME,"Title",&title_display))
			title_display=TRUE;
		if (!xmms_cfg_read_boolean(config,PLUGIN_NAME,"Fullscreen",&fullscreen))
			fullscreen=FALSE;
		if (!xmms_cfg_read_boolean(config,PLUGIN_NAME,"Skin",&skinned))
			skinned=TRUE;
		if (!xmms_cfg_read_boolean(config,PLUGIN_NAME,"Buttons",&show_button))
			show_button=TRUE;
		if (!xmms_cfg_read_boolean(config,PLUGIN_NAME,"InternetSearch",&internet_search))
			internet_search=TRUE;
		if (!xmms_cfg_read_boolean(config,PLUGIN_NAME,"AutoHide",&auto_hide))
			auto_hide=FALSE;
		if (!xmms_cfg_read_int(config, PLUGIN_NAME, "SlideShowSpeed" , &slide_speed))
			slide_speed=1000;
		xmms_cfg_free (config);
		}
	else
		{
		cdaudio_player=strdup("/dev/cdrom");
		xwin=300;
		ywin=300;
		fontname=strdup("-*-*-*-*-*-*-14-*-*-*-*-*-*");
		title_format=strdup("%t (%s : %a)");
		empty_picture=g_strdup_printf("%s/coverviewer/pingoo.jpg",DATADIR);
		image_dir=g_strdup_printf("%s/.covers/",g_get_home_dir());
		image_keywords=strdup("");
		script_net=g_strdup_printf("%s/coverviewer/script.py",DATADIR);
		script_album=g_strdup_printf("%s/coverviewer/get_album.py",DATADIR);
		search_order=strdup("5312");
		get_all=strdup("0");
		ratio=TRUE;
		slide=TRUE;
		skinned=TRUE;
		show_button=TRUE;
		title_display=TRUE;
		fullscreen=FALSE;
		internet_search=TRUE;
		smart_search=TRUE;
		auto_hide=FALSE;
		posx=0;
		posy=0;
		}
	cmd=g_strdup_printf("mkdir \"%s\" 2>/dev/null",image_dir);
	system(cmd);
	free(cmd);
	cmd=g_strdup_printf("mkdir \"%s/.albums\" 2>/dev/null",image_dir);
	system(cmd);
	free(cmd);
	config_loaded=TRUE;
	}
	
void write_xmms_config()
	{
	ConfigFile *config;

	config = xmms_cfg_open_default_file ();
	if (config)
		{
		xmms_cfg_write_int(config, PLUGIN_NAME, "WindowSizeX" , xwin);
		xmms_cfg_write_int(config, PLUGIN_NAME, "WindowSizeY" , ywin);
		gdk_window_get_position(window->window,&posx,&posy);
		xmms_cfg_write_int(config, PLUGIN_NAME, "PosX" , posx);
		xmms_cfg_write_int(config, PLUGIN_NAME, "PosY" , posy);
		xmms_cfg_write_string(config,PLUGIN_NAME,"Font",fontname);
		xmms_cfg_write_string(config,PLUGIN_NAME,"TitleFormat",title_format);
		xmms_cfg_write_string(config,PLUGIN_NAME,"NoPicture",empty_picture);
		xmms_cfg_write_string(config,PLUGIN_NAME,"ImagesDirectory",image_dir);
		xmms_cfg_write_string(config,PLUGIN_NAME,"ImagesKeywords",image_keywords);
		xmms_cfg_write_string(config,PLUGIN_NAME,"ScriptNet",script_net);
		xmms_cfg_write_string(config,PLUGIN_NAME,"SearchOrder",search_order);	
		xmms_cfg_write_string(config,PLUGIN_NAME,"GetAllImages",get_all);
		xmms_cfg_write_string(config,PLUGIN_NAME,"ScriptAlbum",script_album);
		xmms_cfg_write_boolean(config,PLUGIN_NAME,"ImageRatioPreserve",ratio);
		xmms_cfg_write_boolean(config,PLUGIN_NAME,"SlideShow",slide);
		xmms_cfg_write_boolean(config,PLUGIN_NAME,"Title",title_display);
		xmms_cfg_write_boolean(config,PLUGIN_NAME,"Fullscreen",fullscreen);
		xmms_cfg_write_boolean(config,PLUGIN_NAME,"Skin",skinned);
		xmms_cfg_write_boolean(config,PLUGIN_NAME,"Buttons",show_button);
		xmms_cfg_write_boolean(config,PLUGIN_NAME,"InternetSearch",internet_search);
		xmms_cfg_write_boolean(config,PLUGIN_NAME,"SmartSearch",smart_search);
		xmms_cfg_write_boolean(config,PLUGIN_NAME,"AutoHide",auto_hide);
		xmms_cfg_write_int(config,PLUGIN_NAME,"SlideShowSpeed",slide_speed);
		xmms_cfg_write_default_file(config);
		xmms_cfg_free (config);
		}
	}
	
void write_xmms_config_partial()
	{
	ConfigFile *config;

	config = xmms_cfg_open_default_file ();
	if (config && !(fullscreen))
		{
		xmms_cfg_write_int(config, PLUGIN_NAME, "WindowSizeX" , xwin);
		xmms_cfg_write_int(config, PLUGIN_NAME, "WindowSizeY" , ywin);
		gdk_window_get_position(window->window,&posx,&posy);
		xmms_cfg_write_int(config, PLUGIN_NAME, "PosX" , posx);
		xmms_cfg_write_int(config, PLUGIN_NAME, "PosY" , posy);
		xmms_cfg_write_default_file(config);
		xmms_cfg_free (config);
		} 
	}
	
/*******************************************************************************
	Plugin Interface
*******************************************************************************/

GeneralPlugin coview = {
	0, // Handle, filled in by xmms
	0, // Filename, filled in by xmms
	0, // Session ID
	"CoverViewer (Images and covers display)",// description
	coview_init,// Called when plugin is enabled
	coview_about,// Show the about box
	coview_configure,// Show the configure box
	coview_cleanup// Called when plugin is disabled
	};

gdouble dx,dy;
	
void sigpress(GtkWidget *widget,GdkEventButton *event,gpointer callback_data)
	{ gint mx,my;
	  GdkModifierType modmask;
	
	if (event->button==1)
	{
	gdk_window_get_pointer (NULL,&mx,&my,&modmask);
	gdk_window_raise(widget->window);
	if (!skinned || !show_button || (skinned &&
			(event->y<=ywin-31 || 
				event->y>ywin-12 || 
				(event->x<11 || (event->x>125 && event->x<130) || (event->x>146 && event->x<xwin-19-46-28) || event->x>xwin-19)) 
			&&
			(event->x<xwin-20 || event->y>12)
			))
		{
		moving=1;
		dx=event->x;
		dy=event->y;
		gdk_pointer_grab (window->window, FALSE,
                        GDK_BUTTON_MOTION_MASK | GDK_BUTTON_RELEASE_MASK, GDK_NONE, GDK_NONE, GDK_CURRENT_TIME);
		dock_move_press(dock_window_list, window, event, FALSE);
		}
	if (event->y>=ywin-15 && event->x>=xwin-15)
		{
		moving=2;
		dx=xwin-mx;
		dy=ywin-my;
		gdk_pointer_grab (window->window, FALSE,
					GDK_BUTTON_MOTION_MASK | GDK_BUTTON_RELEASE_MASK, GDK_NONE, GDK_NONE, GDK_CURRENT_TIME);
		}
	}
	if (event->button==3)
		{
		coview_menu();
		}
	}

void sigrelease(GtkWidget *widget,GdkEventButton *event,gpointer callback_data)
	{gint mx,my;
	  GdkModifierType modmask;
	if (event->button==1)
	{
	gdk_window_get_pointer (NULL,&mx,&my,&modmask);
	gdk_pointer_ungrab (GDK_CURRENT_TIME);
	if (moving==0)
		{
		if (event->y<=12 && event->x>=xwin-19 && event->x<=xwin-11 && skinned)		
			{/* The user clicked on the maximize button */
			mx=Xwin;
			my=Ywin;
			Xwin=xwin;
			Ywin=ywin;
			xwin=mx;
			ywin=my;
			mx=Posx;
			my=Posy;
			gdk_window_get_position(window->window,&Posx,&Posy);
			gdk_window_move_resize(window->window,mx,my, xwin,ywin);
			coview_init_imagebuffer();
			coview_load_skin(curskin);
			coview_load_image(curimage->imagename);
			return;
			}
		if (event->y<=12 && event->x>=xwin-10 && event->x<=xwin-2 && skinned)
			{/* The user clicked on the mini button */
			xwin=300;
			ywin=300;
			Xwin=gdk_screen_width();
			Ywin=gdk_screen_height();
			gdk_window_get_position(window->window,&posx,&posy);
			Posx=0;
			Posy=0;
			if ((posx+300)<0) posx=0;
			if ((posy+300)<0) posy=0;
			gdk_window_move_resize(window->window,posx,posy,xwin,ywin);
			coview_init_imagebuffer();
			coview_load_skin(curskin);
			coview_load_image(curimage->imagename);
			return;
			}
		/*if (event->y>=18 && event->y<=ywin-18-37 && event->x>=11 && event->x<=xwin-11-19)
			{
			if (slide)
				{
				slide_pause=1-slide_pause;
				}
			else
				{
				curimage=curimage->next;
				if (!curimage) { curimage=first->next; }
				if (!curimage) { curimage=first; }
				coview_load_image(curimage->imagename);
				}
			}*/
		if (event->y>=ywin-31 && event->y<=ywin-12 && skinned && show_button)
			{	/*testing the control buttons */
			if (event->x>=11 && event->x<=33)
				{coview_play_prev();}
			if (event->x>=34 && event->x<=57)
				{coview_play();}
			if (event->x>=58 && event->x<=80)
				{coview_pause();}
			if (event->x>=81 && event->x<=103)
				{coview_stop();}
			if (event->x>=104 && event->x<=125)
				{coview_play_next();}
			if (event->x>=130 && event->x<=146)
				{coview_open();}
			if (event->x>=xwin-19-46-28 && event->x<=xwin-19-29)
				{coview_shuffle();}
			if (event->x>=xwin-19-28 && event->x<=xwin-19)
				{coview_repeat();}
			}
		}
	if (moving==2)
		{
		Xwin=gdk_screen_width();
		Ywin=gdk_screen_height();
		Posx=0;
		Posy=0;
		moving=0;
		coview_init_imagebuffer();
		coview_load_skin(curskin);
		coview_load_image(curimage->imagename);
		}
	moving=0;
	}
	/*if (event->button==2)
		{
		show_playlist(coview.xmms_session);
		coview_song_menu(coview.xmms_session);
		}*/
	}
	
void sigmotion(GtkWidget *widget,GdkEventMotion *event,gpointer callback_data)
	{ gint mx,my;
	  GdkModifierType modmask;
	gdk_window_get_pointer (NULL,&mx,&my,&modmask);
	if (moving==1)
		{
		gdk_window_move (window->window,mx-dx,my-dy);
		dock_move_motion(window, event);
		}
	if (moving==2)
		{
		gdk_window_resize(window->window, dx+mx,dy+my);
		xwin=dx+mx; ywin=dy+my;
		}
	}
void sigexpose(GtkWidget *widget,GdkEventExpose *event,gpointer callback_data)
	{
	gdk_window_copy_area (drawzone->window,
			      drawzone->style->fg_gc[GTK_STATE_NORMAL],
			      event->area.x, event->area.y,
			      imagebuffer,
			      event->area.x, event->area.y,
			      event->area.width, event->area.height);
	}

GeneralPlugin *get_gplugin_info(void)
{
	/* the config window must load/create default
	value even if plugin is not enabled */
	config_loaded=FALSE;
	return &coview;
}

static void coview_init(void)
{	gchar *strtemp;
	
	timeout_tag = gtk_timeout_add (100, (GtkFunction) timeout_func, NULL);
	gtk_init (NULL,NULL);
	read_xmms_config();
	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	
	dock_add_window(dock_window_list, window);
	
	drawzone=gtk_drawing_area_new();
	gtk_widget_set_events (window,GDK_BUTTON_MOTION_MASK|GDK_BUTTON_PRESS_MASK|GDK_BUTTON_RELEASE_MASK);
	gtk_signal_connect (GTK_OBJECT(window),"button_press_event",GTK_SIGNAL_FUNC(sigpress),NULL);
	gtk_signal_connect (GTK_OBJECT(window),"button_release_event",GTK_SIGNAL_FUNC(sigrelease),NULL);
	gtk_signal_connect (GTK_OBJECT(window),"motion_notify_event", GTK_SIGNAL_FUNC(sigmotion),NULL);
	// Window signal for repaint signal
	gtk_signal_connect (GTK_OBJECT(drawzone), "expose_event", GTK_SIGNAL_FUNC(sigexpose), NULL);

	gtk_widget_realize (window);
	gdk_window_set_decorations (window->window,0);
	gdk_window_set_functions(window->window,8);
	gdk_window_set_back_pixmap (window->window, NULL, FALSE);

	gtk_container_add (GTK_CONTAINER (window), drawzone);
	gtk_widget_show (drawzone);
	gtk_widget_show(window);

	init=0; moving=0;
	curdir=strdup("Nowhere");
	curfile=malloc(sizeof(fileinfo));
	curfile->filename=strdup("Nothing");
	curfile->title=curfile->artist=curfile->album=curfile->track=curfile->year=NULL;
	
	curskin=strdup("Nothing");
	curstream=strdup("Nothing");
	curtitle=(char*) malloc(1);

	first=malloc(sizeof(image_name_buffer));
	first->imagename=NULL;
	first->next=NULL;

	curimage=first;

	Xwin=gdk_screen_width();
	Ywin=gdk_screen_height();
	Posx=0;
	Posy=0;
	if (fullscreen)
		{
		gdk_window_move_resize(window->window,0,0, Xwin,Ywin);
		Xwin=xwin; Ywin=ywin;
		xwin=gdk_screen_width(); ywin=gdk_screen_height();
		Posx=posx; Posy=posy;
		posx=0; posy=0;
		}
	else
		{gdk_window_move_resize(window->window,posx,posy, xwin,ywin);}
	coview_init_imagebuffer();
	init_temp_img();
	write_xmms_config();
	from_dir=2;
	net_search=FALSE;
	strtemp = g_strdup_printf("\\rm \"%s\"*.lock 2>/dev/null", image_dir);
	system(strtemp);
	free(strtemp);

	//coview_session=coview.xmms_session;
#ifdef __DEBUG__
	printf("Covervierwer plugin : init\n");
	printf("coverviewer build date : %s\n",DATEOFBUILD);
#endif
		}

static void coview_cleanup(void)
{
	write_xmms_config_partial();
	gtk_timeout_remove(timeout_tag);
		// Not really cleaning : we're hiding
	gtk_widget_hide(window);
	clean_temp();
#ifdef __DEBUG__
	printf("Coverview plugin: exiting\n");
#endif
}

void offabout(GtkWidget *widget)
{
	gtk_widget_destroy(widget);
	dial=FALSE;
}

static void coview_about(void)
{
	GtkWidget *dialog, *label, *okay_button, *hbox;
	gchar *text;

	if (!dial)
		{
		read_xmms_config();
		dial=TRUE;
		dialog = gtk_dialog_new();
		text=g_strdup_printf("Xmms CoverViewer %s\nby Caligari\nemail :caligari77@users.sourceforge.net", VERSION);
		label = gtk_label_new (text);
		okay_button = gtk_button_new_with_label("Ok");
		gtk_signal_connect_object (GTK_OBJECT (okay_button), "clicked",GTK_SIGNAL_FUNC (offabout), (GtkObject *)dialog);
		gtk_signal_connect_object (GTK_OBJECT (dialog), "destroy",GTK_SIGNAL_FUNC (offabout), (GtkObject *)dialog);
			
		hbox=gtk_hbox_new(FALSE,10);
		gtk_box_pack_start(GTK_BOX(hbox),label,FALSE,FALSE,10);
		gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),hbox,FALSE,FALSE,10);
		gtk_container_add (GTK_CONTAINER (GTK_DIALOG(dialog)->action_area),okay_button);
		gtk_widget_show_all (dialog);
		gtk_window_set_title((GtkWindow *) dialog,(gchar *) "CoverViewer plugin");
		gtk_window_set_policy(GTK_WINDOW(dialog), FALSE, FALSE, FALSE);
		}
}

static void coview_configure(void)
{
	if (!conf)
		{
		conf=TRUE;
		conf_window();
		}
}
