#include <math.h>

#include <qregexp.h>
#include <qpoint.h>
#include <stdlib.h>

#include "misc.h"

QString qpointToString (const QPoint &p)
{
	return "(" + QString("%1").arg(p.x()) +","+ QString ("%1").arg (p.y()) +")";
}

ostream &operator<< (ostream &stream, QPoint const &p)
{ 
    return (stream << qpointToString(p) );
}

float getAngle(const QPoint &p)
{	
	// Calculate angle of vector to y-axis
	if (p.y()==0)
	{
		if (p.x()>=0)
			return M_PI_2;
		else
			return 3* M_PI_2;
	} else
	{
		if (p.y()>0) 
			return (float)(M_PI  - atan ( (double)(p.x()) / (double)(p.y()) ) );
		else	
			if (p.x()<0)
				return (float)( 2*M_PI - atan ( (double)(p.x()) / (double)(p.y()) ) );
			else	
				return (float)( - atan ( (double)(p.x()) / (double)(p.y()) ) );
	}	
}

QPoint normalise(const QPoint &p)
{	
	// Calculate normalised position (fixed length) 

	double px=p.x();
	double py=p.y();
	double x;
	double y;
	double r=150;

	if (px==0)
	{
		x=0;
		if (py>=0)
			y=r;
		else
			y=-r;
	} else
	{
		double sign;
		double a;
		if (px>0) 
			sign=1; 
		else 
			sign=-1;
		
		a=atan (py / px);
		x=cos (a) * r *sign;
		y=sin (a) * r *sign;
	}	
	return QPoint ((int) (x),(int) (y));
}


// returns masked "<" ">" "&"
QString quotemeta(const QString &s)
{
	QString r=s;
    QRegExp  rx("&(?!amp;)");
    r.replace ( rx,"&amp;");
    rx.setPattern( ">");
    r.replace ( rx,"&gt;");
    rx.setPattern( "<");
    r.replace ( rx,"&lt;");
    rx.setPattern( "\"");
    r.replace ( rx,"&quot;");
    return r;
}

int max(int a, int b)
{
	if (a>b)
		return a;
	return b;
}

int xmlObj::actindent=0;		// make instance of actindent

xmlObj::xmlObj()
{
    indentwidth=4;
}


// returns <s at />
QString xmlObj::singleElement(QString s, QString at)
{
    return indent() + "<" + s +" " + at +" " + "/>\n";
}

// returns <s>
QString xmlObj::beginElement(QString s)
{
    return indent() + "<" + s + ">\n";
}

// returns <s at>
QString xmlObj::beginElement(QString s, QString at)
{
    return indent() + "<" + s + " " + at + ">\n";
}

// returns </s>
QString xmlObj::endElement(QString s)
{
    return indent() + "</" + s + ">\n";
}

// returns  at="val"
QString xmlObj::attribut(QString at, QString val)
{
    return " " + at + "=\"" + quotemeta (val) + "\""; 
}

// returns <s> val </s>
QString xmlObj::valueElement(QString el, QString val)
{
    return indent() + "<" + el + ">" + quotemeta(val) + "</" +el + ">\n";
}

// returns <s at> val </s>
QString xmlObj::valueElement(QString el, QString val, QString at)
{
    return indent() + "<" + el + " " + at + ">" + quotemeta(val) + "</" +el + ">\n";
}

void xmlObj::incIndent()
{
    actindent++;
}	

void xmlObj::decIndent()
{
    actindent--;
    if (actindent<0) actindent=0;
}	

QString xmlObj::indent()
{
    QString s;
    int i;
    for (i=0; i<actindent*indentwidth; i++)
    {
		s= s + " ";
    }
    return s;
}	

