<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" "http://www.w3.org/TR/1998/REC-html40-19980424/loose.dtd">
<html>
<head>
  <title>Tor: Linux/BSD/Unix Install Instructions</title>
  <meta name="Author" content="The Tor Project, Inc.">
  <meta http-equiv="content-type" content="text/html; charset=UTF-8">
  <link rel="stylesheet" type="text/css" href="../stylesheet-ltr.css">
  <link rel="shortcut icon" type="image/x-icon" href="../favicon.ico">
</head>
<body>
<div class="center">
<table class="banner" border="0" cellpadding="0" cellspacing="0" summary="">
    <tr>
        <td class="banner-left"><a href="https://www.torproject.org/"><img src="../images/top-left.png" alt="Click to go to home page" width="193" height="79"></a></td>
        <td class="banner-middle">
	<a href="../index.html.ru">Главная</a>
<a href="../overview.html.ru">Обзор</a>
<a href="../easy-download.html.ru">Скачать</a>
<a href="../documentation.html.ru">Документация</a>
<a href="../volunteer.html">Добровольцы</a>
<a href="../people.html.ru">Люди</a>
<a href="https://blog.torproject.org/">Блог</a>
<a href="../donate.html.ru">Donate!</a>
        </td>
    </tr>
</table>
<div class="center">
<div class="main-column">
<h1>Запуск <a href="../index.html.ru">Tor</a> на Linux/BSD/Unix</h1>
<br>
<p>
<b>Обратите внимание, что это инструкции по запуску клиента Tor. Если бы Вы
хотели предоставить свой траффик другим пользователям, чтобы помочь сети Tor
расти, ознакомьтесь с руководством по <a href="../docs/tor-doc-relay.html.ru">настройке узла</a>.</b>
</p>
<hr> <a id="installing"></a>
<h2><a class="anchor" href="#installing">Шаг 1: загрузка и установка Tor</a></h2>
<br>
<p>
Последняя версия Tor находится на странице <a href="../download-unix.html.ru">загрузок</a>, где предоставлены пакеты для Debian, Red Hat,
Gentoo, *BSD итд. Если Вы используете Ubuntu, не используйте стандартные
репозитории, лучше настройте <a href="../docs/debian.html.ru#ubuntu">источник
Tor</a>.
</p>
<p>Если Вы собираете Tor из исходных кодов, сначала установите <a
href="http://www.monkey.org/~provos/libevent/">библиотеку libevent</a>, а
также убедитесь, что у Вас установлены библиотеки openssl и zlib (в том
числе пакеы для разработчиков с окончанием -devel). Затем запустите:<br>
<tt>tar xzf tor-0.2.1.25.tar.gz; cd tor-0.2.1.25</tt><br>
<tt>./configure &amp;&amp; make</tt><br> После этого Вы можете запустить
Tor как <tt>src/or/tor</tt>, или Вы можете выполнить команду <tt>make
install</tt> (от имени суперпользователя root при необходимости) для
установки Tor в папку /usr/local/, после чего Вы сможете запускать программу
просто командой <tt>tor</tt>.
</p>
<p>Изначально Tor настроен как клиент. В прогамме используется встроенный
конфигурационный файл, и в большинстве случаев перенастройка Tor не
потребуется. Теперь Tor установлен.
</p>
<hr> <a id="privoxy"></a> <a id="polipo"></a>
<h2><a class="anchor" href="#polipo">Шаг 2: установка Polipo для браузера</a></h2>
<br>
<p>После установки Tor Вам потребуется настроить используемые Вами приложения
для работы с программой.
</p>
<p>
Прежде всего настраивается браузер. Загрузите <a
href="http://www.pps.jussieu.fr/~jch/software/polipo/">Polipo</a> с Вашего
репозитория. Polipo - кеширующий прокси-сервер, который имеет широкие
возможности по туннелированию HTTP-траффика, поэтому он является подходящим
для использования с Tor. Убедитесь, что версия загружаемого Polipo не
меньше, чем 1.0.4, так как более ранние версии не поддерживают
туннелирование в SOCKS, что необходимо для использования Polipo с Tor. Вам
потребуется удалить Privoxy (например, apt-get remove privoxy or yum remove
privoxy) для предотвращения несовместимостей программ.
</p>
<p>Установив Polipo (из пакета или из исходных кодов), <b>Вы должны настроить
Polipo на работу с Tor</b>. Скачайте <a
href="https://svn.torproject.org/svn/torbrowser/trunk/build-scripts/config/polipo.conf">настройки
Polipo для Tor</a> и перезапишите им конфигурационный файл Polipo (например,
/etc/polipo/config or ~/.polipo). Перезапустите Polipo для применения
настроек. Например:<br> <tt>/etc/init.d/polipo restart</tt>
</p>
<p>Если Вы хотите, Вы можете использовать Privoxy с <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/PrivoxyConfig">данными
настройками</a>. Так как оба прокси-сервера (Privoxy и Polipo) используют
порт 8118, не стоит их использовать одновременно.</p>
<hr> <a id="using"></a>
<h2><a class="anchor" href="#using">Шаг 3: настройте Ваши приложения на работу с
Tor</a></h2>
<br>
<p>После установки Tor и Polipo, Вам потребуется настроить ваши приложения для
работы с ними. Прежде всего следует настроить браузер.</p>
<p>При работе с Tor рекомендуется использовать браузер Firefox с дополнением
Torbutton для обеспечения наивысшей безопасности. Просто установите <a
href="https://addons.mozilla.org/firefox/2275/">дополнение Torbutton</a>,
перезагрузите Firefox, и браузер будет готов к работе:
</p>
<img alt="Torbutton plugin for Firefox"
src="../img/screenshot-torbutton.png" border="1" width="161" height="78"> <br>
<p>
Если Вы собираетесь использовать Firefox на компьютере без Tor, ознакомьтесь
с <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#SocksListenAddress">частыми
вопросами по запуску Tor на другом компьютере</a>.
</p>
<p>Чтобы направить через сеть Tor траффик приложений, поддерживающих настройку
HTTP-прокси, укажите настройки Polipo (по умолчанию localhost порт
8118). Для использования SOCKS5 (для быстрых сообщений, клиентов Jabber, IRC
итд), Вы можете настроить приложение непосредственно на Tor (по умолчанию
localhost порт 9050), но ознакомьтесь с <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#SOCKSAndDNS">частыми
вопросами</a> по поводу опасностей данного способа. Для приложений без
поддержки настройки прокси-серверов протоколов SOCKS/HTTP, Вы можете
воспользоваться приложениями <a
href="http://tsocks.sourceforge.net/">tsocks</a> или <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorifyHOWTO#socat">socat</a>.
</p>
<p>Дополнительную информацию по настройке различных приложений для работы с
Tor, ознакомьтесь с <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorifyHOWTO">данным
руководством</a>.
</p>
<hr> <a id="verify"></a>
<h2><a class="anchor" href="#verify">Шаг 4: проверка на корректность работы</a></h2>
<br>
<p>
<!--PO4ASHARPBEGIN<a href="http://ipchicken.com/">
this site</a>PO4ASHARPEND-->
Теперь вам следует попробовать запустить браузер с использованием Tor и
убедиться, что Ваш IP-адрес скрыт от получателя. Зайдите на страницу <a
href="https://check.torproject.org/">проверки Tor</a> и посмотрите, работает
Tor или нет. (если сайт не работает, посмотрите <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#IsMyConnectionPrivate">частые
вопросы</a> по дополнительным способам проверки Tor.)
</p>
<p>Если у Вас стоит брандмауэр, который ограничивает возможность для компьютера
подключиться к самому себе (например, средства наподобие SELinux на Fedora
Core 4), проверьте, разрешено ли приложениям подключаться к Polipo
(localhost, порт 8118) и Tor (localhost, порт 9050). Если Ваш брандмауэр
ограничивает исходящие соединения, разрешите Tor подключаться хотя бы к
TCP-портам 80 и 443, и ознакомьтесь с <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#FirewalledClient">частыми
вопросами</a>. Если Ваши настройки SELinux нарушают работу tor или privoxy,
создайте файл с именем booleans.local в каталоге /etc/selinux/targeted.
Откройте файл в текстовом редакторе и добавьте строчку
"allow_ypbind=1". Перезагрузите машину для применения изменений.
</p>
<p>Если проблемы не исчезли, ознакомьтесь с <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#ItDoesntWork">частыми
вопросами</a>.</p>
<hr> <a id="server"></a> <a id="relay"></a>
<h2><a class="anchor" href="#relay">Шаг 5: настройка узла</a></h2>
<br>
<p>Сеть Tor основана на добровольцах, которые предоставляют траффик
пользователям сети. Чем больше узлов, тем быстрее сеть. Если у Вас есть хотя
бы 20Кб/с в обе стороны, пожалуйста, помогите сети Tor - запустите
узел. Программа предоставляет достаточно функций, которые делают настройку
узла Tor лёгкой и удобной для Вас, в том числе ограничение скорости канала,
поддержка динамических IP-адресов и политики выхода, которые могут
предотвратить жалобы в Ваш адрес.</p>
<p>Множество узлов в разных точках Интернета даёт пользователям Tor
безопасность и конфиденциальность.<a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#RelayAnonymity">Вы
можете повысить уровень безопасности</a>, так как при наличии узла удалённые
серверы не смогут отличить Ваш запрос от перенаправленного с узла.</p>
<p>Подробности в руководстве по <a href="../docs/tor-doc-relay.html.ru">настройке
узла</a>.</p>
<hr>
<p>Если у Вас есть предложения по улучшению этого документа, пожалуйста, <a
href="../contact.html.ru">ознакомьте нас с ними</a>. Спасибо!</p>
  </div>
<!-- #main -->
</div>
<hr>
</div>
  <div class="bottom" id="bottom">
     <p>"Tor" и "Onion Logo" &mdash; <a href="../trademark-faq.html">зарегистрированные торговые
     марки</a> Tor Project, Inc.
     <br>
     Содержимое сайта защищенo по условиям лицензии
     <a href="http://creativecommons.org/licenses/by/3.0/us/">Creative Commons Attribution 3.0 United States License
 	   <!--img alt="Creative Commons Attribution 3.0 United States License" style="border-width:0" src="../images/cc-by-us-80x15.png"--></a>, если явно не указано другое.
     </p>
     <p>
      Внимание! Этот перевод устарел. Английский оригинал имеет ревизию
      21798 тогда как этот перевод основан на ревизии
      (unknown).
     </p>
     <p>
       Эта страница также переведена на следующие языки:
       <a href="tor-doc-unix.html.de">Deutsch</a>, <a href="tor-doc-unix.html.en">English</a>, <a href="tor-doc-unix.html.es">espa&ntilde;ol</a>, <a href="tor-doc-unix.html.fr">fran&ccedil;ais</a>, <a href="tor-doc-unix.html.it">Italiano</a>, <a href="tor-doc-unix.html.ko">&#54620;&#44397;&#50612;&nbsp;(Hangul)</a>, <a href="tor-doc-unix.html.pl">polski</a>, <a href="tor-doc-unix.html.zh-cn">&#20013;&#25991;(&#31616;) (Simplified Chinese)</a>.<br>
       Как установить <a href="http://www.debian.org/intro/cn#howtoset">язык документов по умолчанию</a>.
     </p>
   <p>Разработчики Tor не проверяли этот перевод на точность и корректность.
   Перевод может быть устаревшим или просто неправильным. Официальный веб-сайт
   Tor на английском языке доступен по адресу
   <a href="https://www.torproject.org/">https://www.torproject.org/</a>.
   </p>
   <p>
   <i><a href="../contact.html.ru" class="smalllink">Webmaster</a></i> -
    Последние изменения: Thu Apr 15 14:45:15 2010
    -
    Последняя компиляция: Sun May 2 18:43:56 2010
   </p>
  </div>
</body>
</html>
