#include <stdarg.h>
#include <stdio.h>

#include "sshguard_log.h"


int sshguard_log_init() {
    /* open syslog */
#ifndef DEBUG
    openlog("sshguard", LOG_PID, LOG_AUTH);
#endif
    return 0;
}

int sshguard_log_fin() {
#ifndef DEBUG
    closelog();
#endif
    return 0;
}

int sshguard_log(int prio, char *fmt, ...) {
    va_list ap;
    va_start(ap, fmt);

#ifndef DEBUG
    vsyslog(prio, fmt, ap);
#else
    vfprintf(stderr, fmt, ap);
    fprintf(stderr, "\n");
#endif
    
    va_end(ap);

    return 0;
}

