/*
 * Unix SMB/CIFS implementation.
 * client auto-generated by pidl. DO NOT MODIFY!
 */

#include "includes.h"
#include "../librpc/gen_ndr/cli_dfs.h"

struct rpccli_dfs_GetManagerVersion_state {
	struct dfs_GetManagerVersion orig;
	struct dfs_GetManagerVersion tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_dfs_GetManagerVersion_done(struct tevent_req *subreq);

struct tevent_req *rpccli_dfs_GetManagerVersion_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct rpc_pipe_client *cli,
						     enum dfs_ManagerVersion *_version /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_dfs_GetManagerVersion_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_dfs_GetManagerVersion_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */
	state->orig.out.version = _version;

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_dfs_GetManagerVersion_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netdfs,
				    NDR_DFS_GETMANAGERVERSION,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_dfs_GetManagerVersion_done, req);
	return req;
}

static void rpccli_dfs_GetManagerVersion_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_dfs_GetManagerVersion_state *state = tevent_req_data(
		req, struct rpccli_dfs_GetManagerVersion_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.version = *state->tmp.out.version;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_dfs_GetManagerVersion_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx)
{
	struct rpccli_dfs_GetManagerVersion_state *state = tevent_req_data(
		req, struct rpccli_dfs_GetManagerVersion_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_dfs_GetManagerVersion(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      enum dfs_ManagerVersion *version /* [out] [ref] */)
{
	struct dfs_GetManagerVersion r;
	NTSTATUS status;

	/* In parameters */

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netdfs,
				NDR_DFS_GETMANAGERVERSION,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*version = *r.out.version;

	/* Return result */
	return NT_STATUS_OK;
}

struct rpccli_dfs_Add_state {
	struct dfs_Add orig;
	struct dfs_Add tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_dfs_Add_done(struct tevent_req *subreq);

struct tevent_req *rpccli_dfs_Add_send(TALLOC_CTX *mem_ctx,
				       struct tevent_context *ev,
				       struct rpc_pipe_client *cli,
				       const char *_path /* [in] [ref,charset(UTF16)] */,
				       const char *_server /* [in] [ref,charset(UTF16)] */,
				       const char *_share /* [in] [unique,charset(UTF16)] */,
				       const char *_comment /* [in] [unique,charset(UTF16)] */,
				       uint32_t _flags /* [in]  */)
{
	struct tevent_req *req;
	struct rpccli_dfs_Add_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_dfs_Add_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.path = _path;
	state->orig.in.server = _server;
	state->orig.in.share = _share;
	state->orig.in.comment = _comment;
	state->orig.in.flags = _flags;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netdfs,
				    NDR_DFS_ADD,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_dfs_Add_done, req);
	return req;
}

static void rpccli_dfs_Add_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_dfs_Add_state *state = tevent_req_data(
		req, struct rpccli_dfs_Add_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_dfs_Add_recv(struct tevent_req *req,
			     TALLOC_CTX *mem_ctx,
			     WERROR *result)
{
	struct rpccli_dfs_Add_state *state = tevent_req_data(
		req, struct rpccli_dfs_Add_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_dfs_Add(struct rpc_pipe_client *cli,
			TALLOC_CTX *mem_ctx,
			const char *path /* [in] [ref,charset(UTF16)] */,
			const char *server /* [in] [ref,charset(UTF16)] */,
			const char *share /* [in] [unique,charset(UTF16)] */,
			const char *comment /* [in] [unique,charset(UTF16)] */,
			uint32_t flags /* [in]  */,
			WERROR *werror)
{
	struct dfs_Add r;
	NTSTATUS status;

	/* In parameters */
	r.in.path = path;
	r.in.server = server;
	r.in.share = share;
	r.in.comment = comment;
	r.in.flags = flags;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netdfs,
				NDR_DFS_ADD,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_dfs_Remove_state {
	struct dfs_Remove orig;
	struct dfs_Remove tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_dfs_Remove_done(struct tevent_req *subreq);

struct tevent_req *rpccli_dfs_Remove_send(TALLOC_CTX *mem_ctx,
					  struct tevent_context *ev,
					  struct rpc_pipe_client *cli,
					  const char *_dfs_entry_path /* [in] [ref,charset(UTF16)] */,
					  const char *_servername /* [in] [unique,charset(UTF16)] */,
					  const char *_sharename /* [in] [unique,charset(UTF16)] */)
{
	struct tevent_req *req;
	struct rpccli_dfs_Remove_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_dfs_Remove_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.dfs_entry_path = _dfs_entry_path;
	state->orig.in.servername = _servername;
	state->orig.in.sharename = _sharename;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netdfs,
				    NDR_DFS_REMOVE,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_dfs_Remove_done, req);
	return req;
}

static void rpccli_dfs_Remove_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_dfs_Remove_state *state = tevent_req_data(
		req, struct rpccli_dfs_Remove_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_dfs_Remove_recv(struct tevent_req *req,
				TALLOC_CTX *mem_ctx,
				WERROR *result)
{
	struct rpccli_dfs_Remove_state *state = tevent_req_data(
		req, struct rpccli_dfs_Remove_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_dfs_Remove(struct rpc_pipe_client *cli,
			   TALLOC_CTX *mem_ctx,
			   const char *dfs_entry_path /* [in] [ref,charset(UTF16)] */,
			   const char *servername /* [in] [unique,charset(UTF16)] */,
			   const char *sharename /* [in] [unique,charset(UTF16)] */,
			   WERROR *werror)
{
	struct dfs_Remove r;
	NTSTATUS status;

	/* In parameters */
	r.in.dfs_entry_path = dfs_entry_path;
	r.in.servername = servername;
	r.in.sharename = sharename;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netdfs,
				NDR_DFS_REMOVE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_dfs_SetInfo_state {
	struct dfs_SetInfo orig;
	struct dfs_SetInfo tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_dfs_SetInfo_done(struct tevent_req *subreq);

struct tevent_req *rpccli_dfs_SetInfo_send(TALLOC_CTX *mem_ctx,
					   struct tevent_context *ev,
					   struct rpc_pipe_client *cli,
					   const char *_dfs_entry_path /* [in] [charset(UTF16)] */,
					   const char *_servername /* [in] [unique,charset(UTF16)] */,
					   const char *_sharename /* [in] [unique,charset(UTF16)] */,
					   uint32_t _level /* [in]  */,
					   union dfs_Info *_info /* [in] [ref,switch_is(level)] */)
{
	struct tevent_req *req;
	struct rpccli_dfs_SetInfo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_dfs_SetInfo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.dfs_entry_path = _dfs_entry_path;
	state->orig.in.servername = _servername;
	state->orig.in.sharename = _sharename;
	state->orig.in.level = _level;
	state->orig.in.info = _info;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netdfs,
				    NDR_DFS_SETINFO,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_dfs_SetInfo_done, req);
	return req;
}

static void rpccli_dfs_SetInfo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_dfs_SetInfo_state *state = tevent_req_data(
		req, struct rpccli_dfs_SetInfo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_dfs_SetInfo_recv(struct tevent_req *req,
				 TALLOC_CTX *mem_ctx,
				 WERROR *result)
{
	struct rpccli_dfs_SetInfo_state *state = tevent_req_data(
		req, struct rpccli_dfs_SetInfo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_dfs_SetInfo(struct rpc_pipe_client *cli,
			    TALLOC_CTX *mem_ctx,
			    const char *dfs_entry_path /* [in] [charset(UTF16)] */,
			    const char *servername /* [in] [unique,charset(UTF16)] */,
			    const char *sharename /* [in] [unique,charset(UTF16)] */,
			    uint32_t level /* [in]  */,
			    union dfs_Info *info /* [in] [ref,switch_is(level)] */,
			    WERROR *werror)
{
	struct dfs_SetInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.dfs_entry_path = dfs_entry_path;
	r.in.servername = servername;
	r.in.sharename = sharename;
	r.in.level = level;
	r.in.info = info;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netdfs,
				NDR_DFS_SETINFO,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_dfs_GetInfo_state {
	struct dfs_GetInfo orig;
	struct dfs_GetInfo tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_dfs_GetInfo_done(struct tevent_req *subreq);

struct tevent_req *rpccli_dfs_GetInfo_send(TALLOC_CTX *mem_ctx,
					   struct tevent_context *ev,
					   struct rpc_pipe_client *cli,
					   const char *_dfs_entry_path /* [in] [charset(UTF16)] */,
					   const char *_servername /* [in] [unique,charset(UTF16)] */,
					   const char *_sharename /* [in] [unique,charset(UTF16)] */,
					   uint32_t _level /* [in]  */,
					   union dfs_Info *_info /* [out] [ref,switch_is(level)] */)
{
	struct tevent_req *req;
	struct rpccli_dfs_GetInfo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_dfs_GetInfo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.dfs_entry_path = _dfs_entry_path;
	state->orig.in.servername = _servername;
	state->orig.in.sharename = _sharename;
	state->orig.in.level = _level;

	/* Out parameters */
	state->orig.out.info = _info;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_dfs_GetInfo_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netdfs,
				    NDR_DFS_GETINFO,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_dfs_GetInfo_done, req);
	return req;
}

static void rpccli_dfs_GetInfo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_dfs_GetInfo_state *state = tevent_req_data(
		req, struct rpccli_dfs_GetInfo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.info = *state->tmp.out.info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_dfs_GetInfo_recv(struct tevent_req *req,
				 TALLOC_CTX *mem_ctx,
				 WERROR *result)
{
	struct rpccli_dfs_GetInfo_state *state = tevent_req_data(
		req, struct rpccli_dfs_GetInfo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_dfs_GetInfo(struct rpc_pipe_client *cli,
			    TALLOC_CTX *mem_ctx,
			    const char *dfs_entry_path /* [in] [charset(UTF16)] */,
			    const char *servername /* [in] [unique,charset(UTF16)] */,
			    const char *sharename /* [in] [unique,charset(UTF16)] */,
			    uint32_t level /* [in]  */,
			    union dfs_Info *info /* [out] [ref,switch_is(level)] */,
			    WERROR *werror)
{
	struct dfs_GetInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.dfs_entry_path = dfs_entry_path;
	r.in.servername = servername;
	r.in.sharename = sharename;
	r.in.level = level;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netdfs,
				NDR_DFS_GETINFO,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*info = *r.out.info;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_dfs_Enum_state {
	struct dfs_Enum orig;
	struct dfs_Enum tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_dfs_Enum_done(struct tevent_req *subreq);

struct tevent_req *rpccli_dfs_Enum_send(TALLOC_CTX *mem_ctx,
					struct tevent_context *ev,
					struct rpc_pipe_client *cli,
					uint32_t _level /* [in]  */,
					uint32_t _bufsize /* [in]  */,
					struct dfs_EnumStruct *_info /* [in,out] [unique] */,
					uint32_t *_total /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct rpccli_dfs_Enum_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_dfs_Enum_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.level = _level;
	state->orig.in.bufsize = _bufsize;
	state->orig.in.info = _info;
	state->orig.in.total = _total;

	/* Out parameters */
	state->orig.out.info = _info;
	state->orig.out.total = _total;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_dfs_Enum_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netdfs,
				    NDR_DFS_ENUM,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_dfs_Enum_done, req);
	return req;
}

static void rpccli_dfs_Enum_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_dfs_Enum_state *state = tevent_req_data(
		req, struct rpccli_dfs_Enum_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.info && state->tmp.out.info) {
		*state->orig.out.info = *state->tmp.out.info;
	}
	if (state->orig.out.total && state->tmp.out.total) {
		*state->orig.out.total = *state->tmp.out.total;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_dfs_Enum_recv(struct tevent_req *req,
			      TALLOC_CTX *mem_ctx,
			      WERROR *result)
{
	struct rpccli_dfs_Enum_state *state = tevent_req_data(
		req, struct rpccli_dfs_Enum_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_dfs_Enum(struct rpc_pipe_client *cli,
			 TALLOC_CTX *mem_ctx,
			 uint32_t level /* [in]  */,
			 uint32_t bufsize /* [in]  */,
			 struct dfs_EnumStruct *info /* [in,out] [unique] */,
			 uint32_t *total /* [in,out] [unique] */,
			 WERROR *werror)
{
	struct dfs_Enum r;
	NTSTATUS status;

	/* In parameters */
	r.in.level = level;
	r.in.bufsize = bufsize;
	r.in.info = info;
	r.in.total = total;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netdfs,
				NDR_DFS_ENUM,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	if (info && r.out.info) {
		*info = *r.out.info;
	}
	if (total && r.out.total) {
		*total = *r.out.total;
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_dfs_Rename_state {
	struct dfs_Rename orig;
	struct dfs_Rename tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_dfs_Rename_done(struct tevent_req *subreq);

struct tevent_req *rpccli_dfs_Rename_send(TALLOC_CTX *mem_ctx,
					  struct tevent_context *ev,
					  struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_dfs_Rename_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_dfs_Rename_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netdfs,
				    NDR_DFS_RENAME,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_dfs_Rename_done, req);
	return req;
}

static void rpccli_dfs_Rename_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_dfs_Rename_state *state = tevent_req_data(
		req, struct rpccli_dfs_Rename_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_dfs_Rename_recv(struct tevent_req *req,
				TALLOC_CTX *mem_ctx,
				WERROR *result)
{
	struct rpccli_dfs_Rename_state *state = tevent_req_data(
		req, struct rpccli_dfs_Rename_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_dfs_Rename(struct rpc_pipe_client *cli,
			   TALLOC_CTX *mem_ctx,
			   WERROR *werror)
{
	struct dfs_Rename r;
	NTSTATUS status;

	/* In parameters */

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netdfs,
				NDR_DFS_RENAME,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_dfs_Move_state {
	struct dfs_Move orig;
	struct dfs_Move tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_dfs_Move_done(struct tevent_req *subreq);

struct tevent_req *rpccli_dfs_Move_send(TALLOC_CTX *mem_ctx,
					struct tevent_context *ev,
					struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_dfs_Move_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_dfs_Move_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netdfs,
				    NDR_DFS_MOVE,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_dfs_Move_done, req);
	return req;
}

static void rpccli_dfs_Move_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_dfs_Move_state *state = tevent_req_data(
		req, struct rpccli_dfs_Move_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_dfs_Move_recv(struct tevent_req *req,
			      TALLOC_CTX *mem_ctx,
			      WERROR *result)
{
	struct rpccli_dfs_Move_state *state = tevent_req_data(
		req, struct rpccli_dfs_Move_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_dfs_Move(struct rpc_pipe_client *cli,
			 TALLOC_CTX *mem_ctx,
			 WERROR *werror)
{
	struct dfs_Move r;
	NTSTATUS status;

	/* In parameters */

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netdfs,
				NDR_DFS_MOVE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_dfs_ManagerGetConfigInfo_state {
	struct dfs_ManagerGetConfigInfo orig;
	struct dfs_ManagerGetConfigInfo tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_dfs_ManagerGetConfigInfo_done(struct tevent_req *subreq);

struct tevent_req *rpccli_dfs_ManagerGetConfigInfo_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_dfs_ManagerGetConfigInfo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_dfs_ManagerGetConfigInfo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netdfs,
				    NDR_DFS_MANAGERGETCONFIGINFO,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_dfs_ManagerGetConfigInfo_done, req);
	return req;
}

static void rpccli_dfs_ManagerGetConfigInfo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_dfs_ManagerGetConfigInfo_state *state = tevent_req_data(
		req, struct rpccli_dfs_ManagerGetConfigInfo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_dfs_ManagerGetConfigInfo_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      WERROR *result)
{
	struct rpccli_dfs_ManagerGetConfigInfo_state *state = tevent_req_data(
		req, struct rpccli_dfs_ManagerGetConfigInfo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_dfs_ManagerGetConfigInfo(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 WERROR *werror)
{
	struct dfs_ManagerGetConfigInfo r;
	NTSTATUS status;

	/* In parameters */

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netdfs,
				NDR_DFS_MANAGERGETCONFIGINFO,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_dfs_ManagerSendSiteInfo_state {
	struct dfs_ManagerSendSiteInfo orig;
	struct dfs_ManagerSendSiteInfo tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_dfs_ManagerSendSiteInfo_done(struct tevent_req *subreq);

struct tevent_req *rpccli_dfs_ManagerSendSiteInfo_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_dfs_ManagerSendSiteInfo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_dfs_ManagerSendSiteInfo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netdfs,
				    NDR_DFS_MANAGERSENDSITEINFO,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_dfs_ManagerSendSiteInfo_done, req);
	return req;
}

static void rpccli_dfs_ManagerSendSiteInfo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_dfs_ManagerSendSiteInfo_state *state = tevent_req_data(
		req, struct rpccli_dfs_ManagerSendSiteInfo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_dfs_ManagerSendSiteInfo_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     WERROR *result)
{
	struct rpccli_dfs_ManagerSendSiteInfo_state *state = tevent_req_data(
		req, struct rpccli_dfs_ManagerSendSiteInfo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_dfs_ManagerSendSiteInfo(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					WERROR *werror)
{
	struct dfs_ManagerSendSiteInfo r;
	NTSTATUS status;

	/* In parameters */

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netdfs,
				NDR_DFS_MANAGERSENDSITEINFO,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_dfs_AddFtRoot_state {
	struct dfs_AddFtRoot orig;
	struct dfs_AddFtRoot tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_dfs_AddFtRoot_done(struct tevent_req *subreq);

struct tevent_req *rpccli_dfs_AddFtRoot_send(TALLOC_CTX *mem_ctx,
					     struct tevent_context *ev,
					     struct rpc_pipe_client *cli,
					     const char *_servername /* [in] [charset(UTF16)] */,
					     const char *_dns_servername /* [in] [charset(UTF16)] */,
					     const char *_dfsname /* [in] [charset(UTF16)] */,
					     const char *_rootshare /* [in] [charset(UTF16)] */,
					     const char *_comment /* [in] [charset(UTF16)] */,
					     const char *_dfs_config_dn /* [in] [charset(UTF16)] */,
					     uint8_t _unknown1 /* [in]  */,
					     uint32_t _flags /* [in]  */,
					     struct dfs_UnknownStruct **_unknown2 /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct rpccli_dfs_AddFtRoot_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_dfs_AddFtRoot_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.servername = _servername;
	state->orig.in.dns_servername = _dns_servername;
	state->orig.in.dfsname = _dfsname;
	state->orig.in.rootshare = _rootshare;
	state->orig.in.comment = _comment;
	state->orig.in.dfs_config_dn = _dfs_config_dn;
	state->orig.in.unknown1 = _unknown1;
	state->orig.in.flags = _flags;
	state->orig.in.unknown2 = _unknown2;

	/* Out parameters */
	state->orig.out.unknown2 = _unknown2;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_dfs_AddFtRoot_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netdfs,
				    NDR_DFS_ADDFTROOT,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_dfs_AddFtRoot_done, req);
	return req;
}

static void rpccli_dfs_AddFtRoot_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_dfs_AddFtRoot_state *state = tevent_req_data(
		req, struct rpccli_dfs_AddFtRoot_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.unknown2 && state->tmp.out.unknown2) {
		*state->orig.out.unknown2 = *state->tmp.out.unknown2;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_dfs_AddFtRoot_recv(struct tevent_req *req,
				   TALLOC_CTX *mem_ctx,
				   WERROR *result)
{
	struct rpccli_dfs_AddFtRoot_state *state = tevent_req_data(
		req, struct rpccli_dfs_AddFtRoot_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_dfs_AddFtRoot(struct rpc_pipe_client *cli,
			      TALLOC_CTX *mem_ctx,
			      const char *servername /* [in] [charset(UTF16)] */,
			      const char *dns_servername /* [in] [charset(UTF16)] */,
			      const char *dfsname /* [in] [charset(UTF16)] */,
			      const char *rootshare /* [in] [charset(UTF16)] */,
			      const char *comment /* [in] [charset(UTF16)] */,
			      const char *dfs_config_dn /* [in] [charset(UTF16)] */,
			      uint8_t unknown1 /* [in]  */,
			      uint32_t flags /* [in]  */,
			      struct dfs_UnknownStruct **unknown2 /* [in,out] [unique] */,
			      WERROR *werror)
{
	struct dfs_AddFtRoot r;
	NTSTATUS status;

	/* In parameters */
	r.in.servername = servername;
	r.in.dns_servername = dns_servername;
	r.in.dfsname = dfsname;
	r.in.rootshare = rootshare;
	r.in.comment = comment;
	r.in.dfs_config_dn = dfs_config_dn;
	r.in.unknown1 = unknown1;
	r.in.flags = flags;
	r.in.unknown2 = unknown2;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netdfs,
				NDR_DFS_ADDFTROOT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	if (unknown2 && r.out.unknown2) {
		*unknown2 = *r.out.unknown2;
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_dfs_RemoveFtRoot_state {
	struct dfs_RemoveFtRoot orig;
	struct dfs_RemoveFtRoot tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_dfs_RemoveFtRoot_done(struct tevent_req *subreq);

struct tevent_req *rpccli_dfs_RemoveFtRoot_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct rpc_pipe_client *cli,
						const char *_servername /* [in] [charset(UTF16)] */,
						const char *_dns_servername /* [in] [charset(UTF16)] */,
						const char *_dfsname /* [in] [charset(UTF16)] */,
						const char *_rootshare /* [in] [charset(UTF16)] */,
						uint32_t _flags /* [in]  */,
						struct dfs_UnknownStruct **_unknown /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct rpccli_dfs_RemoveFtRoot_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_dfs_RemoveFtRoot_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.servername = _servername;
	state->orig.in.dns_servername = _dns_servername;
	state->orig.in.dfsname = _dfsname;
	state->orig.in.rootshare = _rootshare;
	state->orig.in.flags = _flags;
	state->orig.in.unknown = _unknown;

	/* Out parameters */
	state->orig.out.unknown = _unknown;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_dfs_RemoveFtRoot_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netdfs,
				    NDR_DFS_REMOVEFTROOT,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_dfs_RemoveFtRoot_done, req);
	return req;
}

static void rpccli_dfs_RemoveFtRoot_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_dfs_RemoveFtRoot_state *state = tevent_req_data(
		req, struct rpccli_dfs_RemoveFtRoot_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.unknown && state->tmp.out.unknown) {
		*state->orig.out.unknown = *state->tmp.out.unknown;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_dfs_RemoveFtRoot_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      WERROR *result)
{
	struct rpccli_dfs_RemoveFtRoot_state *state = tevent_req_data(
		req, struct rpccli_dfs_RemoveFtRoot_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_dfs_RemoveFtRoot(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 const char *servername /* [in] [charset(UTF16)] */,
				 const char *dns_servername /* [in] [charset(UTF16)] */,
				 const char *dfsname /* [in] [charset(UTF16)] */,
				 const char *rootshare /* [in] [charset(UTF16)] */,
				 uint32_t flags /* [in]  */,
				 struct dfs_UnknownStruct **unknown /* [in,out] [unique] */,
				 WERROR *werror)
{
	struct dfs_RemoveFtRoot r;
	NTSTATUS status;

	/* In parameters */
	r.in.servername = servername;
	r.in.dns_servername = dns_servername;
	r.in.dfsname = dfsname;
	r.in.rootshare = rootshare;
	r.in.flags = flags;
	r.in.unknown = unknown;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netdfs,
				NDR_DFS_REMOVEFTROOT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	if (unknown && r.out.unknown) {
		*unknown = *r.out.unknown;
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_dfs_AddStdRoot_state {
	struct dfs_AddStdRoot orig;
	struct dfs_AddStdRoot tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_dfs_AddStdRoot_done(struct tevent_req *subreq);

struct tevent_req *rpccli_dfs_AddStdRoot_send(TALLOC_CTX *mem_ctx,
					      struct tevent_context *ev,
					      struct rpc_pipe_client *cli,
					      const char *_servername /* [in] [charset(UTF16)] */,
					      const char *_rootshare /* [in] [charset(UTF16)] */,
					      const char *_comment /* [in] [charset(UTF16)] */,
					      uint32_t _flags /* [in]  */)
{
	struct tevent_req *req;
	struct rpccli_dfs_AddStdRoot_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_dfs_AddStdRoot_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.servername = _servername;
	state->orig.in.rootshare = _rootshare;
	state->orig.in.comment = _comment;
	state->orig.in.flags = _flags;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netdfs,
				    NDR_DFS_ADDSTDROOT,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_dfs_AddStdRoot_done, req);
	return req;
}

static void rpccli_dfs_AddStdRoot_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_dfs_AddStdRoot_state *state = tevent_req_data(
		req, struct rpccli_dfs_AddStdRoot_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_dfs_AddStdRoot_recv(struct tevent_req *req,
				    TALLOC_CTX *mem_ctx,
				    WERROR *result)
{
	struct rpccli_dfs_AddStdRoot_state *state = tevent_req_data(
		req, struct rpccli_dfs_AddStdRoot_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_dfs_AddStdRoot(struct rpc_pipe_client *cli,
			       TALLOC_CTX *mem_ctx,
			       const char *servername /* [in] [charset(UTF16)] */,
			       const char *rootshare /* [in] [charset(UTF16)] */,
			       const char *comment /* [in] [charset(UTF16)] */,
			       uint32_t flags /* [in]  */,
			       WERROR *werror)
{
	struct dfs_AddStdRoot r;
	NTSTATUS status;

	/* In parameters */
	r.in.servername = servername;
	r.in.rootshare = rootshare;
	r.in.comment = comment;
	r.in.flags = flags;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netdfs,
				NDR_DFS_ADDSTDROOT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_dfs_RemoveStdRoot_state {
	struct dfs_RemoveStdRoot orig;
	struct dfs_RemoveStdRoot tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_dfs_RemoveStdRoot_done(struct tevent_req *subreq);

struct tevent_req *rpccli_dfs_RemoveStdRoot_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct rpc_pipe_client *cli,
						 const char *_servername /* [in] [charset(UTF16)] */,
						 const char *_rootshare /* [in] [charset(UTF16)] */,
						 uint32_t _flags /* [in]  */)
{
	struct tevent_req *req;
	struct rpccli_dfs_RemoveStdRoot_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_dfs_RemoveStdRoot_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.servername = _servername;
	state->orig.in.rootshare = _rootshare;
	state->orig.in.flags = _flags;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netdfs,
				    NDR_DFS_REMOVESTDROOT,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_dfs_RemoveStdRoot_done, req);
	return req;
}

static void rpccli_dfs_RemoveStdRoot_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_dfs_RemoveStdRoot_state *state = tevent_req_data(
		req, struct rpccli_dfs_RemoveStdRoot_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_dfs_RemoveStdRoot_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       WERROR *result)
{
	struct rpccli_dfs_RemoveStdRoot_state *state = tevent_req_data(
		req, struct rpccli_dfs_RemoveStdRoot_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_dfs_RemoveStdRoot(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  const char *servername /* [in] [charset(UTF16)] */,
				  const char *rootshare /* [in] [charset(UTF16)] */,
				  uint32_t flags /* [in]  */,
				  WERROR *werror)
{
	struct dfs_RemoveStdRoot r;
	NTSTATUS status;

	/* In parameters */
	r.in.servername = servername;
	r.in.rootshare = rootshare;
	r.in.flags = flags;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netdfs,
				NDR_DFS_REMOVESTDROOT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_dfs_ManagerInitialize_state {
	struct dfs_ManagerInitialize orig;
	struct dfs_ManagerInitialize tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_dfs_ManagerInitialize_done(struct tevent_req *subreq);

struct tevent_req *rpccli_dfs_ManagerInitialize_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct rpc_pipe_client *cli,
						     const char *_servername /* [in] [ref,charset(UTF16)] */,
						     uint32_t _flags /* [in]  */)
{
	struct tevent_req *req;
	struct rpccli_dfs_ManagerInitialize_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_dfs_ManagerInitialize_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.servername = _servername;
	state->orig.in.flags = _flags;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netdfs,
				    NDR_DFS_MANAGERINITIALIZE,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_dfs_ManagerInitialize_done, req);
	return req;
}

static void rpccli_dfs_ManagerInitialize_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_dfs_ManagerInitialize_state *state = tevent_req_data(
		req, struct rpccli_dfs_ManagerInitialize_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_dfs_ManagerInitialize_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result)
{
	struct rpccli_dfs_ManagerInitialize_state *state = tevent_req_data(
		req, struct rpccli_dfs_ManagerInitialize_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_dfs_ManagerInitialize(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      const char *servername /* [in] [ref,charset(UTF16)] */,
				      uint32_t flags /* [in]  */,
				      WERROR *werror)
{
	struct dfs_ManagerInitialize r;
	NTSTATUS status;

	/* In parameters */
	r.in.servername = servername;
	r.in.flags = flags;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netdfs,
				NDR_DFS_MANAGERINITIALIZE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_dfs_AddStdRootForced_state {
	struct dfs_AddStdRootForced orig;
	struct dfs_AddStdRootForced tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_dfs_AddStdRootForced_done(struct tevent_req *subreq);

struct tevent_req *rpccli_dfs_AddStdRootForced_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct rpc_pipe_client *cli,
						    const char *_servername /* [in] [charset(UTF16)] */,
						    const char *_rootshare /* [in] [charset(UTF16)] */,
						    const char *_comment /* [in] [charset(UTF16)] */,
						    const char *_store /* [in] [charset(UTF16)] */)
{
	struct tevent_req *req;
	struct rpccli_dfs_AddStdRootForced_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_dfs_AddStdRootForced_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.servername = _servername;
	state->orig.in.rootshare = _rootshare;
	state->orig.in.comment = _comment;
	state->orig.in.store = _store;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netdfs,
				    NDR_DFS_ADDSTDROOTFORCED,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_dfs_AddStdRootForced_done, req);
	return req;
}

static void rpccli_dfs_AddStdRootForced_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_dfs_AddStdRootForced_state *state = tevent_req_data(
		req, struct rpccli_dfs_AddStdRootForced_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_dfs_AddStdRootForced_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result)
{
	struct rpccli_dfs_AddStdRootForced_state *state = tevent_req_data(
		req, struct rpccli_dfs_AddStdRootForced_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_dfs_AddStdRootForced(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     const char *servername /* [in] [charset(UTF16)] */,
				     const char *rootshare /* [in] [charset(UTF16)] */,
				     const char *comment /* [in] [charset(UTF16)] */,
				     const char *store /* [in] [charset(UTF16)] */,
				     WERROR *werror)
{
	struct dfs_AddStdRootForced r;
	NTSTATUS status;

	/* In parameters */
	r.in.servername = servername;
	r.in.rootshare = rootshare;
	r.in.comment = comment;
	r.in.store = store;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netdfs,
				NDR_DFS_ADDSTDROOTFORCED,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_dfs_GetDcAddress_state {
	struct dfs_GetDcAddress orig;
	struct dfs_GetDcAddress tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_dfs_GetDcAddress_done(struct tevent_req *subreq);

struct tevent_req *rpccli_dfs_GetDcAddress_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct rpc_pipe_client *cli,
						const char *_servername /* [in] [charset(UTF16)] */,
						const char **_server_fullname /* [in,out] [ref,charset(UTF16)] */,
						uint8_t *_is_root /* [in,out] [ref] */,
						uint32_t *_ttl /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_dfs_GetDcAddress_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_dfs_GetDcAddress_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.servername = _servername;
	state->orig.in.server_fullname = _server_fullname;
	state->orig.in.is_root = _is_root;
	state->orig.in.ttl = _ttl;

	/* Out parameters */
	state->orig.out.server_fullname = _server_fullname;
	state->orig.out.is_root = _is_root;
	state->orig.out.ttl = _ttl;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_dfs_GetDcAddress_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netdfs,
				    NDR_DFS_GETDCADDRESS,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_dfs_GetDcAddress_done, req);
	return req;
}

static void rpccli_dfs_GetDcAddress_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_dfs_GetDcAddress_state *state = tevent_req_data(
		req, struct rpccli_dfs_GetDcAddress_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.server_fullname = *state->tmp.out.server_fullname;
	*state->orig.out.is_root = *state->tmp.out.is_root;
	*state->orig.out.ttl = *state->tmp.out.ttl;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_dfs_GetDcAddress_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      WERROR *result)
{
	struct rpccli_dfs_GetDcAddress_state *state = tevent_req_data(
		req, struct rpccli_dfs_GetDcAddress_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_dfs_GetDcAddress(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 const char *servername /* [in] [charset(UTF16)] */,
				 const char **server_fullname /* [in,out] [ref,charset(UTF16)] */,
				 uint8_t *is_root /* [in,out] [ref] */,
				 uint32_t *ttl /* [in,out] [ref] */,
				 WERROR *werror)
{
	struct dfs_GetDcAddress r;
	NTSTATUS status;

	/* In parameters */
	r.in.servername = servername;
	r.in.server_fullname = server_fullname;
	r.in.is_root = is_root;
	r.in.ttl = ttl;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netdfs,
				NDR_DFS_GETDCADDRESS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*server_fullname = *r.out.server_fullname;
	*is_root = *r.out.is_root;
	*ttl = *r.out.ttl;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_dfs_SetDcAddress_state {
	struct dfs_SetDcAddress orig;
	struct dfs_SetDcAddress tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_dfs_SetDcAddress_done(struct tevent_req *subreq);

struct tevent_req *rpccli_dfs_SetDcAddress_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct rpc_pipe_client *cli,
						const char *_servername /* [in] [charset(UTF16)] */,
						const char *_server_fullname /* [in] [charset(UTF16)] */,
						uint32_t _flags /* [in]  */,
						uint32_t _ttl /* [in]  */)
{
	struct tevent_req *req;
	struct rpccli_dfs_SetDcAddress_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_dfs_SetDcAddress_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.servername = _servername;
	state->orig.in.server_fullname = _server_fullname;
	state->orig.in.flags = _flags;
	state->orig.in.ttl = _ttl;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netdfs,
				    NDR_DFS_SETDCADDRESS,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_dfs_SetDcAddress_done, req);
	return req;
}

static void rpccli_dfs_SetDcAddress_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_dfs_SetDcAddress_state *state = tevent_req_data(
		req, struct rpccli_dfs_SetDcAddress_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_dfs_SetDcAddress_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      WERROR *result)
{
	struct rpccli_dfs_SetDcAddress_state *state = tevent_req_data(
		req, struct rpccli_dfs_SetDcAddress_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_dfs_SetDcAddress(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 const char *servername /* [in] [charset(UTF16)] */,
				 const char *server_fullname /* [in] [charset(UTF16)] */,
				 uint32_t flags /* [in]  */,
				 uint32_t ttl /* [in]  */,
				 WERROR *werror)
{
	struct dfs_SetDcAddress r;
	NTSTATUS status;

	/* In parameters */
	r.in.servername = servername;
	r.in.server_fullname = server_fullname;
	r.in.flags = flags;
	r.in.ttl = ttl;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netdfs,
				NDR_DFS_SETDCADDRESS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_dfs_FlushFtTable_state {
	struct dfs_FlushFtTable orig;
	struct dfs_FlushFtTable tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_dfs_FlushFtTable_done(struct tevent_req *subreq);

struct tevent_req *rpccli_dfs_FlushFtTable_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct rpc_pipe_client *cli,
						const char *_servername /* [in] [charset(UTF16)] */,
						const char *_rootshare /* [in] [charset(UTF16)] */)
{
	struct tevent_req *req;
	struct rpccli_dfs_FlushFtTable_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_dfs_FlushFtTable_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.servername = _servername;
	state->orig.in.rootshare = _rootshare;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netdfs,
				    NDR_DFS_FLUSHFTTABLE,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_dfs_FlushFtTable_done, req);
	return req;
}

static void rpccli_dfs_FlushFtTable_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_dfs_FlushFtTable_state *state = tevent_req_data(
		req, struct rpccli_dfs_FlushFtTable_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_dfs_FlushFtTable_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      WERROR *result)
{
	struct rpccli_dfs_FlushFtTable_state *state = tevent_req_data(
		req, struct rpccli_dfs_FlushFtTable_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_dfs_FlushFtTable(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 const char *servername /* [in] [charset(UTF16)] */,
				 const char *rootshare /* [in] [charset(UTF16)] */,
				 WERROR *werror)
{
	struct dfs_FlushFtTable r;
	NTSTATUS status;

	/* In parameters */
	r.in.servername = servername;
	r.in.rootshare = rootshare;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netdfs,
				NDR_DFS_FLUSHFTTABLE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_dfs_Add2_state {
	struct dfs_Add2 orig;
	struct dfs_Add2 tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_dfs_Add2_done(struct tevent_req *subreq);

struct tevent_req *rpccli_dfs_Add2_send(TALLOC_CTX *mem_ctx,
					struct tevent_context *ev,
					struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_dfs_Add2_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_dfs_Add2_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netdfs,
				    NDR_DFS_ADD2,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_dfs_Add2_done, req);
	return req;
}

static void rpccli_dfs_Add2_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_dfs_Add2_state *state = tevent_req_data(
		req, struct rpccli_dfs_Add2_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_dfs_Add2_recv(struct tevent_req *req,
			      TALLOC_CTX *mem_ctx,
			      WERROR *result)
{
	struct rpccli_dfs_Add2_state *state = tevent_req_data(
		req, struct rpccli_dfs_Add2_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_dfs_Add2(struct rpc_pipe_client *cli,
			 TALLOC_CTX *mem_ctx,
			 WERROR *werror)
{
	struct dfs_Add2 r;
	NTSTATUS status;

	/* In parameters */

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netdfs,
				NDR_DFS_ADD2,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_dfs_Remove2_state {
	struct dfs_Remove2 orig;
	struct dfs_Remove2 tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_dfs_Remove2_done(struct tevent_req *subreq);

struct tevent_req *rpccli_dfs_Remove2_send(TALLOC_CTX *mem_ctx,
					   struct tevent_context *ev,
					   struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_dfs_Remove2_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_dfs_Remove2_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netdfs,
				    NDR_DFS_REMOVE2,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_dfs_Remove2_done, req);
	return req;
}

static void rpccli_dfs_Remove2_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_dfs_Remove2_state *state = tevent_req_data(
		req, struct rpccli_dfs_Remove2_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_dfs_Remove2_recv(struct tevent_req *req,
				 TALLOC_CTX *mem_ctx,
				 WERROR *result)
{
	struct rpccli_dfs_Remove2_state *state = tevent_req_data(
		req, struct rpccli_dfs_Remove2_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_dfs_Remove2(struct rpc_pipe_client *cli,
			    TALLOC_CTX *mem_ctx,
			    WERROR *werror)
{
	struct dfs_Remove2 r;
	NTSTATUS status;

	/* In parameters */

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netdfs,
				NDR_DFS_REMOVE2,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_dfs_EnumEx_state {
	struct dfs_EnumEx orig;
	struct dfs_EnumEx tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_dfs_EnumEx_done(struct tevent_req *subreq);

struct tevent_req *rpccli_dfs_EnumEx_send(TALLOC_CTX *mem_ctx,
					  struct tevent_context *ev,
					  struct rpc_pipe_client *cli,
					  const char *_dfs_name /* [in] [charset(UTF16)] */,
					  uint32_t _level /* [in]  */,
					  uint32_t _bufsize /* [in]  */,
					  struct dfs_EnumStruct *_info /* [in,out] [unique] */,
					  uint32_t *_total /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct rpccli_dfs_EnumEx_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_dfs_EnumEx_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.dfs_name = _dfs_name;
	state->orig.in.level = _level;
	state->orig.in.bufsize = _bufsize;
	state->orig.in.info = _info;
	state->orig.in.total = _total;

	/* Out parameters */
	state->orig.out.info = _info;
	state->orig.out.total = _total;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_dfs_EnumEx_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netdfs,
				    NDR_DFS_ENUMEX,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_dfs_EnumEx_done, req);
	return req;
}

static void rpccli_dfs_EnumEx_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_dfs_EnumEx_state *state = tevent_req_data(
		req, struct rpccli_dfs_EnumEx_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.info && state->tmp.out.info) {
		*state->orig.out.info = *state->tmp.out.info;
	}
	if (state->orig.out.total && state->tmp.out.total) {
		*state->orig.out.total = *state->tmp.out.total;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_dfs_EnumEx_recv(struct tevent_req *req,
				TALLOC_CTX *mem_ctx,
				WERROR *result)
{
	struct rpccli_dfs_EnumEx_state *state = tevent_req_data(
		req, struct rpccli_dfs_EnumEx_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_dfs_EnumEx(struct rpc_pipe_client *cli,
			   TALLOC_CTX *mem_ctx,
			   const char *dfs_name /* [in] [charset(UTF16)] */,
			   uint32_t level /* [in]  */,
			   uint32_t bufsize /* [in]  */,
			   struct dfs_EnumStruct *info /* [in,out] [unique] */,
			   uint32_t *total /* [in,out] [unique] */,
			   WERROR *werror)
{
	struct dfs_EnumEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.dfs_name = dfs_name;
	r.in.level = level;
	r.in.bufsize = bufsize;
	r.in.info = info;
	r.in.total = total;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netdfs,
				NDR_DFS_ENUMEX,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	if (info && r.out.info) {
		*info = *r.out.info;
	}
	if (total && r.out.total) {
		*total = *r.out.total;
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

struct rpccli_dfs_SetInfo2_state {
	struct dfs_SetInfo2 orig;
	struct dfs_SetInfo2 tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_dfs_SetInfo2_done(struct tevent_req *subreq);

struct tevent_req *rpccli_dfs_SetInfo2_send(TALLOC_CTX *mem_ctx,
					    struct tevent_context *ev,
					    struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_dfs_SetInfo2_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_dfs_SetInfo2_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_netdfs,
				    NDR_DFS_SETINFO2,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_dfs_SetInfo2_done, req);
	return req;
}

static void rpccli_dfs_SetInfo2_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_dfs_SetInfo2_state *state = tevent_req_data(
		req, struct rpccli_dfs_SetInfo2_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_dfs_SetInfo2_recv(struct tevent_req *req,
				  TALLOC_CTX *mem_ctx,
				  WERROR *result)
{
	struct rpccli_dfs_SetInfo2_state *state = tevent_req_data(
		req, struct rpccli_dfs_SetInfo2_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_dfs_SetInfo2(struct rpc_pipe_client *cli,
			     TALLOC_CTX *mem_ctx,
			     WERROR *werror)
{
	struct dfs_SetInfo2 r;
	NTSTATUS status;

	/* In parameters */

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netdfs,
				NDR_DFS_SETINFO2,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

