/*
 * Unix SMB/CIFS implementation.
 * client auto-generated by pidl. DO NOT MODIFY!
 */

#include "includes.h"
#include "../librpc/gen_ndr/cli_dfs.h"

NTSTATUS rpccli_dfs_GetManagerVersion(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      enum dfs_ManagerVersion *version /* [out] [ref] */)
{
	struct dfs_GetManagerVersion r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(dfs_GetManagerVersion, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netdfs,
				NDR_DFS_GETMANAGERVERSION,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(dfs_GetManagerVersion, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*version = *r.out.version;

	/* Return result */
	return NT_STATUS_OK;
}

NTSTATUS rpccli_dfs_Add(struct rpc_pipe_client *cli,
			TALLOC_CTX *mem_ctx,
			const char *path /* [in] [ref,charset(UTF16)] */,
			const char *server /* [in] [ref,charset(UTF16)] */,
			const char *share /* [in] [unique,charset(UTF16)] */,
			const char *comment /* [in] [unique,charset(UTF16)] */,
			uint32_t flags /* [in]  */,
			WERROR *werror)
{
	struct dfs_Add r;
	NTSTATUS status;

	/* In parameters */
	r.in.path = path;
	r.in.server = server;
	r.in.share = share;
	r.in.comment = comment;
	r.in.flags = flags;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(dfs_Add, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netdfs,
				NDR_DFS_ADD,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(dfs_Add, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_dfs_Remove(struct rpc_pipe_client *cli,
			   TALLOC_CTX *mem_ctx,
			   const char *dfs_entry_path /* [in] [ref,charset(UTF16)] */,
			   const char *servername /* [in] [unique,charset(UTF16)] */,
			   const char *sharename /* [in] [unique,charset(UTF16)] */,
			   WERROR *werror)
{
	struct dfs_Remove r;
	NTSTATUS status;

	/* In parameters */
	r.in.dfs_entry_path = dfs_entry_path;
	r.in.servername = servername;
	r.in.sharename = sharename;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(dfs_Remove, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netdfs,
				NDR_DFS_REMOVE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(dfs_Remove, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_dfs_SetInfo(struct rpc_pipe_client *cli,
			    TALLOC_CTX *mem_ctx,
			    const char *dfs_entry_path /* [in] [charset(UTF16)] */,
			    const char *servername /* [in] [unique,charset(UTF16)] */,
			    const char *sharename /* [in] [unique,charset(UTF16)] */,
			    uint32_t level /* [in]  */,
			    union dfs_Info *info /* [in] [ref,switch_is(level)] */,
			    WERROR *werror)
{
	struct dfs_SetInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.dfs_entry_path = dfs_entry_path;
	r.in.servername = servername;
	r.in.sharename = sharename;
	r.in.level = level;
	r.in.info = info;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(dfs_SetInfo, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netdfs,
				NDR_DFS_SETINFO,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(dfs_SetInfo, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_dfs_GetInfo(struct rpc_pipe_client *cli,
			    TALLOC_CTX *mem_ctx,
			    const char *dfs_entry_path /* [in] [charset(UTF16)] */,
			    const char *servername /* [in] [unique,charset(UTF16)] */,
			    const char *sharename /* [in] [unique,charset(UTF16)] */,
			    uint32_t level /* [in]  */,
			    union dfs_Info *info /* [out] [ref,switch_is(level)] */,
			    WERROR *werror)
{
	struct dfs_GetInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.dfs_entry_path = dfs_entry_path;
	r.in.servername = servername;
	r.in.sharename = sharename;
	r.in.level = level;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(dfs_GetInfo, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netdfs,
				NDR_DFS_GETINFO,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(dfs_GetInfo, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*info = *r.out.info;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_dfs_Enum(struct rpc_pipe_client *cli,
			 TALLOC_CTX *mem_ctx,
			 uint32_t level /* [in]  */,
			 uint32_t bufsize /* [in]  */,
			 struct dfs_EnumStruct *info /* [in,out] [unique] */,
			 uint32_t *total /* [in,out] [unique] */,
			 WERROR *werror)
{
	struct dfs_Enum r;
	NTSTATUS status;

	/* In parameters */
	r.in.level = level;
	r.in.bufsize = bufsize;
	r.in.info = info;
	r.in.total = total;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(dfs_Enum, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netdfs,
				NDR_DFS_ENUM,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(dfs_Enum, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	if (info && r.out.info) {
		*info = *r.out.info;
	}
	if (total && r.out.total) {
		*total = *r.out.total;
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_dfs_Rename(struct rpc_pipe_client *cli,
			   TALLOC_CTX *mem_ctx,
			   WERROR *werror)
{
	struct dfs_Rename r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(dfs_Rename, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netdfs,
				NDR_DFS_RENAME,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(dfs_Rename, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_dfs_Move(struct rpc_pipe_client *cli,
			 TALLOC_CTX *mem_ctx,
			 WERROR *werror)
{
	struct dfs_Move r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(dfs_Move, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netdfs,
				NDR_DFS_MOVE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(dfs_Move, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_dfs_ManagerGetConfigInfo(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 WERROR *werror)
{
	struct dfs_ManagerGetConfigInfo r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(dfs_ManagerGetConfigInfo, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netdfs,
				NDR_DFS_MANAGERGETCONFIGINFO,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(dfs_ManagerGetConfigInfo, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_dfs_ManagerSendSiteInfo(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					WERROR *werror)
{
	struct dfs_ManagerSendSiteInfo r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(dfs_ManagerSendSiteInfo, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netdfs,
				NDR_DFS_MANAGERSENDSITEINFO,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(dfs_ManagerSendSiteInfo, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_dfs_AddFtRoot(struct rpc_pipe_client *cli,
			      TALLOC_CTX *mem_ctx,
			      const char *servername /* [in] [charset(UTF16)] */,
			      const char *dns_servername /* [in] [charset(UTF16)] */,
			      const char *dfsname /* [in] [charset(UTF16)] */,
			      const char *rootshare /* [in] [charset(UTF16)] */,
			      const char *comment /* [in] [charset(UTF16)] */,
			      const char *dfs_config_dn /* [in] [charset(UTF16)] */,
			      uint8_t unknown1 /* [in]  */,
			      uint32_t flags /* [in]  */,
			      struct dfs_UnknownStruct **unknown2 /* [in,out] [unique] */,
			      WERROR *werror)
{
	struct dfs_AddFtRoot r;
	NTSTATUS status;

	/* In parameters */
	r.in.servername = servername;
	r.in.dns_servername = dns_servername;
	r.in.dfsname = dfsname;
	r.in.rootshare = rootshare;
	r.in.comment = comment;
	r.in.dfs_config_dn = dfs_config_dn;
	r.in.unknown1 = unknown1;
	r.in.flags = flags;
	r.in.unknown2 = unknown2;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(dfs_AddFtRoot, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netdfs,
				NDR_DFS_ADDFTROOT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(dfs_AddFtRoot, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	if (unknown2 && r.out.unknown2) {
		*unknown2 = *r.out.unknown2;
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_dfs_RemoveFtRoot(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 const char *servername /* [in] [charset(UTF16)] */,
				 const char *dns_servername /* [in] [charset(UTF16)] */,
				 const char *dfsname /* [in] [charset(UTF16)] */,
				 const char *rootshare /* [in] [charset(UTF16)] */,
				 uint32_t flags /* [in]  */,
				 struct dfs_UnknownStruct **unknown /* [in,out] [unique] */,
				 WERROR *werror)
{
	struct dfs_RemoveFtRoot r;
	NTSTATUS status;

	/* In parameters */
	r.in.servername = servername;
	r.in.dns_servername = dns_servername;
	r.in.dfsname = dfsname;
	r.in.rootshare = rootshare;
	r.in.flags = flags;
	r.in.unknown = unknown;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(dfs_RemoveFtRoot, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netdfs,
				NDR_DFS_REMOVEFTROOT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(dfs_RemoveFtRoot, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	if (unknown && r.out.unknown) {
		*unknown = *r.out.unknown;
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_dfs_AddStdRoot(struct rpc_pipe_client *cli,
			       TALLOC_CTX *mem_ctx,
			       const char *servername /* [in] [charset(UTF16)] */,
			       const char *rootshare /* [in] [charset(UTF16)] */,
			       const char *comment /* [in] [charset(UTF16)] */,
			       uint32_t flags /* [in]  */,
			       WERROR *werror)
{
	struct dfs_AddStdRoot r;
	NTSTATUS status;

	/* In parameters */
	r.in.servername = servername;
	r.in.rootshare = rootshare;
	r.in.comment = comment;
	r.in.flags = flags;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(dfs_AddStdRoot, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netdfs,
				NDR_DFS_ADDSTDROOT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(dfs_AddStdRoot, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_dfs_RemoveStdRoot(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  const char *servername /* [in] [charset(UTF16)] */,
				  const char *rootshare /* [in] [charset(UTF16)] */,
				  uint32_t flags /* [in]  */,
				  WERROR *werror)
{
	struct dfs_RemoveStdRoot r;
	NTSTATUS status;

	/* In parameters */
	r.in.servername = servername;
	r.in.rootshare = rootshare;
	r.in.flags = flags;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(dfs_RemoveStdRoot, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netdfs,
				NDR_DFS_REMOVESTDROOT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(dfs_RemoveStdRoot, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_dfs_ManagerInitialize(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      const char *servername /* [in] [ref,charset(UTF16)] */,
				      uint32_t flags /* [in]  */,
				      WERROR *werror)
{
	struct dfs_ManagerInitialize r;
	NTSTATUS status;

	/* In parameters */
	r.in.servername = servername;
	r.in.flags = flags;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(dfs_ManagerInitialize, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netdfs,
				NDR_DFS_MANAGERINITIALIZE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(dfs_ManagerInitialize, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_dfs_AddStdRootForced(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     const char *servername /* [in] [charset(UTF16)] */,
				     const char *rootshare /* [in] [charset(UTF16)] */,
				     const char *comment /* [in] [charset(UTF16)] */,
				     const char *store /* [in] [charset(UTF16)] */,
				     WERROR *werror)
{
	struct dfs_AddStdRootForced r;
	NTSTATUS status;

	/* In parameters */
	r.in.servername = servername;
	r.in.rootshare = rootshare;
	r.in.comment = comment;
	r.in.store = store;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(dfs_AddStdRootForced, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netdfs,
				NDR_DFS_ADDSTDROOTFORCED,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(dfs_AddStdRootForced, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_dfs_GetDcAddress(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 const char *servername /* [in] [charset(UTF16)] */,
				 const char **server_fullname /* [in,out] [ref,charset(UTF16)] */,
				 uint8_t *is_root /* [in,out] [ref] */,
				 uint32_t *ttl /* [in,out] [ref] */,
				 WERROR *werror)
{
	struct dfs_GetDcAddress r;
	NTSTATUS status;

	/* In parameters */
	r.in.servername = servername;
	r.in.server_fullname = server_fullname;
	r.in.is_root = is_root;
	r.in.ttl = ttl;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(dfs_GetDcAddress, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netdfs,
				NDR_DFS_GETDCADDRESS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(dfs_GetDcAddress, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*server_fullname = *r.out.server_fullname;
	*is_root = *r.out.is_root;
	*ttl = *r.out.ttl;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_dfs_SetDcAddress(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 const char *servername /* [in] [charset(UTF16)] */,
				 const char *server_fullname /* [in] [charset(UTF16)] */,
				 uint32_t flags /* [in]  */,
				 uint32_t ttl /* [in]  */,
				 WERROR *werror)
{
	struct dfs_SetDcAddress r;
	NTSTATUS status;

	/* In parameters */
	r.in.servername = servername;
	r.in.server_fullname = server_fullname;
	r.in.flags = flags;
	r.in.ttl = ttl;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(dfs_SetDcAddress, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netdfs,
				NDR_DFS_SETDCADDRESS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(dfs_SetDcAddress, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_dfs_FlushFtTable(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 const char *servername /* [in] [charset(UTF16)] */,
				 const char *rootshare /* [in] [charset(UTF16)] */,
				 WERROR *werror)
{
	struct dfs_FlushFtTable r;
	NTSTATUS status;

	/* In parameters */
	r.in.servername = servername;
	r.in.rootshare = rootshare;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(dfs_FlushFtTable, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netdfs,
				NDR_DFS_FLUSHFTTABLE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(dfs_FlushFtTable, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_dfs_Add2(struct rpc_pipe_client *cli,
			 TALLOC_CTX *mem_ctx,
			 WERROR *werror)
{
	struct dfs_Add2 r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(dfs_Add2, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netdfs,
				NDR_DFS_ADD2,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(dfs_Add2, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_dfs_Remove2(struct rpc_pipe_client *cli,
			    TALLOC_CTX *mem_ctx,
			    WERROR *werror)
{
	struct dfs_Remove2 r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(dfs_Remove2, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netdfs,
				NDR_DFS_REMOVE2,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(dfs_Remove2, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_dfs_EnumEx(struct rpc_pipe_client *cli,
			   TALLOC_CTX *mem_ctx,
			   const char *dfs_name /* [in] [charset(UTF16)] */,
			   uint32_t level /* [in]  */,
			   uint32_t bufsize /* [in]  */,
			   struct dfs_EnumStruct *info /* [in,out] [unique] */,
			   uint32_t *total /* [in,out] [unique] */,
			   WERROR *werror)
{
	struct dfs_EnumEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.dfs_name = dfs_name;
	r.in.level = level;
	r.in.bufsize = bufsize;
	r.in.info = info;
	r.in.total = total;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(dfs_EnumEx, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netdfs,
				NDR_DFS_ENUMEX,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(dfs_EnumEx, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	if (info && r.out.info) {
		*info = *r.out.info;
	}
	if (total && r.out.total) {
		*total = *r.out.total;
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_dfs_SetInfo2(struct rpc_pipe_client *cli,
			     TALLOC_CTX *mem_ctx,
			     WERROR *werror)
{
	struct dfs_SetInfo2 r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(dfs_SetInfo2, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_netdfs,
				NDR_DFS_SETINFO2,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(dfs_SetInfo2, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

