/*
 * vcardfactory.h - class for caching vCards
 * Copyright (C) 2003  Michail Pishchagin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef VCARDFACTORY_H
#define VCARDFACTORY_H

#include <qobject.h>

#include "im.h"
#include "xmpp_vcard.h"
#include "xmpp_tasks.h"

using namespace XMPP;

class VCardFactory
{
public:
	// call this, when you need a cached vCard
	static const VCard *vcard(const Jid &);

	// call this when you need to update vCard in cache
	static void setVCard(const Jid &, const VCard &);

	// call this when you need to retrieve fresh vCard from server (and store it in cache afterwards)
	static JT_VCard *getVCard(const Jid &, Task *rootTask, const QObject *, const char *slot, bool cacheVCard = true);

	// Register for updates to vcard changes
	static void registerVCardChanged(const QObject*, const char* slot);
};

#endif
