/*
 * psitextview.h - Icon-aware QTextView subclass widget
 * Copyright (C) 2003  Michail Pishchagin
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef PSITEXTVIEW
#define PSITEXTVIEW

#include <qtextedit.h>
#include <qlabel.h>

class QStyleSheet;

class URLLabel : public QLabel
{
	Q_OBJECT

	Q_PROPERTY( QString url READ url WRITE setUrl )
	Q_PROPERTY( QString title READ title WRITE setTitle )

	Q_OVERRIDE( QString text DESIGNABLE false SCRIPTABLE false )
	//Q_OVERRIDE( TextFormat DESIGNABLE false SCRIPTABLE false )

public:
	URLLabel(QWidget *parent = 0, const char *name = 0);
	~URLLabel();

	const QString &url() const;
	void setUrl(const QString &);

	const QString &title() const;
	void setTitle(const QString &);

	static void connectOpenURL(QObject *receiver, const char *slot); // openURL(QString url);

protected:
	virtual void mouseReleaseEvent (QMouseEvent *);
	virtual void enterEvent (QEvent *);
	virtual void leaveEvent (QEvent *);

	void updateText();

public:
	class Private;
private:
	Private *d;
};

class PsiTextView : public QTextEdit
{
	Q_OBJECT

	Q_OVERRIDE( int undoDepth DESIGNABLE false SCRIPTABLE false )
	Q_OVERRIDE( bool overwriteMode DESIGNABLE false SCRIPTABLE false )
	Q_OVERRIDE( bool modified SCRIPTABLE false)
	Q_OVERRIDE( bool readOnly DESIGNABLE false SCRIPTABLE false )
	Q_OVERRIDE( bool undoRedoEnabled DESIGNABLE false SCRIPTABLE false )

public:
	PsiTextView(QWidget *parent = 0, const char *name = 0);

	static QStyleSheet *styleSheet();

	class Private;

protected:
	QPopupMenu *createPopupMenu(const QPoint &pos);
	QPopupMenu *createPopupMenu() { return 0; } // FIXME

private:
	bool linksEnabled() const { return TRUE; }
	void emitHighlighted(const QString &s);
	void emitLinkClicked(const QString &s);

	Private *d;
};

#endif
