/* $Cambridge: hermes/src/prayer/session/filter.h,v 1.2 2008/05/19 15:55:58 dpc22 Exp $ */
/************************************************
 *    Prayer - a Webmail Interface              *
 ************************************************/

/* Copyright (c) University of Cambridge 2000 - 2008 */
/* See the file NOTICE for conditions of use and distribution. */

/* Data structures for Exim filter file support */

/* Types of filter that we support */
typedef enum { FILTER_UNKNOWN, FILTER_SENDER, FILTER_RECIPIENT,
    FILTER_SUBJECT, FILTER_BLOCK
} FILTER_TYPE;

struct filter {
    struct list_item hdr;       /* Linked list */
    FILTER_TYPE type;           /* Type of filter */
    char *local_part;           /* For SENDER/RECIPIENT/BLOCK type */
    char *domain;               /* For SENDER/RECIPIENT/BLOCK type */
    char *subject;              /* For SUBJECT type */
    char *mailbox;              /* For SENDER/RECIPIENT/SUBJECT type */
    BOOL copy;                  /* For SENDER/RECIPIENT/SUBJECT type */
};

struct filter *filter_alloc(void);
void filter_free(struct filter *filter);
void filter_set_type(struct filter *filter, FILTER_TYPE type);
void filter_set_local_part(struct filter *filter, char *local_part);
void filter_set_domain(struct filter *filter, char *domain);
void filter_set_subject(struct filter *filter, char *subject);
void filter_set_mailbox(struct filter *filter, char *mailbox);
void filter_set_copy(struct filter *filter, BOOL copy);

BOOL
filter_set_addr(struct filter *filter, struct session *session,
                char *addr);
BOOL filter_test_addr(struct filter *filter, struct session *session,
                      char *addr);

void filter_print(struct filter *filter, struct buffer *b);

BOOL
filter_sieve_print(struct filter *filter, struct buffer *b);

void filter_strip8bit(struct filter *filter);
