/* $Cambridge: hermes/src/prayer/lib/mydb.c,v 1.2 2008/05/19 15:55:56 dpc22 Exp $ */
/*  db: database wrapper, adapted (not quite verbatim) from the Cyrus IMAP
 *      server (lib/cyrusdb_db3) which has the following COPYRIGHT */

/*  cyrusdb_db3: berkeley db backend
 *
 * Copyright (c) 2000 Carnegie Mellon University.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The name "Carnegie Mellon University" must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission. For permission or any other legal
 *    details, please contact  
 *      Office of Technology Transfer
 *      Carnegie Mellon University
 *      5000 Forbes Avenue
 *      Pittsburgh, PA  15213-3890
 *      (412) 268-4387, fax: (412) 268-7395
 *      tech-transfer@andrew.cmu.edu
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Computing Services
 *     at Carnegie Mellon University (http://www.cmu.edu/computing/)."
 *
 * CARNEGIE MELLON UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO
 * THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL CARNEGIE MELLON UNIVERSITY BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <netdb.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <errno.h>
#include <syslog.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include "mydb.h"

struct mydb_backend *mydb_backends[] = {
    &mydb_db3,
    &mydb_db3_nosync,
    NULL };

/*
 * Keep calling the write() system call with 'fd', 'buf', and 'nbyte'
 * until all the data is written out or an error occurs.
 */
static int
retry_write(int fd, const char *buf, size_t nbyte)
{
  int n;
  int written = 0;

  if (nbyte == 0) return 0;

  for (;;) {
    n = write(fd, buf, nbyte);
    if (n == -1) {
      if (errno == EINTR) continue;
      return -1;
    }

    written += n;

    if (((size_t) n) >= nbyte) return written;

    buf += n;
    nbyte -= n;
  }
}

int mydb_copyfile(const char *srcname, const char *dstname)
{
    int srcfd, dstfd;
    struct stat sbuf;
    char *buf;
    int bufsize, n;

    if ((srcfd = open(srcname, O_RDONLY)) < 0) {
	syslog(LOG_DEBUG, "error opening %s for reading", srcname);
	return -1;
    }

    if (fstat(srcfd, &sbuf) < 0) {
	syslog(LOG_DEBUG, "error fstating %s", srcname);
	close(srcfd);
	return -1;
    }

    if ((dstfd = open(dstname, O_WRONLY | O_CREAT, sbuf.st_mode)) < 0) {
	syslog(LOG_DEBUG, "error opening %s for writing (%d)",
	       dstname, sbuf.st_mode);
	close(srcfd);
	return -1;
    }

    bufsize = sbuf.st_blksize;
    if ((buf = (char*) malloc(bufsize)) == NULL) {
	syslog(LOG_DEBUG, "error allocing buf (%d)", bufsize);
	close(srcfd);
	close(dstfd);
	return -1;
    }

    for (;;) {
	n = read(srcfd, buf, bufsize);

	if (n < 0) {
	    if (errno == EINTR)
		continue;

	    syslog(LOG_DEBUG, "error reading buf (%d)", bufsize);
	    close(srcfd);
	    close(dstfd);
	    unlink(dstname);
	    return -1;
	}

	if (n == 0)
	    break;

	if (retry_write(dstfd, buf, n) != n) {
	    syslog(LOG_DEBUG, "error writing buf (%d)", n);
	    close(srcfd);
	    close(dstfd);
	    unlink(dstname);
	    return -1;
	}
    }

    close(srcfd);
    close(dstfd);
    return 0;
}
