/****************************************************************************
** $Id: qsfuncref.h,v 1.1 2006/09/05 11:55:57 petrm1am Exp $
**
** Copyright (C) 2001-2006 Trolltech AS.  All rights reserved.
**
** This file is part of the Qt Script for Applications framework (QSA).
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding a valid Qt Script for Applications license may use
** this file in accordance with the Qt Script for Applications License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about QSA Commercial License Agreements.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
*****************************************************************************/

#ifndef QSFUNCREF_H
#define QSFUNCREF_H

#include "qsclass.h"

class QSFuncRefClass : public QSSharedClass {
public:
    QSFuncRefClass( QSClass *b ) : QSSharedClass( b, AttributeExecutable ) { }
    QString name() const { return QString::fromLatin1("Function"); }

    virtual QSEqualsResult isEqual( const QSObject &a, const QSObject &b ) const;

    bool toBoolean( const QSObject * ) const;
    double toNumber( const QSObject *obj ) const;
    QString toString( const QSObject * ) const;

    QSObject construct( const QSList &args ) const;
    QSObject cast( const QSList &args ) const;

    QSObject createReference( const QSObject &base, const QSMember &mem ) const;


    static QSMember refMember( const QSObject &ref );
    static ScopeChain refScope( const QSObject &ref );
    static QSObject refBase( const QSObject &ref );

protected:
    virtual QSObject invoke( QSObject * objPtr, const QSMember &mem ) const;
};

#endif
