/**
  * udpecho.c - simple fast udp sender without timeouts
  * Copyright (C) 2006  NETWAYS GmbH, Marius Hein
  * $Id: udpecho.c 1559 2007-03-07 14:01:11Z gmueller $
  *
  * This program is free software; you can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; either version 2
  * of the License, or (at your option) any later version.
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  * GNU General Public License for more details.
  *
  * You should have received a copy of the GNU General Public License
  * along with this program; if not, write to the Free Software
  * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
  *
  * ----> To compile: gcc -Wall udpecho.c -o udpecho <----
  *
  **/

/**
 *
 * CHANGELOG:
 *
 * 1.0
 * 	- INITIAL RELEASE
 *
 * 1.1
 * -	[netways #15679]: NagiosGrapher-1.6-rc1 udpecho.c: Send buffer too small for plugin output
 * 		Increased the buffersize to 512 for larger pluginoutput (Ed Voncken)
 *
 **/

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define DEF_PORT 5667
#define BUFFER_LENGTH 512

void die(char* msg);
void p_usage();

int main(int argc, char* argv[]) {

	int sockfd, n;
	int port=DEF_PORT;
	struct sockaddr_in server;
    
    char *dest = "127.0.0.1";
    char *pdest = dest;
    
	char buffer[BUFFER_LENGTH+1];
	char recv[BUFFER_LENGTH+1];
    
    memset(buffer,0,BUFFER_LENGTH);

	if (argc > 4) {
		p_usage();
	}

	sockfd = socket(AF_INET, SOCK_DGRAM, 0);
	if (sockfd <= 0) {
		die("Can't create socket!");
	}

    if(argc == 4) {
    	if (argv[3] && argv[3] > 0) {
    		port = atoi(argv[3]);
    	}
        strcpy(buffer, argv[2]);
        pdest=argv[1];
    } else {
        
        if(argc == 3) {
          port = atoi(argv[2]);
          pdest=argv[1];
        }
        snprintf(buffer,BUFFER_LENGTH,"%s\t%s\t%s\t%s",
          getenv("NAGIOS_HOSTNAME"),
          getenv("NAGIOS_SERVICEDESC"),
          getenv("NAGIOS_SERVICEOUTPUT"),
          getenv("NAGIOS_SERVICEPERFDATA"));
    }

	bzero(&server, sizeof(server));
	server.sin_family = AF_INET;
	server.sin_addr.s_addr = inet_addr(pdest);
	server.sin_port = htons(port);

	n = sendto(sockfd, buffer, strlen(buffer), 0, (struct sockaddr *)&server, sizeof(server));
	if (!n == strlen(buffer)) {
		die("Wrong size of bytes!");
	}

	/*
	 *
	 * If you want to see what the server is returning ... (maybe this needs to much time)
	 *
		n=0;
		n = recvfrom(sockfd, recv, 10000, 0, NULL, NULL);
		if (n>0) {
			recv[n] = 0;
			printf("%s: %s\n", argv[0], recv);
		}
	*/

	close (sockfd);

	bzero(buffer, BUFFER_LENGTH);
	bzero(recv, BUFFER_LENGTH);

	return (0);
}

void die(char* msg) {
	printf("ERROR: %s\n", msg);

	exit (-1);
}

void p_usage() {
	printf("Usage: udpecho [<ip> [port]]\n");

	exit (0);
}
