

#include <gtkmm.h>
#include "MGCanvas.h"
#include "myx_gc_figure.h"
#include "myx_gc_model.h"


CLayer *paperLayer;




void make_something(CGenericCanvas *canvas)
{
  CFigure *paper, *obj[5];
  
  paperLayer= canvas->CreateLayer("Paper", GC_LAYER_NORMAL, true);

  paper= canvas->CreateFigure("paper");
  paperLayer->CreateInstance(paper);
  paper->Scale(10,10,1,false);

  if ( canvas->AddStylesFromFile("./xml/layout.styles.db.xml") != GC_NO_ERROR)
    g_message("error loading styles");

  if ( canvas->AddLayoutsFromFile("./xml/layout.figures.db.xml") != GC_NO_ERROR)
    g_message("error loading layouts");

  
  obj[0]= canvas->CreateFigure("model1");
  obj[1]= canvas->CreateFigure("table");
  
  
  for (int i=0; i < 1; i++)
  {
    int o= rand()%6;
    
    obj[o]->Scale(20,20,1,false);
    obj[o]->Translate(10+rand()%500,10+rand()%500, 0, false);
    
    paperLayer->CreateInstance(obj[o]);
  }
}



int main(int argc, char **argv)
{
  Gtk::Main main(argc, argv);
  Gtk::Window win(Gtk::WINDOW_TOPLEVEL);
  MGCanvas canvas;
  
  win.add(canvas);
  
  canvas.show();

  win.show();
  
  make_something(canvas.canvas());

  main.run();
  
  return 0;
}
