-- MySQL dump 10.7
--
-- Host: localhost    Database: 
-- ------------------------------------------------------
-- Server version	4.1.3b-beta-nt

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE="NO_AUTO_VALUE_ON_ZERO" */;

--
-- Current Database: `mysql`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `mysql`;

USE `mysql`;

--
-- Table structure for table `columns_priv`
--

DROP TABLE IF EXISTS `columns_priv`;
CREATE TABLE `columns_priv` (
  `Host` char(60) character set latin1 collate latin1_bin NOT NULL default '',
  `Db` char(64) character set latin1 collate latin1_bin NOT NULL default '',
  `User` char(16) character set latin1 collate latin1_bin NOT NULL default '',
  `Table_name` char(64) character set latin1 collate latin1_bin NOT NULL default '',
  `Column_name` char(64) character set latin1 collate latin1_bin NOT NULL default '',
  `Timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `Column_priv` set('Select','Insert','Update','References') NOT NULL default '',
  PRIMARY KEY  (`Host`,`Db`,`User`,`Table_name`,`Column_name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Column privileges';

--
-- Dumping data for table `columns_priv`
--


/*!40000 ALTER TABLE `columns_priv` DISABLE KEYS */;
LOCK TABLES `columns_priv` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `columns_priv` ENABLE KEYS */;

--
-- Table structure for table `db`
--

DROP TABLE IF EXISTS `db`;
CREATE TABLE `db` (
  `Host` char(60) character set latin1 collate latin1_bin NOT NULL default '',
  `Db` char(64) character set latin1 collate latin1_bin NOT NULL default '',
  `User` char(16) character set latin1 collate latin1_bin NOT NULL default '',
  `Select_priv` enum('N','Y') NOT NULL default 'N',
  `Insert_priv` enum('N','Y') NOT NULL default 'N',
  `Update_priv` enum('N','Y') NOT NULL default 'N',
  `Delete_priv` enum('N','Y') NOT NULL default 'N',
  `Create_priv` enum('N','Y') NOT NULL default 'N',
  `Drop_priv` enum('N','Y') NOT NULL default 'N',
  `Grant_priv` enum('N','Y') NOT NULL default 'N',
  `References_priv` enum('N','Y') NOT NULL default 'N',
  `Index_priv` enum('N','Y') NOT NULL default 'N',
  `Alter_priv` enum('N','Y') NOT NULL default 'N',
  `Create_tmp_table_priv` enum('N','Y') NOT NULL default 'N',
  `Lock_tables_priv` enum('N','Y') NOT NULL default 'N',
  PRIMARY KEY  (`Host`,`Db`,`User`),
  KEY `User` (`User`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Database privileges';

--
-- Dumping data for table `db`
--


/*!40000 ALTER TABLE `db` DISABLE KEYS */;
LOCK TABLES `db` WRITE;
INSERT INTO `db` VALUES ('%','test','','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y'),('%','test\\_%','','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y');
UNLOCK TABLES;
/*!40000 ALTER TABLE `db` ENABLE KEYS */;

--
-- Table structure for table `func`
--

DROP TABLE IF EXISTS `func`;
CREATE TABLE `func` (
  `name` char(64) character set latin1 collate latin1_bin NOT NULL default '',
  `ret` tinyint(1) NOT NULL default '0',
  `dl` char(128) NOT NULL default '',
  `type` enum('function','aggregate') NOT NULL default 'function',
  PRIMARY KEY  (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='User defined functions';

--
-- Dumping data for table `func`
--


/*!40000 ALTER TABLE `func` DISABLE KEYS */;
LOCK TABLES `func` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `func` ENABLE KEYS */;

--
-- Table structure for table `help_category`
--

DROP TABLE IF EXISTS `help_category`;
CREATE TABLE `help_category` (
  `help_category_id` smallint(5) unsigned NOT NULL default '0',
  `name` varchar(64) NOT NULL default '',
  `parent_category_id` smallint(5) unsigned default NULL,
  `url` varchar(128) NOT NULL default '',
  PRIMARY KEY  (`help_category_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='help categories';

--
-- Dumping data for table `help_category`
--


/*!40000 ALTER TABLE `help_category` DISABLE KEYS */;
LOCK TABLES `help_category` WRITE;
INSERT INTO `help_category` VALUES (0,'Point properties',24,''),(1,'Column Types',12,''),(2,'Geometry constructors',24,''),(3,'Data Definition',12,''),(4,'Comparison operators',16,''),(5,'WKB',24,''),(6,'MBR',24,''),(7,'Polygon properties',24,''),(8,'Encryption Functions',16,''),(9,'GeometryCollection properties',24,''),(10,'Numeric Functions',16,''),(11,'String Functions',16,''),(12,'Contents',0,''),(13,'Geometry properties',24,''),(14,'Control flow functions',16,''),(15,'Date and Time Functions',16,''),(16,'Functions',12,''),(17,'WKT',24,''),(18,'Miscellaneous Functions',16,''),(19,'Administration',12,''),(20,'Information Functions',16,''),(21,'LineString properties',24,''),(22,'Functions and Modifiers for Use with GROUP BY Clauses',16,''),(23,'Transactions',12,''),(24,'Geographic features',12,''),(25,'Geometry relations',24,''),(26,'Data Manipulation',12,''),(27,'Logical operators',16,''),(28,'Bit Functions',16,'');
UNLOCK TABLES;
/*!40000 ALTER TABLE `help_category` ENABLE KEYS */;

--
-- Table structure for table `help_keyword`
--

DROP TABLE IF EXISTS `help_keyword`;
CREATE TABLE `help_keyword` (
  `help_keyword_id` int(10) unsigned NOT NULL default '0',
  `name` varchar(64) NOT NULL default '',
  PRIMARY KEY  (`help_keyword_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='help keywords';

--
-- Dumping data for table `help_keyword`
--


/*!40000 ALTER TABLE `help_keyword` DISABLE KEYS */;
LOCK TABLES `help_keyword` WRITE;
INSERT INTO `help_keyword` VALUES (0,'CEIL'),(1,'IN'),(2,'DISABLE'),(3,'MERGE'),(4,'STRIPED'),(5,'IS'),(6,'CHARACTER'),(7,'DATE_SUB'),(8,'REPLICATION'),(9,'REFERENCES'),(10,'UNCOMMITTED'),(11,'DESC'),(12,'INNOBASE'),(13,'LINES'),(14,'LEVEL'),(15,'SPATIAL'),(16,'LEADING'),(17,'OFFSET'),(18,'START'),(19,'INNER'),(20,'AGGREGATE'),(21,'SAVEPOINT'),(22,'MULTIPOINTFROMTEXT'),(23,'CHECK'),(24,'FAST'),(25,'BEGIN'),(26,'BINARY'),(27,'AFTER'),(28,'SQL_BIG_RESULT'),(29,'CHAR'),(30,'STATUS'),(31,'FROM'),(32,'MYISAM'),(33,'MASTER_SSL'),(34,'AUTOCOMMIT'),(35,'MAX_CONNECTIONS_PER_HOUR'),(36,'VARIABLE'),(37,'SQL_CALC_FOUND_ROWS'),(38,'INTEGER'),(39,'USE'),(40,'WARNINGS'),(41,'LOW_PRIORITY'),(42,'DES_KEY_FILE'),(43,'IGNORE'),(44,'COMMITTED'),(45,'LIMIT'),(46,'FILE'),(47,'<>'),(48,'PASSWORD'),(49,'EXISTS'),(50,'INDEX'),(51,'SHA1'),(52,'TEMPORARY'),(53,'SIGNED'),(54,'SHOW'),(55,'GLOBAL'),(56,'FIXED'),(57,'MULTILINESTRINGFROMTEXT'),(58,'MASTER'),(59,'CASCADE'),(60,'FORCE'),(61,'RELAY_LOG_FILE'),(62,'CHANGE'),(63,'KEYS'),(64,'COMMIT'),(65,'COMPRESSED'),(66,'ENCLOSED'),(67,'MASTER_PORT'),(68,'SQL_NO_CACHE'),(69,'DELAY_KEY_WRITE'),(70,'MASTER_HOST'),(71,'WITH'),(72,'HOUR_SECOND'),(73,'USAGE'),(74,'TABLE'),(75,'YEAR_MONTH'),(76,'GRANTS'),(77,'NO_WRITE_TO_BINLOG'),(78,'REGEXP'),(79,'USING'),(80,'UNLOCK'),(81,'WORK'),(82,'VALUES'),(83,'READ'),(84,'TINYTEXT'),(85,'FLOAT4'),(86,'BYTE'),(87,'FLOAT8'),(88,'SLAVE'),(89,'REAL'),(90,'INDEXES'),(91,'RAID_TYPE'),(92,'ASC'),(93,'NEXT'),(94,'ADD'),(95,'MODIFY'),(96,'FLOOR'),(97,'FULLTEXT'),(98,'X509'),(99,'PREV'),(100,'CIPHER'),(101,'SOUNDS'),(102,'CONVERT'),(103,'LOGS'),(104,'LEFT'),(105,'KEY'),(106,'BOTH'),(107,'SQL_SMALL_RESULT'),(108,'MOD'),(109,'RESET'),(110,'MASTER_SSL_CERT'),(111,'MEMORY'),(112,'PROCESSLIST'),(113,'FOREIGN'),(114,'REPLACE'),(115,'EXIST'),(116,'CACHE'),(117,'DROP'),(118,'SHUTDOWN'),(119,'AVG_ROW_LENGTH'),(120,'CONCURRENT'),(121,'DATA'),(122,'MASTER_SSL_KEY'),(123,'STARTING'),(124,'MULTIPOINTFROMWKB'),(125,'DISTINCTROW'),(126,'DATE'),(127,'LONGBINARY'),(128,'RETURNS'),(129,'REPEATABLE'),(130,'HIGH_PRIORITY'),(131,'RENAME'),(132,'GEOMETRYCOLLECTIONFROMWKB'),(133,'VARYING'),(134,'NO'),(135,'LIKE'),(136,'EVENTS'),(137,'NATURAL'),(138,'DATETIME'),(139,'LAST'),(140,'USER_RESOURCES'),(141,'ALTER'),(142,'ROW_FORMAT'),(143,'MASTER_LOG_FILE'),(144,'CREATE'),(145,'MIDDLEINT'),(146,'INTERVAL'),(147,'AES_ENCRYPT'),(148,'MAX'),(149,'GRANT'),(150,'HEAP'),(151,'ROLLBACK'),(152,'CHECKSUM'),(153,'MASTER_SSL_CIPHER'),(154,'ON'),(155,'ENGINES'),(156,'RAID_CHUNKS'),(157,'OR'),(158,'DATE_ADD'),(159,'SQL_SLAVE_SKIP_COUNTER'),(160,'BDB'),(161,'SHARE'),(162,'MULTIPOLYGONFROMTEXT'),(163,'MODE'),(164,'POLYGONFROMTEXT'),(165,'STOP'),(166,'PROCEDURE'),(167,'MRG_MYISAM'),(168,'FULL'),(169,'ORDER'),(170,'SEPARATOR'),(171,'SUPER'),(172,'INSERT_METHOD'),(173,'MINUTE'),(174,'OPEN'),(175,'NONE'),(176,'OPTION'),(177,'WRITE'),(178,'MASTER_CONNECT_RETRY'),(179,'RELOAD'),(180,'ISAM'),(181,'AS'),(182,'CLIENT'),(183,'GEOMETRYCOLLECTIONFROMTEXT'),(184,'NOT'),(185,'NULL'),(186,'SQL_CACHE'),(187,'MEDIUMTEXT'),(188,'DELETE'),(189,'LINESTRINGFROMTEXT.'),(190,'DECIMAL'),(191,'TIME'),(192,'ZEROFILL'),(193,'RESTRICT'),(194,'INSERT'),(195,'GROUP'),(196,'BY'),(197,'CLOSE'),(198,'COLUMN'),(199,'SQL_THREAD'),(200,'COUNT'),(201,'SESSION'),(202,'NCHAR'),(203,'DAY_MINUTE'),(204,'SERIAL'),(205,'SQL_LOG_BIN'),(206,'AGAINST'),(207,'FUNCTION'),(208,'FIELDS'),(209,'BOOLEAN'),(210,'LONGTEXT'),(211,'OPTIONALLY'),(212,'SERIALIZABLE'),(213,'UNIQUE'),(214,'INNODB'),(215,'PARTIAL'),(216,'MATCH'),(217,'MAX_UPDATES_PER_HOUR'),(218,'JOIN'),(219,'TYPES'),(220,'MAX_ROWS'),(221,'SONAME'),(222,'MULTIPOLYGONFROMWKB'),(223,'FLUSH'),(224,'ENGINE'),(225,'BTREE'),(226,'CSV'),(227,'BIGINT'),(228,'DAY'),(229,'UNSIGNED'),(230,'DISTINCT'),(231,'TRAILING'),(232,'SELECT'),(233,'HOUR'),(234,'IO_THREAD'),(235,'EXECUTE'),(236,'END'),(237,'DATABASES'),(238,'POLYGONFROMWKB'),(239,'DEFAULT'),(240,'BERKELEYDB'),(241,'RAID0'),(242,'FALSE'),(243,'MASTER_LOG_POS'),(244,'PACK_KEYS'),(245,'QUICK'),(246,'RIGHT'),(247,'OUTER'),(248,'TIMESTAMP'),(249,'MASTER_PASSWORD'),(250,'LONG'),(251,'IMPORT'),(252,'INT1'),(253,'INT2'),(254,'INT3'),(255,'RAID_CHUNKSIZE'),(256,'SSL'),(257,'INT4'),(258,'TABLES'),(259,'DAY_HOUR'),(260,'WHERE'),(261,'INT8'),(262,'RELAY_LOG_POS'),(263,'TO'),(264,'MIN_ROWS'),(265,'DELAYED'),(266,'BETWEEN'),(267,'HOSTS'),(268,'MASTER_SSL_CA'),(269,'PROCESS'),(270,'DATABASE'),(271,'STD'),(272,'ELSE'),(273,'ALL'),(274,'INTO'),(275,'HOUR_MINUTE'),(276,'BIT'),(277,'DUMPFILE'),(278,'CHANGED'),(279,'RTREE'),(280,'UPDATE'),(281,'SET'),(282,'TRUE'),(283,'DUPLICATE'),(284,'NATIONAL'),(285,'VARIABLES'),(286,'EXTENDED'),(287,'THEN'),(288,'TYPE'),(289,'LOAD'),(290,'GEOMETRYFROMWKB'),(291,'USE_FRM'),(292,'MAX_QUERIES_PER_HOUR'),(293,'SECOND'),(294,'ERRORS'),(295,'CONSTRAINT'),(296,'MEDIUM'),(297,'ENABLE'),(298,'MINUTE_SECOND'),(299,'VARCHARACTER'),(300,'ESCAPE'),(301,'DEC'),(302,'BACKUP'),(303,'COLUMNS'),(304,'AND'),(305,'CROSS'),(306,'LINESTRINGFROMWKB'),(307,'OUTFILE'),(308,'POW'),(309,'SECURITY'),(310,'MIN'),(311,'YEAR'),(312,'PRIVILEGES'),(313,'COMMENT'),(314,'TRANSACTION'),(315,'ESCAPED'),(316,'INFILE'),(317,'ACTION'),(318,'REQUIRE'),(319,'LOCAL'),(320,'FIRST'),(321,'TERMINATED'),(322,'QUERY'),(323,'MONTH'),(324,'IDENTIFIED'),(325,'DIRECTORY'),(326,'BINLOG'),(327,'BOOL'),(328,'DYNAMIC'),(329,'SQL_BUFFER_RESULT'),(330,'FOR'),(331,'STRING'),(332,'ISSUER'),(333,'PRECISION'),(334,'ISOLATION'),(335,'DAY_SECOND'),(336,'SUBJECT'),(337,'PRIMARY'),(338,'VALUE'),(339,'MASTER_USER'),(340,'REVOKE'),(341,'WHEN'),(342,'GEOMETRYFROMTEXT'),(343,'LOCK'),(344,'HAVING'),(345,'IF'),(346,'MULTILINESTRINGFROMWKB'),(347,'STRAIGHT_JOIN');
UNLOCK TABLES;
/*!40000 ALTER TABLE `help_keyword` ENABLE KEYS */;

--
-- Table structure for table `help_relation`
--

DROP TABLE IF EXISTS `help_relation`;
CREATE TABLE `help_relation` (
  `help_topic_id` int(10) unsigned NOT NULL default '0',
  `help_keyword_id` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`help_keyword_id`,`help_topic_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='keyword-topic relation';

--
-- Dumping data for table `help_relation`
--


/*!40000 ALTER TABLE `help_relation` DISABLE KEYS */;
LOCK TABLES `help_relation` WRITE;
INSERT INTO `help_relation` VALUES (102,0),(65,1),(256,1),(259,1),(266,2),(290,3),(290,4),(176,5),(27,6),(243,6),(326,6),(249,7),(164,8),(164,9),(290,9),(321,9),(363,10),(259,11),(352,11),(377,11),(290,12),(95,13),(363,14),(266,15),(278,15),(11,16),(259,17),(70,18),(123,18),(244,19),(233,20),(19,21),(186,22),(290,23),(21,24),(123,25),(27,26),(326,26),(338,26),(266,27),(259,28),(247,29),(338,29),(44,30),(62,30),(350,30),(11,31),(52,31),(62,31),(65,31),(212,31),(246,31),(259,31),(290,32),(39,33),(123,34),(164,35),(306,36),(259,37),(192,38),(233,38),(244,39),(62,40),(18,41),(95,41),(212,41),(303,41),(374,41),(375,41),(251,42),(18,43),(95,43),(244,43),(259,43),(266,43),(303,43),(363,44),(65,45),(80,45),(212,45),(259,45),(303,45),(164,46),(134,47),(164,48),(226,49),(257,49),(14,50),(62,50),(241,50),(244,50),(266,50),(278,50),(290,50),(369,51),(257,52),(338,53),(44,54),(65,54),(71,54),(204,54),(350,54),(286,55),(306,55),(363,55),(119,56),(290,56),(106,57),(39,58),(44,58),(52,58),(71,58),(115,58),(246,58),(257,59),(290,59),(321,59),(244,60),(39,61),(39,62),(266,62),(62,63),(266,63),(123,64),(290,65),(95,66),(39,67),(259,68),(290,69),(39,70),(164,71),(249,72),(164,73),(14,74),(21,74),(52,74),(62,74),(75,74),(257,74),(323,74),(354,74),(370,74),(249,75),(62,76),(251,77),(323,77),(354,77),(170,78),(212,79),(244,79),(375,80),(123,81),(374,82),(80,83),(363,83),(375,83),(13,84),(128,85),(247,86),(89,87),(47,88),(70,88),(204,88),(276,88),(350,88),(89,89),(233,89),(62,90),(290,91),(259,92),(377,92),(80,93),(14,94),(266,94),(266,95),(73,96),(266,97),(278,97),(290,97),(164,98),(80,99),(164,100),(351,101),(338,102),(62,103),(71,103),(244,104),(14,105),(18,105),(266,105),(290,105),(321,105),(11,106),(259,107),(35,108),(47,109),(115,109),(310,109),(39,110),(259,111),(62,112),(266,113),(290,113),(321,113),(95,114),(155,115),(310,116),(226,117),(233,117),(241,117),(257,117),(266,117),(164,118),(266,119),(290,119),(95,120),(95,121),(246,121),(290,121),(39,122),(95,123),(261,124),(259,125),(7,126),(136,126),(249,126),(338,126),(181,127),(233,128),(363,129),(259,130),(266,131),(86,132),(326,133),(290,134),(321,134),(62,135),(351,135),(65,136),(244,137),(338,138),(80,139),(251,140),(14,141),(164,141),(266,141),(290,142),(39,143),(14,144),(62,144),(155,144),(233,144),(278,144),(290,144),(314,145),(249,146),(210,147),(227,148),(164,149),(290,150),(19,151),(123,151),(290,152),(39,153),(244,154),(321,154),(62,155),(290,156),(196,157),(249,158),(286,159),(290,160),(259,161),(122,162),(256,163),(259,163),(359,164),(276,165),(259,166),(290,167),(62,168),(290,168),(212,169),(259,169),(266,169),(303,169),(377,169),(377,170),(164,171),(290,172),(249,173),(62,174),(80,174),(164,175),(164,176),(375,177),(39,178),(164,179),(290,180),(244,181),(259,181),(375,181),(164,182),(341,183),(32,184),(155,184),(176,185),(321,185),(259,186),(143,187),(290,188),(321,188),(340,189),(119,190),(169,191),(214,191),(338,191),(89,192),(119,192),(128,192),(192,192),(254,192),(285,192),(257,193),(321,193),(18,194),(165,194),(259,195),(95,196),(164,196),(212,196),(259,196),(266,196),(290,196),(303,196),(377,196),(80,197),(266,198),(70,199),(276,199),(228,200),(306,201),(363,201),(27,202),(249,203),(280,204),(290,204),(178,205),(256,206),(233,207),(62,208),(95,208),(256,209),(285,209),(181,210),(95,211),(363,212),(266,213),(62,214),(290,214),(290,215),(256,216),(164,217),(259,218),(62,219),(290,220),(233,221),(250,222),(310,223),(266,224),(290,224),(278,225),(95,226),(73,227),(249,228),(89,229),(119,229),(128,229),(192,229),(254,229),(285,229),(338,229),(228,230),(259,230),(377,230),(11,231),(205,232),(374,232),(249,233),(70,234),(276,234),(164,235),(327,236),(62,237),(85,238),(18,239),(266,239),(280,239),(290,239),(290,240),(290,241),(197,242),(39,243),(290,244),(21,245),(212,245),(323,245),(244,246),(244,247),(232,248),(269,248),(39,249),(181,250),(95,251),(285,252),(82,253),(314,254),(290,255),(164,256),(192,257),(62,258),(375,258),(249,259),(80,260),(212,260),(303,260),(254,261),(39,262),(19,263),(39,263),(290,264),(18,265),(165,265),(374,265),(193,266),(62,267),(204,267),(39,268),(164,269),(155,270),(226,270),(25,271),(327,272),(147,273),(164,273),(259,273),(18,274),(259,274),(374,274),(249,275),(285,276),(259,277),(21,278),(278,279),(18,280),(259,280),(321,280),(123,281),(178,281),(243,281),(266,281),(286,281),(303,281),(321,281),(374,281),(197,282),(18,283),(27,284),(326,284),(62,285),(21,286),(323,286),(327,287),(266,288),(290,288),(52,289),(95,289),(246,289),(153,290),(323,291),(164,292),(249,293),(62,294),(266,295),(290,295),(21,296),(266,297),(249,298),(326,299),(142,300),(119,301),(75,302),(62,303),(193,304),(236,304),(244,305),(234,306),(259,307),(239,308),(164,309),(227,310),(249,311),(164,312),(290,313),(123,314),(363,314),(95,315),(95,316),(290,317),(321,317),(164,318),(95,319),(251,319),(323,319),(354,319),(375,319),(80,320),(266,320),(290,320),(95,321),(310,322),(249,323),(164,324),(290,325),(65,326),(285,327),(290,328),(259,329),(62,330),(259,330),(233,331),(164,332),(89,333),(363,334),(249,335),(164,336),(266,337),(280,338),(39,339),(164,340),(327,341),(131,342),(259,343),(375,343),(259,344),(155,345),(226,345),(257,345),(10,346),(244,347),(259,347);
UNLOCK TABLES;
/*!40000 ALTER TABLE `help_relation` ENABLE KEYS */;

--
-- Table structure for table `help_topic`
--

DROP TABLE IF EXISTS `help_topic`;
CREATE TABLE `help_topic` (
  `help_topic_id` int(10) unsigned NOT NULL default '0',
  `name` varchar(64) NOT NULL default '',
  `help_category_id` smallint(5) unsigned NOT NULL default '0',
  `description` text NOT NULL,
  `example` text NOT NULL,
  `url` varchar(128) NOT NULL default '',
  PRIMARY KEY  (`help_topic_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='help topics';

--
-- Dumping data for table `help_topic`
--


/*!40000 ALTER TABLE `help_topic` DISABLE KEYS */;
LOCK TABLES `help_topic` WRITE;
INSERT INTO `help_topic` VALUES (0,'ASCII',11,'   ASCII(str)\nReturns the numeric value of the leftmost character of the string\nstr. Returns 0 if str is the empty string.  Returns\nNULL if str is NULL.\nASCII() works for characters with numeric values from 0 to\n255.\n','mysql> SELECT ASCII(\'2\');\n        -> 50\nmysql> SELECT ASCII(2);\n        -> 50\nmysql> SELECT ASCII(\'dx\');\n        -> 100',''),(1,'LOAD_FILE',11,'   LOAD_FILE(file_name)\nReads the file and returns the file contents as a string.  The file\nmust be located on the server, you must specify the full pathname to the\nfile, and you must have the FILE privilege.  The file must\nbe readable by all and be smaller than max_allowed_packet bytes.\n\nIf the file doesn\'t exist or cannot be read because one of the preceding\nconditions is not satisfied, the function returns NULL.\n','mysql> UPDATE tbl_name\n           SET blob_column=LOAD_FILE(\'/tmp/picture\')\n           WHERE id=1;',''),(2,'OCTETLENGTH',11,'   OCTET_LENGTH(str)\n\nOCTET_LENGTH() is a synonym for LENGTH().\n','',''),(3,'INSTR',11,'   INSTR(str,substr)\nReturns the position of the first occurrence of substring substr in\nstring str. This is the same as the two-argument form of\nLOCATE(), except that the arguments are swapped.\n','mysql> SELECT INSTR(\'foobarbar\', \'bar\');\n        -> 4\nmysql> SELECT INSTR(\'xbar\', \'foobar\');\n        -> 0',''),(4,'IN',4,'   expr IN (value,...)\nReturns 1 if expr is any of the values in the IN list,\nelse returns 0.  If all values are constants, they are\nevaluated according to the type of expr and sorted. The search for the\nitem then is done using a binary search. This means IN is very quick\nif the IN value list consists entirely of constants.  If expr\nis a case-sensitive string expression, the string comparison is performed in\ncase-sensitive fashion.\n','mysql> SELECT 2 IN (0,3,5,\'wefwf\');\n        -> 0\nmysql> SELECT \'wefwf\' IN (0,3,5,\'wefwf\');\n        -> 1',''),(5,'CURRENT_TIME',15,'   CURRENT_TIME\n   CURRENT_TIME()\n\nCURRENT_TIME and CURRENT_TIME() are synonyms for\nCURTIME().\n','',''),(6,'MBRCONTAINS',6,'   MBRContains(g1,g2)\nReturns 1 or 0 to indicate whether or not the Minimum Bounding Rectangle of\ng1 contains the Minimum Bounding Rectangle of g2.\n','mysql> SET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nmysql> SET @g2 = GeomFromText(\'Point(1 1)\');\nmysql> SELECT MBRContains(@g1,@g2), MBRContains(@g2,@g1);\n----------------------+----------------------+\n| MBRContains(@g1,@g2) | MBRContains(@g2,@g1) |\n+----------------------+----------------------+\n|                    1 |                    0 |\n+----------------------+----------------------+',''),(7,'DATE FUNCTION',15,'   DATE(expr)\n\nExtracts the date part of the date or datetime expression expr.\n','mysql> SELECT DATE(\'2003-12-31 01:02:03\');\n        -> \'2003-12-31\'',''),(8,'MERGE',19,'\n@menu\n* MERGE table problems::        MERGE Table Problems\n@end menu\n\nThe MERGE storage engine was introduced in MySQL 3.23.25. It\nis also known as the MRG_MyISAM engine. The code is now reasonably\nstable.\n\nA MERGE table is a collection of identical MyISAM tables that\ncan be used as one.  ``Identical\'\' means that all tables have\nidentical column and index information.  You can\'t merge tables in which the\ncolumns are packed differently, don\'t have exactly the same columns, or\nhave the indexes in different order.  However, any or all of the tables can be\ncompressed with myisampack.\nSee also : [myisampack, , myisampack].\n','mysql> CREATE TABLE t1 (\n    ->    a INT NOT NULL AUTO_INCREMENT PRIMARY KEY,\n    ->    message CHAR(20));\nmysql> CREATE TABLE t2 (\n    ->    a INT NOT NULL AUTO_INCREMENT PRIMARY KEY,\n    ->    message CHAR(20));\nmysql> INSERT INTO t1 (message) VALUES (\'Testing\'),(\'table\'),(\'t1\');\nmysql> INSERT INTO t2 (message) VALUES (\'Testing\'),(\'table\'),(\'t2\');\nmysql> CREATE TABLE total (\n    ->    a INT NOT NULL AUTO_INCREMENT,\n    ->    message CHAR(20), INDEX(a))\n    ->    TYPE=MERGE UNION=(t1,t2) INSERT_METHOD=LAST;',''),(9,'WITHIN',25,'   Within(g1,g2)\nReturns 1 or 0 to indicate whether or not g1 is spatially within\ng2.\n','',''),(10,'MLINEFROMWKB',5,'   MLineFromWKB(wkb[,srid])\n   MultiLineStringFromWKB(wkb[,srid])\nConstructs a MULTILINESTRING value using its WKB representation and SRID.\n','',''),(11,'TRIM',11,'   TRIM([[BOTH | LEADING | TRAILING] [remstr] FROM] str)\nReturns the string str with all remstr prefixes and/or suffixes\nremoved. If none of the specifiers BOTH, LEADING, or\nTRAILING is given, BOTH is assumed. If remstr is not\nspecified, spaces are removed.\n','mysql> SELECT TRIM(\'  bar   \');\n        -> \'bar\'\nmysql> SELECT TRIM(LEADING \'x\' FROM \'xxxbarxxx\');\n        -> \'barxxx\'\nmysql> SELECT TRIM(BOTH \'x\' FROM \'xxxbarxxx\');\n        -> \'bar\'\nmysql> SELECT TRIM(TRAILING \'xyz\' FROM \'barxxyz\');\n        -> \'barx\'',''),(12,'LPAD',11,'   LPAD(str,len,padstr)\nReturns the string str, left-padded with the string padstr\nto a length of len characters. If str is longer\nthan len, the return value is shortened to len characters.\n','mysql> SELECT LPAD(\'hi\',4,\'??\');\n        -> \'??hi\'\nmysql> SELECT LPAD(\'hi\',1,\'??\');\n        -> \'h\'',''),(13,'TINYBLOB',1,'   TINYBLOB\n   TINYTEXT\n\nA BLOB or TEXT column with a maximum length of 255 (2^8\n@minus{} 1)\ncharacters.\n','',''),(14,'SPATIAL',24,'MySQL can create spatial indexes using syntax similar to that for creating\nregular indexes, but extended with the SPATIAL keyword.\nSpatial columns that are indexed currently must be declared NOT NULL.\nThe following examples demonstrate how to create spatial indexes.\n\n\n   With CREATE TABLE:\n\nmysql> CREATE TABLE geom (g GEOMETRY NOT NULL, SPATIAL INDEX(g));\n\n   With ALTER TABLE:\n\nmysql> ALTER TABLE geom ADD SPATIAL INDEX(g);\n\n   With CREATE INDEX:\n\nmysql> CREATE SPATIAL INDEX sp_index ON geom (g);\n\n\nTo drop spatial indexes, use ALTER TABLE or DROP INDEX:\n\n\n   With ALTER TABLE:\n\nmysql> ALTER TABLE geom DROP INDEX g;\n\n   With DROP INDEX:\n\nmysql> DROP INDEX sp_index ON geom;\n\n\nExample: Suppose that a table geom contains more than 32,000 geometries,\nwhich are stored in the column g of type GEOMETRY.\nThe table also has an AUTO_INCREMENT column fid for storing\nobject ID values.\n','',''),(15,'KILL',26,'Each connection to mysqld runs in a separate thread.  You can see\nwhich threads are running with the SHOW PROCESSLIST statement and kill\na thread with the KILL thread_id statement.\n\nAs of MySQL 5.0.0, KILL allows the optional CONNECTION or\nQUERY modifiers:\n\n\n --- KILL CONNECTION is the same as KILL with no modifier:\nIt terminates the connection associated with the given thread_id.\n\n --- KILL QUERY terminates the statement that the connection currently\nis executing, but leaves the connection intact.\n\n\nIf you have the PROCESS privilege, you can see all threads.\nIf you have the SUPER privilege, you can kill all threads and\nstatements.  Otherwise, you can see and kill only your own threads and\nstatements.\n\nYou can also use the mysqladmin processlist and mysqladmin kill\ncommands to examine and kill threads.\n\nNote: You currently cannot use KILL with the Embedded MySQL\nServer library, because the embedded server merely runs inside the threads\nof the host application, it does not create connection threads of its own.\n','KILL [CONNECTION | QUERY] thread_id',''),(16,'BIT_LENGTH',11,'   BIT_LENGTH(str)\nReturns the length of the string str in bits.\n','mysql> SELECT BIT_LENGTH(\'text\');\n        -> 32',''),(17,'GEOMETRY',24,'MySQL provides a standard way of creating spatial columns for\ngeometry types, for example, with CREATE TABLE or ALTER TABLE.\nCurrently, spatial columns are supported only for MyISAM tables.\n','mysql> CREATE TABLE geom (g GEOMETRY);\nQuery OK, 0 rows affected (0.02 sec)',''),(18,'INSERT INTO',26,'INSERT inserts new rows into an existing table.  The INSERT ...\nVALUES and INSERT ... SET forms of the statement insert rows based\non explicitly specified values.  The INSERT ... SELECT form inserts\nrows selected from another table or tables.  The INSERT ... VALUES\nform with multiple value lists is supported in MySQL 3.22.5 or\nlater.  The INSERT ... SET syntax is supported in MySQL\n3.22.10 or later.\nINSERT ... SELECT is discussed further in\nSee also : [INSERT SELECT,  , INSERT SELECT].\n','INSERT [LOW_PRIORITY | DELAYED] [IGNORE]\n    [INTO] tbl_name [(col_name,...)]\n    VALUES ({expr | DEFAULT},...),(...),...\n    [ ON DUPLICATE KEY UPDATE col_name=expr, ... ]',''),(19,'SAVEPOINT',23,'SAVEPOINT identifier\nROLLBACK TO SAVEPOINT identifier\n\nStarting from MySQL 4.0.14 and 4.1.1, InnoDB supports the SQL statements\nSAVEPOINT and ROLLBACK TO SAVEPOINT.\n','',''),(20,'PURGE',26,'','PURGE MASTER LOGS TO \'mysql-bin.010\';\nPURGE MASTER LOGS BEFORE \'2003-04-02 22:46:26\';',''),(21,'CHECK',19,'CHECK TABLE works only on MyISAM and InnoDB tables. On\nMyISAM tables, This is the same thing as running myisamchk\n--medium-check tbl_name on the table.\n\nIf you don\'t specify any option, MEDIUM is used.\n','CHECK TABLE tbl_name [, tbl_name] ... [option] ...\n\noption = {QUICK | FAST | MEDIUM | EXTENDED | CHANGED}',''),(22,'WEEKDAY',15,'   WEEKDAY(date)\nReturns the weekday index for\ndate (0 = Monday, 1 = Tuesday, ... 6 = Sunday).\n','mysql> SELECT WEEKDAY(\'1998-02-03 22:23:00\');\n        -> 1\nmysql> SELECT WEEKDAY(\'1997-11-05\');\n        -> 2',''),(23,'MBREQUAL',6,'   MBREqual(g1,g2)\nReturns 1 or 0 to indicate whether or not the Minimum Bounding Rectangles of\nthe two geometries g1 and g2 are the same.\n','',''),(24,'BINARY',27,'   BINARY\nThe BINARY operator casts the string following it to a binary string.\nThis is an easy way to force a column comparison to be case sensitive even\nif the column isn\'t defined as BINARY or BLOB.\n','mysql> SELECT \'a\' = \'A\';\n        -> 1\nmysql> SELECT BINARY \'a\' = \'A\';\n        -> 0',''),(25,'STDDEV',22,'   STD(expr)\n   STDDEV(expr)\nReturns the standard deviation of expr (the square root of\nVARIANCE()). This is an extension to standard SQL. The STDDEV()\nform of this function is provided for Oracle compatibility.\n','',''),(26,'SIN',10,'   SIN(X)\nReturns the sine of X, where X is given in radians.\n','mysql> SELECT SIN(PI());\n        -> 0.000000',''),(27,'CHAR',1,'   [NATIONAL] CHAR(M) [BINARY | ASCII | UNICODE]\n\nA fixed-length string that is always right-padded with spaces to the\nspecified length when stored.  M represents the column length.  The\nrange of M is 0 to 255 characters (1 to 255 prior to MySQL 3.23).\n\nNote: Trailing spaces are removed when CHAR values are\nretrieved.\n\nFrom MySQL 4.1.0, a CHAR column with a length specification greater\nthan 255 is converted to the smallest TEXT type that can hold values\nof the given length.  For example, CHAR(500) is converted to\nTEXT, and CHAR(200000) is converted to MEDIUMTEXT.\nThis is a compatibility feature.  However, this conversion causes the\ncolumn to become a variable-length column, and also affects trailing-space\nremoval.\n\nCHAR is shorthand for CHARACTER.\nNATIONAL CHAR (or its equivalent short form, NCHAR) is the\nstandard SQL way to define that a CHAR column should use the default\ncharacter set.  This is the default in MySQL.\n\nThe BINARY attribute causes sorting and comparisons to be\ncase sensitive.\n\nFrom MySQL 4.1.0 on, the ASCII attribute can be specified. It\nassigns the latin1 character set to a CHAR column.\n\nFrom MySQL 4.1.1 on, the UNICODE attribute can be specified. It\nassigns the ucs2 character set to a CHAR column.\n\nMySQL allows you to create a column of type CHAR(0). This is mainly\nuseful when you have to be compliant with some old applications that depend\non the existence of a column but that do not actually use the value.  This\nis also quite nice when you need a column that can take only two values: A\nCHAR(0) column that is not defined as NOT NULL occupies only\none bit and can take only the values NULL and \'\' (the empty\nstring).\n\n   CHAR\nThis is a synonym for CHAR(1).\n','',''),(28,'SQRT',10,'   SQRT(X)\nReturns the non-negative square root of X.\n','mysql> SELECT SQRT(4);\n        -> 2.000000\nmysql> SELECT SQRT(20);\n        -> 4.472136',''),(29,'ROUND',10,'   ROUND(X)\n   ROUND(X,D)\nReturns the argument X, rounded to the nearest integer.\nWith two arguments, returns X rounded to D decimals.\nIf D is negative, the integer part of the number is zeroed out.\n','mysql> SELECT ROUND(-1.23);\n        -> -1\nmysql> SELECT ROUND(-1.58);\n        -> -2\nmysql> SELECT ROUND(1.58);\n        -> 2\nmysql> SELECT ROUND(1.298, 1);\n        -> 1.3\nmysql> SELECT ROUND(1.298, 0);\n        -> 1\nmysql> SELECT ROUND(23.298, -1);\n        -> 20',''),(30,'CONCAT',11,'   CONCAT(str1,str2,...)\nReturns the string that results from concatenating the arguments.  Returns\nNULL if any argument is NULL.  May have one or more arguments.\nA numeric argument is converted to its equivalent string form.\n','mysql> SELECT CONCAT(\'My\', \'S\', \'QL\');\n        -> \'MySQL\'\nmysql> SELECT CONCAT(\'My\', NULL, \'QL\');\n        -> NULL\nmysql> SELECT CONCAT(14.3);\n        -> \'14.3\'',''),(31,'CURRENT_TIMESTAMP',15,'   CURRENT_TIMESTAMP\n   CURRENT_TIMESTAMP()\n\nCURRENT_TIMESTAMP and CURRENT_TIMESTAMP() are synonyms for\nNOW().\n','',''),(32,'!',27,'   NOT\n   !\nLogical NOT.\nEvaluates to 1 if the operand is 0,\nto 0 if the operand is non-zero,\nand NOT NULL returns NULL.\n','mysql> SELECT NOT 10;\n        -> 0\nmysql> SELECT NOT 0;\n        -> 1\nmysql> SELECT NOT NULL;\n        -> NULL\nmysql> SELECT ! (1+1);\n        -> 0\nmysql> SELECT ! 1+1;\n        -> 1',''),(33,'GREATEST',4,'   GREATEST(value1,value2,...)\nWith two or more arguments, returns the largest (maximum-valued) argument.\nThe arguments are compared using the same rules as for LEAST().\n','mysql> SELECT GREATEST(2,0);\n        -> 2\nmysql> SELECT GREATEST(34.0,3.0,5.0,767.0);\n        -> 767.0\nmysql> SELECT GREATEST(\'B\',\'A\',\'C\');\n        -> \'C\'',''),(34,'LOWER',11,'   LOWER(str)\nReturns the string str with all characters changed to lowercase\naccording to the current character set mapping (the default is ISO-8859-1\nLatin1).\n','mysql> SELECT LOWER(\'QUADRATICALLY\');\n        -> \'quadratically\'',''),(35,'%',10,'   MOD(N,M)\n   N % M\n   N MOD M\nModulo (like the % operator in C).\nReturns the remainder of N divided by M.\n','mysql> SELECT MOD(234, 10);\n        -> 4\nmysql> SELECT 253 % 7;\n        -> 1\nmysql> SELECT MOD(29,9);\n        -> 2\nmysql> SELECT 29 MOD 9;\n        -> 2',''),(36,'&',28,'   &\nBitwise AND:\n','mysql> SELECT 29 & 15;\n        -> 13',''),(37,'DAYNAME',15,'   DAYNAME(date)\nReturns the name of the weekday for date.\n','mysql> SELECT DAYNAME(\'1998-02-05\');\n        -> \'Thursday\'',''),(38,'- UNARY',10,'   -\nUnary minus. Changes the sign of the argument.\n','mysql> SELECT - 2;\n        -> -2',''),(39,'CHANGE MASTER TO',26,'\nCHANGE MASTER TO master_def [, master_def] ...\n\nmaster_def:\n      MASTER_HOST = \'host_name\'\n    | MASTER_USER = \'user_name\'\n    | MASTER_PASSWORD = \'password\'\n    | MASTER_PORT = port_num\n    | MASTER_CONNECT_RETRY = count\n    | MASTER_LOG_FILE = \'master_log_name\'\n    | MASTER_LOG_POS = master_log_pos\n    | RELAY_LOG_FILE = \'relay_log_name\'\n    | RELAY_LOG_POS = relay_log_pos\n    | MASTER_SSL = {0|1}\n    | MASTER_SSL_CA = \'ca_file_name\'\n    | MASTER_SSL_CAPATH = \'ca_directory_name\'\n    | MASTER_SSL_CERT = \'cert_file_name\'\n    | MASTER_SSL_KEY = \'key_file_name\'\n    | MASTER_SSL_CIPHER = \'cipher_list\'\n\nChanges the parameters that the slave server uses for connecting to and\ncommunicating with the master server.\n\nMASTER_USER, MASTER_PASSWORD, MASTER_SSL,\nMASTER_SSL_CA, MASTER_SSL_CAPATH, MASTER_SSL_CERT,\nMASTER_SSL_KEY, and MASTER_SSL_CIPHER provide information for\nthe slave about how to connect to its master.\n\nThe relay log options (RELAY_LOG_FILE and RELAY_LOG_POS) are\navailable beginning with MySQL 4.0.\n\nThe SSL options\n(MASTER_SSL,\nMASTER_SSL_CA,\nMASTER_SSL_CAPATH,\nMASTER_SSL_CERT,\nMASTER_SSL_KEY,\nand\nMASTER_SSL_CIPHER)\nare available beginning with MySQL 4.1.1.\nYou can change these options even on slaves that are compiled without SSL\nsupport. They are saved to the *master.info file, but is ignored\nuntil you use a server that has SSL support enabled.\n\nIf you don\'t specify a given parameter, it keeps its old\nvalue, except as indicated in the following discussion. For example, if the password to connect to your MySQL master has\nchanged, you just need to issue these statements\nto tell the slave about the new password:\n\nmysql> STOP SLAVE; -- if replication was running\nmysql> CHANGE MASTER TO MASTER_PASSWORD=\'new3cret\';\nmysql> START SLAVE; -- if you want to restart replication\n\nThere is no need to specify the parameters that do\nnot change (host, port, user, and so forth).\n\nMASTER_HOST and MASTER_PORT are the hostname (or IP address) of\nthe master host and its TCP/IP port. Note that if MASTER_HOST is\nequal to localhost, then, like in other parts of MySQL, the port\nmay be ignored (if Unix socket files can be used, for example).\n\nIf you specify MASTER_HOST or MASTER_PORT,\nthe slave assumes that the master server is different than\nbefore (even if you specify a host or port value that is\nthe same as the current value.) In this case, the old values for the master\nbinary log name and position are considered no longer applicable, so if you\ndo not specify MASTER_LOG_FILE and MASTER_LOG_POS in the\nstatement, MASTER_LOG_FILE=\'\' and MASTER_LOG_POS=4 are\nsilently appended to it. \n\nMASTER_LOG_FILE and MASTER_LOG_POS are the coordinates\nat which the slave I/O thread should begin reading from the master the\nnext time the thread starts.\nIf you specify either of them, you can\'t specify RELAY_LOG_FILE or\nRELAY_LOG_POS.\nIf neither of MASTER_LOG_FILE or MASTER_LOG_POS are\nspecified, the slave uses the last coordinates of the /slave SQL thread/\nbefore CHANGE MASTER was issued. This ensures that\nreplication has no discontinuity, even if the slave SQL thread was late\ncompared to the slave I/O thread, when you just want to change, say, the\npassword to use. This safe behavior was introduced starting from MySQL\n4.0.17 and 4.1.1. (Before these versions, the coordinates used were \nthe last coordinates of the slave I/O thread before CHANGE MASTER\nwas issued. This caused the SQL thread to possibly lose some events\nfrom the master, thus breaking replication.)\n\nCHANGE MASTER /deletes all relay log files/ and starts\na new one, unless you specify RELAY_LOG_FILE or\nRELAY_LOG_POS. In that case, relay logs are kept;\nas of MySQL 4.1.1 the relay_log_purge global variable\nis set silently to 0.\n\nCHANGE MASTER TO updates the contents of the *master.info and\n*relay-log.info files.\n\nCHANGE MASTER is useful for setting up a slave when you have\nthe snapshot of the master and have recorded the log and the offset\ncorresponding to it.  After loading the snapshot into the slave, you\ncan run CHANGE MASTER TO MASTER_LOG_FILE=\'log_name_on_master\',\nMASTER_LOG_POS=log_offset_on_master on the slave.\n\nExamples:\n\nmysql> CHANGE MASTER TO\n    ->     MASTER_HOST=\'master2.mycompany.com\',\n    ->     MASTER_USER=\'replication\',\n    ->     MASTER_PASSWORD=\'bigs3cret\',\n    ->     MASTER_PORT=3306,\n    ->     MASTER_LOG_FILE=\'master2-bin.001\',\n    ->     MASTER_LOG_POS=4,\n    ->     MASTER_CONNECT_RETRY=10;\n\nmysql> CHANGE MASTER TO\n    ->     RELAY_LOG_FILE=\'slave-relay-bin.006\',\n    ->     RELAY_LOG_POS=4025;\n','',''),(40,'*',10,'   *\nMultiplication:\n','mysql> SELECT 3*5;\n        -> 15\nmysql> SELECT 18014398509481984*18014398509481984.0;\n        -> 324518553658426726783156020576256.0\nmysql> SELECT 18014398509481984*18014398509481984;\n        -> 0',''),(41,'RTRIM',11,'   RTRIM(str)\nReturns the string str with trailing space characters removed.\n','mysql> SELECT RTRIM(\'barbar   \');\n        -> \'barbar\'',''),(42,'+',10,'   +\nAddition:\n','mysql> SELECT 3+5;\n        -> 8',''),(43,'COALESCE',4,'   COALESCE(value,...)\nReturns the first non-NULL value in the list.\n','mysql> SELECT COALESCE(NULL,1);\n        -> 1\nmysql> SELECT COALESCE(NULL,NULL,NULL);\n        -> NULL',''),(44,'SHOW MASTER STATUS',26,'SHOW MASTER STATUS\n\nProvides status information on the binary log files of the master.\n','',''),(45,'LOG',10,'   LOG(X)\n   LOG(B,X)\nIf called with one parameter, this function returns the natural logarithm\nof X.\n','mysql> SELECT LOG(2);\n        -> 0.693147\nmysql> SELECT LOG(-2);\n        -> NULL',''),(46,'/',10,'   /\nDivision:\n','mysql> SELECT 3/5;\n        -> 0.60',''),(47,'RESET SLAVE',19,'RESET SLAVE\n\nMakes the slave forget its replication position in the master\'s binary logs.\nThis statement is meant to be used for a clean start: It deletes the\n*master.info and *relay-log.info files, all the relay logs,\nand starts a new relay log.\n\nNote: All relay logs are deleted, even if they have not been\ntotally executed by the slave SQL thread.  (This is a condition likely to\nexist on a replication slave if you have issued a STOP SLAVE\nstatement or if the slave is highly loaded.)\n\nConnection information stored in the *master.info file is immediately\nreset using any values specified in the corresponding startup options.\nThis information includes values such as master host, master port, master\nuser, and master password.  If the slave SQL thread was in the middle of\nreplicating temporary tables when it was stopped, and RESET SLAVE\nis issued, these replicated temporary tables are deleted on the slave.\n\nThis statement was named FLUSH SLAVE before MySQL 3.23.26.\n','',''),(48,'INTERSECTS',25,'   Intersects(g1,g2)\nReturns 1 or 0 to indicate whether or not g1 spatially intersects\ng2.\n','',''),(49,'<<',28,'   <<\nShifts a longlong (BIGINT) number to the left.\n','mysql> SELECT 1 << 2;\n        -> 4',''),(50,'REPEAT',11,'   REPEAT(str,count)\nReturns a string consisting of the string str repeated count\ntimes. If count <= 0, returns an empty string. Returns NULL if\nstr or count are NULL.\n','mysql> SELECT REPEAT(\'MySQL\', 3);\n        -> \'MySQLMySQLMySQL\'',''),(51,'<=',4,'   <=\nLess than or equal:\n','mysql> SELECT 0.1 <= 2;\n        -> 1',''),(52,'LOAD TABLE FROM MASTER',26,'LOAD TABLE tbl_name FROM MASTER\n\nTransfers a copy of the table from master to the slave. This statement is\nimplemented mainly for debugging of LOAD DATA FROM MASTER.\nIt requires that the account used for connecting to the master server has the\nRELOAD and SUPER privileges on the master and the\nSELECT privilege on the master table to load.\nOn the slave side, the user that issues LOAD TABLE FROM MASTER should\nhave privileges to drop and create the table.\n\nThe conditions for LOAD DATA FROM MASTER apply here, too. For\nexample, LOAD TABLE FROM MASTER works only for MyISAM tables.\nThe timeout notes for LOAD DATA FROM MASTER apply as well.\n','',''),(53,'TIME_FORMAT',15,'   TIME_FORMAT(time,format)\nThis is used like the DATE_FORMAT() function, but the\nformat string may contain only those format specifiers that handle\nhours, minutes, and seconds.  Other specifiers produce a NULL value or\n0.\n','',''),(54,'CHAR_LENGTH',11,'   CHAR_LENGTH(str)\n\nReturns the length of the string str, measured in characters.\nA multi-byte character counts as a single character.\nThis means that for a string containing five two-byte characters,\nLENGTH() returns 10, whereas CHAR_LENGTH() returns\n5.\n','',''),(55,'PASSWORD',8,'','mysql> SELECT PASSWORD(\'badpwd\');\n        -> \'7f84554057dd964b\'',''),(56,'<',4,'   <\nLess than:\n','mysql> SELECT 2 < 2;\n        -> 0',''),(57,'=',4,'   =\nEqual:\n','mysql> SELECT 1 = 0;\n        -> 0\nmysql> SELECT \'0\' = 0;\n        -> 1\nmysql> SELECT \'0.0\' = 0;\n        -> 1\nmysql> SELECT \'0.01\' = 0;\n        -> 0\nmysql> SELECT \'.01\' = 0.01;\n        -> 1',''),(58,'>',4,'   >\nGreater than:\n','mysql> SELECT 2 > 2;\n        -> 0',''),(59,'ISEMPTY',13,'   IsEmpty(g)\nReturns 1 if the geometry value g is the empty geometry, 0 if it is not\nempty, and @minus{}1 if the argument is NULL.\nIf the geometry is empty, it represents the empty point set.\n','',''),(60,'ABS',10,'   ABS(X)\nReturns the absolute value of X.\n','mysql> SELECT ABS(2);\n        -> 2\nmysql> SELECT ABS(-32);\n        -> 32',''),(61,'LCASE',11,'   LCASE(str)\n\nLCASE() is a synonym for LOWER().\n','',''),(62,'SHOW',19,'\nSET allows you to set variables and options.\n\nSHOW has many forms that provide information about databases,\ntables, columns, or status information about the server.\nThis section describes those following:\n\nSHOW [FULL] COLUMNS FROM tbl_name [FROM db_name] [LIKE \'pattern\']\nSHOW CREATE DATABASE db_name\nSHOW CREATE TABLE tbl_name\nSHOW DATABASES [LIKE \'pattern\']\nSHOW [STORAGE] ENGINES\nSHOW ERRORS [LIMIT [offset,] row_count]\nSHOW GRANTS FOR user\nSHOW INDEX FROM tbl_name [FROM db_name]\nSHOW INNODB STATUS\nSHOW [BDB] LOGS\nSHOW PRIVILEGES\nSHOW [FULL] PROCESSLIST\nSHOW STATUS [LIKE \'pattern\']\nSHOW TABLE STATUS [FROM db_name] [LIKE \'pattern\']\nSHOW [OPEN] TABLES [FROM db_name] [LIKE \'pattern\']\nSHOW [GLOBAL | SESSION] VARIABLES [LIKE \'pattern\']\nSHOW WARNINGS [LIMIT [offset,] row_count]\n\nIf the syntax for a given SHOW statement includes a LIKE\n\'pattern\' part, \'pattern\' is a string that can contain the SQL %\nand _ wildcard characters.\nThe pattern is useful for restricting statement output to matching values.\n','',''),(63,'CURTIME',15,'   CURTIME()\n\nReturns the current time as a value in \'HH:MM:SS\' or HHMMSS\nformat, depending on whether the function is used in a string or numeric\ncontext.\n','mysql> SELECT CURTIME();\n        -> \'23:50:26\'\nmysql> SELECT CURTIME() + 0;\n        -> 235026',''),(64,'TYPE SET',1,'   SET(\'value1\',\'value2\',...)\n\nA set.  A string object that can have zero or more values, each of which must\nbe chosen from the list of values \'value1\', \'value2\',\n... A SET column can have a maximum of 64 members.\nSET values are represented internally as integers.\n  \n','',''),(65,'SHOW BINLOG',26,'SHOW BINLOG EVENTS\n   [IN \'log_name\'] [FROM pos] [LIMIT [offset,] row_count]\n\nShows the events in the binary log. \nIf you do not specify \'log_name\', the first binary log will be displayed.\n','',''),(66,'RENAME TABLE',3,'RENAME TABLE tbl_name TO new_tbl_name\n    [, tbl_name2 TO new_tbl_name2] ...\n\nThis statement renames one or more tables.  It was added in MySQL 3.23.23.\n\nThe rename operation is done atomically, which means that no other thread\ncan access any of the tables while the rename is running. For example,\nif you have an existing table old_table, you can create another\ntable new_table that has the same structure but is empty, and then\nreplace the existing table with the empty one as follows:\n','CREATE TABLE new_table (...);\nRENAME TABLE old_table TO backup_table, new_table TO old_table;',''),(67,'SUBSTRING_INDEX',11,'   SUBSTRING_INDEX(str,delim,count)\nReturns the substring from string str before count\noccurrences of the delimiter delim.\nIf count is positive, everything to the left of the final delimiter\n(counting from the left) is returned.\nIf count is negative, everything to the right of the final delimiter\n(counting from the right) is returned.\n','mysql> SELECT SUBSTRING_INDEX(\'www.mysql.com\', \'.\', 2);\n        -> \'www.mysql\'\nmysql> SELECT SUBSTRING_INDEX(\'www.mysql.com\', \'.\', -2);\n        -> \'mysql.com\'',''),(68,'LOCALTIME',15,'   LOCALTIME\n   LOCALTIME()\n\nLOCALTIME and LOCALTIME() are synonyms for\nNOW().\n','',''),(69,'X',0,'   X(p)\nReturns the X-coordinate value for the point p as a double-precision\nnumber.\n','mysql> SELECT X(GeomFromText(\'Point(56.7 53.34)\'));\n+--------------------------------------+\n| X(GeomFromText(\'Point(56.7 53.34)\')) |\n+--------------------------------------+\n|                                 56.7 |\n+--------------------------------------+',''),(70,'START SLAVE',19,'START SLAVE [thread_type [, thread_type] ... ]\nSTART SLAVE [SQL_THREAD] UNTIL\n    MASTER_LOG_FILE = \'log_name\', MASTER_LOG_POS = log_pos\nSTART SLAVE [SQL_THREAD] UNTIL\n    RELAY_LOG_FILE = \'log_name\', RELAY_LOG_POS = log_pos\n\nthread_type: IO_THREAD | SQL_THREAD\n\nSTART SLAVE with no options starts both of the slave threads.\nThe I/O thread reads queries from the master server and stores them in the\nrelay log.  The SQL thread reads the relay log and executes the\nqueries.\nSTART SLAVE requires the SUPER privilege.\n\nIf START SLAVE succeeds in starting the slave threads, it\nreturns without any error. However, even in that case, it might be that the slave\nthreads start and then later stop (for example, because they don\'t manage to\nconnect to the master or read its binary logs, or some other\nproblem). START SLAVE will not warn you about this. You must\ncheck your slave\'s error log for error messages generated by\nthe slave threads, or check that they are running fine with SHOW\nSLAVE STATUS.\n','',''),(71,'SHOW MASTER LOGS',26,'SHOW MASTER LOGS\n\nLists the binary log files on the master. This statement is used as part of\nthe procedure described in [PURGE MASTER LOGS] for determining which logs\ncan be purged.\n','',''),(72,'Y',0,'   Y(p)\nReturns the Y-coordinate value for the point p as a double-precision\nnumber.\n','mysql> SELECT Y(GeomFromText(\'Point(56.7 53.34)\'));\n+--------------------------------------+\n| Y(GeomFromText(\'Point(56.7 53.34)\')) |\n+--------------------------------------+\n|                                53.34 |\n+--------------------------------------+',''),(73,'DIV',10,'Integer division.\nSimilar to FLOOR() but safe with BIGINT values.\n','mysql> SELECT 5 DIV 2;\n        -> 2',''),(74,'ENCRYPT',8,'   ENCRYPT(str[,salt])\nEncrypt str using the Unix crypt() system call. The\nsalt argument should be a string with two characters.\n(As of MySQL 3.22.16, salt may be longer than two characters.)\n','mysql> SELECT ENCRYPT(\'hello\');\n        -> \'VxuFAJXVARROc\'',''),(75,'BACKUP TABLE',19,'Note: This statement is deprecated. We are working on a better\nreplacement for it that will provide online backup capabilities.\nIn the meantime, the mysqlhotcopy script can be used instead.\n\nBACKUP TABLE copies to the backup directory the minimum number of\ntable files needed to restore the table, after flushing any buffered changes\nto disk. The statement works only for MyISAM tables.  It copies the\n*.frm definition  and *.MYD data files. The *.MYI\nindex file can be rebuilt from those two files.\nThe directory should be specified as a full pathname.\n','BACKUP TABLE tbl_name [, tbl_name] ... TO \'/path/to/backup/directory\'',''),(76,'^',28,'   ^\nBitwise XOR:\n','mysql> SELECT 1 ^ 1;\n        -> 0\nmysql> SELECT 1 ^ 0;\n        -> 1\nmysql> SELECT 11 ^ 3;\n        -> 8',''),(77,'TIMESTAMPDIFF FUNCTION',15,'','mysql> SELECT TIMESTAMPDIFF(MONTH,\'2003-02-01\',\'2003-05-01\');\n        -> 3\nmysql> SELECT TIMESTAMPDIFF(YEAR,\'2002-05-01\',\'2001-01-01\');\n        -> -1',''),(78,'BLOB TYPE TEXT BLOB',1,'   BLOB\n   TEXT\n\nA BLOB or TEXT column with a maximum length of 65,535 (2^16\n@minus{}1)\ncharacters.\n','',''),(79,'INSERT SELECT',26,'INSERT [LOW_PRIORITY] [IGNORE] [INTO] tbl_name [(column_list)]\n    SELECT ...\n\nWith INSERT ... SELECT, you can quickly insert many rows\ninto a table from one or many tables.\n','INSERT INTO tbl_temp2 (fld_id)\n    SELECT tbl_temp1.fld_order_id\n    FROM tbl_temp1 WHERE tbl_temp1.fld_order_id > 100;',''),(80,'HANDLER',26,'The HANDLER statement provides direct access to table storage engine\ninterfaces.  It is available for MyISAM tables as MySQL 4.0.0 and\nInnoDB tables as of MySQL 4.0.3.\n','HANDLER tbl_name OPEN [ AS alias ]\nHANDLER tbl_name READ index_name { = | >= | <= | < } (value1,value2,...)\n    [ WHERE where_condition ] [LIMIT ... ]\nHANDLER tbl_name READ index_name { FIRST | NEXT | PREV | LAST }\n    [ WHERE where_condition ] [LIMIT ... ]\nHANDLER tbl_name READ { FIRST | NEXT }\n    [ WHERE where_condition ] [LIMIT ... ]\nHANDLER tbl_name CLOSE',''),(81,'LOCALTIMESTAMP',15,'   LOCALTIMESTAMP\n   LOCALTIMESTAMP()\n\nLOCALTIMESTAMP and LOCALTIMESTAMP() are synonyms for\nNOW().\n','',''),(82,'SMALLINT',1,'   SMALLINT[(M)] [UNSIGNED] [ZEROFILL]\n\nA small integer. The signed range is -32768 to 32767. The\nunsigned range is 0 to 65535.\n','',''),(83,'RELEASE_LOCK',18,'   RELEASE_LOCK(str)\nReleases the lock named by the string str that was obtained with\nGET_LOCK(). Returns 1 if the lock was released, 0 if the\nlock wasn\'t locked by this thread (in which case the lock is not released),\nand NULL if the named lock didn\'t exist.  The lock will not exist if\nit was never obtained by a call to GET_LOCK() or if it already has\nbeen released.\n\nThe DO statement is convenient to use with RELEASE_LOCK().\nSee also : [DO,  , DO].\n','',''),(84,'LOG2',10,'   LOG2(X)\nReturns the base-2 logarithm of X.\n','mysql> SELECT LOG2(65536);\n        -> 16.000000\nmysql> SELECT LOG2(-100);\n        -> NULL',''),(85,'POLYFROMWKB',5,'   PolyFromWKB(wkb[,srid])\n   PolygonFromWKB(wkb[,srid])\nConstructs a POLYGON value using its WKB representation and SRID.\n','',''),(86,'GEOMCOLLFROMWKB',5,'   GeomCollFromWKB(wkb[,srid])\n   GeometryCollectionFromWKB(wkt[,srid])\nConstructs a GEOMETRYCOLLECTION value using its WKB representation and SRID.\n','',''),(87,'FROM_UNIXTIME',15,'   FROM_UNIXTIME(unix_timestamp)\n   FROM_UNIXTIME(unix_timestamp,format)\nReturns a representation of the unix_timestamp argument as a value in\n\'YYYY-MM-DD HH:MM:SS\' or YYYYMMDDHHMMSS format, depending on\nwhether the function is used in a string or numeric context.\n\nmysql> SELECT FROM_UNIXTIME(875996580);\n        -> \'1997-10-04 22:23:00\'\nmysql> SELECT FROM_UNIXTIME(875996580) + 0;\n        -> 19971004222300\n\nIf format is given, the result is formatted according to the\nformat string. format may contain the same specifiers as\nthose listed in the entry for the DATE_FORMAT() function.\n','mysql> SELECT FROM_UNIXTIME(UNIX_TIMESTAMP(),\n    ->                      \'%Y %D %M %h:%i:%s %x\');\n        -> \'2003 6th August 06:22:58 2003\'',''),(88,'SUBTIME',15,'   SUBTIME(expr,expr2)\n\n\nSUBTIME() subtracts expr2 from expr and returns the result.\nexpr is a date or datetime expression, and expr2 is a time\nexpression.\n','mysql> SELECT SUBTIME(\'1997-12-31 23:59:59.999999\',\n    ->                \'1 1:1:1.000002\');\n        -> \'1997-12-30 22:58:58.999997\'\nmysql> SELECT SUBTIME(\'01:00:00.999999\', \'02:00:00.999998\');\n        -> \'-00:59:59.999999\'',''),(89,'DOUBLE',1,'   DOUBLE[(M,D)] [UNSIGNED] [ZEROFILL]\n\nA normal-size (double-precision) floating-point number.\nAllowable values are -1.7976931348623157E+308 to\n-2.2250738585072014E-308, 0, and\n2.2250738585072014E-308 to 1.7976931348623157E+308.  If\nUNSIGNED is specified, negative values are disallowed.\nM is the display width and D is the number of decimals.\nDOUBLE without arguments or FLOAT(p) (where\np is in the\nrange from 25 to 53) stands for a double-precision floating-point number.\n\n   DOUBLE PRECISION[(M,D)] [UNSIGNED] [ZEROFILL]\n   REAL[(M,D)] [UNSIGNED] [ZEROFILL]\n\nThese are synonyms for DOUBLE.\nException: If the server SQL mode includes the REAL_AS_FLOAT option,\nREAL is a synonym for FLOAT rather than DOUBLE.\n','',''),(90,'LN',10,'   LN(X)\nReturns the natural logarithm of X.\n','mysql> SELECT LN(2);\n        -> 0.693147\nmysql> SELECT LN(-2);\n        -> NULL',''),(91,'MBRTOUCHES',6,'   MBRTouches(g1,g2)\nReturns 1 or 0 to indicate whether or not the Minimum Bounding Rectangles of\nthe two geometries g1 and g2 touch.\n','',''),(92,'LAST_INSERT_ID',20,'   LAST_INSERT_ID()\n   LAST_INSERT_ID(expr)\nReturns the last automatically generated value that was inserted into\nan AUTO_INCREMENT column.\n','mysql> SELECT LAST_INSERT_ID();\n        -> 195',''),(93,'MULTIPOINT',2,'   MultiPoint(pt1,pt2,...)\nConstructs a WKB MultiPoint value using WKB Point arguments.\nIf any argument is not a WKB Point, the return value is NULL.\n','',''),(94,'CONCAT_WS',11,'   CONCAT_WS(separator,str1,str2,...)\n\nCONCAT_WS() stands for CONCAT With Separator and is a special form of\nCONCAT().  The first argument is the separator for the rest of the\narguments.\nThe separator is added between the strings to be concatenated.\nThe separator can be a string as can the rest of the\narguments. If the separator is NULL, the result is NULL.\nThe function skips any NULL values after the\nseparator argument.\n','mysql> SELECT CONCAT_WS(\',\',\'First name\',\'Second name\',\'Last Name\');\n        -> \'First name,Second name,Last Name\'\nmysql> SELECT CONCAT_WS(\',\',\'First name\',NULL,\'Last Name\');\n        -> \'First name,Last Name\'',''),(95,'LOAD DATA',26,'The LOAD DATA INFILE statement reads rows from a text file into a\ntable at a very high speed.\nFor more information about the efficiency of INSERT versus\nLOAD DATA INFILE and speeding up LOAD DATA INFILE,\n[Insert speed].\n\nYou can also load data files by using the mysqlimport utility; it\noperates by sending a LOAD DATA INFILE statement to the server.  The\n--local option causes mysqlimport to read data files from the\nclient host.  You can specify the --compress option to get better\nperformance over slow networks if the client and server support the\ncompressed protocol.\nSee also : [mysqlimport,  , mysqlimport].\n\nIf you specify the LOW_PRIORITY keyword, execution of the\nLOAD DATA statement is delayed until no other clients are reading\nfrom the table.\n\nIf you specify the CONCURRENT keyword with a MyISAM table that\nsatisfies the condition for concurrent inserts (that is, it contains no free\nblocks in the middle),\nthen other threads can retrieve data from the table while LOAD DATA\nis executing. Using this option affects the performance of LOAD DATA\na bit, even if no other thread is using the table at the same time.\n\nIf the LOCAL keyword is specified, it is\ninterpreted with respect to the client end of the connection:\n\n\n --- If LOCAL is specified, the file is read by the client program on the\nclient host and sent to the server.\n\n --- If LOCAL is not specified, the\nfile must be located on the server host and is read directly by the server.\n\n\nLOCAL is available in MySQL 3.22.6 or later.\n\nFor security reasons, when reading text files located on the server, the\nfiles must either reside in the database directory or be readable by all.\nAlso, to use LOAD DATA INFILE on server files, you must have the\nFILE privilege.\n','LOAD DATA [LOW_PRIORITY | CONCURRENT] [LOCAL] INFILE \'file_name.txt\'\n    [REPLACE | IGNORE]\n    INTO TABLE tbl_name\n    [FIELDS\n        [TERMINATED BY \'\\t\']\n        [[OPTIONALLY] ENCLOSED BY \'\']\n        [ESCAPED BY \'\\\\\' ]\n    ]\n    [LINES \n        [STARTING BY \'\']    \n        [TERMINATED BY \'\\n\']\n    ]\n    [IGNORE number LINES]\n    [(col_name,...)]',''),(96,'TRUNCATE',10,'   TRUNCATE(X,D)\nReturns the number X, truncated to D decimals.  If D\nis 0, the result will have no decimal point or fractional part.\nIf D is negative, the integer part of the number is zeroed out.\n','mysql> SELECT TRUNCATE(1.223,1);\n        -> 1.2\nmysql> SELECT TRUNCATE(1.999,1);\n        -> 1.9\nmysql> SELECT TRUNCATE(1.999,0);\n        -> 1\nmysql> SELECT TRUNCATE(-1.999,1);\n        -> -1.9\nmysql> SELECT TRUNCATE(122,-2);\n       -> 100',''),(97,'FLOOR',10,'   FLOOR(X)\nReturns the largest integer value not greater than X.\n','mysql> SELECT FLOOR(1.23);\n        -> 1\nmysql> SELECT FLOOR(-1.23);\n        -> -2',''),(98,'GET_FORMAT',15,'   GET_FORMAT(DATE|TIME|TIMESTAMP, \'EUR\'|\'USA\'|\'JIS\'|\'ISO\'|\'INTERNAL\')\nReturns a format string. This function is useful in combination with the \nDATE_FORMAT() and the STR_TO_DATE() functions.\nThe three possible values for the first argument \nand the five possible values for the second argument result in 15 possible \nformat strings (for the specifiers used, see the table in the \nDATE_FORMAT() function description).\n     Function Call 	 Result\n   GET_FORMAT(DATE,\'USA\') 	 \'%m.%d.%Y\'\n   GET_FORMAT(DATE,\'JIS\') 	 \'%Y-%m-%d\'\n   GET_FORMAT(DATE,\'ISO\') 	 \'%Y-%m-%d\'\n   GET_FORMAT(DATE,\'EUR\') 	 \'%d.%m.%Y\'\n   GET_FORMAT(DATE,\'INTERNAL\') 	 \'%Y%m%d\'\n   GET_FORMAT(TIMESTAMP,\'USA\') 	 \'%Y-%m-%d-%H.%i.%s\'\n   GET_FORMAT(TIMESTAMP,\'JIS\') 	 \'%Y-%m-%d %H:%i:%s\'\n   GET_FORMAT(TIMESTAMP,\'ISO\') 	 \'%Y-%m-%d %H:%i:%s\'\n   GET_FORMAT(TIMESTAMP,\'EUR\') 	 \'%Y-%m-%d-%H.%i.%s\'\n   GET_FORMAT(TIMESTAMP,\'INTERNAL\') 	 \'%Y%m%d%H%i%s\'\n   GET_FORMAT(TIME,\'USA\') 	 \'%h:%i:%s %p\'\n   GET_FORMAT(TIME,\'JIS\') 	 \'%H:%i:%s\'\n   GET_FORMAT(TIME,\'ISO\') 	 \'%H:%i:%s\'\n   GET_FORMAT(TIME,\'EUR\') 	 \'%H.%i.%S\'\n   GET_FORMAT(TIME,\'INTERNAL\') 	 \'%H%i%s\'\n  \nISO format is ISO 9075, not ISO 8601.\n','mysql> SELECT DATE_FORMAT(\'2003-10-03\',GET_FORMAT(DATE,\'EUR\'));\n        -> \'03.10.2003\'\nmysql> SELECT STR_TO_DATE(\'10.31.2003\',GET_FORMAT(DATE,\'USA\'));\n        -> 2003-10-31\n@c Following is commented out because not yet implemented\n@c mysql> SET DATE_FORMAT=GET_FORMAT(DATE, \'USA\'); SELECT \'2003-10-31\';\n@c         -> 10-31-2003',''),(99,'LOCATE',11,'   LOCATE(substr,str)\n   LOCATE(substr,str,pos)\n\nThe first syntax\nreturns the position of the first occurrence of substring substr\nin string str.\nThe second syntax\nreturns the position of the first occurrence of substring substr in\nstring str, starting at position pos.\nReturns 0 if substr is not in str.\n','',''),(100,'>=',4,'   >=\nGreater than or equal:\n','mysql> SELECT 2 >= 2;\n        -> 1',''),(101,'>>',28,'   >>\nShifts a longlong (BIGINT) number to the right.\n','mysql> SELECT 4 >> 2;\n        -> 1',''),(102,'CEILING',10,'   CEILING(X)\n   CEIL(X)\nReturns the smallest integer value not less than X.\n','mysql> SELECT CEILING(1.23);\n        -> 2\nmysql> SELECT CEIL(-1.23);\n        -> -1',''),(103,'IFNULL',14,'   IFNULL(expr1,expr2)\nIf expr1 is not NULL, IFNULL() returns expr1,\nelse it returns expr2.  IFNULL() returns a numeric or string\nvalue, depending on the context in which it is used.\n','mysql> SELECT IFNULL(1,0);\n        -> 1\nmysql> SELECT IFNULL(NULL,10);\n        -> 10\nmysql> SELECT IFNULL(1/0,10);\n        -> 10\nmysql> SELECT IFNULL(1/0,\'yes\');\n        -> \'yes\'',''),(104,'|',28,'   |\nBitwise OR:\n','mysql> SELECT 29 | 15;\n        -> 31',''),(105,'ISSIMPLE',13,'   IsSimple(g)\n\nCurrently, this function is a placeholder and should not be used.\nIf implemented, its behavior will be as described in the next paragraph.\n\nReturns 1 if the geometry value g has no anomalous geometric points,\nsuch as self-intersection or self-tangency. IsSimple() returns 0 if the\nargument is not simple, and @minus{}1 if it is NULL.\n\nThe description of each instantiable geometric class given earlier in\nthe chapter includes the specific conditions that cause an instance of\nthat class to be classified as not simple.\n','',''),(106,'MLINEFROMTEXT',17,'   MLineFromText(wkt[,srid])\n   MultiLineStringFromText(wkt[,srid])\nConstructs a MULTILINESTRING value using its WKT representation and SRID.\n','',''),(107,'CHAR FUNCTION',11,'   CHAR(N,...)\nCHAR() interprets the arguments as integers and returns a string\nconsisting of the characters given by the code values of those\nintegers. NULL values are skipped.\n','mysql> SELECT CHAR(77,121,83,81,\'76\');\n        -> \'MySQL\'\nmysql> SELECT CHAR(77,77.3,\'77.3\');\n        -> \'MMM\'',''),(108,'DEGREES',10,'   DEGREES(X)\nReturns the argument X, converted from radians to degrees.\n','mysql> SELECT DEGREES(PI());\n        -> 180.000000',''),(109,'~',28,'   ~\nInvert all bits.\n','mysql> SELECT 5 & ~1;\n        -> 4',''),(110,'ADDDATE',15,'   ADDDATE(date,INTERVAL expr type)\n   ADDDATE(expr,days)\n\nWhen invoked with the INTERVAL form of the second argument,\nADDDATE() is a synonym for DATE_ADD().  The related\nfunction SUBDATE() is a synonym for DATE_SUB().\nFor information on the INTERVAL argument, see the\ndiscussion for DATE_ADD().\n\nmysql> SELECT DATE_ADD(\'1998-01-02\', INTERVAL 31 DAY);\n        -> \'1998-02-02\'\nmysql> SELECT ADDDATE(\'1998-01-02\', INTERVAL 31 DAY);\n        -> \'1998-02-02\'\n\nAs of MySQL 4.1.1, the second syntax is allowed, where expr is a date\nor datetime expression and days is the number of days to be added to\nexpr.\n\nmysql> SELECT ADDDATE(\'1998-01-02\', 31);\n        -> \'1998-02-02\'\n','',''),(111,'OVERLAPS',25,'   Overlaps(g1,g2)\nReturns 1 or 0 to indicate whether or not g1 spatially overlaps\ng2.\nThe term /spatially overlaps/ is used if two\ngeometries intersect and their intersection results in a geometry of the\nsame dimension but not equal to either of the given geometries.\n','',''),(112,'EQUALS',25,'   Equals(g1,g2)\nReturns 1 or 0 to indicate whether or not g1 is spatially equal to\ng2.\n','',''),(113,'ACOS',10,'   ACOS(X)\nReturns the arc cosine of X, that is, the value whose cosine is\nX. Returns NULL if X is not in the range -1 to\n1.\n','mysql> SELECT ACOS(1);\n        -> 0.000000\nmysql> SELECT ACOS(1.0001);\n        -> NULL\nmysql> SELECT ACOS(0);\n        -> 1.570796',''),(114,'LEFT',11,'   LEFT(str,len)\nReturns the leftmost len characters from the string str.\n','mysql> SELECT LEFT(\'foobarbar\', 5);\n        -> \'fooba\'',''),(115,'RESET MASTER',26,'RESET MASTER\n\nDeletes all binary logs listed in the index file,\nresets the binary log index file to be empty, and creates a new binary log\nfile.\n\nThis statement was named FLUSH MASTER before MySQL 3.23.26.\n','',''),(116,'LENGTH',11,'   LENGTH(str)\nReturns the length of the string str, measured in bytes.\nA multi-byte character counts as multiple bytes.\nThis means that for a string containing five two-byte characters,\nLENGTH() returns 10, whereas CHAR_LENGTH() returns\n5.\n','mysql> SELECT LENGTH(\'text\');\n        -> 4',''),(117,'LTRIM',11,'   LTRIM(str)\nReturns the string str with leading space characters removed.\n','mysql> SELECT LTRIM(\'  barbar\');\n        -> \'barbar\'',''),(118,'NOT BETWEEN',4,'   expr NOT BETWEEN min AND max\nThis is the same as NOT (expr BETWEEN min AND max).\n','',''),(119,'NUMERIC',1,'   DECIMAL[(M[,D])] [UNSIGNED] [ZEROFILL]\n\nAn unpacked fixed-point number.  Behaves like a CHAR column;\n``unpacked\'\' means the number is stored as a string, using one character for\neach digit of the value.  M is the total number of digits and\nD is the number of decimals.  The decimal point and (for negative\nnumbers) the - sign are not counted in M, although space for\nthem is reserved. If D is 0, values have no decimal point or\nfractional part.  The maximum range of DECIMAL values is the same as\nfor DOUBLE, but the actual range for a given DECIMAL column\nmay be constrained by the choice of M and D.  If\nUNSIGNED is specified, negative values are disallowed.\n\nIf D is omitted, the default is 0.  If M is omitted, the\ndefault is 10.\n\nPrior to MySQL 3.23, the M argument must be large enough to\ninclude the space needed for the sign and the decimal point.\n\n   DEC[(M[,D])] [UNSIGNED] [ZEROFILL]\n   NUMERIC[(M[,D])] [UNSIGNED] [ZEROFILL]\n   FIXED[(M[,D])] [UNSIGNED] [ZEROFILL]\n\nThese are synonyms for DECIMAL.\n\nThe FIXED synonym was added in MySQL 4.1.0 for compatibility\nwith other servers.\n','',''),(120,'ATAN2',10,'   ATAN(Y,X)\n   ATAN2(Y,X)\nReturns the arc tangent of the two variables X and Y. It is\nsimilar to calculating the arc tangent of Y / X, except that the\nsigns of both arguments are used to determine the quadrant of the\nresult.\n','mysql> SELECT ATAN(-2,2);\n        -> -0.785398\nmysql> SELECT ATAN2(PI(),0);\n        -> 1.570796',''),(121,'RESET',26,'The RESET statement is used to clear the state of various server\noperations. It also acts as a stronger\nversion of the FLUSH statement.  See also : [FLUSH, , FLUSH].\n','RESET reset_option [, reset_option] ...',''),(122,'MPOLYFROMTEXT',17,'   MPolyFromText(wkt[,srid])\n   MultiPolygonFromText(wkt[,srid])\nConstructs a MULTIPOLYGON value using its WKT representation and SRID.\n','',''),(123,'START TRANSACTION',23,'By default, MySQL runs with autocommit mode enabled. This means that\nas soon as you execute a statement that updates (modifies) a table,\nMySQL stores the update on disk.\n\nIf you are using transaction-safe tables (like InnoDB or BDB),\nyou can disable autocommit mode with the following statement:\n\nSET AUTOCOMMIT=0;\n\nAfter disabling autocommit mode by setting the AUTOCOMMIT variable to\nzero, you must use COMMIT to store your changes to disk or\nROLLBACK if you want to ignore the changes you have made since\nthe beginning of your transaction.\n\nIf you want to disable autocommit mode for a single series of\nstatements, you can use the START TRANSACTION statement:\n','START TRANSACTION;\nSELECT @A:=SUM(salary) FROM table1 WHERE type=1;\nUPDATE table2 SET summary=@A WHERE type=1;\nCOMMIT;',''),(124,'DAYOFMONTH',15,'   DAYOFMONTH(date)\nReturns the day of the month for date, in the range 1 to\n31.\n','mysql> SELECT DAYOFMONTH(\'1998-02-03\');\n        -> 3',''),(125,'RAND',10,'   RAND()\n   RAND(N)\nReturns a random floating-point value in the range from 0 to 1.0.\nIf an integer argument N is specified, it is used as the seed value\n(producing a repeatable sequence).\n','mysql> SELECT RAND();\n        -> 0.9233482386203\nmysql> SELECT RAND(20);\n        -> 0.15888261251047\nmysql> SELECT RAND(20);\n        -> 0.15888261251047\nmysql> SELECT RAND();\n        -> 0.63553050033332\nmysql> SELECT RAND();\n        -> 0.70100469486881',''),(126,'CONV',11,'   CONV(N,from_base,to_base)\nConverts numbers between different number bases.  Returns a string\nrepresentation of the number N, converted from base from_base\nto base to_base.  Returns NULL if any argument is NULL.\nThe argument N is interpreted as an integer, but may be specified as\nan integer or a string.  The minimum base is 2 and the maximum base is\n36.  If to_base is a negative number, N is regarded as a\nsigned number.  Otherwise, N is treated as unsigned.  CONV() works\nwith 64-bit precision.\n','mysql> SELECT CONV(\'a\',16,2);\n        -> \'1010\'\nmysql> SELECT CONV(\'6E\',18,8);\n        -> \'172\'\nmysql> SELECT CONV(-17,10,-18);\n        -> \'-H\'\nmysql> SELECT CONV(10+\'10\'+\'10\'+0xa,10,10);\n        -> \'40\'',''),(127,'REPLACE',11,'   REPLACE(str,from_str,to_str)\nReturns the string str with all occurrences of the string\nfrom_str replaced by the string to_str.\n','mysql> SELECT REPLACE(\'www.mysql.com\', \'w\', \'Ww\');\n        -> \'WwWwWw.mysql.com\'',''),(128,'FLOAT',1,'   FLOAT(p) [UNSIGNED] [ZEROFILL]\n\nA floating-point number.  p represents the precision. It can be from\n0 to 24 for a single-precision floating-point number and from 25 to 53 for a\ndouble-precision floating-point number. These types are like the FLOAT\nand DOUBLE types described immediately following.  FLOAT(p)\nhas the same range as the corresponding FLOAT and DOUBLE\ntypes, but the display size and number of decimals are undefined.\n\nAs of MySQL 3.23, this is a true floating-point value.  In\nearlier MySQL versions, FLOAT(p) always has two decimals.\n\nThis syntax is provided for ODBC compatibility.\n\nUsing FLOAT might give you some unexpected problems because\nall calculations in MySQL are done with double precision.\nSee also : [No matching rows].\n\n   FLOAT[(M,D)] [UNSIGNED] [ZEROFILL]\n\nA small (single-precision) floating-point number.  Allowable values are\n-3.402823466E+38 to -1.175494351E-38, 0,\nand 1.175494351E-38 to 3.402823466E+38.  If\nUNSIGNED is specified, negative values are disallowed.  M\nis the display width and D is the number of decimals.  FLOAT\nwithout arguments or FLOAT(p) (where p is in the range from\n0 to 24) stands for a single-precision floating-point number.\n','',''),(129,'ENUM',1,'   ENUM(\'value1\',\'value2\',...)\n\nAn enumeration.  A string object that can have only one value, chosen\nfrom the list of values \'value1\', \'value2\', ...,\nNULL or the special \'\' error value.  An ENUM column can\nhave a maximum of 65,535 distinct values.\nENUM values are represented internally as integers.\n','',''),(130,'STARTPOINT',21,'   StartPoint(ls)\nReturns the Point that is the start point of the LineString value\nls.\n','mysql> SET @ls = \'LineString(1 1,2 2,3 3)\';\nmysql> SELECT AsText(StartPoint(GeomFromText(@ls)));\n+---------------------------------------+\n| AsText(StartPoint(GeomFromText(@ls))) |\n+---------------------------------------+\n| POINT(1 1)                            |\n+---------------------------------------+',''),(131,'GEOMFROMTEXT',17,'   GeomFromText(wkt[,srid])\n   GeometryFromText(wkt[,srid])\nConstructs a geometry value of any type using its WKT representation and SRID.\n','',''),(132,'INET_NTOA',18,'   INET_NTOA(expr)\nGiven a numeric network address (4 or 8 byte), returns the dotted-quad\nrepresentation of the address as a string.\n','mysql> SELECT INET_NTOA(3520061480);\n        -> \'209.207.224.40\'',''),(133,'COLLATION',20,'   COLLATION(str)\nReturns the collation for the character set of the string argument.\n','mysql> SELECT COLLATION(\'abc\');\n        -> \'latin1_swedish_ci\'\nmysql> SELECT COLLATION(_utf8\'abc\');\n        -> \'utf8_general_ci\'',''),(134,'!=',4,'   <>\n   !=\nNot equal:\n','mysql> SELECT \'.01\' <> \'0.01\';\n        -> 1\nmysql> SELECT .01 <> \'0.01\';\n        -> 0\nmysql> SELECT \'zapp\' <> \'zappp\';\n        -> 1',''),(135,'RPAD',11,'   RPAD(str,len,padstr)\nReturns the string str, right-padded with the string padstr\nto a length of len characters. If str is longer\nthan len, the return value is shortened to len characters.\n','mysql> SELECT RPAD(\'hi\',5,\'?\');\n        -> \'hi???\'\nmysql> SELECT RPAD(\'hi\',1,\'?\');\n        -> \'h\'',''),(136,'DATE',1,'A date.  The supported range is \'1000-01-01\' to \'9999-12-31\'.\nMySQL displays DATE values in \'YYYY-MM-DD\' format, but\nallows you to assign values to DATE columns using either strings or\nnumbers.\n','',''),(137,'ENDPOINT',21,'   EndPoint(ls)\nReturns the Point that is the end point of the LineString value\nls.\n','mysql> SET @ls = \'LineString(1 1,2 2,3 3)\';\nmysql> SELECT AsText(EndPoint(GeomFromText(@ls)));\n+-------------------------------------+\n| AsText(EndPoint(GeomFromText(@ls))) |\n+-------------------------------------+\n| POINT(3 3)                          |\n+-------------------------------------+',''),(138,'POINTFROMWKB',5,'   PointFromWKB(wkb[,srid])\nConstructs a POINT value using its WKB representation and SRID.\n','',''),(139,'CHARACTER_LENGTH',11,'   CHARACTER_LENGTH(str)\n\nCHARACTER_LENGTH() is a synonym for CHAR_LENGTH().\n','',''),(140,'DAYOFYEAR',15,'   DAYOFYEAR(date)\nReturns the day of the year for date, in the range 1 to\n366.\n','mysql> SELECT DAYOFYEAR(\'1998-02-03\');\n        -> 34',''),(141,'EXPORT_SET',11,'   EXPORT_SET(bits,on,off,[separator,[number_of_bits]])\nReturns a string in which for every bit set in bits, you get an on \nstring and for every reset bit you get an off string. Each string is \nseparated by separator (default ,), and only \nnumber_of_bits (default 64) of bits is used.\n','mysql> SELECT EXPORT_SET(5,\'Y\',\'N\',\',\',4)\n        -> Y,N,Y,N',''),(142,'LIKE',11,'   expr LIKE pat [ESCAPE \'escape-char\']\nPattern matching using\nSQL simple regular expression comparison. Returns 1 (TRUE) or 0\n(FALSE).  If either expr or pat is NULL, the result is\nNULL.\n\nWith LIKE you can use the following two wildcard characters\nin the pattern:\n\n     Character 	 Description\n   % 	 Matches any number of characters, even zero characters\n   _ 	 Matches exactly one character\n  \n','mysql> SELECT \'David!\' LIKE \'David_\';\n        -> 1\nmysql> SELECT \'David!\' LIKE \'%D%v%\';\n        -> 1',''),(143,'MEDIUMBLOB',1,'   MEDIUMBLOB\n   MEDIUMTEXT\n\nA BLOB or TEXT column with a maximum length of 16,777,215\n(2^24 @minus{} 1) characters.\n','',''),(144,'MAKE_SET',11,'   MAKE_SET(bits,str1,str2,...)\nReturns a set value (a string containing substrings separated by ,\ncharacters) consisting of the strings that have the corresponding bit in\nbits set.  str1 corresponds to bit 0, str2 to bit 1,\nand so on.  NULL values in str1, str2, ...\nare not appended to the result.\n','mysql> SELECT MAKE_SET(1,\'a\',\'b\',\'c\');\n        -> \'a\'\nmysql> SELECT MAKE_SET(1 | 4,\'hello\',\'nice\',\'world\');\n        -> \'hello,world\'\nmysql> SELECT MAKE_SET(1 | 4,\'hello\',\'nice\',NULL,\'world\');\n        -> \'hello\'\nmysql> SELECT MAKE_SET(0,\'a\',\'b\',\'c\');\n        -> \'\'',''),(145,'USER',20,'   USER()\n\nReturns the current MySQL username and hostname.\n','mysql> SELECT USER();\n        -> \'davida@localhost\'',''),(146,'GRANT TYPES',19,'For the GRANT and REVOKE statements, priv_type can be\nspecified as any of the following:\n\n     Privilege 	 Meaning\n   ALL [PRIVILEGES] 	 Sets all simple privileges except GRANT OPTION\n   ALTER  	 Allows use of ALTER TABLE\n   CREATE 	 Allows use of CREATE TABLE\n   CREATE TEMPORARY TABLES 	 Allows use of CREATE TEMPORARY TABLE\n   DELETE 	 Allows use of DELETE\n   DROP 	 Allows use of DROP TABLE\n   EXECUTE 	 Allows the user to run stored procedures (MySQL 5.0)\n   FILE 	 Allows use of SELECT ... INTO OUTFILE and LOAD DATA INFILE\n   INDEX 	 Allows use of CREATE INDEX and DROP INDEX\n   INSERT 	 Allows use of INSERT\n   LOCK TABLES 	 Allows use of LOCK TABLES on tables for which you have the SELECT privilege\n   PROCESS 	 Allows use of SHOW FULL PROCESSLIST\n   REFERENCES 	 Not yet implemented\n   RELOAD 	 Allows use of FLUSH\n   REPLICATION CLIENT 	 Allows the user to ask where the slave or master servers are\n   REPLICATION SLAVE 	 Needed for replication slaves (to read binary log events from the master)\n   SELECT 	 Allows use of SELECT\n   SHOW DATABASES 	 SHOW DATABASES shows all databases\n   SHUTDOWN 	 Allows use of mysqladmin shutdown\n   SUPER 	 Allows use of CHANGE MASTER, KILL, PURGE MASTER LOGS, and SET GLOBAL statements, the mysqladmin debug command; allows you to connect (once) even if max_connections is reached\n   UPDATE 	 Allows use of UPDATE\n   USAGE 	 Synonym for ``no privileges\'\'\n   GRANT OPTION 	 Allows privileges to be granted\n  \n','',''),(147,'UNION',26,'UNION is used to combine the result from many SELECT\nstatements into one result set.  UNION is available from MySQL 4.0.0\non.\n\nSelected columns listed in corresponding positions of each SELECT\nstatement should have the same type. (For example, the first column selected\nby the first statement should have the same type as the first column selected\nby the other statements.) The column names used in\nthe first SELECT statement are used as the column names for the\nresults returned.\n','SELECT ...\nUNION [ALL | DISTINCT]\nSELECT ...\n  [UNION [ALL | DISTINCT]\n   SELECT ...]',''),(148,'BLOB',1,'A BLOB is a binary large object that can hold a variable amount of\ndata.  The four BLOB types, TINYBLOB, BLOB,\nMEDIUMBLOB, and LONGBLOB, differ only in the maximum length of\nthe values they can hold.\n','',''),(149,'DATETIME',1,'A date and time combination.  The supported range is \'1000-01-01\n00:00:00\' to \'9999-12-31 23:59:59\'.  MySQL displays\nDATETIME values in \'YYYY-MM-DD HH:MM:SS\' format, but allows you\nto assign values to DATETIME columns using either strings or numbers.\n','',''),(150,'RELATED',25,'   Related(g1,g2,pattern_matrix)\nReturns 1 or 0 to indicate whether or not the spatial relationship specified\nby pattern_matrix exists between g1 and g2.\nReturns @minus{}1 if the arguments are NULL.\nThe pattern matrix is a string. Its specification will be noted here if this\nfunction is implemented.\n','',''),(151,'EXP',10,'   EXP(X)\nReturns the value of e (the base of natural logarithms) raised to\nthe power of X.\n','mysql> SELECT EXP(2);\n        -> 7.389056\nmysql> SELECT EXP(-2);\n        -> 0.135335',''),(152,'INET_ATON',18,'   INET_ATON(expr)\nGiven the dotted-quad representation of a network address as a string,\nreturns an integer that represents the numeric value of the address.\nAddresses may be 4- or 8-byte addresses.\n','mysql> SELECT INET_ATON(\'209.207.224.40\');\n        -> 3520061480',''),(153,'GEOMFROMWKB',5,'   GeomFromWKB(wkb[,srid])\n   GeometryFromWKB(wkt[,srid])\nConstructs a geometry value of any type using its WKB representation and SRID.\n','',''),(154,'DISJOINT',25,'   Disjoint(g1,g2)\nReturns 1 or 0 to indicate whether or not g1 is spatially disjoint\nfrom (does not intersect) g2.\n','',''),(155,'CREATE DATABASE',3,'CREATE DATABASE creates a database with the given name.  \nTo use CREATE DATABASE, you need the CREATE privilege on the\ndatabase.\n','CREATE DATABASE [IF NOT EXISTS] db_name\n    [create_specification [, create_specification] ...]\n\ncreate_specification:\n    [DEFAULT] CHARACTER SET charset_name\n  | [DEFAULT] COLLATE collation_name',''),(156,'COS',10,'   COS(X)\nReturns the cosine of X, where X is given in radians.\n','mysql> SELECT COS(PI());\n        -> -1.000000',''),(157,'CRC32',10,'   CRC32(expr)\nComputes a cyclic redundancy check value and returns a 32-bit unsigned value.\nThe result is NULL if the argument is NULL.\nThe argument is expected be a string and will be treated as one if it is not.\n','mysql> SELECT CRC32(\'MySQL\');\n        -> 3259397556',''),(158,'GEOMETRYCOLLECTION',2,'   GeometryCollection(g1,g2,...)\nConstructs a WKB GeometryCollection. If any argument is not a\nwell-formed WKB representation of a geometry, the return value is\nNULL.\n','',''),(159,'FORMAT',18,'   FORMAT(X,D)\nFormats the number X to a format like \'#,###,###.##\', rounded\nto D decimals, and returns the result as a string.\nIf D is 0, the result will have no\ndecimal point or fractional part.\n','mysql> SELECT FORMAT(12332.123456, 4);\n        -> \'12,332.1235\'\nmysql> SELECT FORMAT(12332.1,4);\n        -> \'12,332.1000\'\nmysql> SELECT FORMAT(12332.2,0);\n        -> \'12,332\'',''),(160,'COMPRESS',11,'   COMPRESS(string_to_compress)\nCompresses a string. This function requires MySQL to have been compiled\nwith a compression library such as zlib. Otherwise, the return\nvalue is always NULL.\n','mysql> SELECT LENGTH(COMPRESS(REPEAT(\'a\',1000)));\n        -> 21\nmysql> SELECT LENGTH(COMPRESS(\'\'));\n        -> 0\nmysql> SELECT LENGTH(COMPRESS(\'a\'));\n        -> 13\nmysql> SELECT LENGTH(COMPRESS(REPEAT(\'a\',16)));\n        -> 15',''),(161,'COT',10,'   COT(X)\nReturns the cotangent of X.\n','mysql> SELECT COT(12);\n        -> -1.57267341\nmysql> SELECT COT(0);\n        -> NULL',''),(162,'FROM_DAYS',15,'   FROM_DAYS(N)\nGiven a daynumber N, returns a DATE value.\n','mysql> SELECT FROM_DAYS(729669);\n        -> \'1997-10-07\'',''),(163,'INTERVAL',4,'   INTERVAL(N,N1,N2,N3,...)\nReturns 0 if N < N1, 1 if N < N2\nand so on or -1 if N is NULL. All arguments are treated\nas integers.  It is required that N1 < N2 < N3 < \n... < Nn for this function to work correctly. This is because\na binary search is used (very fast).\n','mysql> SELECT INTERVAL(23, 1, 15, 17, 30, 44, 200);\n        -> 3\nmysql> SELECT INTERVAL(10, 1, 10, 100, 1000);\n        -> 2\nmysql> SELECT INTERVAL(22, 23, 30, 44, 200);\n        -> 0',''),(164,'GRANT',19,'The GRANT and REVOKE statements allow system administrators to\ncreate MySQL user accounts and to grant rights to and revoke them from\naccounts.  GRANT and REVOKE are implemented in MySQL 3.22.11\nor later. For earlier MySQL versions, these statements do nothing.\n\nMySQL account information is stored in the tables of the mysql\ndatabase. This database and the access control system are discussed\nextensively in [MySQL Database Administration], which you should consult\nfor additional details.\n\nPrivileges can be granted at four levels:\n\n   Global level\nGlobal privileges apply to all databases on a given server. These privileges\nare stored in the mysql.user table.\nGRANT ALL ON *.* and\nREVOKE ALL ON *.* grant and revoke only global privileges.\n\n   Database level\nDatabase privileges apply to all tables in a given database. These privileges\nare stored in the mysql.db and mysql.host tables.\nGRANT ALL ON db_name.* and\nREVOKE ALL ON db_name.* grant and revoke only database privileges.\n\n   Table level\nTable privileges apply to all columns in a given table. These privileges are\nstored in the mysql.tables_priv table.\nGRANT ALL ON db_name.tbl_name and\nREVOKE ALL ON db_name.tbl_name grant and revoke only table privileges.\n\n   Column level\nColumn privileges apply to single columns in a given table. These privileges are\nstored in the mysql.columns_priv table.\nWhen using REVOKE, you must specify the same columns that were granted.\n  \n','GRANT priv_type [(column_list)] [, priv_type [(column_list)]] ...\n    ON {tbl_name | * | *.* | db_name.*}\n    TO user [IDENTIFIED BY [PASSWORD] \'password\']\n        [, user [IDENTIFIED BY [PASSWORD] \'password\']] ...\n    [REQUIRE\n        NONE |\n        [{SSL| X509}]\n        [CIPHER \'cipher\' [AND]]\n        [ISSUER \'issuer\' [AND]]\n        [SUBJECT \'subject\']]\n    [WITH [GRANT OPTION | MAX_QUERIES_PER_HOUR count |\n                          MAX_UPDATES_PER_HOUR count |\n                          MAX_CONNECTIONS_PER_HOUR count]]',''),(165,'INSERT DELAYED',26,'The DELAYED option for the INSERT statement is a\nMySQL extension to standard SQL that is very useful if you have clients\nthat can\'t wait for the INSERT to complete.  This is a common\nproblem when you use MySQL for logging and you also\nperiodically run SELECT and UPDATE statements that take a\nlong time to complete.  DELAYED was introduced in MySQL\n3.22.15.\n\nWhen a client uses INSERT DELAYED, it gets an okay from the server at\nonce, and the row is queued to be inserted when the table is not in use by\nany other thread.\n\nAnother major benefit of using INSERT DELAYED is that inserts\nfrom many clients are bundled together and written in one block. This is much\nfaster than doing many separate inserts.\n\nThere are some constraints on the use of DELAYED:\n\n\n --- INSERT DELAYED works only with MyISAM and ISAM\ntables.\nFor MyISAM tables, if there are no free blocks in the middle of the\ndata file, concurrent SELECT and INSERT statements are supported.\nUnder these circumstances, you very seldom need to use INSERT\nDELAYED with MyISAM. See also : [MyISAM].\n\n --- INSERT DELAYED should be used only for INSERT statements that\nspecify value lists. This is enforced as of MySQL 4.0.18.  The server ignores\nDELAYED for INSERT DELAYED ... SELECT statements.\n\n --- The server ignores\nDELAYED for INSERT DELAYED ... ON DUPLICATE UPDATE statements.\n\n --- Because the statement returns immediately before the rows are inserted,\nyou cannot use LAST_INSERT_ID() to get the AUTO_INCREMENT\nvalue the statement might generate.\n\n --- DELAYED rows are not visible to SELECT statements until they\nactually have been inserted.\n','INSERT DELAYED ...',''),(166,'WEEK',15,'   WEEK(date[,mode])\nThe function returns the week number for date.  The two-argument form\nof WEEK() allows you to specify whether the week starts on Sunday or\nMonday and whether the return value should be in the range from 0 to\n53 or from 1 to 52. If the mode argument is\nomitted, the value of the default_week_format system variable is\nused (or 0 before MySQL 4.0.14).\nSee also : [Server system variables].\n\nThe following table describes how the mode argument works:\n\n     Value 	 Meaning\n   0 	 Week starts on Sunday; return value range is 0 to\n53; week 1 is the first week that starts in this year\n   1 	 Week starts on Monday; return value range is 0 to\n53; week 1 is the first week that has more than three days in this year\n   2 	 Week starts on Sunday; return value range is 1 to\n53; week 1 is the first week that starts in this year\n   3 	 Week starts on Monday; return value range is 1 to\n53; week 1 is the first week that has more than three days in this year\n   4 	 Week starts on Sunday; return value range is 0 to\n53; week 1 is the first week that has more than three days in this year\n   5 	 Week starts on Monday; return value range is 0 to\n53; week 1 is the first week that starts in this year\n   6 	 Week starts on Sunday; return value range is 1 to\n53; week 1 is the first week that has more than three days in this year\n   7 	 Week starts on Monday; return value range is 1 to\n53; week 1 is the first week that starts in this year\n  \n\nThe mode value of 3 can be used as of MySQL 4.0.5.\nValues of 4 and above can be used as of MySQL 4.0.17.\n','mysql> SELECT WEEK(\'1998-02-20\');\n        -> 7\nmysql> SELECT WEEK(\'1998-02-20\',0);\n        -> 7\nmysql> SELECT WEEK(\'1998-02-20\',1);\n        -> 8\nmysql> SELECT WEEK(\'1998-12-31\',1);\n        -> 53',''),(167,'TO_DAYS',15,'   TO_DAYS(date)\nGiven a date date, returns a daynumber (the number of days since year\n0).\n','mysql> SELECT TO_DAYS(950501);\n        -> 728779\nmysql> SELECT TO_DAYS(\'1997-10-07\');\n        -> 729669',''),(168,'CHECKSUM',19,'\nReports a table checksum.\n\nIf QUICK is specified, the live table checksum is reported if it is\navailable, or NULL otherwise.  This is very fast.  A live checksum\nis enabled by specifying the CHECKSUM=1 table option, currently\nsupported only for MyISAM tables.\nSee also : [CREATE TABLE,  , CREATE TABLE].\n\nIn EXTENDED mode the whole table is read row by row and the checksum\nis calculated. This can be very slow for large tables.\n\nBy default, if neither QUICK nor EXTENDED is specified, MySQL\nreturns a live checksum if the table storage engine supports it and scans\nthe table otherwise.\n\nThis statement is implemented in MySQL 4.1.1.\n\n\n  @subsubsection OPTIMIZE TABLE Syntax\n\n\n\n\nOPTIMIZE [LOCAL | NO_WRITE_TO_BINLOG] TABLE tbl_name [, tbl_name] ...\n\nOPTIMIZE TABLE should be used if you have deleted a large part of a\ntable or if you have made many changes to a table with variable-length rows\n(tables that have VARCHAR, BLOB, or TEXT columns).\nDeleted records are maintained in a linked list and subsequent INSERT\noperations reuse old record positions. You can use OPTIMIZE TABLE to\nreclaim the unused space and to defragment the data file.\n','CHECKSUM TABLE tbl_name [, tbl_name] ... [ QUICK | EXTENDED ]',''),(169,'TIME FUNCTION',15,'   TIME(expr)\n\nExtracts the time part of the time or datetime expression expr.\n','mysql> SELECT TIME(\'2003-12-31 01:02:03\');\n        -> \'01:02:03\'\nmysql> SELECT TIME(\'2003-12-31 01:02:03.000123\');\n        -> \'01:02:03.000123\'',''),(170,'RLIKE',11,'   expr REGEXP pat\n   expr RLIKE pat\nPerforms a pattern match of a string expression expr against a pattern\npat.  The pattern can be an extended regular expression.\nThe syntax for regular expressions is discussed in\n[Regexp].  Returns 1 if expr matches pat, otherwise\nreturns 0.  If either expr or pat is NULL,\nthe result is NULL.  RLIKE is a synonym for REGEXP,\nprovided for\nmSQL compatibility. Note: Because MySQL uses the C escape\nsyntax in strings (for example, \\n to represent newline), you must double any \\ that\nyou use in your REGEXP strings.  As of MySQL 3.23.4,\nREGEXP is not case sensitive for normal (not binary) strings.\n','mysql> SELECT \'Monty!\' REGEXP \'m%y%%\';\n        -> 0\nmysql> SELECT \'Monty!\' REGEXP \'.*\';\n        -> 1\nmysql> SELECT \'new*\\n*line\' REGEXP \'new\\\\*.\\\\*line\';\n        -> 1\nmysql> SELECT \'a\' REGEXP \'A\', \'a\' REGEXP BINARY \'A\';\n        -> 1  0\nmysql> SELECT \'a\' REGEXP \'^[a-d]\';\n        -> 1',''),(171,'PERIOD_ADD',15,'   PERIOD_ADD(P,N)\nAdds N months to period P (in the format YYMM or\nYYYYMM). Returns a value in the format YYYYMM.\nNote that the period argument P is /not/ a date value.\n','mysql> SELECT PERIOD_ADD(9801,2);\n        -> 199803',''),(172,'FOUND_ROWS',20,'\nA SELECT statement may include a LIMIT clause to restrict the\nnumber of rows the server returns to the client.\nIn some cases, it is desirable to know how many rows the statement would have\nreturned without the LIMIT, but without running the statement again.\nTo get this row count, include a SQL_CALC_FOUND_ROWS option in the\nSELECT statement, then invoke FOUND_ROWS() afterward:\n','mysql> SELECT SQL_CALC_FOUND_ROWS * FROM tbl_name\n    -> WHERE id > 100 LIMIT 10;\nmysql> SELECT FOUND_ROWS();',''),(173,'POINTFROMTEXT',17,'   PointFromText(wkt[,srid])\nConstructs a POINT value using its WKT representation and SRID.\n','',''),(174,'BIT_AND',22,'   BIT_AND(expr)\nReturns the bitwise AND of all bits in expr. The calculation is\nperformed with 64-bit (BIGINT) precision.\n','mysql> SELECT order.custid, customer.name, MAX(payments)\n    ->        FROM order,customer\n    ->        WHERE order.custid = customer.custid\n    ->        GROUP BY order.custid;',''),(175,'MICROSECOND',15,'   MICROSECOND(expr)\n\nReturns the microseconds from the time or datetime expression expr as a\nnumber in the range from 0 to 999999.\n','mysql> SELECT MICROSECOND(\'12:00:00.123456\');\n        -> 123456\nmysql> SELECT MICROSECOND(\'1997-12-31 23:59:59.000010\');\n        -> 10',''),(176,'IS NULL',4,'   IS NULL\n   IS NOT NULL\nTests whether a value is or is not NULL.\n','mysql> SELECT 1 IS NULL, 0 IS NULL, NULL IS NULL;\n        -> 0, 0, 1\nmysql> SELECT 1 IS NOT NULL, 0 IS NOT NULL, NULL IS NOT NULL;\n        -> 1, 1, 0',''),(177,'WKT DEFINITION',17,'The Well-Known Text (WKT) representation of Geometry is designed to\nexchange geometry data in ASCII form.\n','',''),(178,'SET SQL_LOG_BIN',26,'SET SQL_LOG_BIN = {0|1}\n\nDisables or enables binary logging for the current connection \n(SQL_LOG_BIN is a session variable)\nif the client connects using an account that has the SUPER privilege.\nThe statement is refused with an error if the client does not have that\nprivilege. (Before MySQL 4.1.2, the statement was simply ignored in that case.)\n','',''),(179,'AVG',22,'   AVG(expr)\nReturns the average value of expr.\n','mysql> SELECT student_name, AVG(test_score)\n    ->        FROM student\n    ->        GROUP BY student_name;',''),(180,'SEC_TO_TIME',15,'   SEC_TO_TIME(seconds)\nReturns the seconds argument, converted to hours, minutes, and seconds,\nas a value in \'HH:MM:SS\' or HHMMSS format, depending on whether\nthe function is used in a string or numeric context.\n','mysql> SELECT SEC_TO_TIME(2378);\n        -> \'00:39:38\'\nmysql> SELECT SEC_TO_TIME(2378) + 0;\n        -> 3938',''),(181,'LONGBLOB',1,'   LONGBLOB\n   LONGTEXT\n\nA BLOB or TEXT column with a maximum length of 4,294,967,295 or\n4GB (2^32 @minus{} 1) characters.  Up to MySQL\n3.23, the client/server protocol and MyISAM tables had a limit\nof 16MB per communication packet / table row. From MySQL 4.0, the maximum\nallowed length of LONGBLOB or LONGTEXT columns depends on the\nconfigured maximum packet size in the client/server protocol and available\nmemory.\n','',''),(182,'CROSSES',25,'   Crosses(g1,g2)\nReturns 1 if g1 spatially crosses g2.\nReturns NULL if g1 is a Polygon or a MultiPolygon,\nor if g2 is a Point or a MultiPoint.\nOtherwise, returns 0.\n\nThe term /spatially crosses/ denotes a spatial relation between two given\ngeometries that has the following properties:\n\n\n --- The two geometries intersect\n\n --- Their intersection results in a geometry that has\na dimension that is one less than the maximum dimension of the two given\ngeometries\n\n --- Their intersection is not equal to either of the two given geometries\n','',''),(183,'GLENGTH',21,'   GLength(ls)\nReturns as a double-precision number the length of the LineString\nvalue ls in its associated spatial reference.\n','mysql> SET @ls = \'LineString(1 1,2 2,3 3)\';\nmysql> SELECT GLength(GeomFromText(@ls));\n+----------------------------+\n| GLength(GeomFromText(@ls)) |\n+----------------------------+\n|            2.8284271247462 |\n+----------------------------+',''),(184,'XOR',27,'   XOR\nLogical XOR.\nReturns NULL if either operand is NULL.\nFor non-NULL operands, evaluates to 1 if an odd number\nof operands is non-zero,\notherwise 0 is returned.\n','mysql> SELECT 1 XOR 1;\n        -> 0\nmysql> SELECT 1 XOR 0;\n        -> 1\nmysql> SELECT 1 XOR NULL;\n        -> NULL\nmysql> SELECT 1 XOR 1 XOR 1;\n        -> 1',''),(185,'NUMGEOMETRIES',9,'   NumGeometries(gc)\nReturns the number of geometries in the GeometryCollection value\ngc.\n','mysql> SET @gc = \'GeometryCollection(Point(1 1),LineString(2 2, 3 3))\';\nmysql> SELECT NumGeometries(GeomFromText(@gc));\n+----------------------------------+\n| NumGeometries(GeomFromText(@gc)) |\n+----------------------------------+\n|                                2 |\n+----------------------------------+',''),(186,'MPOINTFROMTEXT',17,'   MPointFromText(wkt[,srid])\n   MultiPointFromText(wkt[,srid])\nConstructs a MULTIPOINT value using its WKT representation and SRID.\n','',''),(187,'ADDTIME',15,'   ADDTIME(expr,expr2)\n\n\nADDTIME() adds expr2 to expr and returns the result.\nexpr is a date or datetime expression, and expr2 is a time\nexpression.\n','mysql> SELECT ADDTIME(\'1997-12-31 23:59:59.999999\',\n    ->                \'1 1:1:1.000002\');\n        -> \'1998-01-02 01:01:01.000001\'\nmysql> SELECT ADDTIME(\'01:00:00.999999\', \'02:00:00.999998\');\n        -> \'03:00:01.999997\'',''),(188,'AREA',7,'   Area(poly)\nReturns as a double-precision number the area of the Polygon value\npoly, as measured in its spatial reference system.\n','mysql> SET @poly = \'Polygon((0 0,0 3,3 0,0 0),(1 1,1 2,2 1,1 1))\';\nmysql> SELECT Area(GeomFromText(@poly));\n+---------------------------+\n| Area(GeomFromText(@poly)) |\n+---------------------------+\n|                         4 |\n+---------------------------+',''),(189,'MINUTE',15,'   MINUTE(time)\nReturns the minute for time, in the range 0 to 59.\n','mysql> SELECT MINUTE(\'98-02-03 10:05:03\');\n        -> 5',''),(190,'PI',10,'   PI()\nReturns the value of PI. The default number of decimals displayed is five, but\nMySQL internally uses the full double-precision value for PI.\n','mysql> SELECT PI();\n        -> 3.141593\nmysql> SELECT PI()+0.000000000000000000;\n        -> 3.141592653589793116',''),(191,'MBROVERLAPS',6,'   MBROverlaps(g1,g2)\nReturns 1 or 0 to indicate whether or not the Minimum Bounding Rectangles of\nthe two geometries g1 and g2 overlap.\n','',''),(192,'INT',1,'   INT[(M)] [UNSIGNED] [ZEROFILL]\n\nA normal-size integer. The signed range is -2147483648 to\n2147483647.  The unsigned range is 0 to 4294967295.\n\n   INTEGER[(M)] [UNSIGNED] [ZEROFILL]\n\nThis is a synonym for INT.\n','',''),(193,'BETWEEN AND',4,'   expr BETWEEN min AND max\nIf expr is greater than or equal to min and expr is\nless than or equal to max, BETWEEN returns 1,\notherwise it returns 0.  This is equivalent to the expression\n(min <= expr AND expr <= max) if all the arguments are of the\nsame type. Otherwise type conversion takes place according to the rules\ndescribed at the beginning of this section, but applied to all the three\narguments. Note: Before MySQL\n4.0.5, arguments were converted to the type of expr instead.\n','mysql> SELECT 1 BETWEEN 2 AND 3;\n        -> 0\nmysql> SELECT \'b\' BETWEEN \'a\' AND \'c\';\n        -> 1\nmysql> SELECT 2 BETWEEN 2 AND \'3\';\n        -> 1\nmysql> SELECT 2 BETWEEN 2 AND \'x-3\';\n        -> 0',''),(194,'SPACE',11,'   SPACE(N)\nReturns a string consisting of N space characters.\n','mysql> SELECT SPACE(6);\n        -> \'      \'',''),(195,'MAKEDATE',15,'   MAKEDATE(year,dayofyear)\n\nReturns a date, given year and day-of-year values.\ndayofyear must be greater than 0 or the result will be NULL.\n','mysql> SELECT MAKEDATE(2001,31), MAKEDATE(2001,32);\n        -> \'2001-01-31\', \'2001-02-01\'\nmysql> SELECT MAKEDATE(2001,365), MAKEDATE(2004,365);\n        -> \'2001-12-31\', \'2004-12-30\'\nmysql> SELECT MAKEDATE(2001,0);\n        -> NULL',''),(196,'||',27,'   OR\n   ||\nLogical OR.\nEvaluates to 1 if any operand is non-zero,\nto NULL if any operand is NULL,\notherwise 0 is returned.\n','mysql> SELECT 1 || 1;\n        -> 1\nmysql> SELECT 1 || 0;\n        -> 1\nmysql> SELECT 0 || 0;\n        -> 0\nmysql> SELECT 0 || NULL;\n        -> NULL\nmysql> SELECT 1 || NULL;\n        -> 1',''),(197,'TRUE FALSE',16,'TRUE and FALSE added as alias for 1 and 0, respectively.\n','',''),(198,'WEEKOFYEAR',15,'   WEEKOFYEAR(date)\n\nReturns the calendar week of the date as a number in the\nrange from 1 to 53.\n','mysql> SELECT WEEKOFYEAR(\'1998-02-20\');\n        -> 8',''),(199,'RADIANS',10,'   RADIANS(X)\nReturns the argument X, converted from degrees to radians.\n','mysql> SELECT RADIANS(90);\n        -> 1.570796',''),(200,'ISNULL',4,'   ISNULL(expr)\nIf expr is NULL, ISNULL() returns 1, otherwise\nit returns 0.\n','mysql> SELECT ISNULL(1+1);\n        -> 0\nmysql> SELECT ISNULL(1/0);\n        -> 1',''),(201,'EXTERIORRING',7,'   ExteriorRing(poly)\nReturns the exterior ring of the Polygon value poly\nas a LineString.\n','mysql> SET @poly =\n    -> \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\nmysql> SELECT AsText(ExteriorRing(GeomFromText(@poly)));\n+-------------------------------------------+\n| AsText(ExteriorRing(GeomFromText(@poly))) |\n+-------------------------------------------+\n| LINESTRING(0 0,0 3,3 3,3 0,0 0)           |\n+-------------------------------------------+',''),(202,'GEOMETRY HIERARCHY',24,'Geometry is the base class. It\'s an abstract class.\nThe instantiable subclasses of Geometry are restricted to zero-, one-,\nand two-dimensional geometric objects that exist in\ntwo-dimensional coordinate space. All instantiable geometry classes are\ndefined so that valid instances of a geometry class are topologically closed\n(that is, all defined geometries include their boundary).\n\nThe base Geometry class has subclasses for Point,\nCurve, Surface, and GeometryCollection:\n\n\n --- Point represents zero-dimensional objects.\n\n --- Curve represents one-dimensional objects, and has subclass\nLineString, with sub-subclasses Line and LinearRing.\n\n --- Surface is designed for two-dimensional objects and\nhas subclass Polygon.\n\n --- GeometryCollection\nhas specialized zero-, one-, and two-dimensional collection classes named\nMultiPoint, MultiLineString, and MultiPolygon\nfor modeling geometries corresponding to collections of\nPoints, LineStrings, and Polygons, respectively.\nMultiCurve and MultiSurface are introduced as abstract superclasses\nthat generalize the collection interfaces to handle Curves and Surfaces.\n\n\nGeometry, Curve, Surface, MultiCurve,\nand MultiSurface are defined as non-instantiable classes.\nThey define a common set of methods for their subclasses and\nare included for extensibility.\n\nPoint, LineString, Polygon, GeometryCollection,\nMultiPoint, MultiLineString, and\nMultiPolygon are instantiable classes.\n','',''),(203,'POINT',2,'   Point(x,y)\nConstructs a WKB Point using its coordinates.\n','',''),(204,'SHOW SLAVE HOSTS',26,'SHOW SLAVE HOSTS\n\nDisplays a list of slaves currently registered with the master. \nAny slave not started with the --report-host=slave_name \noption will not be visible in that list.\n','',''),(205,'EXPLAIN',26,'The EXPLAIN statement can be used either as a synonym for\nDESCRIBE or as a way to obtain information about how MySQL will execute\na SELECT statement:\n\n --- The EXPLAIN tbl_name syntax is synonymous with DESCRIBE tbl_name\nor\nSHOW COLUMNS FROM tbl_name.\n --- When you precede a SELECT statement with the keyword EXPLAIN,\nMySQL explains how it would process the SELECT, providing\ninformation about how tables are joined and in which order.\n','EXPLAIN tbl_name',''),(206,'NOW',15,'   NOW()\n\nReturns the current date and time as a value in \'YYYY-MM-DD HH:MM:SS\'\nor YYYYMMDDHHMMSS format, depending on whether the function is used in\na string or numeric context.\n','mysql> SELECT NOW();\n        -> \'1997-12-15 23:50:26\'\nmysql> SELECT NOW() + 0;\n        -> 19971215235026',''),(207,'UNHEX',11,'   UNHEX(str)\n\nDoes the opposite of HEX(string). That is, it interprets each pair of\nhexadecimal digits in the argument as a number and converts it to the\ncharacter represented by the number. The resulting characters are returned as\na binary string.\n','mysql> SELECT UNHEX(\'4D7953514C\');\n        -> \'MySQL\'\nmysql> SELECT 0x4D7953514C;\n        -> \'MySQL\'\nmysql> SELECT UNHEX(HEX(\'string\'));\n        -> \'string\'\nmysql> SELECT HEX(UNHEX(\'1267\'));\n        -> \'1267\'',''),(208,'UTC_TIMESTAMP',15,'   UTC_TIMESTAMP\n   UTC_TIMESTAMP()\nReturns the current UTC date and time as a value in \'YYYY-MM-DD HH:MM:SS\'\nor YYYYMMDDHHMMSS format, depending on whether the function is used in\na string or numeric context.\n','mysql> SELECT UTC_TIMESTAMP(), UTC_TIMESTAMP() + 0;\n        -> \'2003-08-14 18:08:04\', 20030814180804',''),(209,'NUMINTERIORRINGS',7,'   NumInteriorRings(poly)\nReturns the number of interior rings in the Polygon value poly.\n','mysql> SET @poly =\n    -> \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\nmysql> SELECT NumInteriorRings(GeomFromText(@poly));\n+---------------------------------------+\n| NumInteriorRings(GeomFromText(@poly)) |\n+---------------------------------------+\n|                                     1 |\n+---------------------------------------+',''),(210,'AES_DECRYPT',8,'   AES_ENCRYPT(str,key_str)\n   AES_DECRYPT(crypt_str,key_str)\nThese functions allow encryption and decryption of data using the official\nAES (Advanced Encryption Standard) algorithm, previously known as \"Rijndael.\"\nEncoding with a 128-bit key length is used, but you can extend it up to\n256 bits by modifying the source. We chose 128 bits because it is much\nfaster and it is usually secure enough.\n\nThe input arguments may be any length. If either argument is NULL,\nthe result of this function is also NULL.\n\nBecause AES is a block-level algorithm, padding is used to encode uneven length\nstrings and so the result string length may be calculated as\n16*(trunc(string_length/16)+1).\n\nIf AES_DECRYPT() detects invalid data or incorrect padding, it\nreturns NULL. However, it is possible for AES_DECRYPT()\nto return a non-NULL value (possibly garbage) if the input data or\nthe key is invalid.\n\nYou can use the AES functions to store data in an encrypted form by\nmodifying your queries:\n','INSERT INTO t VALUES (1,AES_ENCRYPT(\'text\',\'password\'));',''),(211,'MD5',8,'   MD5(str)\nCalculates an MD5 128-bit checksum for the string. The value is returned\nas a string of 32 hex digits,\nor NULL if the argument was NULL.\nThe return value can, for example, be used as a hash key.\n','mysql> SELECT MD5(\'testing\');\n        -> \'ae2b1fca515949e5d54fb22b8ed95575\'',''),(212,'DELETE',26,'DELETE deletes rows from tbl_name that satisfy the condition\ngiven by where_definition, and returns the number of records deleted.\n\nIf you issue a DELETE statement with no WHERE clause, all\nrows are deleted.  A faster way to do this, when you don\'t want to know\nthe number of deleted rows, is to use TRUNCATE TABLE.\nSee also : [TRUNCATE,  , TRUNCATE].\n','DELETE [LOW_PRIORITY] [QUICK] [IGNORE] FROM tbl_name\n       [WHERE where_definition]\n       [ORDER BY ...]\n       [LIMIT row_count]',''),(213,'DIMENSION',13,'   Dimension(g)\nReturns the inherent dimension of the geometry value g. The result\ncan be @minus{}1, 0, 1, or 2. (The meaning of these values is given in\n[GIS class geometry].)\n','mysql> SELECT Dimension(GeomFromText(\'LineString(1 1,2 2)\'));\n+------------------------------------------------+\n| Dimension(GeomFromText(\'LineString(1 1,2 2)\')) |\n+------------------------------------------------+\n|                                              1 |\n+------------------------------------------------+',''),(214,'TIME',1,'   TIME\n\nA time.  The range is \'-838:59:59\' to \'838:59:59\'.\nMySQL displays TIME values in \'HH:MM:SS\' format, but\nallows you to assign values to TIME columns using either strings or\nnumbers.\n','',''),(215,'LAST_DAY',15,'   LAST_DAY(date)\n\nTakes a date or datetime value and returns the corresponding value for the\nlast day of the month.  Returns NULL if the argument is invalid.\n','mysql> SELECT LAST_DAY(\'2003-02-05\');\n        -> \'2003-02-28\'\nmysql> SELECT LAST_DAY(\'2004-02-05\');\n        -> \'2004-02-29\'\nmysql> SELECT LAST_DAY(\'2004-01-01 01:01:01\');\n        -> \'2004-01-31\'\nmysql> SELECT LAST_DAY(\'2003-03-32\');\n        -> NULL',''),(216,'ENVELOPE',13,'   Envelope(g)\nReturns the Minimum Bounding Rectangle (MBR) for the geometry value g.\nThe result is returned as a Polygon value.\n\nmysql> SELECT AsText(Envelope(GeomFromText(\'LineString(1 1,2 2)\')));\n+-------------------------------------------------------+\n| AsText(Envelope(GeomFromText(\'LineString(1 1,2 2)\'))) |\n+-------------------------------------------------------+\n| POLYGON((1 1,2 1,2 2,1 2,1 1))                        |\n+-------------------------------------------------------+\n\nThe polygon is defined by the corner points of the bounding box:\n\nPOLYGON((MINX MINY, MAXX MINY, MAXX MAXY, MINX MAXY, MINX MINY))\n','',''),(217,'POLYGON',2,'   Polygon(ls1,ls2,...)\nConstructs a WKB Polygon value from a number of WKB LineString\narguments. If any argument does not represent the WKB of a LinearRing\n(that is, not a closed and simple LineString) the return value\nis NULL.\n','',''),(218,'NOT IN',4,'   expr NOT IN (value,...)\nThis is the same as NOT (expr IN (value,...)).\n','',''),(219,'INSERT',11,'   INSERT(str,pos,len,newstr)\nReturns the string str, with the substring beginning at position\npos and len characters long replaced by the string\nnewstr.\n','mysql> SELECT INSERT(\'Quadratic\', 3, 4, \'What\');\n        -> \'QuWhattic\'',''),(220,'PERIOD_DIFF',15,'   PERIOD_DIFF(P1,P2)\nReturns the number of months between periods P1 and P2.\nP1 and P2 should be in the format YYMM or YYYYMM.\nNote that the period arguments P1 and P2 are /not/\ndate values.\n','mysql> SELECT PERIOD_DIFF(9802,199703);\n        -> 11',''),(221,'DISTANCE',25,'   Distance(g1,g2)\nReturns as a double-precision number\nthe shortest distance between any two points in the two geometries.\n','',''),(222,'ELT',11,'   ELT(N,str1,str2,str3,...)\nReturns str1 if N = 1, str2 if N =\n2, and so on.  Returns NULL if N is less than 1\nor greater than the number of arguments.  ELT() is the complement of\nFIELD().\n','mysql> SELECT ELT(1, \'ej\', \'Heja\', \'hej\', \'foo\');\n        -> \'ej\'\nmysql> SELECT ELT(4, \'ej\', \'Heja\', \'hej\', \'foo\');\n        -> \'foo\'',''),(223,'COUNT',22,'   COUNT(expr)\nReturns a count of the number of non-NULL values in the rows\nretrieved by a SELECT statement.\n','mysql> SELECT student.student_name,COUNT(*)\n    ->        FROM student,course\n    ->        WHERE student.student_id=course.student_id\n    ->        GROUP BY student_name;',''),(224,'PURGE MASTER LOGS BEFORE TO',26,'PURGE {MASTER | BINARY} LOGS TO \'log_name\'\nPURGE {MASTER | BINARY} LOGS BEFORE \'date\'\n\nDeletes all the binary logs listed in the log\nindex that are strictly prior to the specified log or date.\nThe logs also are removed from the list recorded in the log index file,\nso that the given log becomes the first. \n','',''),(225,'SET PASSWORD',19,'','SET PASSWORD = PASSWORD(\'some password\')\nSET PASSWORD FOR user = PASSWORD(\'some password\')',''),(226,'DROP DATABASE',3,'DROP DATABASE drops all tables in the database and deletes the\ndatabase.  Be /very/ careful with this statement!\nTo use DROP DATABASE, you need the DROP privilege on the\ndatabase.\n\nIn MySQL 3.22 or later, you can use the keywords IF EXISTS\nto prevent an error from occurring if the database doesn\'t exist.\n','DROP DATABASE [IF EXISTS] db_name',''),(227,'MIN MAX',22,'   MIN(expr)\n   MAX(expr)\nReturns the minimum or maximum value of expr.  MIN() and\nMAX() may take a string argument; in such cases they return the\nminimum or maximum string value. See also : [MySQL indexes].\n','mysql> SELECT student_name, MIN(test_score), MAX(test_score)\n    ->        FROM student\n    ->        GROUP BY student_name;',''),(228,'COUNT DISTINCT',22,'   COUNT(DISTINCT expr,[expr...])\nReturns a count of the number of different non-NULL values.\n','mysql> SELECT COUNT(DISTINCT results) FROM student;',''),(229,'MBRDISJOINT',6,'   MBRDisjoint(g1,g2)\nReturns 1 or 0 to indicate whether or not the Minimum Bounding Rectangles of\nthe two geometries g1 and g2 are disjoint (do not intersect).\n','',''),(230,'LOG10',10,'   LOG10(X)\nReturns the base-10 logarithm of X.\n','mysql> SELECT LOG10(2);\n        -> 0.301030\nmysql> SELECT LOG10(100);\n        -> 2.000000\nmysql> SELECT LOG10(-100);\n        -> NULL',''),(231,'SYSDATE',15,'   SYSDATE()\n\nSYSDATE() is a synonym for NOW().\n','',''),(232,'TIMESTAMP FUNCTION',15,'   TIMESTAMP(expr)\n   TIMESTAMP(expr,expr2)\n\nWith one argument, returns the date or datetime expression expr\nas a datetime value.\nWith two arguments, adds the time expression expr2 to the\ndate or datetime expression expr and returns a datetime value.\n','mysql> SELECT TIMESTAMP(\'2003-12-31\');\n        -> \'2003-12-31 00:00:00\'\nmysql> SELECT TIMESTAMP(\'2003-12-31 12:00:00\',\'12:00:00\');\n        -> \'2004-01-01 00:00:00\'',''),(233,'FUNCTION',16,'A user-defined function (UDF) is a way to extend MySQL with a new\nfunction that works like native (built in) MySQL function such as\nABS() and CONCAT().\n\nAGGREGATE is a new option for MySQL 3.23.  An\nAGGREGATE function works exactly like a native MySQL\nGROUP function like SUM or COUNT().\n\nCREATE FUNCTION saves the function\'s name, type, and shared library\nname in the mysql.func system table.  You must have the\nINSERT and DELETE privileges for the mysql database\nto create and drop functions.\n','CREATE [AGGREGATE] FUNCTION function_name RETURNS {STRING|REAL|INTEGER}\n       SONAME shared_library_name\n\nDROP FUNCTION function_name',''),(234,'LINEFROMWKB',5,'   LineFromWKB(wkb[,srid])\n   LineStringFromWKB(wkb[,srid])\nConstructs a LINESTRING value using its WKB representation and SRID.\n','',''),(235,'GEOMETRYN',9,'   GeometryN(gc,n)\nReturns the n-th geometry in the GeometryCollection value\ngc.  Geometry numbers begin at 1.\n','mysql> SET @gc = \'GeometryCollection(Point(1 1),LineString(2 2, 3 3))\';\nmysql> SELECT AsText(GeometryN(GeomFromText(@gc),1));\n+----------------------------------------+\n| AsText(GeometryN(GeomFromText(@gc),1)) |\n+----------------------------------------+\n| POINT(1 1)                             |\n+----------------------------------------+',''),(236,'&&',27,'   AND\n   &&\nLogical AND.\nEvaluates to 1 if all operands are non-zero and not NULL,\nto 0 if one or more operands are 0,\notherwise NULL is returned.\n','mysql> SELECT 1 && 1;\n        -> 1\nmysql> SELECT 1 && 0;\n        -> 0\nmysql> SELECT 1 && NULL;\n        -> NULL\nmysql> SELECT 0 && NULL;\n        -> 0\nmysql> SELECT NULL && 0;\n        -> 0',''),(237,'ENCODE',8,'   ENCODE(str,pass_str)\nEncrypt str using pass_str as the password.\nTo decrypt the result, use DECODE().\n\nThe result is a binary string of the same length as str.\nIf you want to save it in a column, use a BLOB column type.\n','',''),(238,'ATAN',10,'   ATAN(X)\nReturns the arc tangent of X, that is, the value whose tangent is\nX.\n','mysql> SELECT ATAN(2);\n        -> 1.107149\nmysql> SELECT ATAN(-2);\n        -> -1.107149',''),(239,'POWER',10,'   POW(X,Y)\n   POWER(X,Y)\nReturns the value of X raised to the power of Y.\n','mysql> SELECT POW(2,2);\n        -> 4.000000\nmysql> SELECT POW(2,-2);\n        -> 0.250000',''),(240,'MASTER_POS_WAIT',18,'   MASTER_POS_WAIT(log_name,log_pos[,timeout])\n\nThis function is useful for control of master/slave synchronization.\nIt blocks until the slave has read and applied all updates up to the specified\nposition in the master log.\nThe return value is the number of log events it had to wait for to get to\nthe specified position.  The function returns NULL if the slave SQL thread\nis not started, the slave\'s master information is not initialized, the\narguments are incorrect, or an error occurs. It returns -1 if the\ntimeout has been exceeded. If the slave SQL thread stops while\nMASTER_POS_WAIT() is waiting, the function returns NULL.\nIf the slave is already past the specified position, the function returns\nimmediately.\n','SELECT MASTER_POS_WAIT(\'master_log_file\', master_log_pos)',''),(241,'DROP INDEX',3,'DROP INDEX drops the index named index_name from the table\ntbl_name.  In MySQL 3.22 or later, DROP INDEX is mapped to an\nALTER TABLE statement to drop the index.  See also : [ALTER TABLE, ,\nALTER TABLE].  DROP INDEX doesn\'t do anything prior to MySQL\n3.22.\n','DROP INDEX index_name ON tbl_name',''),(242,'CONNECTION_ID',20,'   CONNECTION_ID()\nReturns the connection ID (thread ID) for the connection.\nEvery connection has its own unique ID.\n','mysql> SELECT CONNECTION_ID();\n        -> 23786',''),(243,'ALTER DATABASE',3,'\nALTER DATABASE allows you to change the overall characteristics of a\ndatabase.  These characteristics are stored in the *db.opt file in the\ndatabase directory.\nTo use ALTER DATABASE, you need the ALTER privilege on the\ndatabase.\n','ALTER DATABASE db_name\n    alter_specification [, alter_specification] ...\n\nalter_specification:\n    [DEFAULT] CHARACTER SET charset_name\n  | [DEFAULT] COLLATE collation_name',''),(244,'JOIN',26,'MySQL supports the following JOIN syntaxes for the\ntable_references part of SELECT statements and multiple-table\nDELETE and UPDATE statements:\n\ntable_reference, table_reference\ntable_reference [INNER | CROSS] JOIN table_reference [join_condition]\ntable_reference STRAIGHT_JOIN table_reference\ntable_reference LEFT [OUTER] JOIN table_reference [join_condition]\ntable_reference NATURAL [LEFT [OUTER]] JOIN table_reference\n{ OJ table_reference LEFT OUTER JOIN table_reference\n    ON conditional_expr }\ntable_reference RIGHT [OUTER] JOIN table_reference [join_condition]\ntable_reference NATURAL [RIGHT [OUTER]] JOIN table_reference\n\ntable_reference is defined as:\n\ntbl_name [[AS] alias]\n    [[USE INDEX (key_list)]\n      | [IGNORE INDEX (key_list)]\n      | [FORCE INDEX (key_list)]]\n\njoin_condition is defined as:\n\nON conditional_expr | USING (column_list)\n','mysql> SELECT table1.* FROM table1\n    ->        LEFT JOIN table2 ON table1.id=table2.id\n    ->        WHERE table2.id IS NULL;',''),(245,'MULTIPOLYGON',2,'   MultiPolygon(poly1,poly2,...)\nConstructs a WKB MultiPolygon value from a set of WKB Polygon\narguments.\nIf any argument is not a WKB Polygon, the rerurn value is NULL.\n','',''),(246,'LOAD DATA FROM MASTER',26,'LOAD DATA FROM MASTER\n\nTakes a snapshot of the master and copies it to the slave.  It updates the\nvalues of MASTER_LOG_FILE and MASTER_LOG_POS so that the slave\nwill start replicating from the correct position. Any table and database\nexclusion rules specified with the --replicate-*-do-* and\n--replicate-*-ignore-* options are honored.\n--replicate-rewrite-db is /not/ taken into account (because one user\ncould, with this option, set up a non-unique mapping such as\n--replicate-rewrite-db=db1->db3 and\n--replicate-rewrite-db=db2->db3, which would confuse the slave when\nit loads the master\'s tables).\n\nUse of this statement is subject to the following conditions:\n\n\n --- It works only with MyISAM tables.\n\n --- It acquires a global read lock on the master while taking the snapshot,\nwhich prevents updates on the master during the load operation.\n\n\nIn the future, it is planned to make this statement work with\nInnoDB tables and to remove the need for a global read lock by using\nnon-blocking online backup.\n\nIf you are loading big tables, you might have to increase the values\nof net_read_timeout and net_write_timeout\non both your master and slave servers.\nSee also : [Server system variables].\n\nNote that LOAD DATA FROM MASTER does /not/ copy any\ntables from the mysql database.  This makes it easy to have\ndifferent users and privileges on the master and the slave.\n\nThe LOAD DATA FROM MASTER statement\nrequires the replication account that is used to connect to the master\nto have the RELOAD and SUPER privileges on the master and the\nSELECT privilege for all master tables you want to load. All\nmaster tables for which the user does not have the SELECT privilege are\nignored by LOAD DATA FROM MASTER. This is because the\nmaster will hide them from the user: LOAD DATA FROM MASTER calls\nSHOW DATABASES to know the master databases to load, but\nSHOW DATABASES returns only databases for which the user has\nsome privilege.\nSee [Show database info].\nOn the slave\'s side, the user that issues LOAD DATA FROM MASTER should\nhave grants to drop and create the databases and tables that are copied.\n','',''),(247,'CHAR BYTE',16,'CHAR BYTE is an alias for CHAR BINARY.\n','',''),(248,'SRID',13,'   SRID(g)\nReturns an integer indicating the Spatial Reference System ID for the geometry\nvalue g.\n','mysql> SELECT SRID(GeomFromText(\'LineString(1 1,2 2)\',101));\n+-----------------------------------------------+\n| SRID(GeomFromText(\'LineString(1 1,2 2)\',101)) |\n+-----------------------------------------------+\n|                                           101 |\n+-----------------------------------------------+',''),(249,'DATE OPERATIONS',15,'   DATE_ADD(date,INTERVAL expr type)\n   DATE_SUB(date,INTERVAL expr type)\n\nThese functions perform date arithmetic.\ndate is a DATETIME or DATE value specifying the starting\ndate.  expr is an expression specifying the interval value to be added\nor subtracted from the starting date.  expr is a string; it may start\nwith a - for negative intervals.  type is a keyword indicating\nhow the expression should be interpreted.\n','mysql> SELECT \'1997-12-31 23:59:59\' + INTERVAL 1 SECOND;\n        -> \'1998-01-01 00:00:00\'\nmysql> SELECT INTERVAL 1 DAY + \'1997-12-31\';\n        -> \'1998-01-01\'\nmysql> SELECT \'1998-01-01\' - INTERVAL 1 SECOND;\n        -> \'1997-12-31 23:59:59\'\nmysql> SELECT DATE_ADD(\'1997-12-31 23:59:59\',\n    ->                 INTERVAL 1 SECOND);\n        -> \'1998-01-01 00:00:00\'\nmysql> SELECT DATE_ADD(\'1997-12-31 23:59:59\',\n    ->                 INTERVAL 1 DAY);\n        -> \'1998-01-01 23:59:59\'\nmysql> SELECT DATE_ADD(\'1997-12-31 23:59:59\',\n    ->                 INTERVAL \'1:1\' MINUTE_SECOND);\n        -> \'1998-01-01 00:01:00\'\nmysql> SELECT DATE_SUB(\'1998-01-01 00:00:00\',\n    ->                 INTERVAL \'1 1:1:1\' DAY_SECOND);\n        -> \'1997-12-30 22:58:59\'\nmysql> SELECT DATE_ADD(\'1998-01-01 00:00:00\',\n    ->                 INTERVAL \'-1 10\' DAY_HOUR);\n        -> \'1997-12-30 14:00:00\'\nmysql> SELECT DATE_SUB(\'1998-01-02\', INTERVAL 31 DAY);\n        -> \'1997-12-02\'\nmysql> SELECT DATE_ADD(\'1992-12-31 23:59:59.000002\',\n    ->            INTERVAL \'1.999999\' SECOND_MICROSECOND);\n        -> \'1993-01-01 00:00:01.000001\'',''),(250,'MPOLYFROMWKB',5,'   MPolyFromWKB(wkb[,srid])\n   MultiPolygonFromWKB(wkb[,srid])\nConstructs a MULTIPOLYGON value using its WKB representation and SRID.\n','',''),(251,'FLUSH',26,'You should use the FLUSH statement if you want to clear some of the\ninternal caches MySQL uses.  To execute FLUSH, you must have\nthe RELOAD privilege.\n','FLUSH [LOCAL | NO_WRITE_TO_BINLOG] flush_option [, flush_option] ...',''),(252,'IS_USED_LOCK',18,'   IS_USED_LOCK(str)\nChecks whether the lock named str is in use (that is, locked).\nIf so, it returns the connection identifier of the client that holds\nthe lock.\nOtherwise, it returns NULL.\n','',''),(253,'SESSION_USER',20,'   SESSION_USER()\n\nSESSION_USER() is a synonym for USER().\n','',''),(254,'BIGINT',1,'   BIGINT[(M)] [UNSIGNED] [ZEROFILL]\nA large integer. The signed range is -9223372036854775808 to\n9223372036854775807. The unsigned range is 0 to\n18446744073709551615.\n','',''),(255,'DAY',15,'   DAY(date)\n\nDAY() is a synonym for DAYOFMONTH().\nIt is available as of MySQL 4.1.1.\n','',''),(256,'MATCH AGAINST',11,'As of MySQL 3.23.23, MySQL has support for full-text indexing\nand searching.  A full-text index in MySQL is an index of type\nFULLTEXT.  FULLTEXT indexes are used with MyISAM tables\nonly and can be created from CHAR, VARCHAR,\nor TEXT columns at CREATE TABLE time or added later with\nALTER TABLE or CREATE INDEX.  For large datasets, it will be\nmuch faster to load your data into a table that has no FULLTEXT\nindex, then create the index with ALTER TABLE (or\nCREATE INDEX).  Loading data into a table that already has a\nFULLTEXT index could be significantly slower.\n','mysql> SELECT id, body, MATCH (title,body) AGAINST\n    -> (\'Security implications of running MySQL as root\') AS score\n    -> FROM articles WHERE MATCH (title,body) AGAINST\n    -> (\'Security implications of running MySQL as root\');\n+----+-------------------------------------+-----------------+\n| id | body                                | score           |\n+----+-------------------------------------+-----------------+\n|  4 | 1. Never run mysqld as root. 2. ... | 1.5219271183014 |\n|  6 | When configured properly, MySQL ... | 1.3114095926285 |\n+----+-------------------------------------+-----------------+\n2 rows in set (0.00 sec)',''),(257,'DROP TABLE',3,'DROP TABLE removes one or more tables. You must have the DROP\nprivilege for each table. All table data and the table\ndefinition are /removed/, so /be careful/ with this statement!\n\nIn MySQL 3.22 or later, you can use the keywords IF EXISTS\nto prevent an error from occurring for tables that don\'t exist.  As of\nMySQL 4.1, a NOTE is generated for each non-existent table when\nusing IF EXISTS.\nSee also : [SHOW WARNINGS].\n\nRESTRICT and CASCADE are allowed to make porting easier.\nFor the moment, they do nothing.\n\nNote: DROP TABLE automatically commits the current\nactive transaction, unless you are using MySQL 4.1 or higher and the\nTEMPORARY keyword.\n','DROP [TEMPORARY] TABLE [IF EXISTS]\n    tbl_name [, tbl_name] ...\n    [RESTRICT | CASCADE]',''),(258,'HOUR',15,'   HOUR(time)\nReturns the hour for time. The range of the return value will be\n0 to 23 for time-of-day values.\n','mysql> SELECT HOUR(\'10:05:03\');\n        -> 10',''),(259,'SELECT',26,'SELECT is used to retrieve rows selected from one or more tables.\nSupport for UNION statements and subqueries is available as of MySQL\n4.0 and 4.1, respectively.\nSee [UNION,  , UNION] and [Subqueries].\n\n --- Each select_expr indicates a column you want to retrieve.\n\n --- table_references indicates the table or tables from which to retrieve rows.\nIts syntax is described in [JOIN,  , JOIN].\n\n --- where_definition indicates any conditions that selected rows must\nsatisfy.\n\n\nSELECT can also be used to retrieve rows computed without reference to\nany table.  \n','SELECT\n    [ALL | DISTINCT | DISTINCTROW ]\n      [HIGH_PRIORITY]\n      [STRAIGHT_JOIN]\n      [SQL_SMALL_RESULT] [SQL_BIG_RESULT] [SQL_BUFFER_RESULT]\n      [SQL_CACHE | SQL_NO_CACHE] [SQL_CALC_FOUND_ROWS]\n    select_expr,...\n    [INTO OUTFILE \'file_name\' export_options\n      | INTO DUMPFILE \'file_name\']\n    [FROM table_references\n      [WHERE where_definition]\n      [GROUP BY {col_name | expr | position}\n        [ASC | DESC], ... [WITH ROLLUP]]\n      [HAVING where_definition]\n      [ORDER BY {col_name | expr | position}\n        [ASC | DESC] ,...]\n      [LIMIT {[offset,] row_count | row_count OFFSET offset}]\n      [PROCEDURE procedure_name(argument_list)]\n      [FOR UPDATE | LOCK IN SHARE MODE]]',''),(260,'COERCIBILITY',20,'   COERCIBILITY(str)\nReturns the collation coercibility value of the string argument.\n','mysql> SELECT COERCIBILITY(\'abc\' COLLATE latin1_swedish_ci);\n        -> 0\nmysql> SELECT COERCIBILITY(\'abc\');\n        -> 3\nmysql> SELECT COERCIBILITY(USER());\n        -> 2',''),(261,'MPOINTFROMWKB',5,'   MPointFromWKB(wkb[,srid])\n   MultiPointFromWKB(wkb[,srid])\nConstructs a MULTIPOINT value using its WKB representation and SRID.\n','',''),(262,'CHARSET',20,'   CHARSET(str)\nReturns the character set of the string argument.\n','mysql> SELECT CHARSET(\'abc\');\n        -> \'latin1\'\nmysql> SELECT CHARSET(CONVERT(\'abc\' USING utf8));\n        -> \'utf8\'\nmysql> SELECT CHARSET(USER());\n        -> \'utf8\'',''),(263,'DO',26,'DO executes the expressions but doesn\'t return any results.  This is\nshorthand for SELECT expr, ..., but has the advantage that it\'s\nslightly faster when you don\'t care about the result.\n\nDO is useful mainly with functions that have side effects, such as\nRELEASE_LOCK().\n','DO expr [, expr] ...',''),(264,'MONTHNAME',15,'   MONTHNAME(date)\nReturns the full name of the month for date.\n','mysql> SELECT MONTHNAME(\'1998-02-05\');\n        -> \'February\'',''),(265,'TOUCHES',25,'   Touches(g1,g2)\nReturns 1 or 0 to indicate whether or not g1 spatially touches\ng2. Two geometries /spatially touch/ if the interiors of\nthe geometries do not intersect, but the boundary of one of the geometries\nintersects either the boundary or the interior of the other.\n','',''),(266,'ALTER TABLE',3,'ALTER TABLE allows you to change the structure of an existing table.\nFor example, you can add or delete columns, create or destroy indexes, change\nthe type of existing columns, or rename columns or the table itself.  You can\nalso change the comment for the table and type of the table.\n','ALTER [IGNORE] TABLE tbl_name\n    alter_specification [, alter_specification] ...\n\nalter_specification:\n    ADD [COLUMN] column_definition [FIRST | AFTER col_name ]\n  | ADD [COLUMN] (column_definition,...)\n  | ADD INDEX [index_name] [index_type] (index_col_name,...)\n  | ADD [CONSTRAINT [symbol]]\n        PRIMARY KEY [index_type] (index_col_name,...)\n  | ADD [CONSTRAINT [symbol]]\n        UNIQUE [index_name] [index_type] (index_col_name,...)\n  | ADD [FULLTEXT|SPATIAL] [index_name] (index_col_name,...)\n  | ADD [CONSTRAINT [symbol]]\n        FOREIGN KEY [index_name] (index_col_name,...)\n        [reference_definition]\n  | ALTER [COLUMN] col_name {SET DEFAULT literal | DROP DEFAULT}\n  | CHANGE [COLUMN] old_col_name column_definition\n        [FIRST|AFTER col_name]\n  | MODIFY [COLUMN] column_definition [FIRST | AFTER col_name]\n  | DROP [COLUMN] col_name\n  | DROP PRIMARY KEY\n  | DROP INDEX index_name\n  | DROP FOREIGN KEY fk_symbol\n  | DISABLE KEYS\n  | ENABLE KEYS\n  | RENAME [TO] new_tbl_name\n  | ORDER BY col_name\n  | CONVERT TO CHARACTER SET charset_name [COLLATE collation_name]\n  | [DEFAULT] CHARACTER SET charset_name [COLLATE collation_name]\n  | DISCARD TABLESPACE\n  | IMPORT TABLESPACE\n  | table_options',''),(267,'HEX',11,'   HEX(N_or_S)\n\nIf N_OR_S is a number, returns a string representation of the hexadecimal\nvalue of N, where N is a longlong (BIGINT) number.\nThis is equivalent to CONV(N,10,16).\n\nFrom MySQL 4.0.1 and up,\nif N_OR_S is a string, returns a hexadecimal string of N_OR_S\nwhere each character in N_OR_S is converted to two hexadecimal digits.\n','mysql> SELECT HEX(255);\n        -> \'FF\'\nmysql> SELECT 0x616263;\n        -> \'abc\'\nmysql> SELECT HEX(\'abc\');\n        -> 616263',''),(268,'RIGHT',11,'   RIGHT(str,len)\nReturns the rightmost len characters from the string str.\n','mysql> SELECT RIGHT(\'foobarbar\', 4);\n        -> \'rbar\'',''),(269,'TIMESTAMP',1,'   TIMESTAMP[(M)]\n\nA timestamp.  The range is \'1970-01-01 00:00:00\' to partway through the\nyear 2037.\n\nA TIMESTAMP column is useful for recording the date and time of an\nINSERT or UPDATE operation. The first TIMESTAMP column\nin a table is automatically set to the date and time of the most recent\noperation if you don\'t assign it a value yourself.  You can also set any\nTIMESTAMP column to the current date and time by assigning it a\nNULL value.\n\nFrom MySQL 4.1 on, TIMESTAMP is returned as a string with the format\n\'YYYY-MM-DD HH:MM:SS\'. If you want to obtain the value as a number,\nyou should add +0 to the timestamp column. Different timestamp\ndisplay widths are not supported.\n\nIn MySQL 4.0 and earlier, TIMESTAMP values are displayed in\nYYYYMMDDHHMMSS, YYMMDDHHMMSS, YYYYMMDD, or YYMMDD\nformat, depending on whether M is 14 (or missing), 12,\n8, or 6, but allows you to assign values to TIMESTAMP\ncolumns using either strings or numbers.\nThe M argument affects only how a TIMESTAMP column is displayed,\nnot storage.  Its values always are stored using four bytes each.\nFrom MySQL 4.0.12, the --new option can be used\nto make the server behave as in MySQL 4.1.\n\nNote that TIMESTAMP(M) columns where M is 8 or 14 are reported to\nbe numbers, whereas other TIMESTAMP(M) columns are reported to be\nstrings.  This is just to ensure that you can reliably dump and restore\nthe table with these types.\n','',''),(270,'MAKETIME',15,'   MAKETIME(hour,minute,second)\n\nReturns a time value calculated from the hour, minute, and\nsecond arguments.\n','mysql> SELECT MAKETIME(12,15,30);\n        -> \'12:15:30\'',''),(271,'INTERIORRINGN',7,'   InteriorRingN(poly,n)\nReturns the n-th interior ring for the Polygon value\npoly as a LineString.\nRing numbers begin at 1.\n','mysql> SET @poly =\n    -> \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\nmysql> SELECT AsText(InteriorRingN(GeomFromText(@poly),1));\n+----------------------------------------------+\n| AsText(InteriorRingN(GeomFromText(@poly),1)) |\n+----------------------------------------------+\n| LINESTRING(1 1,1 2,2 2,2 1,1 1)              |\n+----------------------------------------------+',''),(272,'STR_TO_DATE',15,'   STR_TO_DATE(str,format)\nThis is the reverse function of the DATE_FORMAT() function. It takes a \nstring str and a format string format, and returns a \nDATETIME value.\nThe date, time, or datetime values contained in str should be given \nin the format indicated by format. For the specifiers that can be \nused in format, see the table in the DATE_FORMAT() function \ndescription. All other characters are just taken verbatim, thus not being \ninterpreted.\nIf str contains an illegal date, time, or datetime value, \nSTR_TO_DATE() returns NULL.\n','@c next example commented out until format string becomes optional\n@c mysql> SELECT STR_TO_DATE(\'2003-10-03\');\n@c         -> 2003-10-03 00:00:00\nmysql> SELECT STR_TO_DATE(\'03.10.2003 09.20\',\n    ->                    \'%d.%m.%Y %H.%i\');\n        -> \'2003-10-03 09:20:00\'\nmysql> SELECT STR_TO_DATE(\'10arp\', \'%carp\');\n        -> \'0000-10-00 00:00:00\'\nmysql> SELECT STR_TO_DATE(\'2003-15-10 00:00:00\',\n    ->                    \'%Y-%m-%d %H:%i:%s\');\n        -> NULL',''),(273,'BIT_COUNT',28,'   BIT_COUNT(N)\nReturns the number of bits that are set in the argument N.\n','mysql> SELECT BIT_COUNT(29);\n        -> 4',''),(274,'TAN',10,'   TAN(X)\nReturns the tangent of X, where X is given in radians.\n','mysql> SELECT TAN(PI()+1);\n        -> 1.557408',''),(275,'MULTILINESTRING',2,'   MultiLineString(ls1,ls2,...)\nConstructs a WKB MultiLineString value using using WKB LineString\narguments.  If any argument is not a WKB LineString, the return\nvalue is NULL.\n','',''),(276,'STOP SLAVE',19,'STOP SLAVE [thread_type [, thread_type] ... ]\n\nthread_type: IO_THREAD | SQL_THREAD\n\nStops the slave threads.\nSTOP SLAVE requires the SUPER privilege.\n\nLike START SLAVE, as of MySQL 4.0.2, this statement\nmay be used with the IO_THREAD and SQL_THREAD options to name\nthe thread or threads to stop.\n','',''),(277,'UTC_DATE',15,'   UTC_DATE\n   UTC_DATE()\nReturns the current UTC date as a value in \'YYYY-MM-DD\' or\nYYYYMMDD format, depending on whether the function is used in a\nstring or numeric context.\n','mysql> SELECT UTC_DATE(), UTC_DATE() + 0;\n        -> \'2003-08-14\', 20030814',''),(278,'CREATE INDEX',3,'In MySQL 3.22 or later, CREATE INDEX is mapped to an\nALTER TABLE statement to create indexes.\nSee also : [ALTER TABLE, , ALTER TABLE].\nThe CREATE INDEX statement doesn\'t do anything prior\nto MySQL 3.22.\n','CREATE [UNIQUE|FULLTEXT|SPATIAL] INDEX index_name [index_type]\n    ON tbl_name (index_col_name,...)\n\nindex_col_name:\n    col_name [(length)] [ASC | DESC]',''),(279,'UNCOMPRESSED_LENGTH',11,'   UNCOMPRESSED_LENGTH(compressed_string)\nReturns the length of a compressed string before compression.\n','mysql> SELECT UNCOMPRESSED_LENGTH(COMPRESS(REPEAT(\'a\',30)));\n        -> 30',''),(280,'AUTO_INCREMENT',1,'The AUTO_INCREMENT attribute can be used to generate a unique\nidentity for new rows:\n','CREATE TABLE animals (\n             id MEDIUMINT NOT NULL AUTO_INCREMENT,\n             name CHAR(30) NOT NULL,\n             PRIMARY KEY (id)\n             );\nINSERT INTO animals (name) VALUES (\'dog\'),(\'cat\'),(\'penguin\'),\n                                  (\'lax\'),(\'whale\'),(\'ostrich\');\nSELECT * FROM animals;',''),(281,'OLD_PASSWORD',8,'   OLD_PASSWORD(str)\n\n\nOLD_PASSWORD() is available as of MySQL 4.1, when the implementation of\nPASSWORD() was changed to improve security. OLD_PASSWORD()\nreturns the value of the pre-4.1 implementation of PASSWORD().\n[Password hashing].\n\n   PASSWORD(str)\nCalculates and returns a password string from the plaintext password\nstr, or NULL if the argument was NULL. This is\nthe function that is used for encrypting MySQL passwords for storage\nin the Password column of the user grant table.\n','',''),(282,'STRCMP',11,'   STRCMP(expr1,expr2)\nSTRCMP()\nreturns 0 if the strings are the same, -1 if the first\nargument is smaller than the second according to the current sort order,\nand 1 otherwise.\n','mysql> SELECT STRCMP(\'text\', \'text2\');\n        -> -1\nmysql> SELECT STRCMP(\'text2\', \'text\');\n        -> 1\nmysql> SELECT STRCMP(\'text\', \'text\');\n        -> 0',''),(283,'BOUNDARY',13,'   Boundary(g)\nReturns a geometry that is the closure of the combinatorial boundary of the\ngeometry value g.\n','',''),(284,'DATEDIFF',15,'   DATEDIFF(expr,expr2)\n\n\nDATEDIFF() returns the number of days between the start date\nexpr and the end date expr2.\nexpr and expr2 are date or date-and-time expressions.\nOnly the date parts of the values are used in the calculation.\n','mysql> SELECT DATEDIFF(\'1997-12-31 23:59:59\',\'1997-12-30\');\n        -> 1\nmysql> SELECT DATEDIFF(\'1997-11-30 23:59:59\',\'1997-12-31\');\n        -> -31',''),(285,'TINYINT',1,'   TINYINT[(M)] [UNSIGNED] [ZEROFILL]\n\nA very small integer. The signed range is -128 to 127. The\nunsigned range is 0 to 255.\n\n   BIT\n   BOOL\n   BOOLEAN\nThese are synonyms for TINYINT(1).\nThe BOOLEAN synonym was added in MySQL 4.1.0.\nA value of zero is considered false. Non-zero values are considered true.\n\nIn the future,\nfull boolean type handling will be introduced in accordance with standard SQL.\n','',''),(286,'SET GLOBAL SQL_SLAVE_SKIP_COUNTER',19,'SET GLOBAL SQL_SLAVE_SKIP_COUNTER = n\n\nSkip the next n events from the master. This is\nuseful for recovering from replication stops caused by a statement.\n\nThis statement is valid only when the slave thread is not running.\nOtherwise, it produces an error.\n\nBefore MySQL 4.0, omit the GLOBAL keyword from the statement.\n','',''),(287,'DES_ENCRYPT',8,'   DES_ENCRYPT(str[,(key_num|key_str)])\n\nEncrypts the string with the given key using the Triple-DES algorithm.\nOn error, this function returns NULL.\n\nNote that this function works only if MySQL has been configured with\nSSL support. See also : [Secure connections].\n\nThe encryption key to use is chosen based on the second argument to\nDES_ENCRYPT(), if one was given:\n\n     Argument 	 Description\n   No argument 	\nThe first key from the DES key file is used.\n   key_num 	\nThe given key number (0-9) from the DES key file is used.\n   key_str 	\nThe given key string is used to encrypt str.\n  \n\nThe key file can be specified with the --des-key-file server option.\n\nThe return string is a binary string where the first character\nis CHAR(128 | key_num).\n\nThe 128 is added to make it easier to recognize an encrypted key.\nIf you use a string key, key_num will be 127.\n\nThe string length for the result will be\nnew_len = orig_len + (8-(orig_len % 8))+1.\n','key_num des_key_str',''),(288,'QUARTER',15,'   QUARTER(date)\nReturns the quarter of the year for date, in the range 1\nto 4.\n','mysql> SELECT QUARTER(\'98-04-01\');\n        -> 2',''),(289,'DATABASE',20,'   DATABASE()\nReturns the default (current) database name.\n','mysql> SELECT DATABASE();\n        -> \'test\'',''),(290,'CREATE TABLE',3,'CREATE TABLE creates a table with the given name.\nYou must have the CREATE privilege for the table.\n\nRules for allowable table names are given in [Legal names].  \nBy default, the table is created in the current database.  \nAn error occurs if the table already exists, if there is no current database,\nor if the database does not exist.\n','CREATE [TEMPORARY] TABLE [IF NOT EXISTS] tbl_name\n    [(create_definition,...)]\n    [table_options] [select_statement]',''),(291,'BIN',11,'   BIN(N)\nReturns a string representation of the binary value of N, where\nN is a longlong (BIGINT) number.  This is equivalent to\nCONV(N,10,2).  Returns NULL if N is NULL.\n','mysql> SELECT BIN(12);\n        -> \'1100\'',''),(292,'SIGN',10,'   SIGN(X)\nReturns the sign of the argument as -1, 0, or 1, depending\non whether X is negative, zero, or positive.\n','mysql> SELECT SIGN(-32);\n        -> -1\nmysql> SELECT SIGN(0);\n        -> 0\nmysql> SELECT SIGN(234);\n        -> 1',''),(293,'TIME_TO_SEC',15,'   TIME_TO_SEC(time)\nReturns the time argument, converted to seconds.\n','mysql> SELECT TIME_TO_SEC(\'22:23:00\');\n        -> 80580\nmysql> SELECT TIME_TO_SEC(\'00:39:38\');\n        -> 2378',''),(294,'TIMESTAMPADD FUNCTION',15,'','mysql> SELECT TIMESTAMPADD(MINUTE,1,\'2003-01-02\');\n        -> \'2003-01-02 00:01:00\'\nmysql> SELECT TIMESTAMPADD(WEEK,1,\'2003-01-02\');\n        -> \'2003-01-09\'',''),(295,'REVERSE',11,'   REVERSE(str)\nReturns the string str with the order of the characters reversed.\n','mysql> SELECT REVERSE(\'abc\');\n        -> \'cba\'',''),(296,'<=>',4,'   <=>\nNULL-safe equal.\nThis operator performs an equality comparison like the = operator, but\nreturns 1 rather than NULL if both operands are NULL,\nand 0 rather than NULL if one operand is NULL.\n','mysql> SELECT 1 <=> 1, NULL <=> NULL, 1 <=> NULL;\n        -> 1, 1, 0\nmysql> SELECT 1 = 1, NULL = NULL, 1 = NULL;\n        -> 1, NULL, NULL',''),(297,'SUBSTRING',11,'   SUBSTRING(str,pos)\n   SUBSTRING(str FROM pos)\n   SUBSTRING(str,pos,len)\n   SUBSTRING(str FROM pos FOR len)\n\nThe forms without a len argument\nreturn a substring from string str starting at position pos.\nThe forms with a len argument\nreturn a substring len characters long from string str,\nstarting at position pos.\nThe forms that use FROM are standard SQL syntax.\n','mysql> SELECT SUBSTRING(\'Quadratically\',5);\n        -> \'ratically\'\nmysql> SELECT SUBSTRING(\'foobarbar\' FROM 4);\n        -> \'barbar\'\nmysql> SELECT SUBSTRING(\'Quadratically\',5,6);\n        -> \'ratica\'',''),(298,'NULLIF',14,'   NULLIF(expr1,expr2)\nReturns NULL if expr1 = expr2 is true, else returns expr1.\nThis is the same as CASE WHEN expr1 = expr2 THEN NULL ELSE expr1 END.\n','mysql> SELECT NULLIF(1,1);\n        -> NULL\nmysql> SELECT NULLIF(1,2);\n        -> 1',''),(299,'CONTAINS',25,'   Contains(g1,g2)\nReturns 1 or 0 to indicate whether or not g1 completely contains\ng2.\n','',''),(300,'CURRENT_DATE',15,'   CURRENT_DATE\n   CURRENT_DATE()\n\nCURRENT_DATE and CURRENT_DATE() are synonyms for\nCURDATE().\n','',''),(301,'VARIANCE',22,'   VARIANCE(expr)\nReturns the standard variance of expr (considering rows as the\nwhole population, not as a sample; so it has the number of rows as\ndenominator). This is an extension to \nstandard SQL, available only in MySQL 4.1 or later.\n','',''),(302,'TIMESTAMPDIFF',15,'   TIMESTAMPDIFF(interval,datetime_expr1,datetime_expr2)\n\nReturns the integer difference between the date or datetime expressions\ndatetime_expr1 and\ndatetime_expr2. The unit for the result is given by the\ninterval argument. The legal values for interval are the same as\nthose listed in the description of the TIMESTAMPADD() function.\n','',''),(303,'UPDATE',26,'The UPDATE statement updates columns in existing table rows with new values.\nThe SET clause indicates which columns to modify and the values\nthey should be given.  The WHERE clause, if given, specifies\nwhich rows should be updated.  Otherwise, all rows are updated. If the\nORDER BY clause is specified, the rows will be updated in the\norder that is specified. The LIMIT clause places a limit on the number\nof rows that can be updated.\n\nThe UPDATE statement supports the following modifiers:\n\n\n --- If you specify the LOW_PRIORITY keyword, execution of the\nUPDATE is delayed until no other clients are reading from the table.\n\n --- If you specify the IGNORE keyword, the update statement will not\nabort even if duplicate-key errors occur during the update.  Rows for which\nconflicts occur are not updated.\n','UPDATE [LOW_PRIORITY] [IGNORE] tbl_name\n    SET col_name1=expr1 [, col_name2=expr2 ...]\n    [WHERE where_definition]\n    [ORDER BY ...]\n    [LIMIT row_count]',''),(304,'FIND_IN_SET',11,'   FIND_IN_SET(str,strlist)\nReturns a value 1 to N if the string str is in the string list\nstrlist consisting of N substrings. A string list is a string\ncomposed of substrings separated by , characters. If the first\nargument is a constant string and the second is a column of type SET,\nthe FIND_IN_SET() function is optimized to use bit arithmetic.\nReturns 0 if str is not in strlist or if strlist\nis the empty string.  Returns NULL if either argument is NULL.\nThis function will not work properly if the first argument contains a comma\n(,) character.\n','mysql> SELECT FIND_IN_SET(\'b\',\'a,b,c,d\');\n        -> 2',''),(305,'YEARWEEK',15,'Returns year and week for a date.  The start argument works exactly\nlike the start argument to WEEK().  The year in the\nresult may be\ndifferent from the year in the date argument for the first and the last\nweek of the year.\n','mysql> SELECT YEARWEEK(\'1987-01-01\');\n        -> 198653',''),(306,'SET',26,'SET sets different types of variables that affect the operation of the\nserver or your client. It can be used to assign values to user variables or\nsystem variables.\n','SET variable_assignment [, variable_assignment] ...\n\nvariable_assignment:\n      user_var_name = expr\n    | [GLOBAL | SESSION] system_var_name = expr\n    | @@[global. | session.]system_var_name = expr',''),(307,'SOUNDEX',11,'   SOUNDEX(str)\nReturns a soundex string from str. Two strings that sound almost the\nsame should have identical soundex strings. A standard soundex string\nis four characters long, but the SOUNDEX() function returns an\narbitrarily long string. You can use SUBSTRING() on the result to get\na standard soundex string.  All non-alphabetic characters are ignored in the\ngiven string. All international alphabetic characters outside the A-Z range\nare treated as vowels.\n','mysql> SELECT SOUNDEX(\'Hello\');\n        -> \'H400\'\nmysql> SELECT SOUNDEX(\'Quadratically\');\n        -> \'Q36324\'',''),(308,'IS_FREE_LOCK',18,'   IS_FREE_LOCK(str)\nChecks whether the lock named str is free to use (that is, not locked).\nReturns 1 if the lock is free (no one is using the lock),\n0 if the lock is in use, and\nNULL on errors (such as incorrect arguments).\n','',''),(309,'UPPER',11,'   UPPER(str)\nReturns the string str with all characters changed to uppercase\naccording to the current character set mapping (the default is ISO-8859-1\nLatin1).\n','mysql> SELECT UPPER(\'Hej\');\n        -> \'HEJ\'',''),(310,'FLUSH QUERY CACHE',19,'You can defragment the query cache to better utilize its memory\nwith the FLUSH QUERY CACHE statement.\nThe statement does not remove any queries from the cache.\n\nThe RESET QUERY CACHE statement removes all query results from the\nquery cache.  The FLUSH TABLES statement also does this.\n','',''),(311,'CURRENT_USER',20,'   CURRENT_USER()\nReturns the username and hostname combination that the current session was authenticated\nas. This value corresponds to the MySQL account that determines your\naccess privileges. It can be different from the value of USER().\n','mysql> SELECT USER();\n        -> \'davida@localhost\'\nmysql> SELECT * FROM mysql.user;\nERROR 1044: Access denied for user \'@localhost\' to\ndatabase \'mysql\'\nmysql> SELECT CURRENT_USER();\n        -> \'@localhost\'',''),(312,'DAYOFWEEK',15,'   DAYOFWEEK(date)\nReturns the weekday index\nfor date (1 = Sunday, 2 = Monday, ..., 7 =\nSaturday).  These index values correspond to the ODBC standard.\n','mysql> SELECT DAYOFWEEK(\'1998-02-03\');\n        -> 3',''),(313,'LOAD INDEX',26,'The LOAD INDEX INTO CACHE statement preloads a table index into the\nkey cache to which it has been assigned by an explicit CACHE INDEX\nstatement, or into the default key cache otherwise.  LOAD INDEX INTO\nCACHE is used only for MyISAM tables.\n\nThe IGNORE LEAVES modifier causes only blocks for the non-leaf\nnodes of the index to be preloaded.\n','LOAD INDEX INTO CACHE\n  tbl_index_list [, tbl_index_list] ...\n\ntbl_index_list:\n  tbl_name\n    [[INDEX] (index_name[, index_name] ...)]\n    [IGNORE LEAVES]',''),(314,'MEDIUMINT',1,'   MEDIUMINT[(M)] [UNSIGNED] [ZEROFILL]\n\nA medium-size integer. The signed range is -8388608 to\n8388607. The unsigned range is 0 to 16777215.\n','',''),(315,'TRUNCATE TABLE',26,'TRUNCATE TABLE empties a table completely.\nLogically, this is equivalent to a DELETE statement that deletes all\nrows, but there are practical differences under some circumstances.\n\nFor InnoDB, TRUNCATE TABLE is mapped to\nDELETE, so there is no difference. For other storage engines,\nTRUNCATE TABLE differs from DELETE FROM ...\nin the following ways from MySQL 4.0 and up:\n\n --- Truncate operations drop and re-create the table, which is much faster\nthan deleting rows one by one.\n --- Truncate operations are not transaction-safe; you will get an error if\nyou have an active transaction or an active table lock.\n --- The number of deleted rows is not returned.\n --- As long as the table definition file *tbl_name.frm is\nvalid, the table can be re-created as an empty table with TRUNCATE\nTABLE, even if the data or index files have become corrupted.\n --- The table handler does not remember the last used AUTO_INCREMENT\nvalue, but starts counting from the beginning.  This is true even for\nMyISAM, which normally does not reuse sequence values.\n\nIn MySQL 3.23, TRUNCATE TABLE is mapped to\nCOMMIT; DELETE FROM tbl_name, so it behaves like DELETE.\nSee also : [DELETE,  , DELETE].\n\nTRUNCATE TABLE is an Oracle SQL extension.\nThis statement was added in MySQL 3.23.28, although from 3.23.28\nto 3.23.32, the keyword TABLE must be omitted.\n','TRUNCATE TABLE tbl_name',''),(316,'UCASE',11,'   UCASE(str)\n\nUCASE() is a synonym for UPPER().\n','',''),(317,'ISCLOSED',21,'   IsClosed(ls)\nReturns 1 if the LineString value ls is closed\n(that is, its StartPoint() and EndPoint() values are the same).\nReturns 0 if ls is not closed, and @minus{}1 if it is NULL.\n','mysql> SET @ls = \'LineString(1 1,2 2,3 3)\';\nmysql> SELECT IsClosed(GeomFromText(@ls));\n+-----------------------------+\n| IsClosed(GeomFromText(@ls)) |\n+-----------------------------+\n|                           0 |\n+-----------------------------+',''),(318,'YEAR TYPE',1,'   YEAR[(2|4)]\n\nA year in two-digit or four-digit format. The default is four-digit format.\nIn four-digit format, the\nallowable values are 1901 to 2155, and 0000.\nIn two-digit format, the allowable values are\n70 to 69, representing years from\n1970 to 2069.  MySQL displays YEAR values in\nYYYY format, but allows you to assign values to YEAR columns\nusing either strings or numbers. The YEAR type is unavailable prior\nto MySQL 3.22.\n','',''),(319,'SECOND',15,'   SECOND(time)\nReturns the second for time, in the range 0 to 59.\n','mysql> SELECT SECOND(\'10:05:03\');\n        -> 3',''),(320,'POSITION',11,'   POSITION(substr IN str)\n\nPOSITION(substr IN str) is a synonym for LOCATE(substr,str).\n','mysql> SELECT LOCATE(\'bar\', \'foobarbar\');\n        -> 4\nmysql> SELECT LOCATE(\'xbar\', \'foobar\');\n        -> 0\nmysql> SELECT LOCATE(\'bar\', \'foobarbar\',5);\n        -> 7',''),(321,'CONSTRAINT',19,'The syntax of a foreign key constraint definition in InnoDB looks like\nthis:\n\n[CONSTRAINT symbol] FOREIGN KEY [id] (index_col_name, ...)\n    REFERENCES tbl_name (index_col_name, ...)\n    [ON DELETE {RESTRICT | CASCADE | SET NULL | NO ACTION | SET DEFAULT}]\n    [ON UPDATE {RESTRICT | CASCADE | SET NULL | NO ACTION | SET DEFAULT}]\n','CREATE TABLE product (category INT NOT NULL, id INT NOT NULL,\n                      price DECIMAL,\n                      PRIMARY KEY(category, id)) TYPE=INNODB;\nCREATE TABLE customer (id INT NOT NULL,\n                      PRIMARY KEY (id)) TYPE=INNODB;\nCREATE TABLE product_order (no INT NOT NULL AUTO_INCREMENT,\n                      product_category INT NOT NULL,\n                      product_id INT NOT NULL,\n                      customer_id INT NOT NULL,\n                      PRIMARY KEY(no),\n                      INDEX (product_category, product_id),\n                      FOREIGN KEY (product_category, product_id)\n                        REFERENCES product(category, id)\n                        ON UPDATE CASCADE ON DELETE RESTRICT,\n                      INDEX (customer_id),\n                      FOREIGN KEY (customer_id)\n                        REFERENCES customer(id)) TYPE=INNODB;',''),(322,'SUM',22,'   SUM(expr)\nReturns the sum of expr.  Note that if the return set has no rows,\nit returns NULL!\n','',''),(323,'REPAIR',19,'REPAIR TABLE repairs a possibly corrupted table.\nBy default,\nit has the same effect as myisamchk --recover tbl_name.\nREPAIR TABLE works only on MyISAM tables.\n','REPAIR [LOCAL | NO_WRITE_TO_BINLOG] TABLE\n    tbl_name [, tbl_name] ... [QUICK] [EXTENDED] [USE_FRM]',''),(324,'ORD',11,'   ORD(str)\nIf the leftmost character of the string str is a multi-byte character,\nreturns the code for that character, calculated from the numeric values\nof its constituent bytes using this formula:\n\n  (1st byte code * 256)\n+ (2nd byte code * 256^2)\n+ (3rd byte code * 256^3) ...\n\nIf the leftmost character is not a multi-byte character, ORD()\nreturns the same value as the ASCII() function.\n','mysql> SELECT ORD(\'2\');\n        -> 50',''),(325,'POINTN',21,'   PointN(ls,n)\nReturns the n-th point in the Linestring value ls.\nPoint numbers begin at 1.\n','mysql> SET @ls = \'LineString(1 1,2 2,3 3)\';\nmysql> SELECT AsText(PointN(GeomFromText(@ls),2));\n+-------------------------------------+\n| AsText(PointN(GeomFromText(@ls),2)) |\n+-------------------------------------+\n| POINT(2 2)                          |\n+-------------------------------------+',''),(326,'VARCHAR',1,'   [NATIONAL] VARCHAR(M) [BINARY]\n\nA variable-length string.  M represents the maximum column length.\nThe range of M is 0 to 255 characters (1 to 255 prior to MySQL 4.0.2).\n\nNote: Trailing spaces are removed when VARCHAR values are\nstored, which differs from the standard SQL specification.\n\nFrom MySQL 4.1.0 on, a VARCHAR column with a length specification\ngreater than 255 is converted to the smallest TEXT type that can hold\nvalues of the given length.  For example, VARCHAR(500) is converted\nto TEXT, and VARCHAR(200000) is converted to\nMEDIUMTEXT.  This is a compatibility feature.\nHowever, this conversion affects trailing-space removal.\n\nVARCHAR is shorthand for CHARACTER VARYING.\n\nThe BINARY attribute causes sorting and comparisons to be\ncase sensitive.\n','',''),(327,'CASE',14,'   CASE value WHEN [compare-value] THEN result [WHEN [compare-value] THEN result ...] [ELSE result] END\n   CASE WHEN [condition] THEN result [WHEN [condition] THEN result ...] [ELSE result] END\n\nThe first version returns the result where\nvalue=compare-value. The second version returns the result for\nthe first condition that is true. If there was no matching result\nvalue, the result after ELSE is returned, or NULL if there is no\nELSE part.\n','mysql> SELECT CASE 1 WHEN 1 THEN \'one\'\n    ->     WHEN 2 THEN \'two\' ELSE \'more\' END;\n        -> \'one\'\nmysql> SELECT CASE WHEN 1>0 THEN \'true\' ELSE \'false\' END;\n        -> \'true\'\nmysql> SELECT CASE BINARY \'B\'\n    ->     WHEN \'a\' THEN 1 WHEN \'b\' THEN 2 END;\n        -> NULL',''),(328,'MBR DEFINITION',6,'Every geometry occupies some position in space. The exterior of\na geometry is all space not occupied by the geometry. The interior\nis the space occupied by the geometry. The boundary is the\ninterface between the geometry\'s interior and exterior.\n\n --- Its MBR (Minimum Bounding Rectangle), or Envelope.\nThis is the bounding geometry, formed by the minimum and maximum (X,Y)\ncoordinates:\n','((MINX MINY, MAXX MINY, MAXX MAXY, MINX MAXY, MINX MINY))',''),(329,'MID',11,'   MID(str,pos,len)\n\nMID(str,pos,len) is a synonym for SUBSTRING(str,pos,len).\n','',''),(330,'MBRINTERSECTS',6,'   MBRIntersects(g1,g2)\nReturns 1 or 0 to indicate whether or not the Minimum Bounding Rectangles of\nthe two geometries g1 and g2 intersect.\n','',''),(331,'NOT LIKE',11,'   expr NOT LIKE pat [ESCAPE \'escape-char\']\n\nThis is the same as NOT (expr LIKE pat [ESCAPE \'escape-char\']).\n','',''),(332,'DES_DECRYPT',8,'   DES_DECRYPT(crypt_str[,key_str])\n\nDecrypts a string encrypted with DES_ENCRYPT().\nOn error, this function returns NULL.\n\nNote that this function works only if MySQL has been configured with\nSSL support. See also : [Secure connections].\n\nIf no key_str argument is given, DES_DECRYPT() examines\nthe first byte of the encrypted string to determine the DES key number\nthat was used to encrypt the original string, and then reads the key\nfrom the DES key file to decrypt the message.  For this to work,\nthe user must have the SUPER privilege. The key file can be specified\nwith the --des-key-file server option.\n\nIf you pass this function a key_str argument, that string\nis used as the key for decrypting the message.\n\nIf the crypt_str argument doesn\'t look like an encrypted string,\nMySQL will return the given crypt_str.\n','',''),(333,'OCT',11,'   OCT(N)\nReturns a string representation of the octal value of N, where\nN is a longlong number.  This is equivalent to CONV(N,10,8).\nReturns NULL if N is NULL.\n','mysql> SELECT OCT(12);\n        -> \'14\'',''),(334,'GET_LOCK',18,'   GET_LOCK(str,timeout)\nTries to obtain a lock with a name given by the string str, with a\ntimeout of timeout seconds.  Returns 1 if the lock was obtained\nsuccessfully, 0 if the attempt timed out (for example, because another\nclient has already locked the name), or NULL if an error\noccurred (such as running out of memory or the thread was killed with\nmysqladmin kill).  If you have a lock obtained with GET_LOCK(),\nit is released when you execute\nRELEASE_LOCK(), execute a new GET_LOCK(), or your connection\nterminates (either normally or abnormally).\n\nThis function can be used to implement application locks or to\nsimulate record locks.  Names are locked on a server-wide basis.\nIf a name has been locked by one client, GET_LOCK() blocks\nany request by another client for a lock with the same name. This\nallows clients that agree on a given lock name to use the name to\nperform cooperative advisory locking.\n','mysql> SELECT GET_LOCK(\'lock1\',10);\n        -> 1\nmysql> SELECT IS_FREE_LOCK(\'lock2\');\n        -> 1\nmysql> SELECT GET_LOCK(\'lock2\',10);\n        -> 1\nmysql> SELECT RELEASE_LOCK(\'lock2\');\n        -> 1\nmysql> SELECT RELEASE_LOCK(\'lock1\');\n        -> NULL',''),(335,'ASBINARY',5,'   AsBinary(g)\nConverts a value in internal geometry format to its WKB representation\nand returns the binary result.\n','SELECT AsBinary(g) FROM geom;',''),(336,'YEAR',15,'   YEAR(date)\nReturns the year for date, in the range 1000 to 9999.\n','mysql> SELECT YEAR(\'98-02-03\');\n        -> 1998',''),(337,'BENCHMARK',20,'   BENCHMARK(count,expr)\nThe BENCHMARK() function executes the expression expr\nrepeatedly count times.  It may be used to time how fast MySQL\nprocesses the expression.  The result value is always 0.  The intended\nuse is from within the mysql client, which reports query execution times:\n','mysql> SELECT BENCHMARK(1000000,ENCODE(\'hello\',\'goodbye\'));\n+----------------------------------------------+\n| BENCHMARK(1000000,ENCODE(\'hello\',\'goodbye\')) |\n+----------------------------------------------+\n|                                            0 |\n+----------------------------------------------+\n1 row in set (4.74 sec)',''),(338,'CAST',11,'The CAST() and CONVERT() functions may be used to take a\nvalue of one type and produce a value of another type.\n\nThe type can be one of the following values:\n\n --- BINARY\n --- CHAR\n --- DATE\n --- DATETIME\n --- SIGNED [INTEGER]\n --- TIME\n --- UNSIGNED [INTEGER]\n\nCAST() and CONVERT() are available as of MySQL 4.0.2.\nThe CHAR conversion type is available as of 4.0.6.\nThe USING form of CONVERT() is available as of 4.1.0.\n\nCAST() and CONVERT(... USING ...) are standard SQL syntax.\nThe non-USING form of CONVERT() is ODBC syntax.\n\nCONVERT() with USING is used to convert data between different\ncharacter sets.  In MySQL, transcoding names are the same as the\ncorresponding character set names.  For example, this statement converts\nthe string \'abc\' in the server\'s default character set to the\ncorresponding string in the utf8 character set:\n\nSELECT CONVERT(\'abc\' USING utf8);\n\n  \n\nThe cast functions are useful when you want to create a column with\na specific type in a CREATE ... SELECT statement:\n','SELECT enum_col FROM tbl_name ORDER BY CAST(enum_col AS CHAR);',''),(339,'CACHE INDEX',26,'The CACHE INDEX statement assigns table indexes to a specific key\ncache. It is used only for MyISAM tables.\n\nThe following statement assigns indexes from the tables t1,\nt2, and t3 to the key cache named hot_cache:\n\nmysql> CACHE INDEX t1, t2, t3 IN hot_cache;\n+---------+--------------------+----------+----------+\n| Table   | Op                 | Msg_type | Msg_text |\n+---------+--------------------+----------+----------+\n| test.t1 | assign_to_keycache | status   | OK       |\n| test.t2 | assign_to_keycache | status   | OK       |\n| test.t3 | assign_to_keycache | status   | OK       |\n+---------+--------------------+----------+----------+\n','CACHE INDEX\n  tbl_index_list [, tbl_index_list] ...\n  IN key_cache_name\n\ntbl_index_list:\n  tbl_name [[INDEX] (index_name[, index_name] ...)]',''),(340,'LINEFROMTEXT',17,'   LineFromText(wkt[,srid])\n   LineStringFromText(wkt[,srid])\nConstructs a LINESTRING value using its WKT representation and SRID.\n','',''),(341,'GEOMCOLLFROMTEXT',17,'   GeomCollFromText(wkt[,srid])\n   GeometryCollectionFromText(wkt[,srid])\nConstructs a GEOMETRYCOLLECTION value using its WKT representation and SRID.\n','',''),(342,'ASTEXT',17,'   AsText(g)\nConverts a value in internal geometry format to its WKT representation\nand returns the string result.\n','mysql> SELECT AsText(g) FROM geom;\n+-------------------------+\n| AsText(p1)              |\n+-------------------------+\n| POINT(1 1)              |\n| LINESTRING(0 0,1 1,2 2) |\n+-------------------------+',''),(343,'VERSION',20,'   VERSION()\nReturns a string that indicates the MySQL server version.\n','mysql> SELECT VERSION();\n        -> \'4.1.2-alpha-log\'',''),(344,'MBRWITHIN',6,'   MBRWithin(g1,g2)\nReturns 1 or 0 to indicate whether or not the Minimum Bounding Rectangle\nof g1 is within the Minimum Bounding Rectangle of g2.\n','mysql> SET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nmysql> SET @g2 = GeomFromText(\'Polygon((0 0,0 5,5 5,5 0,0 0))\');\nmysql> SELECT MBRWithin(@g1,@g2), MBRWithin(@g2,@g1);\n+--------------------+--------------------+\n| MBRWithin(@g1,@g2) | MBRWithin(@g2,@g1) |\n+--------------------+--------------------+\n|                  1 |                  0 |\n+--------------------+--------------------+',''),(345,'TIMESTAMPADD',15,'   TIMESTAMPADD(interval,int_expr,datetime_expr)\n\nAdds the integer expression int_expr to the date or datetime expression\ndatetime_expr. The unit for int_expr is given by the\ninterval argument, which should be one of the following values:\nFRAC_SECOND,\nSECOND,\nMINUTE,\nHOUR,\nDAY,\nWEEK,\nMONTH,\nQUARTER,\nor\nYEAR.\n\nThe interval value may be specified using one of keywords as shown,\nor with a prefix of SQL_TSI_. For example, DAY or\nSQL_TSI_DAY both are legal.\n','',''),(346,'LEAST',4,'   LEAST(value1,value2,...)\nWith two or more arguments, returns the smallest (minimum-valued) argument.\nThe arguments are compared using the following rules.\n\n --- If the return value is used in an INTEGER context or all arguments\nare integer-valued, they are compared as integers.\n\n --- If the return value is used in a REAL context or all arguments are\nreal-valued, they are compared as reals.\n\n --- If any argument is a case-sensitive string, the arguments are compared\nas case-sensitive strings.\n\n --- In other cases, the arguments are compared as case-insensitive strings.\n','mysql> SELECT LEAST(2,0);\n        -> 0\nmysql> SELECT LEAST(34.0,3.0,5.0,767.0);\n        -> 3.0\nmysql> SELECT LEAST(\'B\',\'A\',\'C\');\n        -> \'A\'',''),(347,'FIELD',11,'   FIELD(str,str1,str2,str3,...)\nReturns the index of str in the str1, str2,\nstr3, ... list.\nReturns 0 if str is not found.\nFIELD() is the complement of ELT().\n','mysql> SELECT FIELD(\'ej\', \'Hej\', \'ej\', \'Heja\', \'hej\', \'foo\');\n        -> 2\nmysql> SELECT FIELD(\'fo\', \'Hej\', \'ej\', \'Heja\', \'hej\', \'foo\');\n        -> 0',''),(348,'CURDATE',15,'   CURDATE()\n\nReturns the current date as a value in \'YYYY-MM-DD\' or YYYYMMDD\nformat, depending on whether the function is used in a string or numeric\ncontext.\n','mysql> SELECT CURDATE();\n        -> \'1997-12-15\'\nmysql> SELECT CURDATE() + 0;\n        -> 19971215',''),(349,'UTC_TIME',15,'   UTC_TIME\n   UTC_TIME()\nReturns the current UTC time as a value in \'HH:MM:SS\' or HHMMSS\nformat, depending on whether the function is used in a string or numeric\ncontext.\n','mysql> SELECT UTC_TIME(), UTC_TIME() + 0;\n        -> \'18:07:53\', 180753',''),(350,'SHOW SLAVE STATUS',19,'SHOW SLAVE STATUS\n\nProvides status information on\nessential parameters of the slave threads. If you issue this statement using\nthe\nmysql client, you can use a \\G statement terminator rather than\nsemicolon to get a more readable vertical layout:\n\nmysql> SHOW SLAVE STATUS\\G\n*************************** 1. row ***************************\n       Slave_IO_State: Waiting for master to send event\n          Master_Host: localhost\n          Master_User: root\n          Master_Port: 3306\n        Connect_Retry: 3\n      Master_Log_File: gbichot-bin.005\n  Read_Master_Log_Pos: 79\n       Relay_Log_File: gbichot-relay-bin.005\n        Relay_Log_Pos: 548\nRelay_Master_Log_File: gbichot-bin.005\n     Slave_IO_Running: Yes\n    Slave_SQL_Running: Yes\n      Replicate_Do_DB:\n  Replicate_Ignore_DB:\n           Last_Errno: 0\n           Last_Error:\n         Skip_Counter: 0\n  Exec_Master_Log_Pos: 79\n      Relay_Log_Space: 552\n      Until_Condition: None\n       Until_Log_File:\n        Until_Log_Pos: 0\n   Master_SSL_Allowed: No\n   Master_SSL_CA_File:\n   Master_SSL_CA_Path:\n      Master_SSL_Cert:\n    Master_SSL_Cipher:\n       Master_SSL_Key:\nSeconds_Behind_Master: 8\n','',''),(351,'SOUNDS LIKE',11,'   expr1 SOUNDS LIKE expr2\n\nThis is the same as SOUNDEX(expr1) = SOUNDEX(expr2). It is\navailable only in MySQL 4.1 or later. \n','',''),(352,'DESCRIBE',19,'{DESCRIBE | DESC} tbl_name [col_name | wild]\n\nDESCRIBE provides information about a table\'s columns.  It is a\nshortcut for SHOW COLUMNS FROM.\n','',''),(353,'MONTH',15,'   MONTH(date)\nReturns the month for date, in the range 1 to 12.\n','mysql> SELECT MONTH(\'1998-02-03\');\n        -> 2',''),(354,'ANALYZE',19,'This statement analyzes and stores the key distribution for a table.\nDuring the analysis, the table is locked with a read lock.  This works on\nMyISAM and BDB tables and (as of MySQL 4.0.13) InnoDB\ntables. For MyISAM tables, this\nstatement is equivalent to using myisamchk -a.\n\nMySQL uses the stored key distribution to decide the order in which\ntables should be joined when you perform a join on something other than a\nconstant.\n','ANALYZE [LOCAL | NO_WRITE_TO_BINLOG] TABLE tbl_name [, tbl_name] ...',''),(355,'DECODE',8,'   DECODE(crypt_str,pass_str)\nDecrypts the encrypted string crypt_str using pass_str as the\npassword.  crypt_str should be a string returned from\nENCODE().\n','',''),(356,'BIT_OR',22,'   BIT_OR(expr)\nReturns the bitwise OR of all bits in expr. The calculation is\nperformed with 64-bit (BIGINT) precision.\n','',''),(357,'DUAL',16,'SELECT ... FROM DUAL is an alias for SELECT ....\n(To be compatible with some other databases).\n','',''),(358,'ASIN',10,'   ASIN(X)\nReturns the arc sine of X, that is, the value whose sine is\nX. Returns NULL if X is not in the range -1 to\n1.\n','mysql> SELECT ASIN(0.2);\n        -> 0.201358\nmysql> SELECT ASIN(\'foo\');\n        -> 0.000000',''),(359,'POLYFROMTEXT',17,'   PolyFromText(wkt[,srid])\n   PolygonFromText(wkt[,srid])\nConstructs a POLYGON value using its WKT representation and SRID.\n','',''),(360,'SYSTEM_USER',20,'   SYSTEM_USER()\n\nSYSTEM_USER() is a synonym for USER().\n','',''),(361,'- BINARY',10,'   -\nSubtraction:\n','mysql> SELECT 3-5;\n        -> -2',''),(362,'NUMPOINTS',21,'   NumPoints(ls)\nReturns the number of points in the LineString value ls.\n','mysql> SET @ls = \'LineString(1 1,2 2,3 3)\';\nmysql> SELECT NumPoints(GeomFromText(@ls));\n+------------------------------+\n| NumPoints(GeomFromText(@ls)) |\n+------------------------------+\n|                            3 |\n+------------------------------+',''),(363,'ISOLATION',23,'SET [GLOBAL | SESSION] TRANSACTION ISOLATION LEVEL\n{ READ UNCOMMITTED | READ COMMITTED | REPEATABLE READ | SERIALIZABLE }\n\nThis statement\nsets the transaction isolation level for the next transaction, globally, or\nfor the current session.\n\nThe default behavior of SET TRANSACTION is to set the isolation level\nfor the next (not yet\nstarted) transaction.  If you use the GLOBAL keyword, the statement\nsets the default transaction level globally for all new connections\ncreated from that point on. Existing connections are unaffected.\nYou need the SUPER\nprivilege to do this.  Using the SESSION keyword sets the\ndefault transaction level for all future transactions performed on the\ncurrent connection.\n\nFor descriptions of each InnoDB transaction isolation level, see\n[InnoDB transaction isolation, InnoDB transaction isolation].\nInnoDB supports each of these levels\nfrom MySQL 4.0.5 on. The default level is REPEATABLE READ.\n\nYou can set the initial default global isolation level for mysqld with\nthe --transaction-isolation option.\nSee also : [Server options].\n','',''),(364,'EXTRACT',15,'   EXTRACT(type FROM date)\n\nThe EXTRACT() function uses the same kinds of interval type\nspecifiers as DATE_ADD() or DATE_SUB(), but extracts parts\nfrom the date rather than performing date arithmetic.\n','mysql> SELECT EXTRACT(YEAR FROM \'1999-07-02\');\n       -> 1999\nmysql> SELECT EXTRACT(YEAR_MONTH FROM \'1999-07-02 01:02:03\');\n       -> 199907\nmysql> SELECT EXTRACT(DAY_MINUTE FROM \'1999-07-02 01:02:03\');\n       -> 20102\nmysql> SELECT EXTRACT(MICROSECOND\n    ->                FROM \'2003-01-02 10:30:00.00123\');\n        -> 123',''),(365,'BIT_XOR',22,'   BIT_XOR(expr)\nReturns the bitwise XOR of all bits in expr. The calculation is\nperformed with 64-bit (BIGINT) precision.\n','',''),(366,'LINESTRING',2,'   LineString(pt1,pt2,...)\nConstructs a WKB LineString value from a number of WKB Point\narguments.  If any argument is not a WKB Point, the return value\nis NULL.  If the number of Point arguments is less than two,\nthe return value is NULL.\n','',''),(367,'QUOTE',11,'   QUOTE(str)\nQuotes a string to produce a result that can be used as a properly escaped\ndata value in an SQL statement.  The string is returned surrounded by single\nquotes and with each instance of single quote (\'), backslash (\\),\nASCII NUL, and Control-Z preceded by a backslash.  If the argument is\nNULL, the return value is the word ``NULL\'\' without surrounding\nsingle quotes.\nThe QUOTE() function was added in MySQL 4.0.3.\n','mysql> SELECT QUOTE(\'Don\\\'t\');\n        -> \'Don\\\'t!\'\nmysql> SELECT QUOTE(NULL);\n        -> NULL',''),(368,'GEOMETRYTYPE',13,'   GeometryType(g)\nReturns as a string the name of the geometry type of which\nthe geometry instance g is a member.\nThe name will correspond to one of the instantiable Geometry subclasses.\n','mysql> SELECT GeometryType(GeomFromText(\'POINT(1 1)\'));\n+------------------------------------------+\n| GeometryType(GeomFromText(\'POINT(1 1)\')) |\n+------------------------------------------+\n| POINT                                    |\n+------------------------------------------+',''),(369,'SHA',8,'   SHA1(str)\n   SHA(str)\nCalculates an SHA1 160-bit checksum for the string, as described in\nRFC 3174 (Secure Hash Algorithm). The value is returned as a string of 40 hex\ndigits, or NULL if the argument was NULL.\nOne of the possible uses for this function is as a hash key. You can\nalso use it as a cryptographically safe function for storing passwords.\n','mysql> SELECT SHA1(\'abc\');\n        -> \'a9993e364706816aba3e25717850c26c9cd0d89d\'',''),(370,'RESTORE',19,'\nRESTORE TABLE tbl_name [, tbl_name] ... FROM \'/path/to/backup/directory\'\n\nRestores the table or tables from a backup that was made with BACKUP\nTABLE. Existing tables will not be overwritten; if you try to restore over\nan existing table, you will get an error.  Just as BACKUP TABLE,\nRESTORE TABLE currently works only for MyISAM tables.\nThe directory should be specified as a full pathname.\n\nThe backup for each table consists of its *.frm format file and\n*.MYD data file. The restore operation restores those files, then\nuses them to rebuild the *.MYI index file.  Restoring takes longer\nthan backing up due to the need to rebuild the indexes. The more indexes the\ntable has, the longer it will take.\n','',''),(371,'UUID',18,'   UUID()\n\nReturns a Universal Unique Identifier (UUID) generated\naccording to ``DCE 1.1: Remote Procedure Call\'\' (Appendix A)\nCAE (Common Applications Environment) Specifications\npublished by The Open Group in October 1997 (Document Number C706).\n\nA UUID is designed as a number that is globally unique in space and\ntime. Two calls to UUID() are expected to generate two different\nvalues, even if these calls are performed on two separate computers that are\nnot connected to each other.\n\nA UUID is a 128-bit number represented by a string\nof five hexadecimal numbers in aaaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee\nformat:\n\n\n --- The first three numbers are generated from a timestamp.\n\n --- The fourth number preserves temporal uniqueness in case the timestamp value loses\nmonotonicity (for example, due to daylight saving time).\n\n --- The fifth number is an IEEE 802 node number that provides spatial uniqueness.  A\nrandom number is substituted if the latter is not available (for example,\nbecause the host computer has no Ethernet card, or we do not know how to\nfind the hardware address of an interface on your operating system).  In\nthis case, spatial uniqueness cannot be guaranteed. Nevertheless, a\ncollision should have /very/ low probability.\n\nCurrently, the MAC address of an interface is taken into account only on\nFreeBSD and Linux. On other operating systems, MySQL uses a randomly generated\n48-bit number.\n','mysql> SELECT UUID();\n        -> \'6ccd780c-baba-1026-9564-0040f4311e29\'',''),(372,'REVOKE',19,'','REVOKE priv_type [(column_list)] [, priv_type [(column_list)]] ...\n    ON {tbl_name | * | *.* | db_name.*}\n    FROM user [, user] ...\n\nREVOKE ALL PRIVILEGES, GRANT OPTION FROM user [, user] ...',''),(373,'TIMEDIFF',15,'   TIMEDIFF(expr,expr2)\n\n\nTIMEDIFF() returns the time between the start time\nexpr and the end time expr2.\nexpr and expr2 are time or date-and-time expressions, but both\nmust be of the same type.\n','mysql> SELECT TIMEDIFF(\'2000:01:01 00:00:00\',\n    ->                 \'2000:01:01 00:00:00.000001\');\n        -> \'-00:00:00.000001\'\nmysql> SELECT TIMEDIFF(\'1997-12-31 23:59:59.000001\',\n    ->                 \'1997-12-30 01:01:01.000002\');\n        -> \'46:58:57.999999\'',''),(374,'REPLACE INTO',26,'REPLACE works exactly like INSERT, except that if an old\nrecord in the table has the same value as a new record for a PRIMARY\nKEY or a UNIQUE index, the old record is deleted before the new\nrecord is inserted.\nSee also : [INSERT, ,INSERT].\n\nNote that unless the table has a PRIMARY KEY or UNIQUE index,\nusing a REPLACE statement makes no sense. It becomes equivalent to\nINSERT, because there is no index to be used to determine whether a new\nrow duplicates another.\n\nValues for all columns are taken from the values specified in the\nREPLACE statement.  Any missing columns are set to their default\nvalues, just as happens for INSERT.  You can\'t refer to values from\nthe old row and use them in the new row.  It appeared that you could do this\nin some old MySQL versions, but that was a bug that has been corrected.\n\nTo be able to use REPLACE, you must have INSERT and\nDELETE privileges for the table.\n','REPLACE [LOW_PRIORITY | DELAYED]\n    [INTO] tbl_name [(col_name,...)]\n    VALUES ({expr | DEFAULT},...),(...),...',''),(375,'LOCK',23,'LOCK TABLES locks tables for the current thread.  UNLOCK\nTABLES releases any locks held by the current thread.  All tables that\nare locked by the current thread are implicitly unlocked when the\nthread issues another LOCK TABLES, or when the connection to the\nserver is closed.\n','LOCK TABLES\n    tbl_name [AS alias] {READ [LOCAL] | [LOW_PRIORITY] WRITE}\n    [, tbl_name [AS alias] {READ [LOCAL] | [LOW_PRIORITY] WRITE}] ...\nUNLOCK TABLES',''),(376,'UNCOMPRESS',11,'   UNCOMPRESS(string_to_uncompress)\nUncompresses a string compressed by the COMPRESS() function.\nIf the argument is not a compressed value, the result is NULL.\nThis function requires MySQL to have been compiled with a compression library\nsuch as zlib. Otherwise, the return value is always NULL.\n','mysql> SELECT UNCOMPRESS(COMPRESS(\'any string\'));\n        -> \'any string\'\nmysql> SELECT UNCOMPRESS(\'any string\');\n        -> NULL',''),(377,'GROUP_CONCAT',22,'   GROUP_CONCAT(expr)\nThis function returns a string result with the concatenated values from a\ngroup.  The full syntax is as follows:\n\nGROUP_CONCAT([DISTINCT] expr [,expr ...]\n             [ORDER BY {unsigned_integer | col_name | expr}\n                 [ASC | DESC] [,col ...]]\n             [SEPARATOR str_val])\n','mysql> SELECT student_name,\n    ->     GROUP_CONCAT(test_score)\n    ->     FROM student \n    ->     GROUP BY student_name;',''),(378,'NOT REGEXP',11,'   expr NOT REGEXP pat\n   expr NOT RLIKE pat\n\nThis is the same as NOT (expr REGEXP pat).\n','',''),(379,'DATE_FORMAT',15,'   DATE_FORMAT(date,format)\nFormats the date value according to the format string. The\nfollowing specifiers may be used in the format string:\n\n     Specifier 	 Description\n   %a 	 Abbreviated weekday name (Sun..Sat)\n   %b 	 Abbreviated month name (Jan..Dec)\n   %c 	 Month, numeric (0..12)\n   %D 	 Day of the month with English suffix (0th, 1st, 2nd, 3rd, ...)\n   %d 	 Day of the month, numeric (00..31)\n   %e 	 Day of the month, numeric (0..31)\n   %f 	 Microseconds (000000..999999)\n   %H 	 Hour (00..23)\n   %h 	 Hour (01..12)\n   %I 	 Hour (01..12)\n   %i 	 Minutes, numeric (00..59)\n   %j 	 Day of year (001..366)\n   %k 	 Hour (0..23)\n   %l 	 Hour (1..12)\n   %M 	 Month name (January..December)\n   %m 	 Month, numeric (00..12)\n   %p 	 AM or PM\n   %r 	 Time, 12-hour (hh:mm:ss followed by AM or PM)\n   %S 	 Seconds (00..59)\n   %s 	 Seconds (00..59)\n   %T 	 Time, 24-hour (hh:mm:ss)\n   %U 	 Week (00..53), where Sunday is the first day of the week\n   %u 	 Week (00..53), where Monday is the first day of the week\n   %V 	 Week (01..53), where Sunday is the first day of the week; used with %X\n   %v 	 Week (01..53), where Monday is the first day of the week; used with %x\n   %W 	 Weekday name (Sunday..Saturday)\n   %w 	 Day of the week (0=Sunday..6=Saturday)\n   %X 	 Year for the week where Sunday is the first day of the week, numeric, four digits; used with %V\n   %x 	 Year for the week, where Monday is the first day of the week, numeric, four digits; used with %v\n   %Y 	 Year, numeric, four digits\n   %y 	 Year, numeric, two digits\n   %% 	 A literal %.\n  \n\nAll other characters are copied to the result without interpretation.\n\nThe %v, %V, %x, and %X format specifiers are\navailable as of MySQL 3.23.8.  %f is available as of MySQL 4.1.1.\n\nAs of MySQL 3.23, the % character is required before\nformat specifier characters.  In earlier versions of MySQL,\n% was optional.\n\nThe reason the ranges for the month and day specifiers begin with zero\nis that MySQL allows incomplete dates such as \'2004-00-00\' to be\nstored as of MySQL 3.23.\n','mysql> SELECT DATE_FORMAT(\'1997-10-04 22:23:00\', \'%W %M %Y\');\n        -> \'Saturday October 1997\'\nmysql> SELECT DATE_FORMAT(\'1997-10-04 22:23:00\', \'%H:%i:%s\');\n        -> \'22:23:00\'\nmysql> SELECT DATE_FORMAT(\'1997-10-04 22:23:00\',\n                          \'%D %y %a %d %m %b %j\');\n        -> \'4th 97 Sat 04 10 Oct 277\'\nmysql> SELECT DATE_FORMAT(\'1997-10-04 22:23:00\',\n                          \'%H %k %I %r %T %S %w\');\n        -> \'22 22 10 10:23:00 PM 22:23:00 00 6\'\nmysql> SELECT DATE_FORMAT(\'1999-01-01\', \'%X %V\');\n        -> \'1998 52\'',''),(380,'UNIX_TIMESTAMP',15,'   UNIX_TIMESTAMP()\n   UNIX_TIMESTAMP(date)\nIf called with no argument, returns a Unix timestamp (seconds since\n\'1970-01-01 00:00:00\' GMT) as an unsigned integer. If\nUNIX_TIMESTAMP() is called with a date argument, it\nreturns the value of the argument as seconds since \'1970-01-01\n00:00:00\' GMT.  date may be a DATE string, a\nDATETIME string, a TIMESTAMP, or a number in the format\nYYMMDD or YYYYMMDD in local time.\n','mysql> SELECT UNIX_TIMESTAMP();\n        -> 882226357\nmysql> SELECT UNIX_TIMESTAMP(\'1997-10-04 22:23:00\');\n        -> 875996580',''),(381,'IF',14,'   IF(expr1,expr2,expr3)\nIf expr1 is TRUE (expr1 <> 0 and expr1 <> NULL) then\nIF() returns expr2, else it returns expr3.\nIF() returns a numeric or string value, depending on the context\nin which it is used.\n','mysql> SELECT IF(1>2,2,3);\n        -> 3\nmysql> SELECT IF(1<2,\'yes\',\'no\');\n        -> \'yes\'\nmysql> SELECT IF(STRCMP(\'test\',\'test1\'),\'no\',\'yes\');\n        -> \'no\'',''),(382,'SUBDATE',15,'   SUBDATE(date,INTERVAL expr type)\n   SUBDATE(expr,days)\n\nWhen invoked with the INTERVAL form of the second argument,\nSUBDATE() is a synonym for DATE_SUB().\nFor information on the INTERVAL argument, see the\ndiscussion for DATE_ADD().\n\nmysql> SELECT DATE_SUB(\'1998-01-02\', INTERVAL 31 DAY);\n        -> \'1997-12-02\'\nmysql> SELECT SUBDATE(\'1998-01-02\', INTERVAL 31 DAY);\n        -> \'1997-12-02\'\n\nAs of MySQL 4.1.1, the second syntax is allowed, where expr is a date\nor datetime expression and days is the number of days to be\nsubtracted from expr.\n\nmysql> SELECT SUBDATE(\'1998-01-02 12:00:00\', 31);\n        -> \'1997-12-02 12:00:00\'\n','','');
UNLOCK TABLES;
/*!40000 ALTER TABLE `help_topic` ENABLE KEYS */;

--
-- Table structure for table `host`
--

DROP TABLE IF EXISTS `host`;
CREATE TABLE `host` (
  `Host` char(60) character set latin1 collate latin1_bin NOT NULL default '',
  `Db` char(64) character set latin1 collate latin1_bin NOT NULL default '',
  `Select_priv` enum('N','Y') NOT NULL default 'N',
  `Insert_priv` enum('N','Y') NOT NULL default 'N',
  `Update_priv` enum('N','Y') NOT NULL default 'N',
  `Delete_priv` enum('N','Y') NOT NULL default 'N',
  `Create_priv` enum('N','Y') NOT NULL default 'N',
  `Drop_priv` enum('N','Y') NOT NULL default 'N',
  `Grant_priv` enum('N','Y') NOT NULL default 'N',
  `References_priv` enum('N','Y') NOT NULL default 'N',
  `Index_priv` enum('N','Y') NOT NULL default 'N',
  `Alter_priv` enum('N','Y') NOT NULL default 'N',
  `Create_tmp_table_priv` enum('N','Y') NOT NULL default 'N',
  `Lock_tables_priv` enum('N','Y') NOT NULL default 'N',
  PRIMARY KEY  (`Host`,`Db`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Host privileges;  Merged with database privileges';

--
-- Dumping data for table `host`
--


/*!40000 ALTER TABLE `host` DISABLE KEYS */;
LOCK TABLES `host` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `host` ENABLE KEYS */;

--
-- Table structure for table `tables_priv`
--

DROP TABLE IF EXISTS `tables_priv`;
CREATE TABLE `tables_priv` (
  `Host` char(60) character set latin1 collate latin1_bin NOT NULL default '',
  `Db` char(64) character set latin1 collate latin1_bin NOT NULL default '',
  `User` char(16) character set latin1 collate latin1_bin NOT NULL default '',
  `Table_name` char(64) character set latin1 collate latin1_bin NOT NULL default '',
  `Grantor` char(77) NOT NULL default '',
  `Timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `Table_priv` set('Select','Insert','Update','Delete','Create','Drop','Grant','References','Index','Alter') NOT NULL default '',
  `Column_priv` set('Select','Insert','Update','References') NOT NULL default '',
  PRIMARY KEY  (`Host`,`Db`,`User`,`Table_name`),
  KEY `Grantor` (`Grantor`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Table privileges';

--
-- Dumping data for table `tables_priv`
--


/*!40000 ALTER TABLE `tables_priv` DISABLE KEYS */;
LOCK TABLES `tables_priv` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `tables_priv` ENABLE KEYS */;

--
-- Table structure for table `time_zone`
--

DROP TABLE IF EXISTS `time_zone`;
CREATE TABLE `time_zone` (
  `Time_zone_id` int(10) unsigned NOT NULL auto_increment,
  `Use_leap_seconds` enum('Y','N') NOT NULL default 'N',
  PRIMARY KEY  (`Time_zone_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Time zones';

--
-- Dumping data for table `time_zone`
--


/*!40000 ALTER TABLE `time_zone` DISABLE KEYS */;
LOCK TABLES `time_zone` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `time_zone` ENABLE KEYS */;

--
-- Table structure for table `time_zone_leap_second`
--

DROP TABLE IF EXISTS `time_zone_leap_second`;
CREATE TABLE `time_zone_leap_second` (
  `Transition_time` bigint(20) NOT NULL default '0',
  `Correction` int(11) NOT NULL default '0',
  PRIMARY KEY  (`Transition_time`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Leap seconds information for time zones';

--
-- Dumping data for table `time_zone_leap_second`
--


/*!40000 ALTER TABLE `time_zone_leap_second` DISABLE KEYS */;
LOCK TABLES `time_zone_leap_second` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `time_zone_leap_second` ENABLE KEYS */;

--
-- Table structure for table `time_zone_name`
--

DROP TABLE IF EXISTS `time_zone_name`;
CREATE TABLE `time_zone_name` (
  `Name` char(64) NOT NULL default '',
  `Time_zone_id` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`Name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Time zone names';

--
-- Dumping data for table `time_zone_name`
--


/*!40000 ALTER TABLE `time_zone_name` DISABLE KEYS */;
LOCK TABLES `time_zone_name` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `time_zone_name` ENABLE KEYS */;

--
-- Table structure for table `time_zone_transition`
--

DROP TABLE IF EXISTS `time_zone_transition`;
CREATE TABLE `time_zone_transition` (
  `Time_zone_id` int(10) unsigned NOT NULL default '0',
  `Transition_time` bigint(20) NOT NULL default '0',
  `Transition_type_id` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`Time_zone_id`,`Transition_time`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Time zone transitions';

--
-- Dumping data for table `time_zone_transition`
--


/*!40000 ALTER TABLE `time_zone_transition` DISABLE KEYS */;
LOCK TABLES `time_zone_transition` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `time_zone_transition` ENABLE KEYS */;

--
-- Table structure for table `time_zone_transition_type`
--

DROP TABLE IF EXISTS `time_zone_transition_type`;
CREATE TABLE `time_zone_transition_type` (
  `Time_zone_id` int(10) unsigned NOT NULL default '0',
  `Transition_type_id` int(10) unsigned NOT NULL default '0',
  `Offset` int(11) NOT NULL default '0',
  `Is_DST` tinyint(3) unsigned NOT NULL default '0',
  `Abbreviation` char(8) NOT NULL default '',
  PRIMARY KEY  (`Time_zone_id`,`Transition_type_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Time zone transition types';

--
-- Dumping data for table `time_zone_transition_type`
--


/*!40000 ALTER TABLE `time_zone_transition_type` DISABLE KEYS */;
LOCK TABLES `time_zone_transition_type` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `time_zone_transition_type` ENABLE KEYS */;

--
-- Table structure for table `user`
--

DROP TABLE IF EXISTS `user`;
CREATE TABLE `user` (
  `Host` varchar(60) character set latin1 collate latin1_bin NOT NULL default '',
  `User` varchar(16) character set latin1 collate latin1_bin NOT NULL default '',
  `Password` varchar(41) character set latin1 collate latin1_bin NOT NULL default '',
  `Select_priv` enum('N','Y') NOT NULL default 'N',
  `Insert_priv` enum('N','Y') NOT NULL default 'N',
  `Update_priv` enum('N','Y') NOT NULL default 'N',
  `Delete_priv` enum('N','Y') NOT NULL default 'N',
  `Create_priv` enum('N','Y') NOT NULL default 'N',
  `Drop_priv` enum('N','Y') NOT NULL default 'N',
  `Reload_priv` enum('N','Y') NOT NULL default 'N',
  `Shutdown_priv` enum('N','Y') NOT NULL default 'N',
  `Process_priv` enum('N','Y') NOT NULL default 'N',
  `File_priv` enum('N','Y') NOT NULL default 'N',
  `Grant_priv` enum('N','Y') NOT NULL default 'N',
  `References_priv` enum('N','Y') NOT NULL default 'N',
  `Index_priv` enum('N','Y') NOT NULL default 'N',
  `Alter_priv` enum('N','Y') NOT NULL default 'N',
  `Show_db_priv` enum('N','Y') NOT NULL default 'N',
  `Super_priv` enum('N','Y') NOT NULL default 'N',
  `Create_tmp_table_priv` enum('N','Y') NOT NULL default 'N',
  `Lock_tables_priv` enum('N','Y') NOT NULL default 'N',
  `Execute_priv` enum('N','Y') NOT NULL default 'N',
  `Repl_slave_priv` enum('N','Y') NOT NULL default 'N',
  `Repl_client_priv` enum('N','Y') NOT NULL default 'N',
  `ssl_type` enum('','ANY','X509','SPECIFIED') NOT NULL default '',
  `ssl_cipher` blob NOT NULL,
  `x509_issuer` blob NOT NULL,
  `x509_subject` blob NOT NULL,
  `max_questions` int(11) unsigned NOT NULL default '0',
  `max_updates` int(11) unsigned NOT NULL default '0',
  `max_connections` int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (`Host`,`User`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Users and global privileges';

--
-- Dumping data for table `user`
--


/*!40000 ALTER TABLE `user` DISABLE KEYS */;
LOCK TABLES `user` WRITE;
INSERT INTO `user` VALUES ('localhost','root','','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','','','','',0,0,0),('%','root','','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','','','','',0,0,0),('localhost','','','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','','','','',0,0,0),('%','','','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','','','','',0,0,0);
UNLOCK TABLES;
/*!40000 ALTER TABLE `user` ENABLE KEYS */;

--
-- Current Database: `test`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `test`;

USE `test`;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;

