/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import net.sourceforge.jtds.jdbc.SharedSocket;

public class SharedLocalNamedPipe
extends SharedSocket {
    RandomAccessFile pipe;

    public SharedLocalNamedPipe(String serverName, int tdsVersion, int serverType, String instance) throws IOException {
        super(tdsVersion, serverType);
        StringBuffer pipeName = new StringBuffer(64);
        pipeName.append("\\\\");
        if (serverName == null || serverName.length() == 0) {
            pipeName.append('.');
        } else {
            pipeName.append(serverName);
        }
        pipeName.append("\\pipe\\");
        if (instance != null && instance.length() != 0) {
            pipeName.append("MSSQL$").append(instance).append('\\');
        }
        pipeName.append("sql\\query");
        this.pipe = new RandomAccessFile(pipeName.toString(), "rw");
        FileOutputStream fos = new FileOutputStream(this.pipe.getFD());
        FileInputStream fis = new FileInputStream(this.pipe.getFD());
        this.setOut(new DataOutputStream(new BufferedOutputStream(fos, 4100)));
        this.setIn(new DataInputStream(new BufferedInputStream(fis, 4100)));
    }

    boolean isConnected() {
        return this.pipe != null;
    }

    byte[] sendNetPacket(int streamId, byte[] buffer) throws IOException {
        byte[] ret = super.sendNetPacket(streamId, buffer);
        this.getOut().flush();
        return ret;
    }

    void close() throws IOException {
        try {
            super.close();
            this.getOut().close();
            this.setOut(null);
            this.getIn().close();
            this.setIn(null);
            if (this.pipe != null) {
                this.pipe.close();
            }
            Object var2_1 = null;
            this.pipe = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.pipe = null;
            throw throwable;
        }
    }

    void forceClose() {
        try {
            try {
                this.getOut().close();
            }
            catch (Exception e) {
                Object var3_2 = null;
                this.setOut(null);
            }
            Object var3_1 = null;
            this.setOut(null);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.setOut(null);
            throw throwable;
        }
        try {
            try {
                this.getIn().close();
            }
            catch (Exception e) {
                Object var5_9 = null;
                this.setIn(null);
            }
            Object var5_8 = null;
            this.setIn(null);
        }
        catch (Throwable throwable) {
            Object var5_10 = null;
            this.setIn(null);
            throw throwable;
        }
        try {
            block14: {
                try {
                    if (this.pipe == null) break block14;
                    this.pipe.close();
                }
                catch (IOException ex) {
                    Object var7_13 = null;
                    this.pipe = null;
                }
            }
            Object var7_12 = null;
            this.pipe = null;
        }
        catch (Throwable throwable) {
            Object var7_14 = null;
            this.pipe = null;
            throw throwable;
        }
    }

    protected void setTimeout(int timeout) {
    }
}

