//
// System.Data.OleDb.OleDbException
//
// Authors:
//	Konstantin Triger <kostat@mainsoft.com>
//	Boris Kirzner <borisk@mainsoft.com>
//	
// (C) 2005 Mainsoft Corporation (http://www.mainsoft.com)
//

//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//



namespace System.Data.OleDb
{

    using java.sql;
	using System.Text;
	using System.Data.Common;
	using System.Data.ProviderBase;

    /*
    * CURRENT LIMITATIONS
    * 1. Constructor for serialization SqlException(SerializationInfo info, StreamingContext sc) 
    *    is not supported.
    * 2. Method "void GetObjectData(...,...)" is not supported (serialization)
    */
#if NET_2_0
	public sealed class OleDbException : AbstractDbException
	{
		internal OleDbException (Exception cause, OleDbConnection connection) : base (cause, connection) { }

		internal OleDbException (SQLException cause, OleDbConnection connection) : base (cause, connection) { }

		internal OleDbException (string message, SQLException cause, OleDbConnection connection) : base (message, cause, connection) { }

		protected override AbstractDbErrorCollection DbErrors {
			get {
				return Errors;
			}
		}

		public OleDbErrorCollection Errors {
			get {
				return new OleDbErrorCollection (_cause, _connection);
			}
		}

		public override int ErrorCode {
			get {
				return DbErrorCode;
			}
		}
	}
#else
    public sealed class OleDbException :  System.Runtime.InteropServices.ExternalException
    {
		private class OleDbExceptionImpl : AbstractDbException {
			internal OleDbExceptionImpl(Exception cause, OleDbConnection connection) : base(cause, connection) {}

			internal OleDbExceptionImpl(SQLException cause, OleDbConnection connection) : base(cause, connection) {}

			internal OleDbExceptionImpl(string message, SQLException cause, OleDbConnection connection) : base(message, cause, connection) {}

			protected override AbstractDbErrorCollection DbErrors {
				get {
					return Errors;
				}
			}

			public OleDbErrorCollection Errors {
				get {
					return new OleDbErrorCollection(_cause, _connection);
				}
			}

			public int ErrorCode {
				get {
					return DbErrorCode;
				}
			}
		}
		
		OleDbExceptionImpl _impl;

		internal OleDbException(Exception cause, OleDbConnection connection) : base(null, cause) {
			_impl = new OleDbExceptionImpl(cause, connection);
		}

		internal OleDbException(SQLException cause, OleDbConnection connection) : base(null, cause) {
			_impl = new OleDbExceptionImpl(cause, connection);
		}

		internal OleDbException(string message, SQLException cause, OleDbConnection connection) : base(null, cause) {
			_impl = new OleDbExceptionImpl(message, cause, connection);
		}
        /**
         * Gets a collection of one or more SqlError objects that give detailed 
         * information about exceptions generated by the SQL Server .NET Data Provider.
         * @return collection of SqlError objects
         */
        public OleDbErrorCollection Errors
        {
            get
            {
				return (OleDbErrorCollection)_impl.Errors;
            }
        }

        /**
         * Gets the error code of the error.
         * @return The error code of the error.
         */
        public override int ErrorCode
        {
            get
            {
                return base.HResult;
            }
        }

 
        /**
         * Gets the name of the OLE DB provider that generated the error.
         * @return the name of the OLE DB provider that generated the error. 
         */
        public override String Source
        {
            get
            {
                return _impl.Source;
            }
        }

		public override string Message {
			get {
				return _impl.Message;
			}
		}

    }
#endif
}