//
// ToolStripDropDownItemAccessibleObject.cs
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
// Copyright (c) 2007 Novell, Inc.
//
// Authors:
//	Jonathan Pobst (monkey@jpobst.com)
//
#if NET_2_0

using System.Drawing;
using System.ComponentModel;
using System.Windows.Forms.Design;

namespace System.Windows.Forms
{
	public class ToolStripDropDownItemAccessibleObject : ToolStripItem.ToolStripItemAccessibleObject
	{
		#region Public Constructor
		public ToolStripDropDownItemAccessibleObject (ToolStripDropDownItem item) : base (item)
		{
		}
		#endregion

		#region Public Properties
		public override AccessibleRole Role {
			get { return base.Role; }
		}
		#endregion

		#region Public Methods
		public override void DoDefaultAction ()
		{
			base.DoDefaultAction ();
		}

		public override AccessibleObject GetChild (int index)
		{
			return (owner_item as ToolStripDropDownItem).DropDownItems[index].AccessibilityObject;
		}

		public override int GetChildCount ()
		{
			return (owner_item as ToolStripDropDownItem).DropDownItems.Count;
		}
		#endregion
	}
}
#endif
