// Copyright John Maddock 2008.
// Use, modification and distribution are subject to the
// Boost Software License, Version 1.0.
// (See accompanying file LICENSE_1_0.txt
// or copy at http://www.boost.org/LICENSE_1_0.txt)
//
// Some of these tests have been commented out: 
// the current algorithm may underflow to zero
// prematurely in these cases.
//
#define SC_(x) static_cast<T>(BOOST_JOIN(x, L))
   static const boost::array<boost::array<T, 5>, 216> nccs_big = {{
      { SC_(1.018147201538085937500000000000000000000e2), SC_(1.814723730087280273437500000000000000000), SC_(1.036294460296630859375000000000000000000e1), SC_(6.015496565199092654771842521716269252752e-33), SC_(9.999999999999999999999999999999939845034e-1) }, 
      { SC_(1.018147201538085937500000000000000000000e2), SC_(2.270954132080078125000000000000000000000), SC_(2.602141952514648437500000000000000000000e1), SC_(6.271325708033427466636203558887430713942e-16), SC_(9.999999999999993728674291966572533363796e-1) }, 
      { SC_(1.018147201538085937500000000000000000000e2), SC_(7.623167991638183593750000000000000000000), SC_(5.471894454956054687500000000000000000000e1), SC_(5.592130493491734836774684682197361443348e-6), SC_(9.999944078695065082651632253153178026386e-1) }, 
      { SC_(1.018147201538085937500000000000000000000e2), SC_(1.468006896972656250000000000000000000000e1), SC_(8.737109375000000000000000000000000000000e1), SC_(2.710350845630041378510514217949405178637e-2), SC_(9.728964915436995862148948578205059482136e-1) }, 
      { SC_(1.018147201538085937500000000000000000000e2), SC_(1.803178977966308593750000000000000000000e1), SC_(1.078618545532226562500000000000000000000e2), SC_(2.416865577598000489309403624290209365410e-1), SC_(7.583134422401999510690596375709790634590e-1) }, 
      { SC_(1.018147201538085937500000000000000000000e2), SC_(6.300376892089843750000000000000000000000e1), SC_(1.631703033447265625000000000000000000000e2), SC_(4.850524327039212486399364362407790060498e-1), SC_(5.149475672960787513600635637592209939502e-1) }, 
      { SC_(1.018147201538085937500000000000000000000e2), SC_(1.224560546875000000000000000000000000000e2), SC_(2.240465087890625000000000000000000000000e2), SC_(5.102803820072670629735512094460263022259e-1), SC_(4.897196179927329370264487905539736977741e-1) }, 
      { SC_(1.018147201538085937500000000000000000000e2), SC_(1.562923583984375000000000000000000000000e2), SC_(2.581070861816406250000000000000000000000e2), SC_(5.127291899610524813372367620548767727485e-1), SC_(4.872708100389475186627632379451232272515e-1) }, 
      { SC_(1.018147201538085937500000000000000000000e2), SC_(4.178839721679687500000000000000000000000e2), SC_(5.197506713867187500000000000000000000000e2), SC_(5.093600674154814778853402924042807787787e-1), SC_(4.906399325845185221146597075957192212213e-1) }, 
      { SC_(1.018147201538085937500000000000000000000e2), SC_(6.697814941406250000000000000000000000000e2), SC_(7.723677978515625000000000000000000000000e2), SC_(5.129845120964498366078694646976298310694e-1), SC_(4.870154879035501633921305353023701689306e-1) }, 
      { SC_(1.018147201538085937500000000000000000000e2), SC_(1.123881347656250000000000000000000000000e3), SC_(1.237953002929687500000000000000000000000e3), SC_(5.763985263535360329428622940628006790554e-1), SC_(4.236014736464639670571377059371993209446e-1) }, 
      { SC_(1.018147201538085937500000000000000000000e2), SC_(3.168707763671875000000000000000000000000e3), SC_(3.597574707031250000000000000000000000000e3), SC_(9.976074228142860532304918135060016111210e-1), SC_(2.392577185713946769508186493998388879014e-3) }, 
      { SC_(1.018147201538085937500000000000000000000e2), SC_(5.236728515625000000000000000000000000000e3), SC_(6.406252441406250000000000000000000000000e3), SC_(9.999999999988234458037685450814132140028e-1), SC_(1.176554196231454918586785997205692327229e-12) }, 
      { SC_(1.018147201538085937500000000000000000000e2), SC_(9.735224609375000000000000000000000000000e3), SC_(1.278815039062500000000000000000000000000e4), SC_(1.000000000000000000000000000000000000000), SC_(1.793740612159310215972825187830541699059e-44) }, 
      //{ SC_(1.018147201538085937500000000000000000000e2), SC_(2.534410546875000000000000000000000000000e4), SC_(3.816887890625000000000000000000000000000e4), SC_(1.000000000000000000000000000000000000000), SC_(2.624557028577293196236760011838770407123e-282) }, 
      { SC_(1.022709503173828125000000000000000000000e2), SC_(1.814723730087280273437500000000000000000), SC_(2.081713409423828125000000000000000000000e2), SC_(9.999999918310188386408291661140606777109e-1), SC_(8.168981161359170833885939322289111656020e-9) }, 
      { SC_(1.022709503173828125000000000000000000000e2), SC_(2.270954132080078125000000000000000000000), SC_(3.136257019042968750000000000000000000000e2), SC_(9.999999999999999999997481941485462016787e-1), SC_(2.518058514537983212510200000883718673124e-22) }, 
      { SC_(1.022709503173828125000000000000000000000e2), SC_(7.623167991638183593750000000000000000000), SC_(4.395764770507812500000000000000000000000e2), SC_(9.999999999999999999999999999999999999891e-1), SC_(1.093991813308405906816815119997010831382e-38) }, 
      { SC_(1.022709503173828125000000000000000000000e2), SC_(1.468006896972656250000000000000000000000e1), SC_(5.847551269531250000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(1.417351093183736492767210449419689603273e-57) }, 
      { SC_(1.022709503173828125000000000000000000000e2), SC_(1.803178977966308593750000000000000000000e1), SC_(1.203027439117431640625000000000000000000e1), SC_(2.489187894860431662832274494325344409044e-33), SC_(9.999999999999999999999999999999975108121e-1) }, 
      { SC_(1.022709503173828125000000000000000000000e2), SC_(6.300376892089843750000000000000000000000e1), SC_(4.131867980957031250000000000000000000000e1), SC_(1.863717764438118737209026563549291091122e-17), SC_(9.999999999999999813628223556188126279097e-1) }, 
      { SC_(1.022709503173828125000000000000000000000e2), SC_(1.224560546875000000000000000000000000000e2), SC_(1.123635025024414062500000000000000000000e2), SC_(1.562309944720834483076150644397119189573e-7), SC_(9.999998437690055279165516923849355602881e-1) }, 
      { SC_(1.022709503173828125000000000000000000000e2), SC_(1.562923583984375000000000000000000000000e2), SC_(1.939224700927734375000000000000000000000e2), SC_(8.258780457581631026955349046902786232602e-3), SC_(9.917412195424183689730446509530972137674e-1) }, 
      { SC_(1.022709503173828125000000000000000000000e2), SC_(4.178839721679687500000000000000000000000e2), SC_(4.681394042968750000000000000000000000000e2), SC_(1.127617352458129417761740693640329728914e-1), SC_(8.872382647541870582238259306359670271086e-1) }, 
      { SC_(1.022709503173828125000000000000000000000e2), SC_(6.697814941406250000000000000000000000000e2), SC_(7.643319091796875000000000000000000000000e2), SC_(4.498977537652141854059258795223599226429e-1), SC_(5.501022462347858145940741204776400773571e-1) }, 
      { SC_(1.022709503173828125000000000000000000000e2), SC_(1.123881347656250000000000000000000000000e3), SC_(1.224926147460937500000000000000000000000e3), SC_(4.985999647216386426350875863423295225661e-1), SC_(5.014000352783613573649124136576704774339e-1) }, 
      { SC_(1.022709503173828125000000000000000000000e2), SC_(3.168707763671875000000000000000000000000e3), SC_(3.270978759765625000000000000000000000000e3), SC_(5.034969893045204369695930956253638797689e-1), SC_(4.965030106954795630304069043746361202311e-1) }, 
      { SC_(1.022709503173828125000000000000000000000e2), SC_(5.236728515625000000000000000000000000000e3), SC_(5.339533691406250000000000000000000000000e3), SC_(5.041995783547151692163350304141522450987e-1), SC_(4.958004216452848307836649695858477549013e-1) }, 
      { SC_(1.022709503173828125000000000000000000000e2), SC_(9.735224609375000000000000000000000000000e3), SC_(9.847333007812500000000000000000000000000e3), SC_(5.218324048038104189906770175658517840455e-1), SC_(4.781675951961895810093229824341482159545e-1) }, 
      { SC_(1.022709503173828125000000000000000000000e2), SC_(2.534410546875000000000000000000000000000e4), SC_(2.570083984375000000000000000000000000000e4), SC_(7.880103151988891744733896616244249648153e-1), SC_(2.119896848011108255266103383755750351847e-1) }, 
      { SC_(1.076231689453125000000000000000000000000e2), SC_(1.814723730087280273437500000000000000000), SC_(1.203816833496093750000000000000000000000e2), SC_(7.750624369611961643063262555200813807594e-1), SC_(2.249375630388038356936737444799186192406e-1) }, 
      { SC_(1.076231689453125000000000000000000000000e2), SC_(2.270954132080078125000000000000000000000), SC_(1.318729553222656250000000000000000000000e2), SC_(9.228340394039078619369894783923632677951e-1), SC_(7.716596059609213806301052160763673220487e-2) }, 
      { SC_(1.076231689453125000000000000000000000000e2), SC_(7.623167991638183593750000000000000000000), SC_(1.498202362060546875000000000000000000000e2), SC_(9.803864144780559501573182632699657782309e-1), SC_(1.961358552194404984268173673003422176910e-2) }, 
      { SC_(1.076231689453125000000000000000000000000e2), SC_(1.468006896972656250000000000000000000000e1), SC_(1.834548645019531250000000000000000000000e2), SC_(9.994450477369483313976504627305397704752e-1), SC_(5.549522630516686023495372694602295248293e-4) }, 
      { SC_(1.076231689453125000000000000000000000000e2), SC_(1.803178977966308593750000000000000000000e1), SC_(2.513099212646484375000000000000000000000e2), SC_(9.999999978494698815923024286513386419513e-1), SC_(2.150530118407697571348661358048672055570e-9) }, 
      { SC_(1.076231689453125000000000000000000000000e2), SC_(6.300376892089843750000000000000000000000e1), SC_(5.118807983398437500000000000000000000000e2), SC_(9.999999999999999999999999996281454655250e-1), SC_(3.718545344749508823584391984811260019469e-28) }, 
      { SC_(1.076231689453125000000000000000000000000e2), SC_(1.224560546875000000000000000000000000000e2), SC_(9.203168945312500000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(1.844040117407159954894223705683882648116e-61) }, 
      { SC_(1.076231689453125000000000000000000000000e2), SC_(1.562923583984375000000000000000000000000e2), SC_(1.319577636718750000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(2.307567466440535440269025223714763348054e-102) }, 
      { SC_(1.076231689453125000000000000000000000000e2), SC_(4.178839721679687500000000000000000000000e2), SC_(5.255071640014648437500000000000000000000e1), SC_(2.531796845396444591295015433691444544079e-68), SC_(1.000000000000000000000000000000000000000) }, 
      { SC_(1.076231689453125000000000000000000000000e2), SC_(6.697814941406250000000000000000000000000e2), SC_(1.943511657714843750000000000000000000000e2), SC_(2.750789427801526842024111313182490307468e-49), SC_(1.000000000000000000000000000000000000000) }, 
      { SC_(1.076231689453125000000000000000000000000e2), SC_(1.123881347656250000000000000000000000000e3), SC_(6.157522583007812500000000000000000000000e2), SC_(2.461738268060311544490176429122248153100e-26), SC_(9.999999999999999999999999753826173193969e-1) }, 
      { SC_(1.076231689453125000000000000000000000000e2), SC_(3.168707763671875000000000000000000000000e3), SC_(2.457248291015625000000000000000000000000e3), SC_(5.405661850111669636069837606294397747895e-15), SC_(9.999999999999945943381498883303639301624e-1) }, 
      { SC_(1.076231689453125000000000000000000000000e2), SC_(5.236728515625000000000000000000000000000e3), SC_(4.809916503906250000000000000000000000000e3), SC_(8.354544126325367215549378532566857712491e-5), SC_(9.999164545587367463278445062146743314229e-1) }, 
      { SC_(1.076231689453125000000000000000000000000e2), SC_(9.735224609375000000000000000000000000000e3), SC_(9.744418945312500000000000000000000000000e3), SC_(3.107885865480433461597834983181702392517e-1), SC_(6.892114134519566538402165016818297607483e-1) }, 
      { SC_(1.076231689453125000000000000000000000000e2), SC_(2.534410546875000000000000000000000000000e4), SC_(2.542627734375000000000000000000000000000e4), SC_(4.694171447888456738194422581057552910696e-1), SC_(5.305828552111543261805577418942447089304e-1) }, 
      { SC_(1.146800689697265625000000000000000000000e2), SC_(1.814723730087280273437500000000000000000), SC_(1.164947891235351562500000000000000000000e2), SC_(5.175568165717480244417625170911940287297e-1), SC_(4.824431834282519755582374829088059712703e-1) }, 
      { SC_(1.146800689697265625000000000000000000000e2), SC_(2.270954132080078125000000000000000000000), SC_(1.169627151489257812500000000000000000000e2), SC_(5.178551608267340377873127329785924010260e-1), SC_(4.821448391732659622126872670214075989740e-1) }, 
      { SC_(1.146800689697265625000000000000000000000e2), SC_(7.623167991638183593750000000000000000000), SC_(1.224255447387695312500000000000000000000e2), SC_(5.204907972977779716918496579742369694450e-1), SC_(4.795092027022220283081503420257630305550e-1) }, 
      { SC_(1.146800689697265625000000000000000000000e2), SC_(1.468006896972656250000000000000000000000e1), SC_(1.306537322998046875000000000000000000000e2), SC_(5.474528038995881333124532630668392901748e-1), SC_(4.525471961004118666875467369331607098252e-1) }, 
      { SC_(1.146800689697265625000000000000000000000e2), SC_(1.803178977966308593750000000000000000000e1), SC_(1.459830474853515625000000000000000000000e2), SC_(7.832288366979795704969093528018475003507e-1), SC_(2.167711633020204295030906471981524996493e-1) }, 
      { SC_(1.146800689697265625000000000000000000000e2), SC_(6.300376892089843750000000000000000000000e1), SC_(2.132206115722656250000000000000000000000e2), SC_(9.413783073078313307265389267620909849263e-1), SC_(5.862169269216866927346107323790901507365e-2) }, 
      { SC_(1.146800689697265625000000000000000000000e2), SC_(1.224560546875000000000000000000000000000e2), SC_(3.082769470214843750000000000000000000000e2), SC_(9.934777844272251128630090437162209999485e-1), SC_(6.522215572774887136990956283779000051496e-3) }, 
      { SC_(1.146800689697265625000000000000000000000e2), SC_(1.562923583984375000000000000000000000000e2), SC_(4.064586181640625000000000000000000000000e2), SC_(9.999821138010587036978045188884872283393e-1), SC_(1.788619894129630219548111151277166068256e-5) }, 
      { SC_(1.146800689697265625000000000000000000000e2), SC_(4.178839721679687500000000000000000000000e2), SC_(1.065128051757812500000000000000000000000e3), SC_(9.999999999999999999999935904841949523242e-1), SC_(6.409515805047675849166079894491046374664e-24) }, 
      { SC_(1.146800689697265625000000000000000000000e2), SC_(6.697814941406250000000000000000000000000e2), SC_(2.353384765625000000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(1.023661920851538295705929615761053588337e-98) }, 
      //{ SC_(1.146800689697265625000000000000000000000e2), SC_(1.123881347656250000000000000000000000000e3), SC_(4.954245605468750000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(9.981443894896708755422107969100144511423e-280) }, 
      { SC_(1.146800689697265625000000000000000000000e2), SC_(3.168707763671875000000000000000000000000e3), SC_(1.641693945312500000000000000000000000000e4), SC_(1.000000000000000000000000000000000000000), SC_(2.211584751667926504338064281830540287596e-1103) }, 
      { SC_(1.146800689697265625000000000000000000000e2), SC_(5.236728515625000000000000000000000000000e3), SC_(5.351408691406250000000000000000000000000e2), SC_(1.001060468250084974228706622505658052743e-557), SC_(1.000000000000000000000000000000000000000) }, 
      { SC_(1.146800689697265625000000000000000000000e2), SC_(9.735224609375000000000000000000000000000e3), SC_(2.462476074218750000000000000000000000000e3), SC_(3.076998312034325431109311869678310633288e-542), SC_(1.000000000000000000000000000000000000000) }, 
      { SC_(1.146800689697265625000000000000000000000e2), SC_(2.534410546875000000000000000000000000000e4), SC_(1.272939257812500000000000000000000000000e4), SC_(2.582783056414707066651486369690842337313e-478), SC_(1.000000000000000000000000000000000000000) }, 
      { SC_(1.180317916870117187500000000000000000000e2), SC_(1.814723730087280273437500000000000000000), SC_(8.988488769531250000000000000000000000000e1), SC_(1.947215129705794162400262597110130678675e-2), SC_(9.805278487029420583759973740288986932133e-1) }, 
      { SC_(1.180317916870117187500000000000000000000e2), SC_(2.270954132080078125000000000000000000000), SC_(1.082724685668945312500000000000000000000e2), SC_(2.260847634753909672699530965233752354440e-1), SC_(7.739152365246090327300469034766247645560e-1) }, 
      { SC_(1.180317916870117187500000000000000000000e2), SC_(7.623167991638183593750000000000000000000), SC_(1.243984146118164062500000000000000000000e2), SC_(4.864415278870480310004614177780510249441e-1), SC_(5.135584721129519689995385822219489750559e-1) }, 
      { SC_(1.180317916870117187500000000000000000000e2), SC_(1.468006896972656250000000000000000000000e1), SC_(1.325791473388671875000000000000000000000e2), SC_(5.139572375025050413624535636515953815362e-1), SC_(4.860427624974949586375464363484046184638e-1) }, 
      { SC_(1.180317916870117187500000000000000000000e2), SC_(1.803178977966308593750000000000000000000e1), SC_(1.360635833740234375000000000000000000000e2), SC_(5.169279946798113870238456169273764061147e-1), SC_(4.830720053201886129761543830726235938853e-1) }, 
      { SC_(1.180317916870117187500000000000000000000e2), SC_(6.300376892089843750000000000000000000000e1), SC_(1.810536651611328125000000000000000000000e2), SC_(5.154815960157419965920383135337618177151e-1), SC_(4.845184039842580034079616864662381822849e-1) }, 
      { SC_(1.180317916870117187500000000000000000000e2), SC_(1.224560546875000000000000000000000000000e2), SC_(2.407283477783203125000000000000000000000e2), SC_(5.167639614756665255117281881493833876847e-1), SC_(4.832360385243334744882718118506166123153e-1) }, 
      { SC_(1.180317916870117187500000000000000000000e2), SC_(1.562923583984375000000000000000000000000e2), SC_(2.770673828125000000000000000000000000000e2), SC_(5.493914007570467249832828175795874676982e-1), SC_(4.506085992429532750167171824204125323018e-1) }, 
      { SC_(1.180317916870117187500000000000000000000e2), SC_(4.178839721679687500000000000000000000000e2), SC_(5.895073852539062500000000000000000000000e2), SC_(8.882130032023238959253365037648334240734e-1), SC_(1.117869967976761040746634962351665759266e-1) }, 
      { SC_(1.180317916870117187500000000000000000000e2), SC_(6.697814941406250000000000000000000000000e2), SC_(9.453759765625000000000000000000000000000e2), SC_(9.974140880981057159646959807649043372741e-1), SC_(2.585911901894284035304019235095662725923e-3) }, 
      { SC_(1.180317916870117187500000000000000000000e2), SC_(1.123881347656250000000000000000000000000e3), SC_(1.614486938476562500000000000000000000000e3), SC_(9.999997953811623764782742168117905843459e-1), SC_(2.046188376235217257831882094156540543191e-7) }, 
      { SC_(1.180317916870117187500000000000000000000e2), SC_(3.168707763671875000000000000000000000000e3), SC_(4.930109375000000000000000000000000000000e3), SC_(9.999999999999999999999999999999999999934e-1), SC_(6.557262454499425866053901459949272385297e-39) }, 
      //{ SC_(1.180317916870117187500000000000000000000e2), SC_(5.236728515625000000000000000000000000000e3), SC_(1.070952050781250000000000000000000000000e4), SC_(1.000000000000000000000000000000000000000), SC_(6.167443665608496863538189576167114928763e-204) }, 
      { SC_(1.180317916870117187500000000000000000000e2), SC_(9.735224609375000000000000000000000000000e3), SC_(2.955976953125000000000000000000000000000e4), SC_(1.000000000000000000000000000000000000000), SC_(1.990645628766642822455100767265998174079e-1154) }, 
      { SC_(1.180317916870117187500000000000000000000e2), SC_(2.534410546875000000000000000000000000000e4), SC_(1.018485468750000000000000000000000000000e5), SC_(1.000000000000000000000000000000000000000), BOOST_MATH_SMALL_CONSTANT(SC_(2.161179594078246743099231258168478258347e-5540)) }, 
      { SC_(1.630037689208984375000000000000000000000e2), SC_(1.814723730087280273437500000000000000000), SC_(8.240924682617187500000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(2.472200591904090894287894991961986227014e-87) }, 
      { SC_(1.630037689208984375000000000000000000000e2), SC_(2.270954132080078125000000000000000000000), SC_(1.652747154235839843750000000000000000000e1), SC_(1.100485350257933009825823755964439914036e-51), SC_(1.000000000000000000000000000000000000000) }, 
      { SC_(1.630037689208984375000000000000000000000e2), SC_(7.623167991638183593750000000000000000000), SC_(4.265673446655273437500000000000000000000e1), SC_(1.676359039911057637896453411108497715675e-24), SC_(9.999999999999999999999983236409600889424e-1) }, 
      { SC_(1.630037689208984375000000000000000000000e2), SC_(1.468006896972656250000000000000000000000e1), SC_(8.884191894531250000000000000000000000000e1), SC_(1.164969194183895855679638135617737927178e-8), SC_(9.999999883503080581610414432036186438226e-1) }, 
      { SC_(1.630037689208984375000000000000000000000e2), SC_(1.803178977966308593750000000000000000000e1), SC_(1.357766723632812500000000000000000000000e2), SC_(7.112306682937619797705492063264441702165e-3), SC_(9.928876933170623802022945079367355582978e-1) }, 
      { SC_(1.630037689208984375000000000000000000000e2), SC_(6.300376892089843750000000000000000000000e1), SC_(2.034067840576171875000000000000000000000e2), SC_(1.742662914239236826164143779813315699532e-1), SC_(8.257337085760763173835856220186684300468e-1) }, 
      { SC_(1.630037689208984375000000000000000000000e2), SC_(1.224560546875000000000000000000000000000e2), SC_(2.826052551269531250000000000000000000000e2), SC_(4.721667273783140745264087516185628684384e-1), SC_(5.278332726216859254735912483814371315616e-1) }, 
      { SC_(1.630037689208984375000000000000000000000e2), SC_(1.562923583984375000000000000000000000000e2), SC_(3.189768371582031250000000000000000000000e2), SC_(5.073340422817300502164732534473078036562e-1), SC_(4.926659577182699497835267465526921963438e-1) }, 
      { SC_(1.630037689208984375000000000000000000000e2), SC_(4.178839721679687500000000000000000000000e2), SC_(5.808877563476562500000000000000000000000e2), SC_(5.084425784308410096109099619882472640584e-1), SC_(4.915574215691589903890900380117527359416e-1) }, 
      { SC_(1.630037689208984375000000000000000000000e2), SC_(6.697814941406250000000000000000000000000e2), SC_(8.328685913085937500000000000000000000000e2), SC_(5.076215130697597231357348705370430113246e-1), SC_(4.923784869302402768642651294629569886754e-1) }, 
      { SC_(1.630037689208984375000000000000000000000e2), SC_(1.123881347656250000000000000000000000000e3), SC_(1.288172119140625000000000000000000000000e3), SC_(5.130053244241986493194984827039569019536e-1), SC_(4.869946755758013506805015172960430980464e-1) }, 
      { SC_(1.630037689208984375000000000000000000000e2), SC_(3.168707763671875000000000000000000000000e3), SC_(3.365028564453125000000000000000000000000e3), SC_(6.179638457481887207790406518030328627503e-1), SC_(3.820361542518112792209593481969671372497e-1) }, 
      { SC_(1.630037689208984375000000000000000000000e2), SC_(5.236728515625000000000000000000000000000e3), SC_(5.939705566406250000000000000000000000000e3), SC_(9.998525794827361155193941307104012561682e-1), SC_(1.474205172638844806058692895987438318365e-4) }, 
      { SC_(1.630037689208984375000000000000000000000e2), SC_(9.735224609375000000000000000000000000000e3), SC_(1.187787500000000000000000000000000000000e4), SC_(9.999999999999999999992693124213364036372e-1), SC_(7.306875786635963628473778675673846968476e-22) }, 
      { SC_(1.630037689208984375000000000000000000000e2), SC_(2.534410546875000000000000000000000000000e4), SC_(3.315924218750000000000000000000000000000e4), SC_(1.000000000000000000000000000000000000000), SC_(1.171713989432710553899691141304571887693e-111) }, 
      { SC_(2.224560546875000000000000000000000000000e2), SC_(1.814723730087280273437500000000000000000), SC_(3.364061889648437500000000000000000000000e2), SC_(9.999980485810349339520012377640543805909e-1), SC_(1.951418965066047998762235945619409083446e-6) }, 
      { SC_(2.224560546875000000000000000000000000000e2), SC_(2.270954132080078125000000000000000000000), SC_(4.494540100097656250000000000000000000000e2), SC_(9.999999999999999444414427488535637060159e-1), SC_(5.555855725114643629398410388513923250589e-17) }, 
      { SC_(2.224560546875000000000000000000000000000e2), SC_(7.623167991638183593750000000000000000000), SC_(6.902376708984375000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(4.301753658418322991049708505117545207079e-46) }, 
      { SC_(2.224560546875000000000000000000000000000e2), SC_(1.468006896972656250000000000000000000000e1), SC_(9.485444946289062500000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(2.880074718448242018542999492358797222097e-81) }, 
      { SC_(2.224560546875000000000000000000000000000e2), SC_(1.803178977966308593750000000000000000000e1), SC_(1.202439208984375000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(7.113289026243423812200592148154381863533e-120) }, 
      { SC_(2.224560546875000000000000000000000000000e2), SC_(6.300376892089843750000000000000000000000e1), SC_(2.854598426818847656250000000000000000000e1), SC_(3.880624760865504725819777373414434531709e-71), SC_(1.000000000000000000000000000000000000000) }, 
      { SC_(2.224560546875000000000000000000000000000e2), SC_(1.224560546875000000000000000000000000000e2), SC_(8.622802734375000000000000000000000000000e1), SC_(2.118120151077913751996766387584262352343e-35), SC_(9.999999999999999999999999999999999788188e-1) }, 
      { SC_(2.224560546875000000000000000000000000000e2), SC_(1.562923583984375000000000000000000000000e2), SC_(1.893742065429687500000000000000000000000e2), SC_(9.974467429778899857536159278483717545919e-13), SC_(9.999999999990025532570221100142463840722e-1) }, 
      { SC_(2.224560546875000000000000000000000000000e2), SC_(4.178839721679687500000000000000000000000e2), SC_(4.802550048828125000000000000000000000000e2), SC_(9.090488852436649001660839859870004365726e-5), SC_(9.999090951114756335099833916014012999563e-1) }, 
      { SC_(2.224560546875000000000000000000000000000e2), SC_(6.697814941406250000000000000000000000000e2), SC_(8.030137939453125000000000000000000000000e2), SC_(5.210689060556661428703090383639533434012e-2), SC_(9.478931093944333857129690961636046656599e-1) }, 
      { SC_(2.224560546875000000000000000000000000000e2), SC_(1.123881347656250000000000000000000000000e3), SC_(1.332874023437500000000000000000000000000e3), SC_(4.292755031946655998827932460863433352210e-1), SC_(5.707244968053344001172067539136566647790e-1) }, 
      { SC_(2.224560546875000000000000000000000000000e2), SC_(3.168707763671875000000000000000000000000e3), SC_(3.387772705078125000000000000000000000000e3), SC_(4.916311154510142131831934457614211574607e-1), SC_(5.083688845489857868168065542385788425393e-1) }, 
      { SC_(2.224560546875000000000000000000000000000e2), SC_(5.236728515625000000000000000000000000000e3), SC_(5.459184570312500000000000000000000000000e3), SC_(5.027087871839553435764977648808052844991e-1), SC_(4.972912128160446564235022351191947155009e-1) }, 
      { SC_(2.224560546875000000000000000000000000000e2), SC_(9.735224609375000000000000000000000000000e3), SC_(9.958676757812500000000000000000000000000e3), SC_(5.040048528962274385367615026215050626182e-1), SC_(4.959951471037725614632384973784949373818e-1) }, 
      { SC_(2.224560546875000000000000000000000000000e2), SC_(2.534410546875000000000000000000000000000e4), SC_(2.559213085937500000000000000000000000000e4), SC_(5.331693942080920197270172783596853702685e-1), SC_(4.668306057919079802729827216403146297315e-1) }, 
      { SC_(2.562923583984375000000000000000000000000e2), SC_(1.814723730087280273437500000000000000000), SC_(2.606881408691406250000000000000000000000e2), SC_(5.565601780565237268786436594857008160846e-1), SC_(4.434398219434762731213563405142991839154e-1) }, 
      { SC_(2.562923583984375000000000000000000000000e2), SC_(2.270954132080078125000000000000000000000), SC_(2.844196777343750000000000000000000000000e2), SC_(8.698321253054475729157580863492668965440e-1), SC_(1.301678746945524270842419136507331034560e-1) }, 
      { SC_(2.562923583984375000000000000000000000000e2), SC_(7.623167991638183593750000000000000000000), SC_(3.166986389160156250000000000000000000000e2), SC_(9.845563776985094919838411087476167790874e-1), SC_(1.544362230149050801615889125238322091256e-2) }, 
      { SC_(2.562923583984375000000000000000000000000e2), SC_(1.468006896972656250000000000000000000000e1), SC_(3.522641296386718750000000000000000000000e2), SC_(9.991544780167738955500496557397274582846e-1), SC_(8.455219832261044499503442602725417153932e-4) }, 
      { SC_(2.562923583984375000000000000000000000000e2), SC_(1.803178977966308593750000000000000000000e1), SC_(4.114862365722656250000000000000000000000e2), SC_(9.999996546003172898959656355039046832883e-1), SC_(3.453996827101040343644960953167116580296e-7) }, 
      { SC_(2.562923583984375000000000000000000000000e2), SC_(6.300376892089843750000000000000000000000e1), SC_(6.385922851562500000000000000000000000000e2), SC_(9.999999999999999999676537773847355327785e-1), SC_(3.234622261526446722151099892086967653726e-20) }, 
      { SC_(2.562923583984375000000000000000000000000e2), SC_(1.224560546875000000000000000000000000000e2), SC_(1.136245239257812500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(2.673485662513226381801134618115179363039e-61) }, 
      { SC_(2.562923583984375000000000000000000000000e2), SC_(1.562923583984375000000000000000000000000e2), SC_(1.650338867187500000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(8.305947564222555363239940610714317285055e-116) }, 
      //{ SC_(2.562923583984375000000000000000000000000e2), SC_(4.178839721679687500000000000000000000000e2), SC_(3.370881591796875000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(4.910656898529544413713954362720656458792e-255) }, 
      { SC_(2.562923583984375000000000000000000000000e2), SC_(6.697814941406250000000000000000000000000e2), SC_(9.260738372802734375000000000000000000000e1), SC_(1.042689231483994884931307605902471685238e-128), SC_(1.000000000000000000000000000000000000000) }, 
      { SC_(2.562923583984375000000000000000000000000e2), SC_(1.123881347656250000000000000000000000000e3), SC_(3.450434265136718750000000000000000000000e2), SC_(2.328799164721530805537291172515795755880e-89), SC_(1.000000000000000000000000000000000000000) }, 
      { SC_(2.562923583984375000000000000000000000000e2), SC_(3.168707763671875000000000000000000000000e3), SC_(1.712500000000000000000000000000000000000e3), SC_(3.251511898122298320287023411605843121442e-69), SC_(1.000000000000000000000000000000000000000) }, 
      { SC_(2.562923583984375000000000000000000000000e2), SC_(5.236728515625000000000000000000000000000e3), SC_(4.119765625000000000000000000000000000000e3), SC_(4.504285512937865010441104149552347902151e-24), SC_(9.999999999999999999999954957144870621350e-1) }, 
      { SC_(2.562923583984375000000000000000000000000e2), SC_(9.735224609375000000000000000000000000000e3), SC_(8.992364257812500000000000000000000000000e3), SC_(1.243000478035549518001937001923412217046e-7), SC_(9.999998756999521964450481998062998076588e-1) }, 
      { SC_(2.562923583984375000000000000000000000000e2), SC_(2.534410546875000000000000000000000000000e4), SC_(2.534439453125000000000000000000000000000e4), SC_(2.115946731097428193661070503057387125564e-1), SC_(7.884053268902571806338929496942612874436e-1) }, 
      { SC_(5.178839721679687500000000000000000000000e2), SC_(1.814723730087280273437500000000000000000), SC_(5.191789550781250000000000000000000000000e2), SC_(5.018428970452626954274890477115999283286e-1), SC_(4.981571029547373045725109522884000716714e-1) }, 
      { SC_(5.178839721679687500000000000000000000000e2), SC_(2.270954132080078125000000000000000000000), SC_(5.201549072265625000000000000000000000000e2), SC_(5.082636544502895252322104229252925738217e-1), SC_(4.917363455497104747677895770747074261783e-1) }, 
      { SC_(5.178839721679687500000000000000000000000e2), SC_(7.623167991638183593750000000000000000000), SC_(5.255596923828125000000000000000000000000e2), SC_(5.089033863962370418852899920139919320620e-1), SC_(4.910966136037629581147100079860080679380e-1) }, 
      { SC_(5.178839721679687500000000000000000000000e2), SC_(1.468006896972656250000000000000000000000e1), SC_(5.330966186523437500000000000000000000000e2), SC_(5.146717669454083771190789480158423124984e-1), SC_(4.853282330545916228809210519841576875016e-1) }, 
      { SC_(5.178839721679687500000000000000000000000e2), SC_(1.803178977966308593750000000000000000000e1), SC_(5.412749023437500000000000000000000000000e2), SC_(5.718710674091369019082278384626477485443e-1), SC_(4.281289325908630980917721615373522514557e-1) }, 
      { SC_(5.178839721679687500000000000000000000000e2), SC_(6.300376892089843750000000000000000000000e1), SC_(6.389765625000000000000000000000000000000e2), SC_(9.439013403919378265416446040109020236115e-1), SC_(5.609865960806217345835539598909797638853e-2) }, 
      { SC_(5.178839721679687500000000000000000000000e2), SC_(1.224560546875000000000000000000000000000e2), SC_(7.684080810546875000000000000000000000000e2), SC_(9.990551656702288516259526175588136299942e-1), SC_(9.448343297711483740473824411863700057515e-4) }, 
      { SC_(5.178839721679687500000000000000000000000e2), SC_(1.562923583984375000000000000000000000000e2), SC_(8.764291992187500000000000000000000000000e2), SC_(9.999975838760454752260266401016787163680e-1), SC_(2.416123954524773973359898321283632012481e-6) }, 
      { SC_(5.178839721679687500000000000000000000000e2), SC_(4.178839721679687500000000000000000000000e2), SC_(1.403651855468750000000000000000000000000e3), SC_(9.999999999999989832787117952102660892203e-1), SC_(1.016721288204789733910779740722377830151e-15) }, 
      { SC_(5.178839721679687500000000000000000000000e2), SC_(6.697814941406250000000000000000000000000e2), SC_(2.375331054687500000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(3.501924408919092527478954034342378175277e-56) }, 
      //{ SC_(5.178839721679687500000000000000000000000e2), SC_(1.123881347656250000000000000000000000000e3), SC_(4.925295898437500000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(1.251260895493816468078725770917244613921e-217) }, 
      { SC_(5.178839721679687500000000000000000000000e2), SC_(3.168707763671875000000000000000000000000e3), SC_(1.474636718750000000000000000000000000000e4), SC_(1.000000000000000000000000000000000000000), SC_(3.049732080748864882222025311867596124637e-840) }, 
      { SC_(5.178839721679687500000000000000000000000e2), SC_(5.236728515625000000000000000000000000000e3), SC_(2.877306250000000000000000000000000000000e4), SC_(1.000000000000000000000000000000000000000), SC_(8.102680562521045884667769318561839749897e-1963) }, 
      { SC_(5.178839721679687500000000000000000000000e2), SC_(9.735224609375000000000000000000000000000e3), SC_(1.025310913085937500000000000000000000000e3), SC_(2.086116728061743184630249199645420023099e-1098), SC_(1.000000000000000000000000000000000000000) }, 
      { SC_(5.178839721679687500000000000000000000000e2), SC_(2.534410546875000000000000000000000000000e4), SC_(6.465497558593750000000000000000000000000e3), SC_(7.480293111923135370961947853995388096976e-1429), SC_(1.000000000000000000000000000000000000000) }, 
      { SC_(7.697814941406250000000000000000000000000e2), SC_(1.814723730087280273437500000000000000000), SC_(3.857980957031250000000000000000000000000e2), SC_(2.094810115698022475718024937612859791203e-34), SC_(9.999999999999999999999999999999997905190e-1) }, 
      { SC_(7.697814941406250000000000000000000000000e2), SC_(2.270954132080078125000000000000000000000), SC_(5.790393066406250000000000000000000000000e2), SC_(3.970702416296524097412618944942891559283e-8), SC_(9.999999602929758370347590258738105505711e-1) }, 
      { SC_(7.697814941406250000000000000000000000000e2), SC_(7.623167991638183593750000000000000000000), SC_(6.996641845703125000000000000000000000000e2), SC_(2.198816676838870688152659456648601860948e-2), SC_(9.780118332316112931184734054335139813905e-1) }, 
      { SC_(7.697814941406250000000000000000000000000e2), SC_(1.468006896972656250000000000000000000000e1), SC_(7.766169433593750000000000000000000000000e2), SC_(4.286229391652691545286141245474001972205e-1), SC_(5.713770608347308454713858754525998027795e-1) }, 
      { SC_(7.697814941406250000000000000000000000000e2), SC_(1.803178977966308593750000000000000000000e1), SC_(7.870255126953125000000000000000000000000e2), SC_(4.989431839765173657060002365081485247308e-1), SC_(5.010568160234826342939997634918514752692e-1) }, 
      { SC_(7.697814941406250000000000000000000000000e2), SC_(6.300376892089843750000000000000000000000e1), SC_(8.327852783203125000000000000000000000000e2), SC_(5.067257722102137039626441640876166123882e-1), SC_(4.932742277897862960373558359123833876118e-1) }, 
      { SC_(7.697814941406250000000000000000000000000e2), SC_(1.224560546875000000000000000000000000000e2), SC_(8.923267822265625000000000000000000000000e2), SC_(5.074067022955277229900539344068357456993e-1), SC_(4.925932977044722770099460655931642543007e-1) }, 
      { SC_(7.697814941406250000000000000000000000000e2), SC_(1.562923583984375000000000000000000000000e2), SC_(9.270000000000000000000000000000000000000e2), SC_(5.144771376550600421916346149802460913093e-1), SC_(4.855228623449399578083653850197539086907e-1) }, 
      { SC_(7.697814941406250000000000000000000000000e2), SC_(4.178839721679687500000000000000000000000e2), SC_(1.199542114257812500000000000000000000000e3), SC_(5.885220022049549001129281220077400108965e-1), SC_(4.114779977950450998870718779922599891035e-1) }, 
      { SC_(7.697814941406250000000000000000000000000e2), SC_(6.697814941406250000000000000000000000000e2), SC_(1.583519287109375000000000000000000000000e3), SC_(9.848718953064180991811462866401103313212e-1), SC_(1.512810469358190081885371335988966867876e-2) }, 
      { SC_(7.697814941406250000000000000000000000000e2), SC_(1.123881347656250000000000000000000000000e3), SC_(2.272395507812500000000000000000000000000e3), SC_(9.999982045156649819489872628059939735894e-1), SC_(1.795484335018051012737194006026410615612e-6) }, 
      { SC_(7.697814941406250000000000000000000000000e2), SC_(3.168707763671875000000000000000000000000e3), SC_(5.120035644531250000000000000000000000000e3), SC_(9.999999999999999999863075990842006528749e-1), SC_(1.369240091579934712506069050438583163269e-20) }, 
      { SC_(7.697814941406250000000000000000000000000e2), SC_(5.236728515625000000000000000000000000000e3), SC_(9.009764648437500000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(3.192153768420601580491738882434963851091e-72) }, 
      { SC_(7.697814941406250000000000000000000000000e2), SC_(9.735224609375000000000000000000000000000e3), SC_(2.101001171875000000000000000000000000000e4), SC_(1.000000000000000000000000000000000000000), SC_(6.556792532966431645836324757077329100213e-406) }, 
      //{ SC_(7.697814941406250000000000000000000000000e2), SC_(2.534410546875000000000000000000000000000e4), SC_(7.834165625000000000000000000000000000000e4), SC_(1.000000000000000000000000000000000000000), SC_(4.255660721475854021027198441934779497924e-3073) }, 
      { SC_(1.223881347656250000000000000000000000000e3), SC_(1.814723730087280273437500000000000000000), SC_(4.902784179687500000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(7.329895745765962019154742819065779507102e-432) }, 
      { SC_(1.223881347656250000000000000000000000000e3), SC_(2.270954132080078125000000000000000000000), SC_(6.130761718750000000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(1.889342182043895264971633160211296439752e-638) }, 
      { SC_(1.223881347656250000000000000000000000000e3), SC_(7.623167991638183593750000000000000000000), SC_(1.231504516601562500000000000000000000000e2), SC_(3.122828274000300027223624087110486648582e-375), SC_(1.000000000000000000000000000000000000000) }, 
      { SC_(1.223881347656250000000000000000000000000e3), SC_(1.468006896972656250000000000000000000000e1), SC_(3.096403503417968750000000000000000000000e2), SC_(1.653199461608098592886493106628475751714e-171), SC_(1.000000000000000000000000000000000000000) }, 
      { SC_(1.223881347656250000000000000000000000000e3), SC_(1.803178977966308593750000000000000000000e1), SC_(6.209565429687500000000000000000000000000e2), SC_(1.474827983758064238151439552554843148356e-53), SC_(1.000000000000000000000000000000000000000) }, 
      { SC_(1.223881347656250000000000000000000000000e3), SC_(6.300376892089843750000000000000000000000e1), SC_(9.651638183593750000000000000000000000000e2), SC_(5.837744100240386378028816104449718072592e-12), SC_(9.999999999941622558997596136219711838956e-1) }, 
      { SC_(1.223881347656250000000000000000000000000e3), SC_(1.224560546875000000000000000000000000000e2), SC_(1.211703613281250000000000000000000000000e3), SC_(5.264268319211435849045630410351514965400e-3), SC_(9.947357316807885641509543695896484850346e-1) }, 
      { SC_(1.223881347656250000000000000000000000000e3), SC_(1.562923583984375000000000000000000000000e2), SC_(1.366371948242187500000000000000000000000e3), SC_(4.065073992605205031803201994303319330366e-1), SC_(5.934926007394794968196798005696680669634e-1) }, 
      { SC_(1.223881347656250000000000000000000000000e3), SC_(4.178839721679687500000000000000000000000e2), SC_(1.640123657226562500000000000000000000000e3), SC_(4.947783228183400629818053466361047243409e-1), SC_(5.052216771816599370181946533638952756591e-1) }, 
      { SC_(1.223881347656250000000000000000000000000e3), SC_(6.697814941406250000000000000000000000000e2), SC_(1.893662841796875000000000000000000000000e3), SC_(5.046851977111400890063348688163364920303e-1), SC_(4.953148022888599109936651311836635079697e-1) }, 
      { SC_(1.223881347656250000000000000000000000000e3), SC_(1.123881347656250000000000000000000000000e3), SC_(2.347997558593750000000000000000000000000e3), SC_(5.053495712752585528461146638283235032296e-1), SC_(4.946504287247414471538853361716764967704e-1) }, 
      { SC_(1.223881347656250000000000000000000000000e3), SC_(3.168707763671875000000000000000000000000e3), SC_(4.396981445312500000000000000000000000000e3), SC_(5.173084157509784624208344308997284751222e-1), SC_(4.826915842490215375791655691002715248778e-1) }, 
      { SC_(1.223881347656250000000000000000000000000e3), SC_(5.236728515625000000000000000000000000000e3), SC_(6.525215820312500000000000000000000000000e3), SC_(6.655162935852918021037691215720017086335e-1), SC_(3.344837064147081978962308784279982913665e-1) }, 
      { SC_(1.223881347656250000000000000000000000000e3), SC_(9.735224609375000000000000000000000000000e3), SC_(1.205501660156250000000000000000000000000e4), SC_(9.999999273769394533935277046862610448502e-1), SC_(7.262306054660647229531373895514980090320e-8) }, 
      { SC_(1.223881347656250000000000000000000000000e3), SC_(2.534410546875000000000000000000000000000e4), SC_(3.188158398437500000000000000000000000000e4), SC_(1.000000000000000000000000000000000000000), SC_(4.590595623431455827408688539888024283152e-56) }, 
      { SC_(3.268707763671875000000000000000000000000e3), SC_(1.814723730087280273437500000000000000000), SC_(4.251679199218750000000000000000000000000e3), SC_(9.999999999999999999999999999369304599680e-1), SC_(6.306954003202485935998390071737568071653e-29) }, 
      { SC_(3.268707763671875000000000000000000000000e3), SC_(2.270954132080078125000000000000000000000), SC_(4.906468261718750000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(1.561720607047429031089833790859982654141e-69) }, 
      { SC_(3.268707763671875000000000000000000000000e3), SC_(7.623167991638183593750000000000000000000), SC_(6.552661621093750000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(1.550476433800876678985013711621544946543e-220) }, 
      { SC_(3.268707763671875000000000000000000000000e3), SC_(1.468006896972656250000000000000000000000e1), SC_(9.850164062500000000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(7.380727559751609589377065368658683398863e-643) }, 
      { SC_(3.268707763671875000000000000000000000000e3), SC_(1.803178977966308593750000000000000000000e1), SC_(1.314695800781250000000000000000000000000e4), SC_(1.000000000000000000000000000000000000000), SC_(1.070075198669384428184696868094554956539e-1148) }, 
      { SC_(3.268707763671875000000000000000000000000e3), SC_(6.300376892089843750000000000000000000000e1), SC_(1.665855664062500000000000000000000000000e4), SC_(1.000000000000000000000000000000000000000), SC_(5.473130666182603983102939876795814753306e-1702) }, 
      { SC_(3.268707763671875000000000000000000000000e3), SC_(1.224560546875000000000000000000000000000e2), SC_(3.391163940429687500000000000000000000000e2), SC_(1.276741407233633232703835710222187763106e-998), SC_(1.000000000000000000000000000000000000000) }, 
      { SC_(3.268707763671875000000000000000000000000e3), SC_(1.562923583984375000000000000000000000000e2), SC_(8.562500000000000000000000000000000000000e2), SC_(1.115296743570225436467479346112053113493e-454), SC_(1.000000000000000000000000000000000000000) }, 
      { SC_(3.268707763671875000000000000000000000000e3), SC_(4.178839721679687500000000000000000000000e2), SC_(1.843295898437500000000000000000000000000e3), SC_(9.157150901962893068367802685242026910627e-141), SC_(1.000000000000000000000000000000000000000) }, 
      { SC_(3.268707763671875000000000000000000000000e3), SC_(6.697814941406250000000000000000000000000e2), SC_(2.953866943359375000000000000000000000000e3), SC_(1.407565789077463347175673837791022925398e-29), SC_(9.999999999999999999999999999859243421092e-1) }, 
      { SC_(3.268707763671875000000000000000000000000e3), SC_(1.123881347656250000000000000000000000000e3), SC_(3.953329833984375000000000000000000000000e3), SC_(7.940374169384573883003159947702418665259e-6), SC_(9.999920596258306154261169968400522975813e-1) }, 
      { SC_(3.268707763671875000000000000000000000000e3), SC_(3.168707763671875000000000000000000000000e3), SC_(6.373041503906250000000000000000000000000e3), SC_(3.229699874048570325644015283488133243419e-1), SC_(6.770300125951429674355984716511866756581e-1) }, 
      { SC_(3.268707763671875000000000000000000000000e3), SC_(5.236728515625000000000000000000000000000e3), SC_(8.496931640625000000000000000000000000000e3), SC_(4.817511189518640281763605885755537488723e-1), SC_(5.182488810481359718236394114244462511277e-1) }, 
      { SC_(3.268707763671875000000000000000000000000e3), SC_(9.735224609375000000000000000000000000000e3), SC_(1.300393261718750000000000000000000000000e4), SC_(5.017815537703105249703557002638167692452e-1), SC_(4.982184462296894750296442997361832307548e-1) }, 
      { SC_(3.268707763671875000000000000000000000000e3), SC_(2.534410546875000000000000000000000000000e4), SC_(2.861567382812500000000000000000000000000e4), SC_(5.046636709131849599417788658424494463632e-1), SC_(4.953363290868150400582211341575505536368e-1) }, 
      { SC_(5.336728515625000000000000000000000000000e3), SC_(1.814723730087280273437500000000000000000), SC_(5.343882324218750000000000000000000000000e3), SC_(5.231641912991815247310768938116631968187e-1), SC_(4.768358087008184752689231061883368031813e-1) }, 
      { SC_(5.336728515625000000000000000000000000000e3), SC_(2.270954132080078125000000000000000000000), SC_(5.392389648437500000000000000000000000000e3), SC_(6.989209785829823642527285557816442705306e-1), SC_(3.010790214170176357472714442183557294694e-1) }, 
      { SC_(5.336728515625000000000000000000000000000e3), SC_(7.623167991638183593750000000000000000000), SC_(5.878786621093750000000000000000000000000e3), SC_(9.999997267631334862144092371181640867755e-1), SC_(2.732368665137855907628818359132245077050e-7) }, 
      { SC_(5.336728515625000000000000000000000000000e3), SC_(1.468006896972656250000000000000000000000e1), SC_(6.421690917968750000000000000000000000000e3), SC_(9.999999999999999999998755436517077779140e-1), SC_(1.244563482922220859843457033640238937977e-22) }, 
      { SC_(5.336728515625000000000000000000000000000e3), SC_(1.803178977966308593750000000000000000000e1), SC_(6.961187988281250000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(6.213904209645332170491444002733911787382e-46) }, 
      { SC_(5.336728515625000000000000000000000000000e3), SC_(6.300376892089843750000000000000000000000e1), SC_(8.099598632812500000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(4.129578759179570039501223721133554053649e-112) }, 
      { SC_(5.336728515625000000000000000000000000000e3), SC_(1.224560546875000000000000000000000000000e2), SC_(1.091836914062500000000000000000000000000e4), SC_(1.000000000000000000000000000000000000000), SC_(1.013122398540403737571759044585873714869e-358) }, 
      { SC_(5.336728515625000000000000000000000000000e3), SC_(1.562923583984375000000000000000000000000e2), SC_(1.647906250000000000000000000000000000000e4), SC_(1.000000000000000000000000000000000000000), SC_(1.798378318681131842856599937421909755127e-1049) }, 
      { SC_(5.336728515625000000000000000000000000000e3), SC_(4.178839721679687500000000000000000000000e2), SC_(2.301844921875000000000000000000000000000e4), SC_(1.000000000000000000000000000000000000000), SC_(1.245637974066302551841972589921559293779e-1895) }, 
      { SC_(5.336728515625000000000000000000000000000e3), SC_(6.697814941406250000000000000000000000000e2), SC_(3.003254882812500000000000000000000000000e4), SC_(1.000000000000000000000000000000000000000), SC_(1.964762684623637286574646116911226588649e-2854) }, 
      { SC_(5.336728515625000000000000000000000000000e3), SC_(1.123881347656250000000000000000000000000e3), SC_(6.460609741210937500000000000000000000000e2), SC_(5.434554874828800376020528413555687226962e-1646), SC_(1.000000000000000000000000000000000000000) }, 
      { SC_(5.336728515625000000000000000000000000000e3), SC_(3.168707763671875000000000000000000000000e3), SC_(2.126359130859375000000000000000000000000e3), SC_(4.014044471242827936794218405164185178313e-811), SC_(1.000000000000000000000000000000000000000) }, 
      //{ SC_(5.336728515625000000000000000000000000000e3), SC_(5.236728515625000000000000000000000000000e3), SC_(5.286728515625000000000000000000000000000e3), SC_(4.230486062225304643326517333533191913791e-285), SC_(1.000000000000000000000000000000000000000) }, 
      { SC_(5.336728515625000000000000000000000000000e3), SC_(9.735224609375000000000000000000000000000e3), SC_(1.130396484375000000000000000000000000000e4), SC_(4.137926192929096684247217099159206422184e-75), SC_(1.000000000000000000000000000000000000000) }, 
      { SC_(5.336728515625000000000000000000000000000e3), SC_(2.534410546875000000000000000000000000000e4), SC_(2.761275000000000000000000000000000000000e4), SC_(2.272437242751958256048797820399249083167e-21), SC_(9.999999999999999999977275627572480417440e-1) }, 
      { SC_(9.835224609375000000000000000000000000000e3), SC_(1.814723730087280273437500000000000000000), SC_(9.738668945312500000000000000000000000000e3), SC_(2.423226533318444691190816122183650790120e-1), SC_(7.576773466681555308809183877816349209880e-1) }, 
      { SC_(9.835224609375000000000000000000000000000e3), SC_(2.270954132080078125000000000000000000000), SC_(9.827658203125000000000000000000000000000e3), SC_(4.739300204447159138057411608874372469320e-1), SC_(5.260699795552840861942588391125627530680e-1) }, 
      { SC_(9.835224609375000000000000000000000000000e3), SC_(7.623167991638183593750000000000000000000), SC_(9.842847656250000000000000000000000000000e3), SC_(5.018959763803816158049482480448946260966e-1), SC_(4.981040236196183841950517519551053739034e-1) }, 
      { SC_(9.835224609375000000000000000000000000000e3), SC_(1.468006896972656250000000000000000000000e1), SC_(9.850889648437500000000000000000000000000e3), SC_(5.046936613055142674404951702442208480020e-1), SC_(4.953063386944857325595048297557791519980e-1) }, 
      { SC_(9.835224609375000000000000000000000000000e3), SC_(1.803178977966308593750000000000000000000e1), SC_(9.863110351562500000000000000000000000000e3), SC_(5.298370953450929796710290002338201784199e-1), SC_(4.701629046549070203289709997661798215801e-1) }, 
      { SC_(9.835224609375000000000000000000000000000e3), SC_(6.300376892089843750000000000000000000000e1), SC_(9.997210937500000000000000000000000000000e3), SC_(7.591896468371765812280509666823008804623e-1), SC_(2.408103531628234187719490333176991195377e-1) }, 
      { SC_(9.835224609375000000000000000000000000000e3), SC_(1.224560546875000000000000000000000000000e2), SC_(1.095344921875000000000000000000000000000e4), SC_(9.999999999946528610317823181276409224358e-1), SC_(5.347138968217681872359077564224414898729e-12) }, 
      { SC_(9.835224609375000000000000000000000000000e3), SC_(1.562923583984375000000000000000000000000e2), SC_(1.198982031250000000000000000000000000000e4), SC_(9.999999999999999999999999999999999999995e-1), SC_(4.844117509934818729605680780365877081835e-40) }, 
      { SC_(9.835224609375000000000000000000000000000e3), SC_(4.178839721679687500000000000000000000000e2), SC_(1.332904003906250000000000000000000000000e4), SC_(1.000000000000000000000000000000000000000), SC_(5.501985290758226024441004905328583091016e-83) }, 
      { SC_(9.835224609375000000000000000000000000000e3), SC_(6.697814941406250000000000000000000000000e2), SC_(1.575750878906250000000000000000000000000e4), SC_(1.000000000000000000000000000000000000000), SC_(1.281917879913831434997572136980170169938e-205) }, 
      { SC_(9.835224609375000000000000000000000000000e3), SC_(1.123881347656250000000000000000000000000e3), SC_(2.191821093750000000000000000000000000000e4), SC_(1.000000000000000000000000000000000000000), SC_(1.655478781768704897040723830687178230050e-668) }, 
      { SC_(9.835224609375000000000000000000000000000e3), SC_(3.168707763671875000000000000000000000000e3), SC_(3.901179687500000000000000000000000000000e4), SC_(1.000000000000000000000000000000000000000), SC_(3.472631147339733657827714586706936341515e-2118) }, 
      //{ SC_(9.835224609375000000000000000000000000000e3), SC_(5.236728515625000000000000000000000000000e3), SC_(6.028781250000000000000000000000000000000e4), SC_(1.000000000000000000000000000000000000000), SC_(9.212326594397207246241789680223342444637e-4200) }, 
      { SC_(9.835224609375000000000000000000000000000e3), SC_(9.735224609375000000000000000000000000000e3), SC_(9.785225000000000000000000000000000000000e4), SC_(1.000000000000000000000000000000000000000), BOOST_MATH_SMALL_CONSTANT(SC_(3.538077281516414493897074365065585126946e-7667)) }, 
      //{ SC_(9.835224609375000000000000000000000000000e3), SC_(2.534410546875000000000000000000000000000e4), SC_(3.517932861328125000000000000000000000000e3), SC_(1.099992559780263385542867064735840160345e-4822), SC_(1.000000000000000000000000000000000000000) }, 
      { SC_(2.544410546875000000000000000000000000000e4), SC_(1.814723730087280273437500000000000000000), SC_(6.361479980468750000000000000000000000000e3), SC_(1.181726713955470992474919794090175086526e-3518), SC_(1.000000000000000000000000000000000000000) }, 
      { SC_(2.544410546875000000000000000000000000000e4), SC_(2.270954132080078125000000000000000000000), SC_(1.272318847656250000000000000000000000000e4), SC_(4.884425625229736252928233330384214577613e-1070), SC_(1.000000000000000000000000000000000000000) }, 
      { SC_(2.544410546875000000000000000000000000000e4), SC_(7.623167991638183593750000000000000000000), SC_(1.908879687500000000000000000000000000000e4), SC_(8.962370551702060333750421105332120391485e-211), SC_(1.000000000000000000000000000000000000000) }, 
      { SC_(2.544410546875000000000000000000000000000e4), SC_(1.468006896972656250000000000000000000000e1), SC_(2.291290625000000000000000000000000000000e4), SC_(8.474346197209301705276834960187638277086e-32), SC_(9.999999999999999999999999999999152565380e-1) }, 
      { SC_(2.544410546875000000000000000000000000000e4), SC_(1.803178977966308593750000000000000000000e1), SC_(2.520751562500000000000000000000000000000e4), SC_(1.295024406285843621340357720924586110287e-1), SC_(8.704975593714156378659642279075413889713e-1) }, 
      { SC_(2.544410546875000000000000000000000000000e4), SC_(6.300376892089843750000000000000000000000e1), SC_(2.548160351562500000000000000000000000000e4), SC_(4.562568770648142018768727830933913267766e-1), SC_(5.437431229351857981231272169066086732234e-1) }, 
      { SC_(2.544410546875000000000000000000000000000e4), SC_(1.224560546875000000000000000000000000000e2), SC_(2.556656250000000000000000000000000000000e4), SC_(5.011806692322517737217772574781293569349e-1), SC_(4.988193307677482262782227425218706430651e-1) }, 
      { SC_(2.544410546875000000000000000000000000000e4), SC_(1.562923583984375000000000000000000000000e2), SC_(2.560295898437500000000000000000000000000e4), SC_(5.056803760816591586262668258627004583009e-1), SC_(4.943196239183408413737331741372995416991e-1) }, 
      { SC_(2.544410546875000000000000000000000000000e4), SC_(4.178839721679687500000000000000000000000e2), SC_(2.588785351562500000000000000000000000000e4), SC_(5.460676224635753887770522516056576743617e-1), SC_(4.539323775364246112229477483943423256383e-1) }, 
      { SC_(2.544410546875000000000000000000000000000e4), SC_(6.697814941406250000000000000000000000000e2), SC_(2.637502539062500000000000000000000000000e4), SC_(8.702351059685343076476037133703416750345e-1), SC_(1.297648940314656923523962866296583249655e-1) }, 
      { SC_(2.544410546875000000000000000000000000000e4), SC_(1.123881347656250000000000000000000000000e3), SC_(2.922478515625000000000000000000000000000e4), SC_(9.999999999999999999999999996167282036646e-1), SC_(3.832717963354218502430822356853389506342e-28) }, 
      { SC_(2.544410546875000000000000000000000000000e4), SC_(3.168707763671875000000000000000000000000e3), SC_(3.433537500000000000000000000000000000000e4), SC_(1.000000000000000000000000000000000000000), SC_(1.698150074923070488658872407738404871525e-101) }, 
      { SC_(2.544410546875000000000000000000000000000e4), SC_(5.236728515625000000000000000000000000000e3), SC_(3.988508203125000000000000000000000000000e4), SC_(1.000000000000000000000000000000000000000), SC_(1.092452334181002182656298507096893396391e-217) }, 
      { SC_(2.544410546875000000000000000000000000000e4), SC_(9.735224609375000000000000000000000000000e3), SC_(5.276899218750000000000000000000000000000e4), SC_(1.000000000000000000000000000000000000000), SC_(3.597661166334420937810823788802336702587e-576) }, 
      { SC_(2.544410546875000000000000000000000000000e4), SC_(2.534410546875000000000000000000000000000e4), SC_(1.015764218750000000000000000000000000000e5), SC_(1.000000000000000000000000000000000000000), SC_(2.563248488880158240698244894381770231093e-2382) }
   }};
#undef SC_

