/**
 * =========================================
 * LibXML : a free Java layouting library
 * =========================================
 *
 * Project Info:  http://reporting.pentaho.org/libxml/
 *
 * (C) Copyright 2006-2008, by Object Refinery Ltd, Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 *
 * ------------
 * XmlWriterSupportTest.java
 * ------------
 */

package org.pentaho.reporting.libraries.xmlns.writer;

import java.io.StringWriter;
import java.io.IOException;

/**
 * Todo: Document Me
 *
 * @author Thomas Morgner
 */
public class XmlWriterSupportTest
{
  public static void main(final String[] args) throws IOException
  {
    final StringWriter writer1 = new StringWriter();
    final StringWriter writer2 = new StringWriter();
    final StringWriter writer3 = new StringWriter();
    final StringWriter writer4 = new StringWriter();
    final StringWriter writer5 = new StringWriter();

    final XmlWriterSupport support = new XmlWriterSupport(new DefaultTagDescription(), "");
    support.writeTextNormalized(writer1, "Some text to make me happy", false);
    support.writeTextNormalized(writer2, "Some <text> &to; make me happy", false);
    support.writeTextNormalized(writer3, "Some <<text to >>make me happy", false);
    support.writeTextNormalized(writer4, "Some \n>text to <\rmake me happy", false);
    support.writeTextNormalized(writer5, "Some \n>text to <\rmake me happy", true);

    System.out.println(writer1);
    System.out.println(writer2);
    System.out.println(writer3);
    System.out.println(writer4);
    System.out.println(writer5);
  }
}
