/***************************************************************************
 *   Copyright (C) 2005 - 2006 by Christian Muehlhaeuser, Last.fm Ltd.     *
 *   chris@last.fm                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#include "progressframe.h"
#include <QPainter>


ProgressFrame::ProgressFrame( QWidget *parent )
    : QFrame( parent )
{
    m_maxValue = 1;
    m_value = 0;

    setMinimumHeight( 16 );
    setFrameStyle( QFrame::Panel | QFrame::Sunken );
    setLineWidth( 1 );
}


void ProgressFrame::paintEvent ( QPaintEvent * event )
{
    QPainter painter( this );

    drawFrame( &painter );

    painter.setPen( QColor( 145, 153, 142, 255 ) );
    painter.setBrush( QColor( 145, 153, 142, 255 ) );

    int w = ( (float)m_value / (float)m_maxValue ) * ( width() - 8 );
    if ( w > width() - 8 )
        w = width() - 8;

    painter.drawRect( 3, 3, w, 8 );
}


void
ProgressFrame::setMaximum( int value )
{
    m_maxValue = value;
}


void
ProgressFrame::setValue( int value )
{
    m_value = value;
    update();
}


int
ProgressFrame::value()
{
    return m_value;
}

