// part of KSUDOKU - by Francesco Rossi <redsh@email.it> 2005

#include "ksudoku.h"
#include <kapplication.h>
#include <dcopclient.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include "knewdlg.h"
#include "sudoku_solver.h"

static const char description[] =
    I18N_NOOP("A KDE Application");

static const char version[] = "0.3";

static KCmdLineOptions options[] =
{
    { "+[URL]", I18N_NOOP( "Document to open" ), 0 },
    KCmdLineLastOption
};

skSolver* solver09 = new skSolver( 9); //graph changes
skSolver* solver16 = new skSolver(16);
skSolver* solver25 = new skSolver(25);

skSolver* solver3d09 = new skSolver(9 , true);
skSolver* solver3d16 = new skSolver(16, true);
skSolver* solver3d25 = new skSolver(25, true);

int main(int argc, char **argv)
{
	solver09->init();
	solver16->init();
	solver25->init();
	
	solver3d09->init();
	solver3d16->init();
	solver3d25->init();

    KAboutData about("ksudoku", I18N_NOOP("ksudoku"), version, description,
                     KAboutData::License_GPL_V2, "(C) 2005 Francesco Rossi", 0, 0, "redsh@email.it");
    about.addAuthor( "Francesco Rossi", 0, "redsh@email.it" );
	about.addAuthor( "Thanks to NeHe for opengl tutorials", 0, "nehe.gamedev.net");
    KCmdLineArgs::init(argc, argv, &about);
    KCmdLineArgs::addCmdLineOptions(options);
    KApplication app;
	
    // register ourselves as a dcop client
    app.dcopClient()->registerAs(app.name(), false);

    // see if we are starting with session management
    if (app.isRestored())
    {
        RESTORE(ksudoku);
    }
    else
    {
        // no session.. just start up normally
        KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
        if (args->count() == 0)
        {
            ksudoku *widget = new ksudoku;
            widget->show();
        }
        else
        {
            int i = 0;
            for (; i < args->count(); i++)
            {
                ksudoku *widget = new ksudoku(0,1, args->url(i));
                widget->show();
            }
        }
        args->clear();
    }


    return app.exec();
}
