/*
 *  Copyright (c) 2005 Boudewijn Rempt <boud@valdyas.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef __KIS_SELECTION_OPTIONS_H__
#define __KIS_SELECTION_OPTIONS_H__

#include <qwidget.h>
#include "koffice_export.h"
class KisCanvasSubject;
class WdgSelectionOptions;

/**
 */
class KRITAUI_EXPORT KisSelectionOptions : public QWidget
{

	Q_OBJECT

	typedef QWidget super;

public:
	KisSelectionOptions( QWidget *parent, KisCanvasSubject * subject);
	virtual ~KisSelectionOptions();

	int action();
	QColor maskColor();

	/** Ensures that the color of the active selection is the same as set on this widget */
	void ensureMaskColor();

signals:
	void actionChanged(int);

public slots:
	/** The mask color of the active selection (if it exists) is set as color of this widget */
	void slotActivated();

private slots:

	void slotSetMaskColor(const QColor &);

private:
	WdgSelectionOptions * m_page;
	KisCanvasSubject* m_subject;
};

#endif

