/* This file is part of the LibMSWrite Library
   Copyright (C) 2001-2003 Clarence Dang <clarencedang@users.sourceforge.net>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License Version 2 as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License Version 2 for more details.

   You should have received a copy of the GNU Library General Public License
   Version 2 along with this library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   LibMSWrite Project Website:
   http://sourceforge.net/projects/libmswrite/
*/

/*
 * structures_generated - Internal MS Write file structures
 * This file was generated by make_structures_generated 0.51pre 2003/07/09.
 * ALL CHANGES MADE TO THIS FILE "WILL BE LOST IN TIME LIKE TEARS IN RAIN"!
 */

#ifndef __STRUCTURES_GENERATED_H__
#define __STRUCTURES_GENERATED_H__

#include "libmswrite_defs.h"

namespace MSWrite
{
	// $Id: structures_generated.h 394586 2005-03-03 13:34:57Z mueller $
	// 
	//    This file is part of the LibMSWrite Library
	//    Copyright (C) 2001-2003 Clarence Dang <clarencedang@users.sourceforge.net>
	// 
	//    This library is free software; you can redistribute it and/or
	//    modify it under the terms of the GNU Library General Public
	//    License Version 2 as published by the Free Software Foundation.
	// 
	//    This library is distributed in the hope that it will be useful,
	//    but WITHOUT ANY WARRANTY; without even the implied warranty of
	//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	//    Library General Public License Version 2 for more details.
	// 
	//    You should have received a copy of the GNU Library General Public License
	//    Version 2 along with this library; see the file COPYING.LIB.  If not,
	//    write to  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
	//    Boston, MA 02111-1307, USA.
	// 
	//    LibMSWrite Project Website:
	//    http://sourceforge.net/projects/libmswrite/
	// 
	// DESCRIPTION
	// 
	// format.xml describes the basic structures that can be found in Microsoft(r)
	// Windows(r) Write files.  The majority of the information in format.xml
	// (excluding the Windows(r) BMP and WMF structures) is the result of
	// investigative file format work but a few portions of format.xml are derived
	// from a specification freely available from http://www.wotsit.org/.  The BMP
	// & WMF structures are from somewhere on the Internet (they are freely and
	// readily available) and can also be found in many programming books.
	// 
	// The data types and numbers in this document are intended to be interpreted
	// in the way they would be in Win3.x (Little Endian, 16-bit).
	// 
	// 
	// 	Structure Fields:
	// 
	// 		name #REQUIRED
	// 		type #IMPLIED "Word"
	// 		default #IMPLIED ""
	// 		description #IMPLIED ""	(also valid for Structures)
	// 		verify #IMPLIED ""
	// 		failVerify #IMPLIED "InvalidFormat"
	// 		rep #IMPLIED "1"
	// 		useThisMuch #IMPLIED "0"
	// 		provideMethod #IMPLIED "0"
	// 		protected #IMPLIED "0"	(also valid for Structures)
	// 
	// 	All structure names will be automatically postfixed with "Generated".
	// 	Derive structures from "Generated" structures (in structures*.cpp) e.g.
	// 
	// 		class Header : public HeaderGenerated
	// 		{
	// 		}
	// 
	// 	All fields will be automatically prefixed with "m_" to signify that
	// 	they are member variables.
	// 
	// 	Note that there are some limitations with make_structures_generated,
	// 	most importantly:
	// 
	// 		* any field of type Bit, must have
	// 			- rep <=8
	// 			- default = 0
	// 			- may not cross a byte boundary!
	
	// Write file header (mostly from wotsit)
	// [PRIVATE] this is a private libmswrite class, do not use it!
	class HeaderGenerated : public NeedsDevice
	{
	public:
		static const int s_size = 98;
	
	private:
		HeaderGenerated (const HeaderGenerated &rhs);	//TODO: copy constructor
	
	protected:
		Byte m_data [98];	// raw data from .wri file
		
		Word m_magic;							// must be 0xBE31 (v3.0) or 0xBE32 (v3.1 because the file contains OLE)
		Word m_zero;
		Word m_magic2;							// Magic number2 (must be 0xAB00)
		Word m_zero2 [4];
		DWord m_numCharBytesPlus128;		// #bytes of text,images & OLE (starting from Byte 128/Page 1)
		Word m_pageParaInfo;
		Word m_pageFootnoteTable;
		Word m_pageSectionProperty;		// I call it "Page Layout"
		Word m_pageSectionTable;
		Word m_pagePageTable;
		Word m_pageFontTable;
		Word m_zero3 [33];
		Word m_numPages;						// (where a page is 128 bytes)
		
		HeaderGenerated &operator= (const HeaderGenerated &rhs);
		
		virtual bool verifyVariables (void);
		virtual bool writeToArray (void);
		
		static const Word magicDefault = Word (0xBE31/*Write 3.0*/);
		static const Word zeroDefault = Word (0);
		static const Word magic2Default = Word (0xAB00);
		// cannot provide default for zero2 (is an array or of a non-internal type)
		// no default for numCharBytesPlus128
		// no default for pageParaInfo
		// no default for pageFootnoteTable
		// no default for pageSectionProperty
		// no default for pageSectionTable
		// no default for pagePageTable
		// no default for pageFontTable
		// cannot provide default for zero3 (is an array or of a non-internal type)
		// no default for numPages
	
	public:
		// [PRIVATE] do not call!
		virtual bool readFromDevice (void);
		virtual bool writeToDevice (void);
		
		HeaderGenerated ();
		virtual ~HeaderGenerated ();
		
		
		//
		// get and set functions
		//
		
		Word getMagic (void) const	{	return m_magic;	}
		void setMagic (const Word val)	{	m_magic = val;	}
		
		Word getPageParaInfo (void) const	{	return m_pageParaInfo;	}
		void setPageParaInfo (const Word val)	{	m_pageParaInfo = val;	}
		
		Word getPageFootnoteTable (void) const	{	return m_pageFootnoteTable;	}
		void setPageFootnoteTable (const Word val)	{	m_pageFootnoteTable = val;	}
		
		Word getPageSectionProperty (void) const	{	return m_pageSectionProperty;	}
		void setPageSectionProperty (const Word val)	{	m_pageSectionProperty = val;	}
		
		Word getPageSectionTable (void) const	{	return m_pageSectionTable;	}
		void setPageSectionTable (const Word val)	{	m_pageSectionTable = val;	}
		
		Word getPagePageTable (void) const	{	return m_pagePageTable;	}
		void setPagePageTable (const Word val)	{	m_pagePageTable = val;	}
		
		Word getPageFontTable (void) const	{	return m_pageFontTable;	}
		void setPageFontTable (const Word val)	{	m_pageFontTable = val;	}
		
		Word getNumPages (void) const	{	return m_numPages;	}
		void setNumPages (const Word val)	{	m_numPages = val;	}
	};
	
	// Page layout information (margins, dimensions, ...)
	class PageLayoutGenerated : public NeedsDevice
	{
	public:
		static const int s_size = 33;
	
	private:
		PageLayoutGenerated (const PageLayoutGenerated &rhs);	//TODO: copy constructor
	
	protected:
		Byte m_data [33];	// raw data from .wri file
		
		Byte m_magic102;						// =102?
		Word m_magic512;						// =512?
		Word m_pageHeight;
		Word m_pageWidth;
		Word m_pageNumberStart;				// start counting page numbers from this value (0xFFFF means ignore, set to 1 I guess)
		Word m_topMargin;
		Word m_textHeight;
		Word m_leftMargin;
		Word m_textWidth;
		
		Word m_magic256;						// =256?
		
		Word m_headerFromTop;				// distance header is from top of page
		Word m_footerFromTop;				// distance footer is from top of page
		
		Word m_magic720;						// 720
		Word m_zero;							// 0
		Word m_magic1080;						// 1080
		Word m_unknown;						// ? (let's not be random and default to 0)
		Word m_zero2;							// 0
		
		PageLayoutGenerated &operator= (const PageLayoutGenerated &rhs);
		
		virtual bool verifyVariables (void);
		virtual bool writeToArray (void);
		
		static const Byte magic102Default = Byte (102);
		static const Word magic512Default = Word (512);
		static const Word pageHeightDefault = Word (Inch2Twip (11));
		static const Word pageWidthDefault = Word (Inch2Twip (8.5));
		static const Word pageNumberStartDefault = Word (1);
		static const Word topMarginDefault = Word (Inch2Twip (1));
		static const Word textHeightDefault = Word (Inch2Twip (9));
		static const Word leftMarginDefault = Word (Inch2Twip (1.25));
		static const Word textWidthDefault = Word (Inch2Twip (6));
		static const Word magic256Default = Word (256);
		static const Word headerFromTopDefault = Word (Inch2Twip (0.75));
		static const Word footerFromTopDefault = Word (Inch2Twip (10.25 /*11.0 (m_pageHeight) - 0.75*/));
		static const Word magic720Default = Word (720);
		static const Word zeroDefault = Word (0);
		static const Word magic1080Default = Word (1080);
		static const Word unknownDefault = Word (0);
		static const Word zero2Default = Word (0);
	
	public:
		// [PRIVATE] do not call!
		virtual bool readFromDevice (void);
		virtual bool writeToDevice (void);
		
		PageLayoutGenerated ();
		virtual ~PageLayoutGenerated ();
		
	};
	
	// No idea what this is supposed to do (from wotsit)
	// [PRIVATE] this is a private libmswrite class, do not use it!
	class SectionDescriptorGenerated : public NeedsDevice
	{
	public:
		static const int s_size = 10;
	
	private:
		SectionDescriptorGenerated (const SectionDescriptorGenerated &rhs);	//TODO: copy constructor
	
	protected:
		Byte m_data [10];	// raw data from .wri file
		
		DWord m_afterEndCharByte;			// byte of character just after end of section
		Word m_undefined;
		DWord m_sectionPropertyLocation;	// byte address of corresponding sectionProperty (I call it a "Page Layout" which is more obvious IMHO)
		
		SectionDescriptorGenerated &operator= (const SectionDescriptorGenerated &rhs);
		
		virtual bool verifyVariables (void);
		virtual bool writeToArray (void);
		
		// no default for afterEndCharByte
		static const Word undefinedDefault = Word (0);
		// no default for sectionPropertyLocation
	
	public:
		// [PRIVATE] do not call!
		virtual bool readFromDevice (void);
		virtual bool writeToDevice (void);
		
		SectionDescriptorGenerated ();
		virtual ~SectionDescriptorGenerated ();
		
		
		//
		// get and set functions
		//
		
		DWord getAfterEndCharByte (void) const	{	return m_afterEndCharByte;	}
		void setAfterEndCharByte (const DWord val)	{	m_afterEndCharByte = val;	}
		
		DWord getSectionPropertyLocation (void) const	{	return m_sectionPropertyLocation;	}
		void setSectionPropertyLocation (const DWord val)	{	m_sectionPropertyLocation = val;	}
	};
	
	// (from wotsit)
	class SectionDescriptor;
	// [PRIVATE] this is a private libmswrite class, do not use it!
	class SectionTableGenerated : public NeedsDevice
	{
	public:
		static const int s_size = 24;
	
	private:
		SectionTableGenerated (const SectionTableGenerated &rhs);	//TODO: copy constructor
	
	protected:
		Byte m_data [24];	// raw data from .wri file
		
		Word m_numSectionDescriptors;
		Word m_undefined;
		SectionDescriptor *m_sed [2];
		
		SectionTableGenerated &operator= (const SectionTableGenerated &rhs);
		
		virtual bool verifyVariables (void);
		virtual bool writeToArray (void);
		
		static const Word numSectionDescriptorsDefault = Word (2);
		static const Word undefinedDefault = Word (0);
		// no default for sed
	
	public:
		// [PRIVATE] do not call!
		virtual bool readFromDevice (void);
		virtual bool writeToDevice (void);
		
		SectionTableGenerated ();
		virtual ~SectionTableGenerated ();
		
	};
	
	class FontGenerated : public NeedsDevice
	{
	public:
		static const int s_size = 3;
	
	private:
		FontGenerated (const FontGenerated &rhs);	//TODO: copy constructor
	
	protected:
		Byte m_data [3];	// raw data from .wri file
		
		Word m_numDataBytes;					// number of bytes that follow
		Byte m_family;
		
		// - - - followed by Byte *fontName - - - 
		
		FontGenerated &operator= (const FontGenerated &rhs);
		
		virtual bool verifyVariables (void);
		virtual bool writeToArray (void);
		
		static const Word numDataBytesDefault = Word (0);
		static const Byte familyDefault = Byte (0);
	
	public:
		// [PRIVATE] do not call!
		virtual bool readFromDevice (void);
		virtual bool writeToDevice (void);
		
		FontGenerated ();
		virtual ~FontGenerated ();
		
		
		//
		// get and set functions
		//
		
		// [PRIVATE] these are private libmswrite methods, do not call them!
		Word getNumDataBytes (void) const	{	return m_numDataBytes;	}
		void setNumDataBytes (const Word val)	{	m_numDataBytes = val;	}
		
		Byte getFamily (void) const	{	return m_family;	}
		void setFamily (const Byte val)	{	m_family = val;	}
	};
	
	// [PRIVATE] this is a private libmswrite class, do not use it!
	class FontTableGenerated : public NeedsDevice
	{
	public:
		static const int s_size = 2;
	
	private:
		FontTableGenerated (const FontTableGenerated &rhs);	//TODO: copy constructor
	
	protected:
		Byte m_data [2];	// raw data from .wri file
		
		Word m_numFonts;
		
		// - - - followed by a list of Font(s) - - - 
		
		FontTableGenerated &operator= (const FontTableGenerated &rhs);
		
		virtual bool verifyVariables (void);
		virtual bool writeToArray (void);
		
		static const Word numFontsDefault = Word (0);
	
	public:
		// [PRIVATE] do not call!
		virtual bool readFromDevice (void);
		virtual bool writeToDevice (void);
		
		FontTableGenerated ();
		virtual ~FontTableGenerated ();
		
		
		//
		// get and set functions
		//
		
		Word getNumFonts (void) const	{	return m_numFonts;	}
		void setNumFonts (const Word val)	{	m_numFonts = val;	}
	};
	
	// [PRIVATE] this is a private libmswrite class, do not use it!
	class PagePointerGenerated : public NeedsDevice
	{
	public:
		static const int s_size = 6;
	
	private:
		PagePointerGenerated (const PagePointerGenerated &rhs);	//TODO: copy constructor
	
	protected:
		Byte m_data [6];	// raw data from .wri file
		
		Word m_pageNumber;
		DWord m_firstCharByte;				// first character on page
		
		PagePointerGenerated &operator= (const PagePointerGenerated &rhs);
		
		virtual bool verifyVariables (void);
		virtual bool writeToArray (void);
		
		// no default for pageNumber
		// no default for firstCharByte
	
	public:
		// [PRIVATE] do not call!
		virtual bool readFromDevice (void);
		virtual bool writeToDevice (void);
		
		PagePointerGenerated ();
		virtual ~PagePointerGenerated ();
		
		
		//
		// get and set functions
		//
		
		Word getPageNumber (void) const	{	return m_pageNumber;	}
		void setPageNumber (const Word val)	{	m_pageNumber = val;	}
		
		DWord getFirstCharByte (void) const	{	return m_firstCharByte;	}
		void setFirstCharByte (const DWord val)	{	m_firstCharByte = val;	}
	};
	
	// File/Repaginate function
	// [PRIVATE] this is a private libmswrite class, do not use it!
	class PageTableGenerated : public NeedsDevice
	{
	public:
		static const int s_size = 4;
	
	private:
		PageTableGenerated (const PageTableGenerated &rhs);	//TODO: copy constructor
	
	protected:
		Byte m_data [4];	// raw data from .wri file
		
		Word m_numPagePointers;
		Word m_zero;
		
		// - - - followed by a list of PagePointer(s) - - - 
		
		PageTableGenerated &operator= (const PageTableGenerated &rhs);
		
		virtual bool verifyVariables (void);
		virtual bool writeToArray (void);
		
		static const Word numPagePointersDefault = Word (0);
		static const Word zeroDefault = Word (0);
	
	public:
		// [PRIVATE] do not call!
		virtual bool readFromDevice (void);
		virtual bool writeToDevice (void);
		
		PageTableGenerated ();
		virtual ~PageTableGenerated ();
		
	};
	
	// A pointer to the actual formatting properties (formatting properties are shared to save space)
	// [PRIVATE] this is a private libmswrite class, do not use it!
	class FormatPointerGenerated : public NeedsDevice
	{
	public:
		static const int s_size = 6;
	
	private:
		FormatPointerGenerated (const FormatPointerGenerated &rhs);	//TODO: copy constructor
	
	protected:
		Byte m_data [6];	// raw data from .wri file
		
		DWord m_afterEndCharBytePlus128;	// last character it points to + 1
		Word m_formatPropertyOffset;		// location of relevant FormatProperty (or 0xFFFF for defaults)
		
		FormatPointerGenerated &operator= (const FormatPointerGenerated &rhs);
		
		virtual bool verifyVariables (void);
		virtual bool writeToArray (void);
		
		// no default for afterEndCharBytePlus128
		// no default for formatPropertyOffset
	
	public:
		// [PRIVATE] do not call!
		virtual bool readFromDevice (void);
		virtual bool writeToDevice (void);
		
		FormatPointerGenerated ();
		virtual ~FormatPointerGenerated ();
		
		
		//
		// get and set functions
		//
		
		DWord getAfterEndCharBytePlus128 (void) const	{	return m_afterEndCharBytePlus128;	}
		void setAfterEndCharBytePlus128 (const DWord val)	{	m_afterEndCharBytePlus128 = val;	}
		
		Word getFormatPropertyOffset (void) const	{	return m_formatPropertyOffset;	}
		void setFormatPropertyOffset (const Word val)	{	m_formatPropertyOffset = val;	}
	};
	
	// Character Properties
	class FormatCharPropertyGenerated : public NeedsDevice, public UseThisMuch
	{
	public:
		static const int s_size = 7;
	
	private:
		FormatCharPropertyGenerated (const FormatCharPropertyGenerated &rhs);	//TODO: copy constructor
	
	protected:
		Byte m_data [7];	// raw data from .wri file
		
		// Byte 0 
		Byte m_numDataBytes;					// number of bytes that follow
		
		// Byte 1 
		Byte m_unknown;						// =0? or =1?
		
		// Byte 2 
		unsigned m_isBold	:	1;
		unsigned m_isItalic	:	1;
		unsigned m_fontCodeLow	:	6;
		
		// Byte 3 
		Byte m_fontSize;						// half the fontSize?
		
		// Byte 4 
		unsigned m_isUnderlined	:	1;
		unsigned m_zero	:	5;
		unsigned m_isPageNumber	:	1;		// seems to be set for '(page)' number variables - only in headers/footers?
		unsigned m_zero2	:	1;
		
		// Byte 5 
		unsigned m_fontCodeHigh	:	3;		// not sure if this is true
		unsigned m_zero3	:	5;
		
		// Byte 6 
		Byte m_position;						// 0=normal, 1-127=superscript, 128-255=subscript (I tested mainly boundary values so I don't know if it's this is totally true)
		
		FormatCharPropertyGenerated &operator= (const FormatCharPropertyGenerated &rhs);
		
		Word getNumDataBytes (void) const	{	return UseThisMuch::getNeedNumDataBytes ();	}
		// note: you cannot set numDataBytes
		void updateNumDataBytes (void)	{	m_numDataBytes = UseThisMuch::getNeedNumDataBytes ();	}
		
		virtual bool verifyVariables (void);
		virtual bool writeToArray (void);
		
		static const Byte numDataBytesDefault = Byte (0);
		static const Byte unknownDefault = Byte (1);
		static const unsigned isBoldDefault = unsigned (0);
		static const unsigned isItalicDefault = unsigned (0);
		// cannot provide default for fontCodeLow (is an array or of a non-internal type)
		static const Byte fontSizeDefault = Byte (24);
		static const unsigned isUnderlinedDefault = unsigned (0);
		// cannot provide default for zero (is an array or of a non-internal type)
		static const unsigned isPageNumberDefault = unsigned (0);
		static const unsigned zero2Default = unsigned (0);
		// cannot provide default for fontCodeHigh (is an array or of a non-internal type)
		// cannot provide default for zero3 (is an array or of a non-internal type)
		static const Byte positionDefault = Byte (0);
	
	public:
		// [PRIVATE] do not call!
		virtual bool readFromDevice (void);
		virtual bool writeToDevice (void);
		
		FormatCharPropertyGenerated ();
		virtual ~FormatCharPropertyGenerated ();
		
		
		//
		// get and set functions
		//
		
		bool getIsBold (void) const	{	return m_isBold;	}
		void setIsBold (const bool val)	{	m_isBold = val;	signalHaveSetData (m_isBold == bool (0), 8/*offset*/ + 1/*size*/);	}
		
		bool getIsItalic (void) const	{	return m_isItalic;	}
		void setIsItalic (const bool val)	{	m_isItalic = val;	signalHaveSetData (m_isItalic == bool (0), 9/*offset*/ + 1/*size*/);	}
		
		// [PRIVATE] these are private libmswrite methods, do not call them!
		unsigned getFontCodeLow (void) const	{	return m_fontCodeLow;	}
		void setFontCodeLow (const unsigned val)	{	m_fontCodeLow = val;	signalHaveSetData (m_fontCodeLow == unsigned (0), 10/*offset*/ + 6/*size*/);	}
		
		bool getIsUnderlined (void) const	{	return m_isUnderlined;	}
		void setIsUnderlined (const bool val)	{	m_isUnderlined = val;	signalHaveSetData (m_isUnderlined == bool (0), 24/*offset*/ + 1/*size*/);	}
		
		bool getIsPageNumber (void) const	{	return m_isPageNumber;	}
		void setIsPageNumber (const bool val)	{	m_isPageNumber = val;	signalHaveSetData (m_isPageNumber == bool (0), 30/*offset*/ + 1/*size*/);	}
		
		// [PRIVATE] these are private libmswrite methods, do not call them!
		unsigned getFontCodeHigh (void) const	{	return m_fontCodeHigh;	}
		void setFontCodeHigh (const unsigned val)	{	m_fontCodeHigh = val;	signalHaveSetData (m_fontCodeHigh == unsigned (0), 32/*offset*/ + 3/*size*/);	}
		
		// [PRIVATE] these are private libmswrite methods, do not call them!
		Byte getPosition (void) const	{	return m_position;	}
		void setPosition (const Byte val)	{	m_position = val;	signalHaveSetData (m_position == Byte (0), 40/*offset*/ + 8/*size*/);	}
	};
	
	// Paragraph Tabulator(s) Properties
	class FormatParaPropertyTabulatorGenerated : public NeedsDevice
	{
	public:
		static const int s_size = 4;
	
	private:
		FormatParaPropertyTabulatorGenerated (const FormatParaPropertyTabulatorGenerated &rhs);	//TODO: copy constructor
	
	protected:
		Byte m_data [4];	// raw data from .wri file
		
		Word m_indent;
		Byte m_type;							// 0=normal,3=decimal...all that the GUI allows
		Byte m_zero;
		
		FormatParaPropertyTabulatorGenerated &operator= (const FormatParaPropertyTabulatorGenerated &rhs);
		
		virtual bool verifyVariables (void);
		virtual bool writeToArray (void);
		
		static const Word indentDefault = Word (0);
		static const Byte typeDefault = Byte (0);
		static const Byte zeroDefault = Byte (0);
	
	public:
		// [PRIVATE] do not call!
		virtual bool readFromDevice (void);
		virtual bool writeToDevice (void);
		
		FormatParaPropertyTabulatorGenerated ();
		virtual ~FormatParaPropertyTabulatorGenerated ();
		
		
		//
		// get and set functions
		//
		
		Word getIndent (void) const	{	return m_indent;	}
		void setIndent (const Word val)	{	m_indent = val;	}
		
		// [PRIVATE] these are private libmswrite methods, do not call them!
		Byte getType (void) const	{	return m_type;	}
		void setType (const Byte val)	{	m_type = val;	}
	};
	
	// Paragraph Properties
	class FormatParaPropertyTabulator;
	class FormatParaPropertyGenerated : public NeedsDevice, public UseThisMuch
	{
	public:
		static const int s_size = 79;
	
	private:
		FormatParaPropertyGenerated (const FormatParaPropertyGenerated &rhs);	//TODO: copy constructor
	
	protected:
		Byte m_data [79];	// raw data from .wri file
		
		Byte m_numDataBytes;					// number of bytes that follow
		Byte m_magic0_60_or_61;				// =0? =60? =61? 60 is the most common
		Byte m_alignment;
		Word m_magic30;						// =30?
		Word m_rightIndent;					// indent from right margin + right margin (if in header/footer)
		Word m_leftIndent;					// indent from left margin + left margin (if in header/footer)
		Short m_leftIndentFirstLine;		// indent of first line relative to leftIndent (may be negative for a "hanging indent")
		Word m_lineSpacing;					// measurement in twips?
		Word m_zero [2];
		
		// Type Byte 
		unsigned m_headerOrFooter	:	1;	// 0=header,1=footer (if not normal paragraph)
		unsigned m_isNotNormalParagraph	:	2;// 0=normal paragraph;1,2?,3?=header/footer
		unsigned m_isOnFirstPage	:	1;	// again, valid only if not normal paragraph
		unsigned m_isObject	:	1;			// 0=image/OLE,1=text
		unsigned m_zero2	:	3;
		
		Byte m_zero3 [5];
		FormatParaPropertyTabulator *m_tab [14];
		
		FormatParaPropertyGenerated &operator= (const FormatParaPropertyGenerated &rhs);
		
		Word getNumDataBytes (void) const	{	return UseThisMuch::getNeedNumDataBytes ();	}
		// note: you cannot set numDataBytes
		void updateNumDataBytes (void)	{	m_numDataBytes = UseThisMuch::getNeedNumDataBytes ();	}
		
		virtual bool verifyVariables (void);
		virtual bool writeToArray (void);
		
		static const Byte numDataBytesDefault = Byte (0);
		static const Byte magic0_60_or_61Default = Byte (60);
		static const Byte alignmentDefault = Byte (0);
		static const Word magic30Default = Word (30);
		static const Word rightIndentDefault = Word (0);
		static const Word leftIndentDefault = Word (0);
		static const Short leftIndentFirstLineDefault = Short (0);
		static const Word lineSpacingDefault = Word (240);
		// cannot provide default for zero (is an array or of a non-internal type)
		static const unsigned headerOrFooterDefault = unsigned (0);
		// cannot provide default for isNotNormalParagraph (is an array or of a non-internal type)
		static const unsigned isOnFirstPageDefault = unsigned (0);
		static const unsigned isObjectDefault = unsigned (0);
		// cannot provide default for zero2 (is an array or of a non-internal type)
		// cannot provide default for zero3 (is an array or of a non-internal type)
		// no default for tab
	
	public:
		// [PRIVATE] do not call!
		virtual bool readFromDevice (void);
		virtual bool writeToDevice (void);
		
		FormatParaPropertyGenerated ();
		virtual ~FormatParaPropertyGenerated ();
		
		
		//
		// get and set functions
		//
		
		Byte getAlignment (void) const	{	return m_alignment;	}
		void setAlignment (const Byte val)	{	m_alignment = val;	signalHaveSetData (m_alignment == Byte (0), 8/*offset*/ + 8/*size*/);	}
		
		Word getRightIndent (void) const	{	return m_rightIndent;	}
		void setRightIndent (const Word val)	{	m_rightIndent = val;	signalHaveSetData (m_rightIndent == Word (0), 32/*offset*/ + 16/*size*/);	}
		
		Word getLeftIndent (void) const	{	return m_leftIndent;	}
		void setLeftIndent (const Word val)	{	m_leftIndent = val;	signalHaveSetData (m_leftIndent == Word (0), 48/*offset*/ + 16/*size*/);	}
		
		Word getLineSpacing (void) const	{	return m_lineSpacing;	}
		void setLineSpacing (const Word val)	{	m_lineSpacing = val;	signalHaveSetData (m_lineSpacing == Word (240), 80/*offset*/ + 16/*size*/);	}
		
		bool getHeaderOrFooter (void) const	{	return m_headerOrFooter;	}
		void setHeaderOrFooter (const bool val)	{	m_headerOrFooter = val;	signalHaveSetData (m_headerOrFooter == bool (0), 128/*offset*/ + 1/*size*/);	}
		
		unsigned getIsNotNormalParagraph (void) const	{	return m_isNotNormalParagraph;	}
		void setIsNotNormalParagraph (const unsigned val)	{	m_isNotNormalParagraph = val;	signalHaveSetData (m_isNotNormalParagraph == unsigned (0), 129/*offset*/ + 2/*size*/);	}
		
		bool getIsOnFirstPage (void) const	{	return m_isOnFirstPage;	}
		void setIsOnFirstPage (const bool val)	{	m_isOnFirstPage = val;	signalHaveSetData (m_isOnFirstPage == bool (0), 131/*offset*/ + 1/*size*/);	}
		
		bool getIsObject (void) const	{	return m_isObject;	}
		void setIsObject (const bool val)	{	m_isObject = val;	signalHaveSetData (m_isObject == bool (0), 132/*offset*/ + 1/*size*/);	}
	};
	
	// [PRIVATE] this is a private libmswrite class, do not use it!
	class FormatInfoPageGenerated : public NeedsDevice
	{
	public:
		static const int s_size = 128;
	
	private:
		FormatInfoPageGenerated (const FormatInfoPageGenerated &rhs);	//TODO: copy constructor
	
	protected:
		Byte m_data [128];	// raw data from .wri file
		
		DWord m_firstCharBytePlus128;
		Byte m_packedStructs [123];		// array of FormatPointers and FormatCharProperties/FormatParaProperties
		Byte m_numFormatPointers;
		
		FormatInfoPageGenerated &operator= (const FormatInfoPageGenerated &rhs);
		
		virtual bool verifyVariables (void);
		virtual bool writeToArray (void);
		
		// no default for firstCharBytePlus128
		// cannot provide default for packedStructs (is an array or of a non-internal type)
		static const Byte numFormatPointersDefault = Byte (0);
	
	public:
		// [PRIVATE] do not call!
		virtual bool readFromDevice (void);
		virtual bool writeToDevice (void);
		
		FormatInfoPageGenerated ();
		virtual ~FormatInfoPageGenerated ();
		
	};
	
	// first header of a .BMP file (_not_ stored in .WRI)
	// [PRIVATE] this is a private libmswrite class, do not use it!
	class BMP_BitmapFileHeaderGenerated : public NeedsDevice
	{
	public:
		static const int s_size = 14;
	
	private:
		BMP_BitmapFileHeaderGenerated (const BMP_BitmapFileHeaderGenerated &rhs);	//TODO: copy constructor
	
	protected:
		Byte m_data [14];	// raw data from .wri file
		
		Word m_magic;
		DWord m_totalBytes;
		Word m_zero [2];
		DWord m_actualImageOffset;
		
		BMP_BitmapFileHeaderGenerated &operator= (const BMP_BitmapFileHeaderGenerated &rhs);
		
		virtual bool verifyVariables (void);
		virtual bool writeToArray (void);
		
		static const Word magicDefault = Word (Word ('B') + (Word ('M') << 8));
		// no default for totalBytes
		// cannot provide default for zero (is an array or of a non-internal type)
		// no default for actualImageOffset
	
	public:
		// [PRIVATE] do not call!
		virtual bool readFromDevice (void);
		virtual bool writeToDevice (void);
		
		BMP_BitmapFileHeaderGenerated ();
		virtual ~BMP_BitmapFileHeaderGenerated ();
		
		
		//
		// get and set functions
		//
		
		DWord getTotalBytes (void) const	{	return m_totalBytes;	}
		void setTotalBytes (const DWord val)	{	m_totalBytes = val;	}
		
		DWord getActualImageOffset (void) const	{	return m_actualImageOffset;	}
		void setActualImageOffset (const DWord val)	{	m_actualImageOffset = val;	}
	};
	
	// second header of a .BMP file (_not_ stored in .WRI)
	// [PRIVATE] this is a private libmswrite class, do not use it!
	class BMP_BitmapInfoHeaderGenerated : public NeedsDevice
	{
	public:
		static const int s_size = 40;
	
	private:
		BMP_BitmapInfoHeaderGenerated (const BMP_BitmapInfoHeaderGenerated &rhs);	//TODO: copy constructor
	
	protected:
		Byte m_data [40];	// raw data from .wri file
		
		DWord m_numHeaderBytes;
		Long m_width;
		Long m_height;
		Word m_numPlanes;						// always==1
		Word m_bitsPerPixel;
		DWord m_compression;
		DWord m_sizeImage;
		Long m_xPixelsPerMeter;
		Long m_yPixelsPerMeter;
		DWord m_coloursUsed;
		DWord m_coloursImportant;
		
		BMP_BitmapInfoHeaderGenerated &operator= (const BMP_BitmapInfoHeaderGenerated &rhs);
		
		virtual bool verifyVariables (void);
		virtual bool writeToArray (void);
		
		static const DWord numHeaderBytesDefault = DWord (s_size);
		// no default for width
		// no default for height
		static const Word numPlanesDefault = Word (1);
		// no default for bitsPerPixel
		static const DWord compressionDefault = DWord (0);
		static const DWord sizeImageDefault = DWord (0);
		static const Long xPixelsPerMeterDefault = Long (0);
		static const Long yPixelsPerMeterDefault = Long (0);
		static const DWord coloursUsedDefault = DWord (0);
		// no default for coloursImportant
	
	public:
		// [PRIVATE] do not call!
		virtual bool readFromDevice (void);
		virtual bool writeToDevice (void);
		
		BMP_BitmapInfoHeaderGenerated ();
		virtual ~BMP_BitmapInfoHeaderGenerated ();
		
		
		//
		// get and set functions
		//
		
		Long getWidth (void) const	{	return m_width;	}
		void setWidth (const Long val)	{	m_width = val;	}
		
		Long getHeight (void) const	{	return m_height;	}
		void setHeight (const Long val)	{	m_height = val;	}
		
		Word getNumPlanes (void) const	{	return m_numPlanes;	}
		void setNumPlanes (const Word val)	{	m_numPlanes = val;	}
		
		Word getBitsPerPixel (void) const	{	return m_bitsPerPixel;	}
		void setBitsPerPixel (const Word val)	{	m_bitsPerPixel = val;	}
		
		DWord getCompression (void) const	{	return m_compression;	}
		void setCompression (const DWord val)	{	m_compression = val;	}
		
		DWord getSizeImage (void) const	{	return m_sizeImage;	}
		void setSizeImage (const DWord val)	{	m_sizeImage = val;	}
		
		Long getXPixelsPerMeter (void) const	{	return m_xPixelsPerMeter;	}
		void setXPixelsPerMeter (const Long val)	{	m_xPixelsPerMeter = val;	}
		
		Long getYPixelsPerMeter (void) const	{	return m_yPixelsPerMeter;	}
		void setYPixelsPerMeter (const Long val)	{	m_yPixelsPerMeter = val;	}
		
		DWord getColoursUsed (void) const	{	return m_coloursUsed;	}
		void setColoursUsed (const DWord val)	{	m_coloursUsed = val;	}
		
		DWord getColoursImportant (void) const	{	return m_coloursImportant;	}
		void setColoursImportant (const DWord val)	{	m_coloursImportant = val;	}
	};
	
	// element of colourTable, triad of RGB
	// [PRIVATE] this is a private libmswrite class, do not use it!
	class BMP_BitmapColourIndexGenerated : public NeedsDevice
	{
	public:
		static const int s_size = 4;
	
	private:
		BMP_BitmapColourIndexGenerated (const BMP_BitmapColourIndexGenerated &rhs);	//TODO: copy constructor
	
	protected:
		Byte m_data [4];	// raw data from .wri file
		
		Byte m_blue;
		Byte m_green;
		Byte m_red;
		Byte m_reserved;
		
		BMP_BitmapColourIndexGenerated &operator= (const BMP_BitmapColourIndexGenerated &rhs);
		
		virtual bool verifyVariables (void);
		virtual bool writeToArray (void);
		
		// no default for blue
		// no default for green
		// no default for red
		static const Byte reservedDefault = Byte (0);
	
	public:
		// [PRIVATE] do not call!
		virtual bool readFromDevice (void);
		virtual bool writeToDevice (void);
		
		BMP_BitmapColourIndexGenerated ();
		virtual ~BMP_BitmapColourIndexGenerated ();
		
		
		//
		// get and set functions
		//
		
		Byte getBlue (void) const	{	return m_blue;	}
		void setBlue (const Byte val)	{	m_blue = val;	}
		
		Byte getGreen (void) const	{	return m_green;	}
		void setGreen (const Byte val)	{	m_green = val;	}
		
		Byte getRed (void) const	{	return m_red;	}
		void setRed (const Byte val)	{	m_red = val;	}
	};
	
	// [PRIVATE] this is a private libmswrite class, do not use it!
	class BitmapHeaderGenerated : public NeedsDevice
	{
	public:
		static const int s_size = 14;
	
	private:
		BitmapHeaderGenerated (const BitmapHeaderGenerated &rhs);	//TODO: copy constructor
	
	protected:
		Byte m_data [14];	// raw data from .wri file
		
		Word m_zero;
		Word m_width;
		Word m_height;
		Word m_widthBytes;
		Byte m_numPlanes;						// always 1 for mono BMP or the entire struct is 0 for WMF
		Byte m_bitsPerPixel;
		DWord m_zero2;
		
		BitmapHeaderGenerated &operator= (const BitmapHeaderGenerated &rhs);
		
		virtual bool verifyVariables (void);
		virtual bool writeToArray (void);
		
		static const Word zeroDefault = Word (0);
		static const Word widthDefault = Word (0);
		static const Word heightDefault = Word (0);
		static const Word widthBytesDefault = Word (0);
		static const Byte numPlanesDefault = Byte (0);
		static const Byte bitsPerPixelDefault = Byte (0);
		static const DWord zero2Default = DWord (0);
	
	public:
		// [PRIVATE] do not call!
		virtual bool readFromDevice (void);
		virtual bool writeToDevice (void);
		
		BitmapHeaderGenerated ();
		virtual ~BitmapHeaderGenerated ();
		
		
		//
		// get and set functions
		//
		
		Word getWidth (void) const	{	return m_width;	}
		void setWidth (const Word val)	{	m_width = val;	}
		
		Word getHeight (void) const	{	return m_height;	}
		void setHeight (const Word val)	{	m_height = val;	}
		
		Word getWidthBytes (void) const	{	return m_widthBytes;	}
		void setWidthBytes (const Word val)	{	m_widthBytes = val;	}
		
		Byte getNumPlanes (void) const	{	return m_numPlanes;	}
		void setNumPlanes (const Byte val)	{	m_numPlanes = val;	}
		
		Byte getBitsPerPixel (void) const	{	return m_bitsPerPixel;	}
		void setBitsPerPixel (const Byte val)	{	m_bitsPerPixel = val;	}
	};
	
	// 'Standard WMF' Header
	// [PRIVATE] this is a private libmswrite class, do not use it!
	class WMFHeaderGenerated : public NeedsDevice
	{
	public:
		static const int s_size = 18;
	
	private:
		WMFHeaderGenerated (const WMFHeaderGenerated &rhs);	//TODO: copy constructor
	
	protected:
		Byte m_data [18];	// raw data from .wri file
		
		Word m_fieldType;						// 0=memory WMF,1=file WMF; so will never be 0
		Word m_headerSize;					// (in Words)
		Word m_winVersion;					// correct for Win>=3.0
		DWord m_fileSize;						// (in Words)
		Word m_numObjects;					// ?
		DWord m_maxRecordSize;				// (in Words)
		Word m_zero;
		
		WMFHeaderGenerated &operator= (const WMFHeaderGenerated &rhs);
		
		virtual bool verifyVariables (void);
		virtual bool writeToArray (void);
		
		static const Word fieldTypeDefault = Word (1);
		static const Word headerSizeDefault = Word (9);
		static const Word winVersionDefault = Word (0x0300);
		// no default for fileSize
		static const Word numObjectsDefault = Word (0);
		// no default for maxRecordSize
		static const Word zeroDefault = Word (0);
	
	public:
		// [PRIVATE] do not call!
		virtual bool readFromDevice (void);
		virtual bool writeToDevice (void);
		
		WMFHeaderGenerated ();
		virtual ~WMFHeaderGenerated ();
		
		
		//
		// get and set functions
		//
		
		DWord getFileSize (void) const	{	return m_fileSize;	}
		void setFileSize (const DWord val)	{	m_fileSize = val;	}
		
		DWord getMaxRecordSize (void) const	{	return m_maxRecordSize;	}
		void setMaxRecordSize (const DWord val)	{	m_maxRecordSize = val;	}
	};
	
	class BitmapHeader;
	class ImageGenerated : public NeedsDevice
	{
	public:
		static const int s_size = 40;
	
	private:
		ImageGenerated (const ImageGenerated &rhs);	//TODO: copy constructor
	
	protected:
		Byte m_data [40];	// raw data from .wri file
		
		// - - - METAFILEPICT begin - - - 
		
		Word m_mappingMode;					// type of image: 0xE3 for mono bitmap, != 0xE3 for WMF (usually 0x88)
		Word m_MFP_width;
		Word m_MFP_height;
		Word m_MFP_unknown;
		
		// - - - METAFILEPICT end - - - 
		
		Word m_indent;							// horizontal position from left margin
		Word m_width;							// WMF width only, use m_bmh for bitmaps
		Word m_height;							// WMF height only, use m_bmh for bitmaps
		Word m_zero;							// ??? varies too much, default to 0
		
		BitmapHeader *m_bmh;					// only valid for mono BMPs i.e. when mappingMode == 0xe3
		
		Word m_numHeaderBytes;				// size of this header? (why isn't it the first element?)
		DWord m_numDataBytes;				// number of image bytes
		Word m_horizontalScalingRel1000;	// horizontal scaling (/1000)*100% (BMPs only)
		Word m_verticalScalingRel1000;	// vertical scaling (/1000)*100% (BMPs only)
		
		// - - - Followed by either a strangely packed monochrome bitmap or a Standard WMF (with WMFHeader, of course) - - - 
		
		ImageGenerated &operator= (const ImageGenerated &rhs);
		
		virtual bool verifyVariables (void);
		virtual bool writeToArray (void);
		
		// no default for mappingMode
		// no default for MFP_width
		// no default for MFP_height
		static const Word MFP_unknownDefault = Word (0);
		static const Word indentDefault = Word (0);
		// no default for width
		// no default for height
		static const Word zeroDefault = Word (0);
		// no default for bmh
		static const Word numHeaderBytesDefault = Word (s_size);
		// no default for numDataBytes
		static const Word horizontalScalingRel1000Default = Word (1000);
		static const Word verticalScalingRel1000Default = Word (1000);
	
	public:
		// [PRIVATE] do not call!
		virtual bool readFromDevice (void);
		virtual bool writeToDevice (void);
		
		ImageGenerated ();
		virtual ~ImageGenerated ();
		
		
		//
		// get and set functions
		//
		
		Word getIndent (void) const	{	return m_indent;	}
		void setIndent (const Word val)	{	m_indent = val;	}
		
		// [PRIVATE] these are private libmswrite methods, do not call them!
		Word getNumHeaderBytes (void) const	{	return m_numHeaderBytes;	}
		void setNumHeaderBytes (const Word val)	{	m_numHeaderBytes = val;	}
		
		// [PRIVATE] these are private libmswrite methods, do not call them!
		DWord getNumDataBytes (void) const	{	return m_numDataBytes;	}
		void setNumDataBytes (const DWord val)	{	m_numDataBytes = val;	}
	};
	
	class OLEGenerated : public NeedsDevice
	{
	public:
		static const int s_size = 40;
	
	private:
		OLEGenerated (const OLEGenerated &rhs);	//TODO: copy constructor
	
	protected:
		Byte m_data [40];	// raw data from .wri file
		
		Word m_mappingMode;
		DWord m_zero;
		Word m_objectType;					// 1=static, 2=embedded, 3=link
		
		Word m_indent;							// horizontal position from left margin
		Word m_width;
		Word m_height;
		Word m_zero2;
		DWord m_numDataBytes;				// number of OLE bytes
		DWord m_zero3;
		DWord m_objectName;					// name of the object in hex
		Word m_zero4;
		Word m_numHeaderBytes;				// size of this header
		DWord m_zero5;
		Word m_widthScaledRel1000;			// horizontal scaling (/1000)*100% (same as Image?)
		Word m_heightScaledRel1000;		// vertical scaling (/1000)*100% (same as Image?)
		
		// - - - Followed by OLE data - - - 
		
		OLEGenerated &operator= (const OLEGenerated &rhs);
		
		virtual bool verifyVariables (void);
		virtual bool writeToArray (void);
		
		// no default for mappingMode
		static const DWord zeroDefault = DWord (0);
		// no default for objectType
		// no default for indent
		// no default for width
		// no default for height
		static const Word zero2Default = Word (0);
		// no default for numDataBytes
		static const DWord zero3Default = DWord (0);
		// no default for objectName
		static const Word zero4Default = Word (0);
		// no default for numHeaderBytes
		static const DWord zero5Default = DWord (0);
		// no default for widthScaledRel1000
		// no default for heightScaledRel1000
	
	public:
		// [PRIVATE] do not call!
		virtual bool readFromDevice (void);
		virtual bool writeToDevice (void);
		
		OLEGenerated ();
		virtual ~OLEGenerated ();
		
		
		//
		// get and set functions
		//
		
		Word getObjectType (void) const	{	return m_objectType;	}
		void setObjectType (const Word val)	{	m_objectType = val;	}
		
		Word getIndent (void) const	{	return m_indent;	}
		void setIndent (const Word val)	{	m_indent = val;	}
		
		Word getWidth (void) const	{	return m_width;	}
		void setWidth (const Word val)	{	m_width = val;	}
		
		Word getHeight (void) const	{	return m_height;	}
		void setHeight (const Word val)	{	m_height = val;	}
		
		// [PRIVATE] these are private libmswrite methods, do not call them!
		DWord getNumDataBytes (void) const	{	return m_numDataBytes;	}
		void setNumDataBytes (const DWord val)	{	m_numDataBytes = val;	}
		
		DWord getObjectName (void) const	{	return m_objectName;	}
		void setObjectName (const DWord val)	{	m_objectName = val;	}
		
		Word getWidthScaledRel1000 (void) const	{	return m_widthScaledRel1000;	}
		void setWidthScaledRel1000 (const Word val)	{	m_widthScaledRel1000 = val;	}
		
		Word getHeightScaledRel1000 (void) const	{	return m_heightScaledRel1000;	}
		void setHeightScaledRel1000 (const Word val)	{	m_heightScaledRel1000 = val;	}
	};
}	// namespace MSWrite	{

#endif	// __STRUCTURES_GENERATED_H__

// end of structures_generated.h
