/***************************************************************************
                          contactextension.cpp  -  description
                             -------------------
    begin                : Fri 13 Dec 2002
    copyright            : (C) 2003 by Michael Curtis.
    email                : mdcurtis@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "contactextension.h"

#include <qdir.h>
#include <qfile.h>

#include <kconfig.h>
#include <kdebug.h>
#include <klocale.h>

#include "contact.h"
#include "../currentaccount.h"
#include "../kmessdebug.h"


// The constructor with specified contact handle
ContactExtension::ContactExtension(QString handle )
 : QObject(),
   alternativeName_(""),
   handle_(handle),
   notifyOnline_(true),
   pictureFile_(""),
   soundFile_(""),
   useAlternativeName_(false)
{
  // Automatically try to read properties we've saved.
  readProperties( kapp->config() );
}


// The destructor
ContactExtension::~ContactExtension()
{

}



// Read property of QString  alternativeName_.
const QString & ContactExtension::getAlternativeName() const
{
	return alternativeName_;
}



// Read property of QString  PictureFile_.
const QString ContactExtension::getContactPicturePath() const
{
  if(QFile::exists(pictureFile_))
  {
    return pictureFile_;
  }
  else
  {
    return QString::null;
  }
}



// Read property of QString  SoundFile_.
const QString ContactExtension::getContactSoundPath() const
{
  if(QFile::exists(soundFile_))
  {
    return soundFile_;
  }
  else
  {
    return QString::null;
  }
}



// Read property of bool notifyOnline_
bool ContactExtension::getNotifyOnline() const
{
	return notifyOnline_;
}



// Read property of bool useAlternativeName_.
bool ContactExtension::getUseAlternativeName() const
{
	return useAlternativeName_;
}



// Load extension settings for a contact
void ContactExtension::readProperties( KConfig *config )
{
  QString groupName;

  groupName = "Contact_" + CurrentAccount::instance()->getHandle() + "/" + handle_;

#ifdef KMESSDEBUG_CONTACTEXTENSION
  kdDebug() << "COE - loadContact - finding group " << groupName << endl;
#endif

  if ( config->hasGroup( groupName ) == true )
  {
#ifdef KMESSDEBUG_CONTACTEXTENSION
    kdDebug() << "COE - group exists" << endl;
#endif
    config->setGroup( groupName );

    alternativeName_       =      config->readEntry("alternativeName",          "");
    // We use the accessor function here because it handles the update, if required
    setUseAlternativeName  (  config->readBoolEntry("useAlternativeName",    false) );

    notifyOnline_          =  config->readBoolEntry("notifyOnline",           true);

    pictureFile_           =      config->readEntry("pictureFile",              "");
    soundFile_             =      config->readEntry("soundFile",                "");
  }
}



// Save extension settings for a contact
void ContactExtension::saveProperties(KConfig *config)
{
#ifdef KMESSDEBUG_CONTACTEXTENSION
  kdDebug() << "ContactExtension - saving contact " << handle_ << endl;
  kdDebug() << "Using " << CurrentAccount::instance()->getHandle() + "/" + handle_ << " -- name = " << alternativeName_ << endl;
#endif
  config->setGroup( "Contact_" + CurrentAccount::instance()->getHandle() + "/" + handle_ );

  config->writeEntry( "useAlternativeName",      useAlternativeName_       );
  config->writeEntry( "alternativeName",         alternativeName_          );
  config->writeEntry( "notifyOnline",            notifyOnline_             );
  config->writeEntry( "pictureFile",             pictureFile_              );
  config->writeEntry( "soundFile",               soundFile_                );
}



// Write property of QString alternativeName_.
void ContactExtension::setAlternativeName( const QString& _newVal )
{
  if ( _newVal != "" )
  {
    alternativeName_ = _newVal;

    if (getUseAlternativeName() == true) emit changedFriendlyName();
  }
}




// Write property of QString  pictureFile_.
void ContactExtension::setContactPicturePath( const QString & _newVal)
{
	pictureFile_ = _newVal;
  emit changedPicture();
}



// Write property of QString  soundFile_.
void ContactExtension::setContactSoundPath( const QString & _newVal)
{
	soundFile_ = _newVal;
}



// Write propety of bool notifyOnline_
void ContactExtension::setNotifyOnline( bool _newVal )
{
	notifyOnline_ = _newVal;
}



// Write property of bool useAlternativeName_
void ContactExtension::setUseAlternativeName( bool _newVal)
{
  bool needUpdate;

  needUpdate = ( useAlternativeName_ != _newVal);

	useAlternativeName_ = _newVal;

  if ( needUpdate == true ) emit changedFriendlyName();
}



#include "contactextension.moc"
