/***************************************************************************
                          chatmaster.h  -  description
                             -------------------
    begin                : Sat Jan 18 2003
    copyright            : (C) 2003 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CHATMASTER_H
#define CHATMASTER_H

#include <qptrlist.h>
#include <qwidget.h>

// Forward declarations
class ChatInformation;
class ChatWindow;
class Contact;

/**
 * This class governs the chat windows, detecting when a chat
 * can be restarted in an open window and the like.
 * @author Mike K. Bennett
 */
class ChatMaster : public QObject
{
  Q_OBJECT

  public: // Public methods
    // The constructor
                       ChatMaster(QObject *parent = 0);
    // The destructor
    virtual           ~ChatMaster();
    // Initialize the class
    bool               initialize();

  public slots: // Public slots
    // The user has disconnected, so close all open chats
    void               disconnected();
    // Start a chat
    void               startChat( ChatInformation *chatInfo );

  private slots: // Private slots
    // A chat window was destroyed
    void               chatWindowDestroyed(QObject *chatWindow);
    // Forward a new chat signal from a chat window
    void               forwardNewChat(const Contact *contact, QString message, ChatWindow *chatWindow);

  private: // Private attributes
    // The pointers to the chat windows
    QPtrList<ChatWindow> chatWindows_;
    // Whether or not the object was initialized
    bool               initialized_;

  signals: // Public signals
    // Signal that a new chat has started
    void               newChat(const Contact *contact, QString message, ChatWindow *chatWindow);
};

#endif
