/*************************************************************************
 * 
 * irmp3 - Multimedia Audio Jukebox for Linux
 * http://irmp3.sourceforge.net
 *
 * $Source: /cvsroot/irmp3/irmp3/src/irmp3d/mod_netctl.h,v $ -- network control interface
 * $Id: mod_netctl.h,v 1.3 2004/02/17 20:40:36 boucman Exp $
 *
 * Copyright (C) by David E. Potter, Ben Reser
 *
 * Please contact the current maintainer, Jeremy Rosen <jeremy.rosen@enst-bretagne.fr>
 * for information and support regarding irmp3.
 *
 *
 */

#ifndef MOD_NETCTL_H
#define MOD_NETCTL_H

#include <regex.h>

typedef struct filter {
	int enabled;
	regex_t regx;
} filter_t;

typedef struct mod_netctl_client {
	unsigned int id;
	int socket;
	filter_t filter;
	char *buffer;
	struct mod_netctl_client *prev;
	struct mod_netctl_client *next;
} mod_netctl_client_t;

void mod_netctl_message (int msgtype, char *msg,const char *sender);
char *mod_netctl_init (void);
void mod_netctl_deinit (void);
int mod_netctl_net_setup (void);
void mod_netctl_poll(int fd);
void mod_netctl_new_client(int newsockfd);
void mod_netctl_disc_client(mod_netctl_client_t *client);
int mod_netctl_regex_match(regex_t *preg, char *string);
mod_netctl_client_t *mod_netctl_next_client(mod_netctl_client_t *client);
mod_netctl_client_t *mod_netctl_last_client(void);
mod_netctl_client_t *mod_netctl_add_client(int newsockfd);
void mod_netctl_remove_client (mod_netctl_client_t *client);
void mod_netctl_close_all_clients(void);
void mod_netctl_remove_all_clients(void);

#endif /* MOD_NETCTL_H */

/*************************************************************************
 * EOF
 */
