/*
 * Decompiled with CFR 0.152.
 */
package com.gallery.GalleryRemote.util;

import com.gallery.GalleryRemote.GalleryRemote;
import com.gallery.GalleryRemote.Log;
import com.gallery.GalleryRemote.prefs.PreferenceNames;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;

public class GRI18n
implements PreferenceNames {
    private static final String RESNAME = "com.gallery.GalleryRemote.resources.GRResources";
    private static final String RESNAME_DEV = "GRResources";
    private static final String RESPATH = "com/gallery/GalleryRemote/resources/GRResources";
    private static final String MODULE = "GRI18n";
    private static Locale grLocale;
    private static ResourceBundle grResBundle;
    private static HashMap formats;
    private static List lAvailLoc;
    private static boolean devMode;
    private static Properties devResProperties;

    public static Locale parseLocaleString(String localeString) {
        if (localeString == null) {
            return Locale.getDefault();
        }
        int i = localeString.indexOf("_");
        if (i != -1) {
            return new Locale(localeString.substring(0, i), localeString.substring(i + 1));
        }
        return new Locale(localeString, "");
    }

    public static void setLocale(String language, String country) {
        grLocale = new Locale(language, country);
        GRI18n.setResBundle();
    }

    public static String getString(String className, String key) {
        String msg;
        String extKey = className + "." + key;
        try {
            msg = grResBundle.getString(extKey);
            if (devResProperties != null && devResProperties.getProperty(extKey) == null) {
                msg = msg.startsWith("<html>") ? "<html>***" + msg.substring(6) : "***" + msg;
            }
        }
        catch (NullPointerException e) {
            Log.log(1, MODULE, "Key null error");
            Log.logException(1, MODULE, e);
            msg = "[NULLKEY]";
        }
        catch (MissingResourceException e) {
            Log.log(2, MODULE, "Key [" + extKey + "] not defined");
            Log.logException(2, MODULE, e);
            msg = "[" + extKey + "]";
        }
        return msg;
    }

    public static String getString(String className, String key, Object[] params) {
        String msg;
        String extKey = className + "." + key;
        try {
            MessageFormat format = (MessageFormat)formats.get(extKey);
            if (format == null) {
                format = new MessageFormat(GRI18n.fixQuotes(grResBundle.getString(extKey)), grLocale);
                formats.put(extKey, format);
            }
            msg = format.format(params);
            if (devResProperties != null && devResProperties.getProperty(extKey) == null) {
                msg = msg.startsWith("<html>") ? "<html>***" + msg.substring(6) : "***" + msg;
            }
        }
        catch (NullPointerException e) {
            Log.log(1, MODULE, "Key null error");
            Log.logException(1, MODULE, e);
            msg = "[NULLKEY]";
        }
        catch (MissingResourceException e) {
            Log.log(2, MODULE, "Key [" + extKey + "] not defined");
            Log.logException(2, MODULE, e);
            msg = "[" + extKey + "]";
        }
        return msg;
    }

    public static String fixQuotes(String s) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\'') {
                sb.append("''");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static Locale getCurrentLocale() {
        return grLocale;
    }

    private static void setResBundle() {
        try {
            grResBundle = ResourceBundle.getBundle(devMode ? RESNAME_DEV : RESNAME, grLocale);
            if (devMode) {
                devResProperties = GRI18n.getLocaleProperties(grLocale);
            }
        }
        catch (MissingResourceException e) {
            Log.log(1, MODULE, "Resource bundle error");
            Log.logException(1, MODULE, e);
        }
    }

    public static Properties getLocaleProperties(Locale locale) {
        Properties p = new Properties();
        String filename = locale == null ? (devMode ? RESNAME_DEV : RESPATH) + ".properties" : (devMode ? RESNAME_DEV : RESPATH) + "_" + locale.toString() + ".properties";
        InputStream is = ClassLoader.getSystemClassLoader().getResourceAsStream(filename);
        if (is != null) {
            try {
                p.load(is);
            }
            catch (IOException e) {
                Log.logException(1, MODULE, e);
            }
        } else {
            Log.log(1, MODULE, "No file for " + filename);
        }
        return p;
    }

    public static List getAvailableLocales() {
        if (lAvailLoc == null) {
            lAvailLoc = GRI18n.initAvailableLocales();
        }
        return lAvailLoc;
    }

    private static List initAvailableLocales() {
        LinkedList<Locale> aList = new LinkedList<Locale>();
        long start = System.currentTimeMillis();
        Log.log(3, MODULE, "Getting the list of locales");
        Locale[] list = Locale.getAvailableLocales();
        Log.log(3, MODULE, "The platform supports " + list.length + " locales. Pruning...");
        String prefix = "##DUMMY";
        for (int i = 0; i < list.length; ++i) {
            String loc = list[i].toString();
            if (loc.startsWith(prefix)) continue;
            prefix = loc;
            if (devMode) {
                Log.log(3, MODULE, "Trying locale: " + loc);
            }
            String locPath = (devMode ? RESNAME_DEV : RESPATH) + "_" + loc + ".properties";
            if (ClassLoader.getSystemClassLoader().getResource(locPath) == null) continue;
            Log.log(2, MODULE, "Found locale: " + loc);
            aList.add(list[i]);
            prefix = "##DUMMY";
        }
        Log.log(3, MODULE, "Pruned locales in " + (System.currentTimeMillis() - start) + "ms");
        return aList;
    }

    static {
        formats = new HashMap();
        lAvailLoc = null;
        devMode = false;
        devResProperties = null;
        String myLocale = GalleryRemote._().properties.getProperty("uiLocale");
        devMode = GalleryRemote._().properties.getBooleanProperty("uiLocaleDev");
        grLocale = GRI18n.parseLocaleString(myLocale);
        Log.log(2, MODULE, grLocale.toString());
        GRI18n.setResBundle();
    }
}

