%% =====================================================================
%% Header file for EDoc Type Representations
%% 
%% Copyright (C) 2001-2005 Richard Carlsson
%%
%% This library is free software; you can redistribute it and/or modify
%% it under the terms of the GNU Lesser General Public License as
%% published by the Free Software Foundation; either version 2 of the
%% License, or (at your option) any later version.
%%
%% This library is distributed in the hope that it will be useful, but
%% WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
%% Lesser General Public License for more details.
%%
%% You should have received a copy of the GNU Lesser General Public
%% License along with this library; if not, write to the Free Software
%% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
%% USA
%%
%% Author contact: richardc@csd.uu.se
%% =====================================================================

%% Type specification data structures

%% @type t_spec() = #t_spec{name = t_name(),
%%                          type = t_type(),
%%                          defs = [t_def()]}

-record(t_spec, {name, type, defs=[]}).		% function specification

%% @type type() = t_atom() | t_fun() | t_integer() | t_list() | t_nil()
%%              | t_tuple() | t_type() | t_union() | t_var()

%% @type t_typedef() = #t_typedef{name = t_name(),
%%                                args = [type()],
%%                                type = type(),
%%                                defs = [t_def()]}

-record(t_typedef, {name, args, type,
		    defs=[]}).			% type declaration/definition

%% @type t_throws() = #t_throws{type = type(),
%%                              defs = [t_def()]}

-record(t_throws, {type, defs=[]}).		% exception declaration

%% @type t_def() = #t_def{name = t_name(),
%%                        type = type()}

-record(t_def, {name, type}).			% local definition 'name = type'
%% @type t_name() = #t_name{app = [] | atom(),
%%                          module = [] | atom(),
%%                          name = [] | atom()}

-record(t_name, {app = [],			% app = [] if module = []
		 module=[],			% unqualified if module = []
		 name=[]}).

%% The following records all have 'a=[]' as their first field.
%% This is used for name annotations; in particular, the fun-argument
%% types of a function specification (t_spec) are often annotated with
%% the names of the corresponding formal parameters.

-define(t_ann(X), element(2, X)).
-define(set_t_ann(X, Y), setelement(2, X, Y)).

%% @type t_var() = #t_var{a = list(), name = [] | atom()}

-record(t_var, {a=[], name=[]}).	% type variable

%% @type t_type() = #t_type{a = list(),
%%                          name = t_name(),
%%                          args = [type()]}

-record(t_type, {a=[], name, args = []}).	% abstract type 'name(...)'

%% @type t_union() = #t_union{a = list(),
%%                            types = [type()]}

-record(t_union, {a=[], types = []}).	% union type 't1|...|tN'

%% @type t_fun() = #t_fun{a = list(),
%%                        args = [type()],
%%                        range = type()}

-record(t_fun, {a=[], args, range}).	% function '(t1,...,tN) -> range'

%% @type t_tuple() = #t_tuple{a = list(),
%%                            types = [type()]}

-record(t_tuple, {a=[], types = []}).	% tuple type '{t1,...,tN}'

%% @type t_list() = #t_list{a = list(),
%%                          type = type()}

-record(t_list, {a=[], type}).		% list type '[type]'

%% @type t_nil() = #t_nil{a = list()}

-record(t_nil, {a=[]}).			% empty-list constant '[]'

%% @type t_atom() = #t_atom{a = list(),
%%                          val = atom()}

-record(t_atom, {a=[], val}).		% atom constant

%% @type t_integer() = #t_integer{a = list(),
%%                                val = integer()}

-record(t_integer, {a=[], val}).	% integer constant

%% @type t_float() = #t_float{a = list(),
%%                            val = float()}

-record(t_float, {a=[], val}).		% floating-point constant

%% @type t_record() = #t_list{a = list(),
%%                            name = type(),
%%                            fields = [field()]}

-record(t_record, {a=[], name, fields = []}).	% record type '#r{f1,...,fN}'

%% @type t_field() = #t_field{a = list(),
%%                            name = type(),
%%                            type = type()}

-record(t_field, {a=[], name, type}).	% named field 'n1=t1'
