<?php
include("../inc/inc.Settings.php");
include("../inc/inc.AccessUtils.php");
include("../inc/inc.ClassAccess.php");
include("../inc/inc.ClassDocument.php");
include("../inc/inc.ClassFolder.php");
include("../inc/inc.ClassGroup.php");
include("../inc/inc.ClassUser.php");
include("../inc/inc.DBAccess.php");
include("../inc/inc.FileUtils.php");
include("../inc/inc.Language.php");
include("../inc/inc.OutUtils.php");
include("../inc/inc.Authentication.php");

$documentid	= (isset($_GET['documentid'])) ? (int) $_GET['documentid'] : NULL;
$expires	= $_GET['expires'];
$expday		= $_GET['expday'];
$expmonth	= $_GET['expmonth'];
$expyear	= $_GET['expyear'];

$document = getDocument($documentid);

printHTMLHead( getMLText("document_title", array("documentname" => $document->getName()) ) );
printTitleBar($document->getFolder());
printCenterStart();

printStartBox(getMLText("expires"));

print "<div class=\"standardText\">";

if ($document->getAccessMode($user) < M_READWRITE)
{
	printMLText("operation_not_allowed");
	printGoBack();
}
else
{
	printMLText("setting_expires");
	
	$expires = ($expires == "true") ? mktime(0,0,0, $expmonth, $expday, $expyear) : false;
	
	if (!$document->setExpires($expires))
	{
		printMLText("error_occured");
		printGoBack();
	}
	else
	{
		printMLText("op_finished");
		printGoto(array(array($document->getName(), "../out/out.ViewDocument.php?documentid=".$document->getID())));
	}
}

print "</div>";
printEndBox();
printCenterEnd();
printHTMLFoot();
?>
